package api

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/friendship/app/api/responses"
	"code.justin.tv/chat/friendship/app/api/utils"
	"code.justin.tv/chat/golibs/gojiplus"
)

func (s *Server) getNotificationsV0(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	params, err := utils.FetchRequiredParams(ctx, "user_id")
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusBadRequest)
		return
	}
	sourceID := params[0]

	n, err := s.backend.GetNotifications(ctx, sourceID)
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, utils.ErrorStatus(err))
		return
	}

	respMap := responses.NotificationsCountResponse{Count: n}
	gojiplus.ServeJSON(w, r, respMap)
}

func (s *Server) resetNotificationsV0(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	params, err := utils.FetchRequiredParams(ctx, "user_id")
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusBadRequest)
		return
	}
	sourceID := params[0]

	err = s.backend.ResetNotifications(ctx, sourceID)
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, utils.ErrorStatus(err))
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
