package api

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/friendship/app/api/utils"
	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/chat/golibs/gojiplus"
)

func (s *Server) rejectRequestV0(ctx context.Context, w http.ResponseWriter, r *http.Request) {
	requiredParams, err := gojiplus.FetchRequiredURLParams(ctx, "user_id", "friend_id")
	if err != nil {
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusBadRequest)
		return
	}
	rejectorID := requiredParams["user_id"]
	otherUserID := requiredParams["friend_id"]

	success, err := s.backend.RejectRequest(ctx, rejectorID, otherUserID)
	if err != nil {
		gojiplus.ServeError(ctx, w, r, err, utils.ErrorStatus(err))
		return
	} else if !success {
		err := errx.New("no friend request found")
		gojiplus.ServePublicError(ctx, w, r, err, http.StatusNotFound)
		return
	}
	w.WriteHeader(http.StatusNoContent)
}
