package api

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/mock"

	"code.justin.tv/chat/friendship/app/backend"
	"code.justin.tv/chat/friendship/app/backend/backendtest"
	"code.justin.tv/chat/redis"
)

func TestGetFriendship(t *testing.T) {
	server, b := serverWithTestBackend(t)

	mockRedis := b.Redis.(*redis.MockRedis)
	defer mockRedis.AssertExpectations(t)
	mockRedis.On("Get", mock.Anything, mock.Anything).Return("", false, nil)

	mockFriends := b.Friends.(*backendtest.CohesionClient)
	assert.Zero(t, len(mockFriends.GetCalls()))

	path := fmt.Sprintf("/users/%s/friends/%s", backend.AliceID, backend.BobID)
	doTestHTTP(t, server, "GET", path)

	assert.Equal(t, 1, len(mockFriends.GetCalls()))

	fetchCall := mockFriends.GetCalls()[0]
	expected := backendtest.Call{
		Name: "Associations",
		E1:   backend.AliceID,
		E2:   backend.BobID,
	}
	validateCall(t, fetchCall, expected)
}

func TestIsFriend(t *testing.T) {
	server, b := serverWithTestBackend(t)

	mockFriends := b.Friends.(*backendtest.CohesionClient)
	assert.Zero(t, len(mockFriends.GetCalls()))

	path := fmt.Sprintf("/v1/users/%s/friends/%s/friend", backend.AliceID, backend.BobID)
	doTestHTTP(t, server, "GET", path)

	assert.Equal(t, 1, len(mockFriends.GetCalls()))

	fetchCall := mockFriends.GetCalls()[0]
	expected := backendtest.Call{
		Name: "FetchAssoc",
		Kind: "friends_with",
		E1:   backend.AliceID,
		E2:   backend.BobID,
	}
	validateCall(t, fetchCall, expected)
}
