package friendship

import (
	"fmt"
	"net/url"
	"strconv"

	"golang.org/x/net/context"

	"code.justin.tv/chat/friendship/app/api/responses"
	"code.justin.tv/foundation/twitchclient"
)

type GetFriendsParams struct {
	Limit  *int
	Cursor *string
	Sort   *string
}

func (c *clientImpl) GetFriends(ctx context.Context, userID string, params GetFriendsParams, reqOpts *twitchclient.ReqOpts) (*responses.FriendListResponse, error) {
	q := url.Values{}
	if params.Limit != nil {
		q.Add("limit", strconv.Itoa(*params.Limit))
	}
	if params.Cursor != nil {
		q.Add("cursor", *params.Cursor)
	}
	if params.Sort != nil {
		q.Add("sort", *params.Sort)
	}

	u := &url.URL{
		Path:     fmt.Sprintf("/v1/users/%s/friends", userID),
		RawQuery: q.Encode(),
	}
	req, err := c.NewRequest("GET", u.String(), nil)
	if err != nil {
		return nil, err
	}

	combinedReqOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.friendship.get_friends",
		StatSampleRate: defaultStatSampleRate,
	})
	ctx, cancel := context.WithTimeout(ctx, defaultCtxTimeout)
	defer cancel()

	var decoded responses.FriendListResponse
	if _, err := c.DoJSON(ctx, &decoded, req, combinedReqOpts); err != nil {
		return nil, err
	}
	return &decoded, nil
}
