package friendship

import (
	"encoding/json"
	"fmt"
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/friendship/app/api/responses"
	"code.justin.tv/foundation/twitchclient"
)

func (c *clientImpl) GetFriendship(ctx context.Context, userID, targetID string, reqOpts *twitchclient.ReqOpts) (string, error) {
	path := fmt.Sprintf("/v1/users/%s/friends/%s", userID, targetID)
	req, err := c.NewRequest("GET", path, nil)
	if err != nil {
		return "", err
	}

	combinedReqOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.friendship.get_status",
		StatSampleRate: defaultStatSampleRate,
	})
	ctx, cancel := context.WithTimeout(ctx, defaultCtxTimeout)
	defer cancel()

	resp, err := c.Do(ctx, req, combinedReqOpts)
	if err != nil {
		return "", err
	}
	defer func() {
		if err := resp.Body.Close(); err != nil {
		}
	}()

	if resp.StatusCode != http.StatusOK {
		return "", twitchclient.HandleFailedResponse(resp)
	}

	var decoded responses.FriendStatusResponse
	if err := json.NewDecoder(resp.Body).Decode(&decoded); err != nil {
		return "", err
	}
	return decoded.Status, nil
}
