package friendship

import (
	"fmt"
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/foundation/twitchclient"
)

func (c *clientImpl) IsFriend(ctx context.Context, userID, targetID string, reqOpts *twitchclient.ReqOpts) (bool, error) {
	path := fmt.Sprintf("/v1/users/%s/friends/%s/friend", userID, targetID)
	req, err := c.NewRequest("GET", path, nil)
	if err != nil {
		return false, err
	}

	combinedReqOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.friendship.is_friend",
		StatSampleRate: defaultStatSampleRate,
	})
	ctx, cancel := context.WithTimeout(ctx, defaultCtxTimeout)
	defer cancel()

	resp, err := c.Do(ctx, req, combinedReqOpts)
	if err != nil {
		return false, err
	}
	defer func() {
		if err := resp.Body.Close(); err != nil {
		}
	}()

	// Expected responses:
	// - 200: true, users id1 and id2 are friends
	// - 404: false, users id1 and id2 are not friends or not valid users
	switch resp.StatusCode {
	case http.StatusOK:
		return true, nil
	case http.StatusNotFound:
		return false, nil
	default:
		return false, twitchclient.HandleFailedResponse(resp)
	}
}
