# Recommendations

[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=discovery-recommendations&style=plastic)](https://jenkins.internal.justin.tv/job/discovery-recommendations)

## Service Details

**Production API:** <http://recommendations-prod-internal.us-west-2.elasticbeanstalk.com>

**Staging API:** <http://recommendations-staging-internal.us-west-2.elasticbeanstalk.com>

**Routes**:

See [Swagger](http://swagger.internal.justin.tv/index-recommendations.html#/) documentation.

### Workers

**Realtime Clips:** Generates realtime clips recommendations once / minute, stored in RDS.

## Build Information

[Build job](https://jenkins.internal.justin.tv/job/discovery-recommendations/)

This project is deployed through [clean-deploy](https://clean-deploy.internal.justin.tv).

**Deploy Jobs**

[![Build Status](https://jenkins.internal.justin.tv/job/discovery-recommendations-api-staging-deploy/badge/icon?style=plastic) API - Staging](https://jenkins.internal.justin.tv/job/discovery-recommendations-api-staging-deploy/)

[![Build Status](https://jenkins.internal.justin.tv/job/discovery-recommendations-api-production-deploy/badge/icon?style=plastic) API - Production](https://jenkins.internal.justin.tv/job/discovery-recommendations-api-production-deploy/)

[![Build Status](https://jenkins.internal.justin.tv/job/discovery-recommendations-worker-staging-deploy/badge/icon?style=plastic) Worker - Staging](https://jenkins.internal.justin.tv/job/discovery-recommendations-worker-staging-deploy/)

[![Build Status](https://jenkins.internal.justin.tv/job/discovery-recommendations-worker-production-deploy/badge/icon?style=plastic) Worker - Staging](https://jenkins.internal.justin.tv/job/discovery-recommendations-worker-production-deploy/)

## Development

First, install Go

    brew install go --cross-compile-common

Now set up your $GOPATH

    mkdir $HOME/go
    export GOPATH=$HOME/go

Download the repo into it

    go get -d code.justin.tv/discovery/recommendations
    cd ~/go/src/code.justin.tv/discovery/recommendations

Make sure you have ROLLBAR_TOKEN set

    export ROLLBAR_TOKEN=fcff06b2ce024d4982cdb838238cb791

And run!

   	make run

### Dev Tools

**Dependencies:**

Vendoring dependencies in autohost is done using [glide](https://github.com/Masterminds/glide).
Be sure to run `make upgrade` when dependencies are added and/or updated to build correctly.
In order to run `make upgrade`, `glide` and `glide-vc` will need to be installed.

    brew install glide                # install glide
    go get github.com/sgotti/glide-vc # install glide-vc

**Tests:**

    make test

**Swagger:**

Whenever an API endpoint is added, Swagger documentation can be autogenerated by running `make swagger`. After the documentation is generated, the resulting JSON file will need to be manually synced to <http://swagger.internal.justin.tv>. Message @jcfox to learn how to do this.

**Mocks:**

Mock definitions are generated by [mockery](https://github.com/vektra/mockery) via `go generate`.
To regenerate mocks, run `make mocks`.
To add a mock, add one or more `//go:generate` stanzas to a `gen_mocks.go` file in the appropriate directory. See `backend/gen_mocks.go` for examples.

## Architecture

**Codebase:** https://git-aws.internal.justin.tv/discovery/recommendations <br>
**Summary:** API for all recommendation algorithms <br>
**Purpose:** Match API requests with corresponding service (considers 	experiment type, extra parameters, etc.) <br>

<img src="docs/resources/Recommendations-Algorithm.png" alt="Recommendations Algorithm" width="800"/>
