package recommendations

import (
	"time"

	"code.justin.tv/video/clips-upload/client/clipsv2"
)

// Recommendations represents a set of recommendations
type Recommendations struct {
	GenerationID    string            `json:"rec_generation_id"`
	Recommendations []*Recommendation `json:"recommendations"`
}

// Recommendation is a single recommended piece of content
type Recommendation struct {
	Kind   string `json:"type"`
	ID     string `json:"id"`
	Reason Reason `json:"reason,omitempty"`
}

// Reason describes why a recommendation was given
type Reason struct {
	Kind      string `json:"type"`
	ContextID string `json:"context_id,omitempty"`
}

// Videos represents a list of video objects returned by recommendations
type Videos struct {
	Vods   []Vod `json:"vods"`
	Offset int   `json:"offset"`
}

// Vod represents a set of metadata fields about a vod
type Vod struct {
	ID       string `json:"vod_id"`
	Language string `json:"language"`
	Game     string `json:"game"`
}

// VodIDs represents a list of vod ids
type VodIDs struct {
	IDs []string `json:"vod_ids"`
}

// RecommendedVodIDs represents a bucket of vod ids
type RecommendedVodIDs struct {
	VodIDs              []string `json:"vod_ids"`
	RecommendationSetID string   `json:"recommendation_set_id"`
}

// SocialRecommendedStream represents a a recommended stream from a friend
type SocialRecommendedStream struct {
	FriendID string `json:"friend_id"`
	Stream   Stream `json:"stream"`
}

// SocialRecommendedStreamList is an ordered list of social RecommendedStreams
type SocialRecommendedStreamList struct {
	RecommendedStreams []SocialRecommendedStream `json:"recommended"`
}

// Stream represents a live stream
type Stream struct {
	ID                string  `json:"id"`
	ChannelID         string  `json:"channel_id"`
	Login             string  `json:"login"`
	Game              string  `json:"game"`
	AverageFPS        float64 `json:"average_fps"`
	IsPlaylist        bool    `json:"is_playlist"`
	IsPartner         bool    `json:"partner"`
	Viewers           int     `json:"viewers"`
	Delay             int     `json:"delay"`
	VideoHeight       int     `json:"video_height"`
	CreatedAt         string  `json:"created_at"`
	StreamType        string  `json:"stream_type"`
	BroadcastPlatform string  `json:"broadcast_platform"`
}

type OnboardingStream struct {
	Stream
	TopClip clipsv2.Clip `json:"top_clip"`
}

// RecommendedStreamsMetadata represents the response of the recommended streams metadata endpoint
type RecommendedStreamsMetadata struct {
	HasRecommendations bool `json:"has_recommendations"`
}

// SimilarStreams represents a bucket of similar channels
type SimilarStreams struct {
	ChannelID      string   `json:"channel_id"`
	SimilarStreams []Stream `json:"similar_streams"`
}

type OnboardingChannels struct {
	// Map of game ids to live channels
	Channels map[string][]OnboardingStream `json:"channels"`
}

type RealtimeClip struct {
	ID        int       `json:"clip_id,string"`
	Slug      string    `json:"clip_slug"`
	ChannelID string    `json:"channel_id"`
	Game      string    `json:"game"`
	Language  string    `json:"language"`
	Score     float64   `json:"score"`
	CreatedAt time.Time `json:"created_at"`
}
