package recommendations

type GetRecommendationsParams struct {
	UserID  string
	Context map[string]interface{}
}

// GetTrendingParams represents a list of parameters for Get trending request
type GetTrendingParams struct {
	Limit     int
	Offset    int
	Languages []string
	Games     []string
}

// GetRecommendationsForDeviceParams represents a list of parameters for Get recommendations for device request
type GetRecommendationsForDeviceParams struct {
	Limit    int
	DeviceID string
	Group    string
}

// GetVodRecommendationsForDeviceParams represents a list of parameters for Get recommendations for device request
type GetVodRecommendationsForDeviceParams struct {
	Limit     int
	Offset    int
	DeviceID  string
	Group     string
	Languages []string
}

// GetRecommendationsForUserParams represents a list of parameters for Get recommendations for user request
type GetRecommendationsForUserParams struct {
	Limit  int
	UserID string
	Group  string
}

// GetSocialRecommendationsForUserParams represents a list of parameters for Get social recommendations for user request
type GetSocialRecommendationsForUserParams struct {
	UserID string
	Limit  int
}

// GetRecommendedStreamsParams represents a list of parameters for Get recommended streams for a channel.
// NOTE: this endpoint is not actually paginated.
type GetRecommendedStreamsParams struct {
	ChannelID string
	Group     string
	Limit     int
	Offset    int
}

type GetOnboardingChannelsParams struct {
	UserID      string
	GameIDs     []string
	Language    string
	WithTopClip bool
}

// GetFavoriteChannelsParams represents a list of parameters for Get favorite channels for a channel request
type GetFavoriteChannelsParams struct {
	ChannelID string
	Limit     int
	Offset    int
}

// GetUnfilteredFavoriteChannelsParams represents a list of parameters for Get unfiltered favorite channels for a channel request
type GetUnfilteredFavoriteChannelsParams struct {
	ChannelID string
	Limit     int
	Offset    int
}

// GetFavoriteGamesParams represents a list of parameters for Get favorite games for a device id request
type GetFavoriteGamesParams struct {
	DeviceID string
	Limit    int
	Offset   int
}

// GetSimilarChannelsParams represents a list of parameters for Get similar channels for a channel request
type GetSimilarChannelsParams struct {
	ChannelID string
	Limit     int
	Offset    int
}

// GetSimilarVideosParams represents a list of parameters for Get similar videos for a video request
type GetSimilarVideosParams struct {
	VodID  string
	Limit  int
	Offset int
}

// GetSimilarClipsParams represents a list of parameters for Get similar clips for a clip request
type GetSimilarClipsParams struct {
	ClipID string
	Limit  int
	Offset int
}

// GetRealtimeClipsParams represents a list of parameters for Get realtime clips request
type GetRealtimeClipsParams struct {
	ChannelID          string
	Game               string
	Language           string
	AlgorithmID        string
	CreatedWithinHours int
	Limit              int
	Offset             int
}
