job {
    name 'discovery-recommendations'
    using 'TEMPLATE-autobuild'
    concurrentBuild true

    scm {
        git {
            remote {
                github 'discovery/recommendations', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    wrappers {
        sshAgent 'git-aws-read-key'
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
        }
    }

    steps {
        shell './scripts/build.sh api'
        shell './scripts/push.sh api'
        saveDeployArtifact 'discovery/recommendations-api-ebextensions', 'deploy/'
    }
}


freeStyleJob('discovery-recommendations-api-production-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'discovery/recommendations-api-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell """set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |set -x
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v
                | eb deploy --timeout 30 production-discovery-recommendations-env""".stripMargin()
    }
}


freeStyleJob('discovery-recommendations-api-staging-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'discovery/recommendations-api-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell """set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |set -x
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v
                | eb deploy staging-discovery-recommendations-env""".stripMargin()
    }
}


freeStyleJob('discovery-recommendations-worker-staging-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'discovery/recommendations-api-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell """set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |set -x
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v
                | eb deploy worker-staging-recommendations-env""".stripMargin()
    }
}

freeStyleJob('discovery-recommendations-worker-production-deploy') {
    using 'TEMPLATE-deploy-aws'

    wrappers {
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            string 'AWS_ACCESS_KEY', 'twitch-discovery-aws-access-key'
            string 'AWS_SECRET_KEY', 'twitch-discovery-aws-secret-key'
        }
    }

    steps {
        // download .ebextensions into deploy/.ebextensions
        downloadDeployArtifact 'discovery/recommendations-api-ebextensions'
        shell 'rm *.manifest*'
        // deploy server
        shell """set +x
                |export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
                |export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
                |set -x
                | eb labs cleanup-versions --num-to-leave 10 --older-than 5 --force -v
                | eb deploy worker-production-recommendations-env""".stripMargin()
    }
}
