# consulconf

A distconf library for fetching configuration from Consul using consul's offical API at github.com/hashicorp/consul/api

Your consul keys should be prefixed in some path inside Consul.  You usually want this path to be `settings/<app_name>/<environment>`.
For example, if your application name was chat and the environment you were configuring was staging, then the prefix would
be `settings/chat/staging`.

# Example usage

Notice in this example I configure two consul prefixes for configuration.
For the most up to date example usage, see `consulconf_integration_test.go`

```
    config := api.DefaultConfig()
    config.Address = "http://some_address.com"
    config.Datacenter = "us-west2"
    client, _ := api.NewClient(config)

    conconfProduction := Consulconf{
        KV: client.KV(),
        Prefix: "settings/chat/production,
    }
	
    conconfDefaults := Consulconf{
        KV: client.KV(),
        Prefix: "settings/chat/defaults,
    }
	
    // Notice we put production first so that location is fetched before defaults are checked
    dconf := distconf.Distconf {
        Readers: []distconf.Reader {
            conconfProduction, conconfDefaults
        }
    }
    
    // Will search the consul key `settings/chat/production/queue.size`
    // then `settings/chat/defaults/queue.size`
    qsize := dconf.Int("queue.size", 10)
    qsize.Get()
```