package manager

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestRegisterSecretUpdateCallback(t *testing.T) {
	const testSecretName = "my-secret-name"

	cb := func(secretName string) {
	}

	t.Run("no existing callbacks", func(t *testing.T) {
		mt := newManagerTest(t)
		defer mt.teardown(t)

		err := mt.m.RegisterSecretUpdateCallback(testSecretName, cb)
		assert.NoError(t, err)

		assert.Contains(t, mt.m.secretCallbacks, testSecretName)
		assert.Len(t, mt.m.secretCallbacks, 1)
		assert.Len(t, mt.m.secretCallbacks[testSecretName], 1)
	})

	t.Run("one existing callbacks", func(t *testing.T) {
		mt := newManagerTest(t)
		defer mt.teardown(t)

		err := mt.m.RegisterSecretUpdateCallback(testSecretName, cb)
		assert.NoError(t, err)

		err = mt.m.RegisterSecretUpdateCallback(testSecretName, cb)
		assert.NoError(t, err)

		assert.Contains(t, mt.m.secretCallbacks, testSecretName)
		assert.Len(t, mt.m.secretCallbacks, 1)
		assert.Len(t, mt.m.secretCallbacks[testSecretName], 2)
	})
}

func TestTriggerSecretUpdateCallbacks(t *testing.T) {
	const testSecretName = "my-secret-name"

	t.Run("no callbacks", func(t *testing.T) {
		mt := newManagerTest(t)
		defer mt.teardown(t)

		mt.m.triggerSecretUpdateCallbacks(testSecretName)
	})

	t.Run("no callbacks match", func(t *testing.T) {
		mt := newManagerTest(t)
		defer mt.teardown(t)

		calls := []string{}
		cb := func(secretName string) {
			calls = append(calls, secretName)
		}

		err := mt.m.RegisterSecretUpdateCallback("something-else", cb)
		assert.NoError(t, err)

		mt.m.triggerSecretUpdateCallbacks(testSecretName)

		assert.Equal(t, []string{}, calls)
	})

	t.Run("one callback matches", func(t *testing.T) {
		mt := newManagerTest(t)
		defer mt.teardown(t)

		calls := []string{}
		cb := func(secretName string) {
			calls = append(calls, secretName)
		}

		err := mt.m.RegisterSecretUpdateCallback(testSecretName, cb)
		assert.NoError(t, err)

		mt.m.triggerSecretUpdateCallbacks(testSecretName)

		assert.Equal(t, []string{
			testSecretName,
		}, calls)
	})
}
