# clips-upload

The full server stack responsible for processing clip creation and rendering the resulting clips page.

**API Documentation**: https://dev.twitch.tv/docs/v5/guides/clips-discovery/

## Production

The clips integration into the mainsite/player lives [here](https://git-aws.internal.justin.tv/video/player-ui).

Clips is powered by [Elastic Beanstalk](https://aws.amazon.com/elasticbeanstalk/) and can be modified by
going to the [AWS Console](https://twitch-video-aws.signin.aws.amazon.com/console), assuming you have an account within
the Twitch-Video-AWS account. Under the Beanstalk view, search for "clips" to find our environments:

* Production: `https://clips.twitch.tv`
* Alpha Web: `https://staging-ffa-48-www.dev.us-west2.twitch.tv/`
* Alpha: `https://clips-alpha.twitch.tv`
* Beta: `https://clips-beta.twitch.tv`
* Staging Web: `https://staging-ffa-41-www.dev.us-west2.twitch.tv/`
* Staging: `https://clips-staging.twitch.tv`

Information around our environments and their infrastructure can be found [here](docs/environments.md).

### Deploy Tool
https://clean-deploy.internal.justin.tv/#/video/clips-upload

Note: Every passing origin/master build is auto-deployed when there is no freeze on the production-external environment.
* If your branch code shouldn't be on production for any reason, do not merge your branch into master.
* If you need to deploy at a specific time for some reason, you can freeze production-external environment
in clean-deploy tool above. When you'd like to release, simply unfreeze and deploy manually.

### Tracking Events

The Clips Tracking report is viewable [here](https://modeanalytics.com/editor/twitch/reports/2688100b85e6).

The schemas behind our events can be viewed at `http://blueprint.sci.twitch.tv/schema/<schema_name>`.
When an event is fired and ingested by Spade, it will take ~5 hours before it can be
queried by [Mode](https://modeanalytics.com/).

The specification for these fields is defined [here](https://docs.google.com/document/d/1CEQ2FJCZfmcQIBz7KPocXsWl2phc3JdCaSNfkw1prCw).

### Engineering Stats

Are tracked within Grafana [here](https://grafana.internal.justin.tv/dashboard/db/clips).

## Developer Notes

### Prerequisites
* [Brew](http://brew.sh/index.html)
* [Go](https://golang.org/dl/) or alternatively, `brew install go`
  * Add `$GOPATH` and update `$PATH` in your startup scripts

    ```sh
    # e.g. in ~/.bash_profile
    export GOPATH=$HOME/go
    export PATH=$GOPATH/bin:$PATH
    ```
  * [Retool](https://github.com/twitchtv/retool) We use retool to manage our Go tools. To install, do `go get github.com/twitchtv/retool` after installing Go.
* [VirtualBox](https://www.virtualbox.org/wiki/Downloads)
* [Vagrant](https://git-aws.internal.justin.tv/video/clips-upload/blob/master/docs/vagrant.md)
* [Node.js](http://nodejs.org/) `brew install node` (Other repositories like `player-ui` uses `node4`, possibly use [nvm](https://github.com/creationix/nvm) to manage node versions)
* [Yarn](https://yarnpkg.com/en/) `brew install yarn --without-node` --without-node allows yarn to fallback onto your nvm version of node
* Nginx `brew install nginx`
* Access to the `twitch-video-aws` AWS account

  ```sh
  # Save to ~/.bash_profile for convenience
  export AWS_ACCESS_KEY='<aws_access_key_id>'
  export AWS_SECRET_KEY='<aws_secret_access_key>'
  ```
* Run `source ~/.bash_profile` or restart the terminal to refresh your environment variables.

### **Go Tools**

These are the packages we use in this repository. Currently these packages are being managed by [retool](https://github.com/twitchtv/retool).
* [counterfeiter](https://github.com/maxbrunsfeld/counterfeiter)
* [errcheck](https://github.com/kisielk/errcheck)
* [ginkgo](https://github.com/onsi/ginkgo)
* [go-i18n](https://git-aws.internal.justin.tv/web/go-i18n)
* [golint](https://github.com/golang/lint/golint)
* [govendor](https://github.com/kardianos/govendor)

### Installation

Get access to the `video` repository from a tech lead and set up [github authentication](https://help.github.com/articles/generating-a-new-ssh-key-and-adding-it-to-the-ssh-agent)

Fetch and install this repository:
```sh
go get code.justin.tv/video/clips-upload
cd <GOPATH HERE>/code.justin.tv/video/clips-upload
```

Run setup script to configure Nginx (among other things): `sudo scripts/dev_setup.sh $GOPATH`

WARNING: The script makes a few assumptions about your setup. Reading the script before running it is highly recommended.

Launch asset server:
```sh
yarn setup # retrieves all modules, installs hooks. Run this any time the package.json file has updated.
yarn start # serves JS and CSS, recompiles on JS changes
```

or

```sh
yarn setup && yarn start # if you don't care about losing 5 secs to a dependency check, this command is nice and easy
```

Launch app server:
```sh
make vserver # Tails the server logs, recompiles on golang changes
```

* IMPORTANT: In order to get the page to load properly, you need to allow/trust the following pages:
  * https://clips-assets.twitch.tv
  * https://clips-assets.twitch.tv/clips.js
  * https://clips-local.twitch.tv

Alternatively, regenerate the cert and trust it:
* Remove cert and key in `$NGINX_DIR/ssl`
* Regenerate the cert and key, making sure to set the `Common Name` field to `*.twitch.tv`
* Add the cert to the `System` keychain and set it to `Always Trust`
  * One easy method is to double click the generated `nginx.crt` file
  * Guides are available online ([example](http://www.andrewconnell.com/blog/setup-self-signed-certificates-trusting-them-on-os-x))
* Restart your browsers

Make sure you understand [the risks](http://security.stackexchange.com/questions/8110/what-are-the-risks-of-self-signing-a-certificate-for-ssl)!

### Testing

- Backend tests are ran via: `make vspecs`
  - For development, see [documentation](docs/testing.md) on using `ginkgo watch`
- Frontend tests are ran via: `yarn test` or `yarn run test:watch`

- We use [counterfeiter](https://github.com/maxbrunsfeld/counterfeiter) for
  mocking intefaces in Go

- For tests that do not rely on templating/configuration, just focus the test and run `ginkgo /path/to/suite` locally

- For js tests, add test specs to `assets/spec`

- For Smoca tests, see our [wiki](https://git-aws.internal.justin.tv/video/clips-upload/wiki/Smoca)

### Internationalization

See docs/i18n.md

### Linting

The project is configured to use [babel-eslint](https://github.com/babel/babel-eslint)
for JavaScript styling rules. Simply enable `eslint` run-on-save support within
your editor to enable this after having run `yarn start`.

### Updating/Adding node modules
Submit any node module updates in their own PR. Any other changes in these PRs are hard to find and review.

`yarn add package-name@1.2.3` in order to add/update a module. Add a -D for dev modules. Please include the version.


### Setting Up video/player-ui for local clip creation

* [player-ui](https://git-aws.internal.justin.tv/video/player-ui)
* To start the player checkout the `clips-staging` branch and run `npm start`
