package clips

import (
	"encoding/json"
	"net/http"
	"net/http/httptest"
	"testing"

	"code.justin.tv/foundation/twitchclient"

	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"
)

func TestClipsClient(t *testing.T) {
	RegisterFailHandler(Fail)
	RunSpecs(t, "Clips client suite")
}

func initClient(host string) Client {
	client, err := NewClient(twitchclient.ClientConf{
		Host: host,
	})
	Expect(err).To(BeNil())
	Expect(client).To(Not(BeNil()))
	return client
}

func initTestServer(path string, responseBody interface{}, expectedRequestBody map[string]interface{}) *httptest.Server {
	return httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		Expect(r.URL.String()).To(Equal(path))

		if expectedRequestBody != nil {
			var decodedRequestBody map[string]interface{}
			decodeErr := json.NewDecoder(r.Body).Decode(&decodedRequestBody)
			Expect(decodeErr).To(BeNil())
			Expect(decodedRequestBody).To(Equal(expectedRequestBody))
		}

		if responseBody == nil {
			w.WriteHeader(http.StatusNoContent)
		} else {
			err := json.NewEncoder(w).Encode(responseBody)
			Expect(err).To(BeNil())
		}
	}))
}

func initBrokenTestServer(status int) *httptest.Server {
	return httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		w.WriteHeader(status)
	}))
}
