package utils

import (
	"net/http"

	"code.justin.tv/common/twitchhttp"
)

func ConstructSingleClipTwitchError(resp *http.Response) error {
	if resp.StatusCode == http.StatusForbidden {
		return &twitchhttp.Error{StatusCode: http.StatusForbidden, Message: "this channel has been closed due to terms of service violation"}
	} else if resp.StatusCode == http.StatusNotFound {
		return &twitchhttp.Error{StatusCode: http.StatusNotFound, Message: "clip not found"}
	}

	return twitchhttp.HandleFailedResponse(resp)
}
