import boto3
from boto3.dynamodb.conditions import Key, Attr
import sys

client = boto3.client('dynamodb')
dynamodb = boto3.resource('dynamodb')

def get_media_for_broadcaster(broadcaster_login):
    table = dynamodb.Table("clips")
    response = table.scan(
        FilterExpression=Attr("broadcaster_login").eq(broadcaster_login)
        )
    items = response['Items']
    ret = set()
    while(len(items)) != 0:
        for item in items:
            ret.add(item['media_key'])
        if 'LastEvaluatedKey' not in response:
            break
        response = table.scan(
                FilterExpression=Attr("broadcaster_login").eq(broadcaster_login),
                ExclusiveStartKey=response['LastEvaluatedKey']
            )
        items = response['Items']
    return ret

def delete_clips(media_keys):
    table = dynamodb.Table("clips-media")
    for key in media_keys:
        table.update_item(
            Key={
                "media_key": key
            },
            UpdateExpression = 'SET #nm = :val1',
            ExpressionAttributeValues={
                ":val1": "404_deleted"
            },
            ExpressionAttributeNames={
                "#nm": "status"
            })

media_keys = get_media_for_broadcaster(sys.argv[1])
print(media_keys)
delete_clips(media_keys)