const TEST_FILE = './assets/webpack/tests.webpack.js';
const TEST_MATCHERS = './assets/spec/matchers/index.js';
const webpack = require('./webpack.config.js');
webpack.entry = function(){return {};};

const localConfig = {
  frameworks: [ 'jasmine' ],
	// Order matters here. Load all the plugins before the files.
  files: [
    'node_modules/jasmine-promises/dist/jasmine-promises.js',
    'node_modules/jasmine-expect-jsx/dist/jasmine-expect-jsx.js',
    TEST_MATCHERS,
    TEST_FILE
  ],
  browsers: [ 'Chrome' ],
  preprocessors: {
    [TEST_FILE]: [ 'webpack', 'sourcemap' ]
  },
  autoWatch: true,
  webpack: webpack,
  webpackMiddleware: {
    noInfo: true
  },
  reporters: [
    'spec',
    'super-dots'
  ],
  specReporter: {
    suppressSkipped: true,
    suppressFailed: false,
    suppressPassed: true,
    suppressErrorSummary: false
  },
  customLaunchers: {
    Chrome_manta: {
      base: 'Chrome',
      flags: [ '--no-sandbox' ]
    }
  },
  superDotsReporter: {
    nbDotsPerLine : 10000,
    icon: {
      success : '.',
      failure : '༼ノಠل͟ಠ༽ノ ︵ ┻━┻\n',
      ignore  : ','
    }
  },
  plugins: [
    'karma-webpack',
    'karma-jasmine',
    'karma-spec-reporter',
    'karma-super-dots-reporter',
    'karma-sourcemap-loader',
    'karma-chrome-launcher',
    'karma-firefox-launcher'
  ]
};

const customLaunchers = {
  bs_win_10_chrome: {
    base: 'BrowserStack',
    os: 'windows',
    os_version: '10',
    browser: 'chrome',
    browser_version: '53.0'
  },
  bs_win_10_firefox: {
    base: 'BrowserStack',
    os: 'windows',
    os_version: '10',
    browser: 'firefox',
    browser_version: '49.0'
  },
  bs_win_10_edge: {
    base: 'BrowserStack',
    os: 'windows',
    os_version: '10',
    browser: 'edge',
    browser_version: '13'
  },
  bs_win_7_chrome: {
    base: 'BrowserStack',
    os: 'windows',
    os_version: '7',
    browser: 'chrome',
    browser_version: '53.0'
  },
  bs_win_7_firefox: {
    base: 'BrowserStack',
    os: 'windows',
    os_version: '7',
    browser: 'firefox',
    browser_version: '49.0'
  },
  bs_osx_el_capitan_safari: {
    base: 'BrowserStack',
    os: 'OS X',
    os_version: 'El Capitan',
    browser: 'Safari',
    browser_version: '9.1'
  },
  bs_android_4_4: {
    base: 'BrowserStack',
    device: 'Samsung Galaxy S5',
    os: 'android',
    os_version: '4.4'
  },
  bs_iphone_9_1: {
    base: 'BrowserStack',
    device: 'iPhone 6S Plus',
    os: 'ios',
    os_version: '9.1'
  },
  bs_iphone_8_3: {
    base: 'BrowserStack',
    device: 'iPhone 6',
    os: 'ios',
    os_version: '8.3'
  },
  bs_ipad_9_1: {
    base: 'BrowserStack',
    device: 'iPad Air 2',
    os: 'ios',
    os_version: '9.1'
  }
};

const browserstackConfig = Object.assign({}, localConfig, {
  browsers: Object.keys(customLaunchers),
  browserStack: {
    username: process.env.BROWSERSTACK_USERNAME,
    accessKey: process.env.BROWSERSTACK_ACCESS_KEY,
    selenium_version: '3.0.0-beta2'
  },
  preprocessors: {
    [TEST_FILE]: [ 'webpack', 'sourcemap' ],
    [TEST_MATCHERS]: [ 'webpack', 'sourcemap' ]
  },
  concurrency: 1,
  browserDisconnectTimeout: 10000,
  browserDisconnectTolerance: 0,
  retryLimit: 0,
  autoWatch: false,
  reporters: [
    'progress',
    'BrowserStack'
  ],
  customLaunchers: customLaunchers,
  plugins: [
    'karma-webpack',
    'karma-jasmine',
    'karma-sourcemap-loader',
    'karma-browserstack-launcher'
  ],
  singleRun: true
});

module.exports = function (config) {
  const { BROWSERSTACK, BROWSERSTACK_USERNAME, BROWSERSTACK_ACCESS_KEY } = process.env;

  if (BROWSERSTACK && !(BROWSERSTACK_USERNAME || BROWSERSTACK_ACCESS_KEY)) {
    throw(new Error('Browserstack credentials not set! Refer to docs/cross_browser_testing.md'));
  }

  let testConfig = (BROWSERSTACK) ? browserstackConfig : localConfig;
  testConfig.logLevel = config.LOG_DISABLE;

  config.set(testConfig);
};
