package associations

import "fmt"

// ErrInvalidID means the provided ID is invalid
type ErrInvalidID struct {
	Message string
}

func (a ErrInvalidID) Error() string {
	return a.Message
}

// ErrNotFound means the combination of ID's and Kind provided did
// not match a known Association
type ErrNotFound struct {
	Assoc *Association
}

func (e ErrNotFound) Error() string {
	return fmt.Sprintf("No association:%q found", e.Assoc)
}

// ErrInvalidKind means the provided Kind is not valid in this context
type ErrInvalidKind struct {
	Message string
}

func (a ErrInvalidKind) Error() string {
	return a.Message
}

// ErrAssociationExists means we tried to create an existing
// Association.
type ErrAssociationExists struct {
	// The underlying ErrAssociationExists occured due to
	Source error
}

const unknownErrorType = "Association already exists"

// Error returns the output of Error() on the underlying error,
// "unknown" if Source is not set
func (a ErrAssociationExists) Error() string {
	if a.Source != nil {
		return a.Source.Error()
	}
	return unknownErrorType
}
