package v2

import (
	"code.justin.tv/web/cohesion/rpc"

	"golang.org/x/net/context"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
)

func (c *v2Client) Get(ctx context.Context, from Entity, kind string, to Entity) (*ListResponse, error) {
	request, err := c.newRequest(from, kind, to, nil)
	if err != nil {
		return nil, err
	}

	resp, err := c.conn.Get(ctx, request)
	if err != nil {
		if grpc.Code(err) == codes.NotFound {
			return nil, nil
		}
		return nil, err
	}

	return newListResponse(resp), err
}

func (c *v2Client) BulkGet(ctx context.Context, from Entity, kind string, bulkKind string, opts ...func(*rpc.RequestOptions)) (*ListResponse, error) {
	request, err := c.newBulkRequest(from, kind, bulkKind, nil)
	if err != nil {
		return nil, err
	}

	request.Options.Offset = 0
	request.Options.Limit = 100
	request.Options.Sort = rpc.Sort_ASC

	for _, opt := range opts {
		opt(request.Options)
	}

	resp, err := c.conn.Get(ctx, request)
	if err != nil {
		return nil, err
	}

	return newListResponse(resp), err
}
