package v2

import (
	"code.justin.tv/web/cohesion/rpc"

	"golang.org/x/net/context"
)

func (c *v2Client) GetHitCounts(ctx context.Context, client string, minutes int) (map[string]int, error) {

	request := &rpc.HitCountRequestV2{
		Source:  c.source,
		Client:  client,
		Minutes: int64(minutes),
	}

	resp, err := c.conn.GetHitCounts(ctx, request)
	if err != nil {
		return nil, err
	}

	result := make(map[string]int)
	for _, h := range resp.HitCounts {
		result[h.Client] = int(h.HitCounts)
	}

	return result, err
}
