// +build integration

package gomemcache_test

import (
	"context"
	"testing"
	"time"

	"code.justin.tv/feeds/distconf"
	"code.justin.tv/feeds/service-common"
	"code.justin.tv/feeds/service-common/feedcache"
	"code.justin.tv/feeds/service-common/feedcache/gomemcache"
	"code.justin.tv/foundation/gomemcache/memcache"
	. "github.com/smartystreets/goconvey/convey"
)

type testConfig struct {
	gomemcache.GomemcacheConfig
}

func (t *testConfig) Load(dconf *distconf.Distconf) error {
	return t.Verify("inttest", dconf)
}

func TestRedisIntegration(t *testing.T) {
	s := service_common.ConfigCommon{
		Team:          "feeds",
		Service:       "int_tests",
		BaseDirectory: "../../../fanout/",
	}
	err := s.Setup()
	if err != nil {
		t.Error("Unable to set up config")
		return
	}
	var mconf testConfig
	err = mconf.Load(s.Config)
	if err != nil {
		t.Error("Unable to load config")
		return
	}
	configServer := s.Config.Str("testing.memcache.config_server", "").Get()
	client, _ := memcache.Elasticache(configServer, time.Minute)
	if client == nil {
		t.Error("Unable to get client")
		return
	}

	mcache := gomemcache.NewGomemcache(client, &mconf.GomemcacheConfig, "int_test:", nil, service_common.NopStatSender())

	Convey("With a memcache integration", t, func() {
		ctx := context.Background()
		feedcache.CommonCacheTestingHelper(ctx, t, mcache)
	})
}
