// +build integration

package redisold

import (
	"testing"

	"code.justin.tv/feeds/service-common"
	. "github.com/smartystreets/goconvey/convey"
	"golang.org/x/net/context"
)

func TestRedisIntegration(t *testing.T) {
	Convey("With a redis integration", t, func() {
		s := service_common.ConfigCommon{
			Team:          "feeds",
			Service:       "int_tests",
			BaseDirectory: "../",
		}
		So(s.Setup(), ShouldBeNil)
		var rconf RedisConfig
		var rcacheconf RedisCacheConfig
		So(rconf.Verify("testing.redis-old", s.Config), ShouldBeNil)
		So(rcacheconf.Verify("testing.redis-old", s.Config), ShouldBeNil)
		rcache := RedisCache{
			Pool:      NewRedisPool(&rconf),
			Config:    &rcacheconf,
			Stats:     service_common.NopStatSender(),
			KeyPrefix: "inttest:",
			Log:       nil,
		}
		var callbackInt []int64
		var callbackErr error
		callbackCount := 0
		callback := func() ([]int64, error) {
			callbackCount++
			return callbackInt, callbackErr
		}
		key := "TestRedisIntegration2"
		ctx := context.Background()
		So(rcache.Invalidate(ctx, key), ShouldBeNil)
		Reset(func() {
			So(rcache.Invalidate(ctx, key), ShouldBeNil)
		})
		callbackInt = []int64{1, 3}

		So(callbackCount, ShouldEqual, 0)
		ints, err := rcache.Ints(ctx, key, callback)

		So(err, ShouldBeNil)
		So(callbackCount, ShouldEqual, 1)
		So(ints, ShouldResemble, callbackInt)

		callbackInt = []int64{1, 5}

		ints, err = rcache.Ints(ctx, key, callback)
		So(err, ShouldBeNil)
		So(callbackCount, ShouldEqual, 1)
		So(ints, ShouldResemble, []int64{1, 3})

		key2 := "to_invalidate"
		So(rcache.Invalidate(ctx, key2), ShouldBeNil)

		type toCache struct {
			Name string
		}

		var thing toCache
		So(rcache.Cached(ctx, key2, func() (interface{}, error) {
			return toCache{
				Name: "bob",
			}, nil
		}, &thing), ShouldBeNil)
		So(thing.Name, ShouldEqual, "bob")
	})
}
