package sfximporter

import (
	"net/http"

	"code.justin.tv/feeds/distconf"
	"code.justin.tv/feeds/service-common"
	"goji.io"
	"goji.io/pat"
)

// HTTPConfig configures HTTPServer
type HTTPConfig struct {
	service_common.BaseHTTPServerConfig
}

// Load load config values from distconf
func (c *HTTPConfig) Load(dconf *distconf.Distconf) error {
	return c.Verify(dconf, "sfximporter")
}

type HTTPServer struct {
	service_common.BaseHTTPServer
}

// SetupRoutes configures the http server
func (h *HTTPServer) SetupRoutes(mux *goji.Mux) {
	mux.Handle(pat.Get("/debug/health"), h.createHandler("get_health", h.getHealth))
}

func (h *HTTPServer) createHandler(name string, callback func(req *http.Request) (interface{}, error)) *service_common.JSONHandler {
	return &service_common.JSONHandler{
		Log:          h.Log,
		Stats:        h.Stats.NewSubStatSender(name),
		ItemCallback: callback,
	}
}

func (h *HTTPServer) getHealth(req *http.Request) (interface{}, error) {
	return "OK", nil
}
