package sfximporter

import (
	"code.justin.tv/feeds/log"
	"github.com/signalfx/golib/datapoint"
	"github.com/signalfx/golib/datapoint/dpsink"
	"github.com/signalfx/golib/event"
	"golang.org/x/net/context"
)

type SfxLoggedClient struct {
	Log log.Logger
}

var _ dpsink.Sink = &SfxLoggedClient{}

func (s *SfxLoggedClient) AddEvents(ctx context.Context, events []*event.Event) error {
	for _, e := range events {
		s.Log.Log("event", e, "sent event")
	}
	return nil
}

func (s *SfxLoggedClient) AddDatapoints(ctx context.Context, points []*datapoint.Datapoint) error {
	for _, p := range points {
		s.Log.Log("datapoint", p, "sent datapoint")
	}
	return nil
}
