#!/bin/bash
set -ex
go env
go version
env
TEAM="feeds"
SERVICE="sfximporter"
if [ -z "$AWS_CONFIG_FILE" ]; then
	CREDS="-v $HOME/.aws:/root/.aws:ro"
else
	CREDS="-e AWS_SHARED_CREDENTIALS_FILE=/awsconfig -v $AWS_CONFIG_FILE:/awsconfig:ro"
fi
docker run -w /go/src/code.justin.tv/$TEAM/$SERVICE $CREDS  -v `pwd`:/go/src/code.justin.tv/$TEAM/$SERVICE docker.internal.justin.tv/feeds/gobuilder:1.9.2-0 make jenkins
if [ -z "$GIT_COMMIT" ]; then
  GIT_COMMIT=$(git rev-parse --verify HEAD)-$(whoami)
fi
./vendor/code.justin.tv/twitch/ecs-deploy/helpers/build-tag-push.sh $TEAM $SERVICE $GIT_COMMIT ./cmd/$SERVICE/Dockerfile
