package service_common

import (
	"strings"
	"testing"
)

type Logger interface {
	Log(params ...string)
}

type AThing struct {
	Name string
	Age  *int
}

type ALogger struct {
	Name *string
}

func (a *ALogger) Log(params ...string) {
}

type S1 struct {
	Log        Logger
	Log2       Logger
	ForeverNil Logger `nilcheck:"ignore"`
	SomeNil    Logger `nilcheck:"nodepth"`
	Ints       []int
	Loggers    []Logger
	Things     []AThing
	ThingPtr   []*AThing
	Thing      AThing
}

func sliceCheck(t *testing.T, res []string, expected []string) {
	a := strings.Join(res, ",")
	b := strings.Join(expected, ",")
	if a != b {
		t.Errorf("%v vs %v does not match: %s vs %s", res, expected, a, b)
	}
}

func TestNilCheck(t *testing.T) {
	a := 3
	n := "abc"
	fullAthing := AThing{
		Age: &a,
	}
	fullALog := ALogger{
		Name: &n,
	}

	testRuns := []struct {
		name     string
		val      interface{}
		expected []string
	}{
		{
			"firstNil",
			nil,
			nil,
		},
		{
			"Empty S1",
			&S1{
				SomeNil: &ALogger{}, // Notice Name is nil inside here
			},
			[]string{"/Log", "/Log2", "/Thing/Age"},
		},
		{
			"Fully set S1",
			&S1{
				Log:     &fullALog,
				Log2:    &fullALog,
				Thing:   fullAthing,
				SomeNil: &ALogger{},
				Loggers: []Logger{&fullALog},
			},
			nil,
		},
		{
			"Nil middles",
			&S1{
				Log:     &fullALog,
				Log2:    &fullALog,
				Thing:   fullAthing,
				SomeNil: &ALogger{},
				Loggers: []Logger{nil, &ALogger{}},
			},
			[]string{"/Loggers/0", "/Loggers/1/Name"},
		},
		{
			"Missing one log",
			&S1{
				Log2:  &fullALog,
				Thing: fullAthing,
			},
			[]string{"/Log", "/SomeNil"},
		},
	}

	for _, run := range testRuns {
		t.Run(run.name, func(t *testing.T) {
			result := (&NilCheck{}).Check(run.val)
			sliceCheck(t, result.res, run.expected)
		})
	}
}
