#!/bin/bash
set -ex

BUILD_PIPELINE_VERSION="v0.4.5"

function docker_run() {
  ADD_CONFIG_ENV=""
  if [ ! -z "$AWS_CONFIG_FILE" ]; then
    ADD_CONFIG_ENV="-e AWS_CONFIG_FILE=/awsconfig -v $AWS_CONFIG_FILE:/awsconfig:ro"
  fi
  echo 'docker run --read-only -e AWS_SDK_LOAD_CONFIG=1 '$ADD_CONFIG_ENV' -v '$(pwd)':/twitch:ro docker-registry.internal.justin.tv'
}

function build_tag_push() {
  TEAM_NAME=$1
  BINARY_NAME=$2
  VERSION=$3
  DOCKERFILE=$4
  if [ -z "$VERSION" ]; then
    VERSION=$GIT_COMMIT
  fi
  if [ -z "$VERSION" ]; then
    echo "Unable to find set version"
    return 1
  fi
  if [ -z "$TEAM_NAME" ]; then
    echo "Unable to find set team name"
    return 1
  fi
  if [ -z "$DOCKERFILE" ]; then
    DOCKERFILE="Dockerfile"
  fi
  if [ ! -f "$DOCKERFILE" ]; then
    echo "Unable to find build file $DOCKERFILE"
    echo "Inside directory $(pwd)"
    exit 1
  fi

  docker build -f $DOCKERFILE -t $TEAM_NAME/$BINARY_NAME:${VERSION} .
  docker tag $TEAM_NAME/$BINARY_NAME:${VERSION} docker-registry.internal.justin.tv/$TEAM_NAME/$BINARY_NAME:${VERSION}
  docker push docker-registry.internal.justin.tv/$TEAM_NAME/$BINARY_NAME:${VERSION}

  IFS='/' read -r -a array <<< "$GIT_BRANCH"
  BRANCH=${array[1]}
  if [ "$BRANCH" == "master" ]; then
    BRANCH="latest"
  fi
  if [ -z "$var" ]; then
    exit 0
  fi
  docker tag $TEAM_NAME/$BINARY_NAME:${VERSION} docker-registry.internal.justin.tv/$TEAM_NAME/$BINARY_NAME:$BRANCH
  docker push docker-registry.internal.justin.tv/$TEAM_NAME/$BINARY_NAME:$BRANCH
  $(docker_run)/twitch/ecs-deploy:$BUILD_PIPELINE_VERSION /ecs-deploy pipeline certify set $TEAM_NAME $BINARY_NAME $BRANCH $VERSION
}

which docker
env
build_tag_push "$1" "$2" "$3" "$4"
