# spade

This is a spade client for twitch.  It uses a background goroutine
to drain events to spade in batches.  You can safely call QueueEvents
without worry it will block, and safely drops messages if Spade misbehaves.


# Usage

```

  var dconf distconf.Distconf
  // ... setup distconf if you want

  // Load spade config
  config := spade.Config{}
  config.Load(&dconf)

  // Create a spade client
  spadeClient := spade.Client{
    Config: &config,
  }
  // Must call Setup() to drain the channel
  spadeClient.Setup()

  // Queue an event
  spadeClient.QueueEvents(spade.Event{
    Name: "feed_server_post",
    Properties: struct {
      AuthorID string `json:"author_id"`
    }{
      AuthorID:  params.UserID,
    },
  })

  // ...
  // When done, close the spade client
  spadeClient.Close()
```
