package queue

import (
	"io/ioutil"
	"testing"
	"time"

	"code.justin.tv/systems/sandstorm/util"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/credentials/stscreds"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/sns"
	"github.com/aws/aws-sdk-go/service/sqs"
	"github.com/aws/aws-sdk-go/service/sts"
	"github.com/sirupsen/logrus"
	. "github.com/smartystreets/goconvey/convey"
)

func TestQueue(t *testing.T) {

	Convey("For a configured Queue", t, func() {

		Convey("queue management", func() {
			awsConfig := &aws.Config{Region: aws.String("us-west-2")}

			stsclient := sts.New(session.New(awsConfig))

			arp := &stscreds.AssumeRoleProvider{
				Duration:     900 * time.Second,
				ExpiryWindow: 10 * time.Second,
				RoleARN:      "arn:aws:iam::734326455073:role/sandstorm-agent-testing-rw",
				Client:       stsclient,
			}

			credentials := credentials.NewCredentials(arp)
			awsConfig.WithCredentials(credentials)

			sess := session.New(awsConfig)
			q := New(sqs.New(sess), sns.New(sess), Config{
				QueueConfigPath: "/build/go/src/code.justin.tv/systems/sandstorm/queue",
				TopicArn:        "arn:aws:sns:us-west-2:734326455073:sandstorm-testing",
			}, &logrus.Logger{Out: ioutil.Discard})
			err := q.Setup()
			So(err, ShouldBeNil)

			Convey("->deleteQueue()", func() {
				err := q.Delete()
				So(err, ShouldBeNil)
				So(util.FileExists(q.Config.queueConfigPath()), ShouldBeFalse)

				_, err = q.getQueueAttributes("QueueArn")
				So(err, ShouldNotBeNil)
			})
		})
	})
}
