locals {
  team = "feeds"

  jenkins_build_secrets = {
    integration = "aws-feeds-integration"
    staging     = "aws-feeds-staging"
    canary      = "aws-feeds-canary"
    production  = "aws-feeds-production"
  }

  xray_roles = {
    integration = "arn:aws:iam::465369119046:role/foundation-xray-role"
    staging     = "arn:aws:iam::465369119046:role/foundation-xray-role"
    canary      = "arn:aws:iam::641044725657:role/foundation-xray-role"
    production  = "arn:aws:iam::641044725657:role/foundation-xray-role"
  }

  s3_backup_buckets = {
    integration = "twitch-feed-dev-dynamodb-backup"
    staging     = "twitch-feed-dev-dynamodb-backup"
    canary      = "twitch-feed-aws-dynamodb-backup"
    production  = "twitch-feed-aws-dynamodb-backup"
  }

  s3_log_buckets = {
    integration = "twitch-feed-dev-logs"
    staging     = "twitch-feed-dev-logs"
    canary      = "twitch-feed-aws-logs"
    production  = "twitch-feed-aws-logs"
  }

  account_ids = {
    integration = "724951484461"
    staging     = "724951484461"
    canary      = "914569885343"
    production  = "914569885343"
  }

  on_demand_role_enableds = {
    integration = false
    staging     = true
    canary      = false
    production  = false
  }

  jenkins_build_secret   = local.jenkins_build_secrets[terraform.workspace]
  xray_role              = local.xray_roles[terraform.workspace]
  environment            = terraform.workspace
  s3_backup_bucket       = local.s3_backup_buckets[terraform.workspace]
  s3_log_bucket          = local.s3_log_buckets[terraform.workspace]
  on_demand_role_enabled = local.on_demand_role_enableds[terraform.workspace]

  profiles = {
    integration = "twitch-feed-dev"
    staging     = "twitch-feed-dev"
    canary      = "twitch-feed-aws"
    production  = "twitch-feed-aws"
  }
}

provider "aws" {
  region              = "us-west-2"
  profile             = local.profiles[terraform.workspace]
  allowed_account_ids = [local.account_ids[terraform.workspace]]
}

terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "feeds/core-account.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

data "terraform_remote_state" "ecs_on_demand_core" {
  backend   = "s3"
  workspace = "production"

  config = {
    bucket  = "twitch-feed-aws"
    key     = "feeds/ondemand-us-west-2.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

output "jenkins_build_secret" {
  value = local.jenkins_build_secret
}

module "core_account" {
  source = "../../module/core_account"

  xray_role          = local.xray_role
  team               = local.team
  environment        = local.environment
  ecs_on_demand_role = local.on_demand_role_enabled ? data.terraform_remote_state.ecs_on_demand_core.outputs.task_role_arn : ""
}

output "build_user" {
  value = module.core_account.build_user
}

output "build_user_arn" {
  value = module.core_account.build_user_arn
}

output "build_role" {
  value = module.core_account.build_role
}

output "container_instance_profile_id" {
  value = module.core_account.container_instance_profile_id
}

output "container_iam_role" {
  value = module.core_account.container_iam_role
}

output "service_iam_role" {
  value = module.core_account.service_iam_role
}

output "task_autoscale_iam_role" {
  value = module.core_account.task_autoscale_iam_role
}

output "xray_task_role" {
  value = module.core_account.xray_task_role
}

output "s3_log_bucket" {
  value = local.s3_log_bucket
}

output "s3_backup_bucket" {
  value = local.s3_backup_bucket
}

