locals {
  team  = "feeds"
  owner = "jlindamo@justin.tv"

  account_ids = {
    twitch-feed-dev = "724951484461"
    twitch-feed-aws = "914569885343"
  }

  profiles = {
    twitch-feed-dev = "twitch-feed-dev"
    twitch-feed-aws = "twitch-feed-aws"
  }
}

provider "aws" {
  region              = "us-west-2"
  profile             = local.profiles[terraform.workspace]
  allowed_account_ids = [local.account_ids[terraform.workspace]]
}

terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "feeds/core-global.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

resource "aws_vpc" "emr_vpc" {
  cidr_block           = "10.0.0.0/24"
  enable_dns_hostnames = true

  tags = {
    Name  = "emr"
    Owner = local.owner
  }
}

resource "aws_subnet" "emr_subnet" {
  vpc_id     = aws_vpc.emr_vpc.id
  cidr_block = "10.0.0.0/24"

  tags = {
    Name  = "emr-subnet"
    Owner = local.owner
  }
}

resource "aws_route_table" "emr" {
  vpc_id = aws_vpc.emr_vpc.id

  route {
    cidr_block = "0.0.0.0/0"
    gateway_id = aws_internet_gateway.emr.id
  }

  tags = {
    Name  = "EMR route table"
    Owner = local.owner
  }
}

resource "aws_route_table_association" "emr" {
  subnet_id      = aws_subnet.emr_subnet.id
  route_table_id = aws_route_table.emr.id
}

resource "aws_internet_gateway" "emr" {
  vpc_id = aws_vpc.emr_vpc.id

  tags = {
    Name  = "emr-pub"
    Owner = local.owner
  }
}

output "emr_subnet" {
  value = aws_subnet.emr_subnet.id
}

