locals {
  owner = "jlindamo@twitch.tv"

  account_ids = {
    integration = "724951484461"
    staging     = "724951484461"
    canary      = "914569885343"
    production  = "914569885343"
  }

  profiles = {
    integration = "twitch-feed-dev"
    staging     = "twitch-feed-dev"
    canary      = "twitch-feed-aws"
    production  = "twitch-feed-aws"
  }

  container_log_retentions = {
    integration = "3"
    staging     = "7"
    canary      = "30"
    production  = "30"
  }

  instance_types = {
    integration = "c4.2xlarge"
    staging     = "c4.2xlarge"
    canary      = "c4.4xlarge"
    production  = "c4.4xlarge"
  }

  min_sizes = {
    integration = "3"
    staging     = "6"
    canary      = "3"
    production  = "15"
  }

  max_sizes = {
    integration = "5"
    staging     = "9"
    canary      = "12"
    production  = "50"
  }

  desired_sizes = {
    integration = "6"
    staging     = "8"
    canary      = "5"
    production  = "20"
  }

  web_xray_roles = {
    integration = "arn:aws:iam::465369119046:role/foundation-xray-role"
    staging     = "arn:aws:iam::465369119046:role/foundation-xray-role"
    canary      = "arn:aws:iam::641044725657:role/foundation-xray-role"
    production  = "arn:aws:iam::641044725657:role/foundation-xray-role"
  }

  min_size_bigger_instanceses = {
    integration = ""
    staging     = "1"
    canary      = "1"
    production  = "25"
  }

  desired_capacity_bigger_instances = {
    integration = ""
    staging     = "1"
    canary      = "1"
    production  = "25"
  }

  instance_type_bigger_instances = {
    integration = ""
    staging     = "c5.4xlarge"
    canary      = "c5.4xlarge"
    production  = "c5.4xlarge"
  }

  max_size_bigger_instanceses = {
    integration = ""
    staging     = "1"
    canary      = "3"
    production  = "45"
  }

  instance_type = local.instance_types[terraform.workspace]
  min_size      = local.min_sizes[terraform.workspace]
  max_size      = local.max_sizes[terraform.workspace]
  desired_size  = local.desired_sizes[terraform.workspace]
  web_xray_role = local.web_xray_roles[terraform.workspace]

  min_size_bigger_instances        = local.min_size_bigger_instanceses[terraform.workspace]
  desired_capacity_bigger_instance = local.desired_capacity_bigger_instances[terraform.workspace]
  instance_type_bigger_instance    = local.instance_type_bigger_instances[terraform.workspace]
  max_size_bigger_instances        = local.max_size_bigger_instanceses[terraform.workspace]

  container_log_retention = local.container_log_retentions[terraform.workspace]
  region                  = "us-west-2"
  profile                 = local.profiles[terraform.workspace]

  scale_out_cooldown              = "300" // how long to wait between scale out events
  scale_out_increment             = "3"   // number of instances to increase by when scaling out
  scale_out_cpu_percent_threshold = "50"  // cpu percentage threshold to initiate scaling out
}

provider "aws" {
  profile             = local.profile
  allowed_account_ids = [local.account_ids[terraform.workspace]]
  region              = local.region
}

terraform {
  backend "s3" {
    bucket  = "twitch-feed-aws"
    key     = "feeds/core-region-us-west-2.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

data "terraform_remote_state" "account" {
  backend = "s3"

  config = {
    bucket  = local.profile
    key     = "tfstate/feed/terraform/accounts/${local.profile}"
    region  = "us-west-2"
    profile = local.profile
  }
}

data "terraform_remote_state" "account_core" {
  backend   = "s3"
  workspace = terraform.workspace

  config = {
    bucket  = "twitch-feed-aws"
    key     = "feeds/core-account.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-aws"
  }
}

module "region" {
  source                        = "../../../module/region"
  security_groups               = data.terraform_remote_state.account.outputs.twitch_subnets_sg
  vpc_zone_identifier           = data.terraform_remote_state.account.outputs.private_subnets
  min_size                      = local.min_size
  desired_capacity              = local.desired_size
  max_size                      = local.max_size
  container_log_retention       = local.container_log_retention
  region                        = local.region
  container_instance_profile_id = data.terraform_remote_state.account_core.outputs.container_instance_profile_id

  instance_type = local.instance_type
  xray_role     = data.terraform_remote_state.account_core.outputs.xray_task_role
  environment   = terraform.workspace
  xray_web_arn  = local.web_xray_role

  min_size_bigger_instances         = local.min_size_bigger_instances
  desired_capacity_bigger_instances = local.desired_capacity_bigger_instance
  instance_type_bigger_instances    = local.instance_type_bigger_instance
  max_size_bigger_instances         = local.max_size_bigger_instances

  scale_out_cooldown              = local.scale_out_cooldown
  scale_out_increment             = local.scale_out_increment
  scale_out_cpu_percent_threshold = local.scale_out_cpu_percent_threshold
}

module "grafana_cloudwatch_read_only" {
  source      = "git::git+ssh://git@git.xarth.tv/twitch/grafana_datasource.git?ref=v1.1.1"
  aws_region  = local.region
  aws_profile = local.profile
}

output "container_loggroup" {
  value = module.region.container_loggroup
}

output "container_loggroup_region" {
  value = module.region.container_loggroup_region
}

output "statsite_task_family" {
  value = module.region.statsite_task_family
}

output "xray_task_family" {
  value = module.region.xray_task_family
}

output "common_cluster_name" {
  value = module.region.common_cluster_name
}

output "common_cluster_id" {
  value = module.region.common_cluster_id
}

output "pagerduty_alarm_arn" {
  value = module.region.pagerduty_alarm_arn
}

