locals {
  // This is from https://wiki.twitch.com/pages/viewpage.action?pageId=81199247
  internal_ldap_hosts = {
    us-west-2 = "ldap.twitch.a2z.com"
    us-east-1 = "ldap.twitch.a2z.com"
  }

  internal_ldap_host = local.internal_ldap_hosts[data.aws_region.current.name]
}

data "aws_region" "current" {
}

variable "environment" {
  description = "Which env run of the service (staging/production/etc)"
}

variable "name" {
  description = "Name of the clusters these ASG hosts should take."
}

variable "min_size" {
  description = "Least number of hosts to have in this ASG"
}

variable "max_size" {
  description = "Most number of hosts to have in this ASG"
}

variable "desired_capacity" {
  description = "Default number of hosts to have in this ASG.  Should be >= min and <= max"
}

variable "team" {
  description = "The twitch team (feeds/events/etc) that wants this resource"
}

variable "owner" {
  description = "Owner's email (jlindamo@twitch.tv) that wants twitch to pay for this."
}

variable "root_volume_size" {
  default     = 32
  description = "Size in GB of the root volume in the ASG"
}

variable "cluster_name" {
  description = "Name of the ECS cluster hosts should belong to"
}

variable "custom_ldap_host" {
  description = "The LDAP server for authentication, if internal Twitch servers are inaccesible."
  default     = ""
}

variable "ldap_group" {
  default     = "team-web-rails"
  description = "LDAP group to add to sudoers"
}

# EC2 Instance Image
variable "ami" {
  default     = ""
  description = "An ECS enabled AMI that these ASG hosts should run with.  If empty, will use the most recent AMI"
}

# EC2 Instance Type
variable "instance_type" {
  description = "AWS instance type of these hosts (c4.2xlarge, etc)"
}

variable "host_key_name" {
  default     = ""
  description = "Can leave blank, but will be an SSH keypair name"
}

variable "container_instance_profile_id" {
  description = "The permissions ID these hosts get.  Should probably use the one created by core."
}

variable "security_groups" {
  description = "Twitch subnet security groups to add EC2 instances into.  Usually .account.twitch_subnets_sg"
}

variable "vpc_zone_identifier" {
  description = "Subnets that ASG adds hosts to.  Usually .account.private_subnets"
}

variable "ssm_agent_loggroup" {
  description = "CloudWatch log group to send SSM agent logs to."
}

variable "ecs_agent_loggroup" {
  description = "CloudWatch log group to send ECS agent logs to."
}

variable "ecs_init_loggroup" {
  description = "CloudWatch log group to send ECS init logs to."
}

variable "instance_attributes" {
  type        = map(string)
  description = "Custom attributes added to instances.  Useful for placement_attributes."
  default     = {}
}

variable "task_cleanup_wait_duration" {
  description = "Time duration to wait from when an ECS task is stopped until the Docker container is removed."
  default     = "3h"
}

# Autoscaling configurations
variable "scale_out_increment" {
  description = "Number of instances to add during a Scale Out operation."
  default     = 1
}

variable "scale_out_cooldown" {
  description = "Seconds to wait between Scale Out operations."
  default     = 1200
}

variable "scale_out_evaluation_periods" {
  description = "Number of consecutive minutes the CPU usage has to be above the threshold to Scale Out."
  default     = 5
}

variable "scale_out_cpu_percent_threshold" {
  description = "Percentage of CPU usage above which the ASG should Scale Out."
  default     = 75
}

variable "scale_in_increment" {
  description = "Number of instances to remove during a Scale In operation, should be negative."
  default     = -1
}

variable "scale_in_cooldown" {
  description = "Seconds to wait between Scale In operations."
  default     = 900
}

variable "scale_in_evaluation_periods" {
  description = "Number of consecutive minutes the CPU usage has to be below or equal to the threshold to Scale In."
  default     = 15
}

variable "scale_in_cpu_percent_threshold" {
  description = "Percentage of CPU usage below or equal which the ASG should Scale In."
  default     = 10
}

