variable "name" {
  description = "Name of the clusters"
}

variable "team" {
  description = "The twitch team (feeds/events/etc) that wants this resource"
}

variable "environment" {
  description = "Which env run of the service (staging/production/etc)"
}

variable "statsite_task_family" {
  description = "Task family for statsite each host will have."
}

variable "xray_task_family" {
  description = "Task family for xray each host will have."
}

resource "aws_ecs_cluster" "cluster" {
  name = var.name
}

module "statsite_daemon" {
  source      = "../perhostdaemon"
  service     = "statsite"
  task_family = var.statsite_task_family
  cluster     = aws_ecs_cluster.cluster.name
}

output "cluster_name" {
  value = aws_ecs_cluster.cluster.name
}

output "cluster_id" {
  value = aws_ecs_cluster.cluster.id
}

