locals {
  owner = "jlindamo@twitch.tv"
  team  = "feeds"

  pagerduty_integration_urls = {
    integration = "https://events.pagerduty.com/integration/38e4c10af5a84765935d91e895d96c99/enqueue"
    staging     = "https://events.pagerduty.com/integration/397de4dd4fe54a15be9b2f562e5a610c/enqueue"
    canary      = "https://events.pagerduty.com/integration/f93f2c78329745c19f717c44693073a5/enqueue"
    production  = "https://events.pagerduty.com/integration/f93f2c78329745c19f717c44693073a5/enqueue"
  }

  pagerduty_integration_url = local.pagerduty_integration_urls[terraform.workspace]

  min_size_bigger_instances         = coalesce(var.min_size_bigger_instances, 0)
  desired_capacity_bigger_instances = coalesce(var.desired_capacity_bigger_instances, 0)
  instance_type_bigger_instances    = coalesce(var.instance_type_bigger_instances, var.instance_type)
  max_size_bigger_instances         = coalesce(var.max_size_bigger_instances, 0)
}

variable "xray_role" {
}

variable "container_log_retention" {
}

variable "environment" {
}

variable "region" {
}

variable "vpc_zone_identifier" {
}

variable "min_size" {
}

variable "desired_capacity" {
}

variable "instance_type" {
}

variable "max_size" {
}

variable "security_groups" {
}

variable "container_instance_profile_id" {
}

variable "xray_web_arn" {
}

variable "min_size_bigger_instances" {
  default = ""
}

variable "desired_capacity_bigger_instances" {
  default = ""
}

variable "instance_type_bigger_instances" {
  default = ""
}

variable "max_size_bigger_instances" {
  default = ""
}

variable "scale_out_cpu_percent_threshold" {
  default = ""
}

variable "scale_out_cooldown" {
  default = ""
}

variable "scale_out_increment" {
  default = ""
}

module "core_region" {
  source                  = "../core_region"
  xray_task_arn           = var.xray_role
  container_log_retention = var.container_log_retention
  environment             = var.environment
  team                    = local.team
  region                  = var.region
  xray_web_arn            = var.xray_web_arn
}

module "ecsasg" {
  source                          = "../ecsasg"
  name                            = "common"
  ldap_group                      = "team-vx-live-infra"
  team                            = local.team
  vpc_zone_identifier             = var.vpc_zone_identifier
  cluster_name                    = module.core_region.common_cluster_name
  environment                     = var.environment
  owner                           = local.owner
  container_instance_profile_id   = var.container_instance_profile_id
  min_size                        = var.min_size
  desired_capacity                = var.desired_capacity
  instance_type                   = var.instance_type
  max_size                        = var.max_size
  security_groups                 = var.security_groups
  ssm_agent_loggroup              = module.core_region.ssm_loggroup
  ecs_agent_loggroup              = module.core_region.ecs_agent_loggroup
  ecs_init_loggroup               = module.core_region.ecs_init_loggroup
  scale_out_cooldown              = var.scale_out_cooldown
  scale_out_increment             = var.scale_out_increment
  scale_out_cpu_percent_threshold = var.scale_out_cpu_percent_threshold
}

module "ecsasg_bigger" {
  source                          = "../ecsasg"
  name                            = "bigger_sizes"
  ldap_group                      = "team-vx-live-infra"
  team                            = local.team
  vpc_zone_identifier             = var.vpc_zone_identifier
  cluster_name                    = module.core_region.common_cluster_name
  environment                     = var.environment
  owner                           = local.owner
  container_instance_profile_id   = var.container_instance_profile_id
  min_size                        = local.min_size_bigger_instances
  desired_capacity                = local.desired_capacity_bigger_instances
  instance_type                   = local.instance_type_bigger_instances
  max_size                        = local.max_size_bigger_instances
  security_groups                 = var.security_groups
  ssm_agent_loggroup              = module.core_region.ssm_loggroup
  ecs_agent_loggroup              = module.core_region.ecs_agent_loggroup
  ecs_init_loggroup               = module.core_region.ecs_init_loggroup
  scale_out_cooldown              = var.scale_out_cooldown
  scale_out_increment             = var.scale_out_increment
  scale_out_cpu_percent_threshold = 30
  scale_in_cpu_percent_threshold  = 20

  instance_attributes = {
    "instance_placement" = "bigger"
  }
}

## These two set up where pager duty alarms go for services in this environment
resource "aws_sns_topic" "pagerduty_alarm" {
  name = "${local.team}-${terraform.workspace}-pagerduty"
}

resource "aws_sns_topic_subscription" "pagerduty_alarm_subscription" {
  topic_arn              = aws_sns_topic.pagerduty_alarm.arn
  protocol               = "https"
  endpoint               = local.pagerduty_integration_url
  endpoint_auto_confirms = true
}

output "container_loggroup" {
  value = module.core_region.container_loggroup
}

output "container_loggroup_region" {
  value = module.core_region.container_loggroup_region
}

output "statsite_task_family" {
  value = module.core_region.statsite_task_family
}

output "xray_task_family" {
  value = module.core_region.xray_task_family
}

output "common_cluster_name" {
  value = module.core_region.common_cluster_name
}

output "common_cluster_id" {
  value = module.core_region.common_cluster_id
}

output "pagerduty_alarm_arn" {
  value = aws_sns_topic.pagerduty_alarm.arn
}

