package datapipeline

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/session"
	awsPipeline "github.com/aws/aws-sdk-go/service/datapipeline"
	"github.com/hashicorp/terraform/helper/schema"
	"github.com/hashicorp/terraform/terraform"
)

func NewProvider() terraform.ResourceProvider {
	p := Provider{}
	return p.Provider()
}

type Provider struct {
}

func (p *Provider) Provider() terraform.ResourceProvider {
	return &schema.Provider{
		Schema: p.Schema(),
		ResourcesMap: map[string]*schema.Resource{
			"datapipeline": p.DatapipelineResource(),
		},
		ConfigureFunc: p.ConfigureFunc,
	}
}

func (p *Provider) Schema() map[string]*schema.Schema {
	return map[string]*schema.Schema{
		"profile": {
			Type:        schema.TypeString,
			Required:    true,
			Description: "The local AWS profile used to create data pipelines",
		},
		"region": {
			Type:        schema.TypeString,
			Required:    true,
			Description: "The region to store data pipelines into",
		},
	}
}

func (p *Provider) ConfigureFunc(d *schema.ResourceData) (interface{}, error) {
	clientProvider, err := session.NewSession(&aws.Config{
		Region:      aws.String(d.Get("region").(string)),
		Credentials: credentials.NewSharedCredentials("", d.Get("profile").(string)),
	})
	if err != nil {
		return nil, err
	}
	return awsPipeline.New(clientProvider), nil
}

func (p *Provider) DatapipelineResource() *schema.Resource {
	r := NewResource{}
	return r.Resource()
}
