provider "aws" {
  region  = "us-west-2"
  profile = "twitch-feed-dev"
}

provider "datapipeline" {
  region  = "us-west-2"
  profile = "twitch-feed-dev"
}

terraform {
  backend "s3" {
    bucket  = "twitch-feed-dev"
    key     = "feeds/testing-datapipeline.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-dev"
  }
}

resource datapipeline "testing" {
  name      = "testing-pipeline-from-provider"

  #  description = "this is testing terraform"
  definition = <<EOF
{
  "objects": [{
      "period": "7 Days",
      "name": "Every 7 days",
      "id": "DefaultSchedule",
      "type": "Schedule",
      "startAt": "FIRST_ACTIVATION_DATE_TIME"
    }],
  "parameters": [
    {
      "default": "0.25",
      "watermark": "Enter value between 0.1-1.0",
      "description": "DynamoDB read throughput ratio",
      "id": "myDDBReadThroughputRatio",
      "type": "Double"
    }
  ],
  "values": {
    "myDDBReadThroughputRatio": "0.25"
  }
}
    EOF
}
