provider "aws" {
  region  = "us-west-2"
  profile = "twitch-feed-dev"
}

provider "datapipeline" {
  region  = "us-west-2"
  profile = "twitch-feed-dev"
}

terraform {
  backend "s3" {
    bucket  = "twitch-feed-dev"
    key     = "feeds/testing-datapipeline-backups.tfstate"
    region  = "us-west-2"
    profile = "twitch-feed-dev"
  }
}

data "template_file" "data_pipeline" {
  template = "${file("${path.module}/data_pipeline.tpl")}"

  vars {
    subnet_id        = "subnet-ca403fac"
    days             = 7
    log_bucket       = "twitch-feed-dev-logs"
    region           = "us-west-2"
    table_name       = "duplo_integration_post"
    backup_s3_bucket = "twitch-feed-dev-dynamodb-backup"
  }
}

resource datapipeline "testing" {
  name      = "testing-backup-from-terraform"

  description = "Backing up dynamodb from terraform"
  definition  = "${data.template_file.data_pipeline.rendered}"
}
