#!/bin/bash
set -ex

BUILD_PIPELINE_VERSION="v0.4.3"

function docker_run() {
  ADD_CONFIG_ENV=""
  if [ ! -z "$AWS_CONFIG_FILE" ]; then
    ADD_CONFIG_ENV="-e AWS_CONFIG_FILE=/awsconfig -v $AWS_CONFIG_FILE:/awsconfig:ro"
  fi
  echo 'docker run --read-only -e AWS_SDK_LOAD_CONFIG=1 '$ADD_CONFIG_ENV' -v '$(pwd)':/twitch:ro docker-registry.internal.justin.tv'
}

function is_new_deploy() {
  TEAM_NAME=$1
  BINARY_NAME=$2
  VERSION=$3
  COMPARE_TO=$4
  if [ -z "$COMPARE_TO" ]; then
    COMPARE_TO="integration"
  fi
  if [ -z "$VERSION" ]; then
    VERSION=$GIT_COMMIT
  fi
  if [ -z "$VERSION" ]; then
    echo "Unable to find set version"
    return 1
  fi
  if [ -z "$TEAM_NAME" ]; then
    echo "Unable to find set team name"
    return 1
  fi

  COMPARED_VERSION=$($(docker_run)/twitch/ecs-deploy:$BUILD_PIPELINE_VERSION /ecs-deploy pipeline certify get $TEAM_NAME $BINARY_NAME $COMPARE_TO)
  if [ -z "$COMPARED_VERSION" ]; then
    # No version to compare
    return 0
  fi
  set +e
  docker pull docker-registry.internal.justin.tv/$TEAM_NAME/$BINARY_NAME:$COMPARED_VERSION || true
  docker pull docker-registry.internal.justin.tv/$TEAM_NAME/$BINARY_NAME:$VERSION || true
  DEPLOYED_SHA=$(docker inspect -f '{{.Id}}' docker-registry.internal.justin.tv/$TEAM_NAME/$BINARY_NAME:$COMPARED_VERSION)
  COMPARED_SHA=$(docker inspect -f '{{.Id}}' docker-registry.internal.justin.tv/$TEAM_NAME/$BINARY_NAME:$VERSION)
  set -e
  if [ -z "$DEPLOYED_SHA" ]; then
    # Deployed is empty
    return 0
  fi

  return $([ "$DEPLOYED_SHA" != "$COMPARED_SHA" ])
}

which docker
env
is_new_deploy "$1" "$2" "$3" "$4"
