// Code generated by running "go generate" in golang.org/x/text. DO NOT EDIT.

package language

import "golang.org/x/text/internal/tag"

// CLDRVersion is the CLDR version from which the tables in this package are derived.
const CLDRVersion = "31"

const numLanguages = 8665

const numScripts = 237

const numRegions = 357

type fromTo struct {
	from uint16
	to   uint16
}

const nonCanonicalUnd = 1199
const (
	_af  = 22
	_am  = 39
	_ar  = 58
	_az  = 88
	_bg  = 126
	_bn  = 165
	_ca  = 215
	_cs  = 249
	_da  = 256
	_de  = 268
	_el  = 309
	_en  = 312
	_es  = 317
	_et  = 319
	_fa  = 327
	_fi  = 336
	_fil = 338
	_fr  = 349
	_gu  = 418
	_he  = 442
	_hi  = 444
	_hr  = 463
	_hu  = 467
	_hy  = 469
	_id  = 479
	_is  = 502
	_it  = 503
	_ja  = 510
	_ka  = 526
	_kk  = 576
	_km  = 584
	_kn  = 591
	_ko  = 594
	_ky  = 648
	_lo  = 694
	_lt  = 702
	_lv  = 709
	_mk  = 765
	_ml  = 770
	_mn  = 777
	_mo  = 782
	_mr  = 793
	_ms  = 797
	_mul = 804
	_my  = 815
	_nb  = 837
	_ne  = 847
	_nl  = 869
	_no  = 877
	_pa  = 923
	_pl  = 945
	_pt  = 958
	_ro  = 986
	_ru  = 992
	_sh  = 1029
	_si  = 1034
	_sk  = 1040
	_sl  = 1044
	_sq  = 1071
	_sr  = 1072
	_sv  = 1090
	_sw  = 1091
	_ta  = 1102
	_te  = 1119
	_th  = 1129
	_tl  = 1144
	_tn  = 1150
	_tr  = 1160
	_uk  = 1196
	_ur  = 1202
	_uz  = 1210
	_vi  = 1217
	_zh  = 1319
	_zu  = 1324
	_jbo = 513
	_ami = 1647
	_bnn = 2354
	_hak = 436
	_tlh = 14464
	_lb  = 659
	_nv  = 897
	_pwn = 12052
	_tao = 14185
	_tay = 14195
	_tsu = 14659
	_nn  = 872
	_sfb = 13626
	_vgt = 15698
	_sgg = 13657
	_cmn = 3004
	_nan = 833
	_hsn = 465
)

const langPrivateStart = 0x2f6f

const langPrivateEnd = 0x3176

// lang holds an alphabetically sorted list of ISO-639 language identifiers.
// All entries are 4 bytes. The index of the identifier (divided by 4) is the language tag.
// For 2-byte language identifiers, the two successive bytes have the following meaning:
//     - if the first letter of the 2- and 3-letter ISO codes are the same:
//       the second and third letter of the 3-letter ISO code.
//     - otherwise: a 0 and a by 2 bits right-shifted index into altLangISO3.
// For 3-byte language identifiers the 4th byte is 0.
const lang tag.Index = "" + // Size: 5312 bytes
	"---\x00aaaraai\x00aak\x00aau\x00abbkabi\x00abq\x00abr\x00abt\x00aby\x00a" +
	"cd\x00ace\x00ach\x00ada\x00ade\x00adj\x00ady\x00adz\x00aeveaeb\x00aey" +
	"\x00affragc\x00agd\x00agg\x00agm\x00ago\x00agq\x00aha\x00ahl\x00aho\x00a" +
	"jg\x00akkaakk\x00ala\x00ali\x00aln\x00alt\x00ammhamm\x00amn\x00amo\x00am" +
	"p\x00anrganc\x00ank\x00ann\x00any\x00aoj\x00aom\x00aoz\x00apc\x00apd\x00" +
	"ape\x00apr\x00aps\x00apz\x00arraarc\x00arh\x00arn\x00aro\x00arq\x00ars" +
	"\x00ary\x00arz\x00assmasa\x00ase\x00asg\x00aso\x00ast\x00ata\x00atg\x00a" +
	"tj\x00auy\x00avvaavl\x00avn\x00avt\x00avu\x00awa\x00awb\x00awo\x00awx" +
	"\x00ayymayb\x00azzebaakbal\x00ban\x00bap\x00bar\x00bas\x00bav\x00bax\x00" +
	"bba\x00bbb\x00bbc\x00bbd\x00bbj\x00bbp\x00bbr\x00bcf\x00bch\x00bci\x00bc" +
	"m\x00bcn\x00bco\x00bcq\x00bcu\x00bdd\x00beelbef\x00beh\x00bej\x00bem\x00" +
	"bet\x00bew\x00bex\x00bez\x00bfd\x00bfq\x00bft\x00bfy\x00bgulbgc\x00bgn" +
	"\x00bgx\x00bhihbhb\x00bhg\x00bhi\x00bhk\x00bhl\x00bho\x00bhy\x00biisbib" +
	"\x00big\x00bik\x00bim\x00bin\x00bio\x00biq\x00bjh\x00bji\x00bjj\x00bjn" +
	"\x00bjo\x00bjr\x00bjt\x00bjz\x00bkc\x00bkm\x00bkq\x00bku\x00bkv\x00blt" +
	"\x00bmambmh\x00bmk\x00bmq\x00bmu\x00bnenbng\x00bnm\x00bnp\x00boodboj\x00" +
	"bom\x00bon\x00bpy\x00bqc\x00bqi\x00bqp\x00bqv\x00brrebra\x00brh\x00brx" +
	"\x00brz\x00bsosbsj\x00bsq\x00bss\x00bst\x00bto\x00btt\x00btv\x00bua\x00b" +
	"uc\x00bud\x00bug\x00buk\x00bum\x00buo\x00bus\x00buu\x00bvb\x00bwd\x00bwr" +
	"\x00bxh\x00bye\x00byn\x00byr\x00bys\x00byv\x00byx\x00bza\x00bze\x00bzf" +
	"\x00bzh\x00bzw\x00caatcan\x00cbj\x00cch\x00ccp\x00ceheceb\x00cfa\x00cgg" +
	"\x00chhachk\x00chm\x00cho\x00chp\x00chr\x00cja\x00cjm\x00cjv\x00ckb\x00c" +
	"kl\x00cko\x00cky\x00cla\x00cme\x00cooscop\x00cps\x00crrecrh\x00crj\x00cr" +
	"k\x00crl\x00crm\x00crs\x00csescsb\x00csw\x00ctd\x00cuhucvhvcyymdaandad" +
	"\x00daf\x00dag\x00dah\x00dak\x00dar\x00dav\x00dbd\x00dbq\x00dcc\x00ddn" +
	"\x00deeuded\x00den\x00dga\x00dgh\x00dgi\x00dgl\x00dgr\x00dgz\x00dia\x00d" +
	"je\x00dnj\x00dob\x00doi\x00dop\x00dow\x00dri\x00drs\x00dsb\x00dtm\x00dtp" +
	"\x00dts\x00dty\x00dua\x00duc\x00dud\x00dug\x00dvivdva\x00dww\x00dyo\x00d" +
	"yu\x00dzzodzg\x00ebu\x00eeweefi\x00egl\x00egy\x00eka\x00eky\x00elllema" +
	"\x00emi\x00enngenn\x00enq\x00eopoeri\x00es\x00\x05esu\x00etstetr\x00ett" +
	"\x00etu\x00etx\x00euusewo\x00ext\x00faasfaa\x00fab\x00fag\x00fai\x00fan" +
	"\x00ffulffi\x00ffm\x00fiinfia\x00fil\x00fit\x00fjijflr\x00fmp\x00foaofod" +
	"\x00fon\x00for\x00fpe\x00fqs\x00frrafrc\x00frp\x00frr\x00frs\x00fub\x00f" +
	"ud\x00fue\x00fuf\x00fuh\x00fuq\x00fur\x00fuv\x00fuy\x00fvr\x00fyrygalega" +
	"a\x00gaf\x00gag\x00gah\x00gaj\x00gam\x00gan\x00gaw\x00gay\x00gbf\x00gbm" +
	"\x00gby\x00gbz\x00gcr\x00gdlagde\x00gdn\x00gdr\x00geb\x00gej\x00gel\x00g" +
	"ez\x00gfk\x00ggn\x00ghs\x00gil\x00gim\x00gjk\x00gjn\x00gju\x00gkn\x00gkp" +
	"\x00gllgglk\x00gmm\x00gmv\x00gnrngnd\x00gng\x00god\x00gof\x00goi\x00gom" +
	"\x00gon\x00gor\x00gos\x00got\x00grb\x00grc\x00grt\x00grw\x00gsw\x00guujg" +
	"ub\x00guc\x00gud\x00gur\x00guw\x00gux\x00guz\x00gvlvgvf\x00gvr\x00gvs" +
	"\x00gwc\x00gwi\x00gwt\x00gyi\x00haauhag\x00hak\x00ham\x00haw\x00haz\x00h" +
	"bb\x00hdy\x00heebhhy\x00hiinhia\x00hif\x00hig\x00hih\x00hil\x00hla\x00hl" +
	"u\x00hmd\x00hmt\x00hnd\x00hne\x00hnj\x00hnn\x00hno\x00homohoc\x00hoj\x00" +
	"hot\x00hrrvhsb\x00hsn\x00htathuunhui\x00hyyehzerianaian\x00iar\x00iba" +
	"\x00ibb\x00iby\x00ica\x00ich\x00idndidd\x00idi\x00idu\x00ieleife\x00igbo" +
	"igb\x00ige\x00iiiiijj\x00ikpkikk\x00ikt\x00ikw\x00ikx\x00ilo\x00imo\x00i" +
	"nndinh\x00iodoiou\x00iri\x00isslittaiukuiw\x00\x03iwm\x00iws\x00izh\x00i" +
	"zi\x00japnjab\x00jam\x00jbo\x00jbu\x00jen\x00jgk\x00jgo\x00ji\x00\x06jib" +
	"\x00jmc\x00jml\x00jra\x00jut\x00jvavjwavkaatkaa\x00kab\x00kac\x00kad\x00" +
	"kai\x00kaj\x00kam\x00kao\x00kbd\x00kbm\x00kbp\x00kbq\x00kbx\x00kby\x00kc" +
	"g\x00kck\x00kcl\x00kct\x00kde\x00kdh\x00kdl\x00kdt\x00kea\x00ken\x00kez" +
	"\x00kfo\x00kfr\x00kfy\x00kgonkge\x00kgf\x00kgp\x00kha\x00khb\x00khn\x00k" +
	"hq\x00khs\x00kht\x00khw\x00khz\x00kiikkij\x00kiu\x00kiw\x00kjuakjd\x00kj" +
	"g\x00kjs\x00kjy\x00kkazkkc\x00kkj\x00klalkln\x00klq\x00klt\x00klx\x00kmh" +
	"mkmb\x00kmh\x00kmo\x00kms\x00kmu\x00kmw\x00knanknf\x00knp\x00koorkoi\x00" +
	"kok\x00kol\x00kos\x00koz\x00kpe\x00kpf\x00kpo\x00kpr\x00kpx\x00kqb\x00kq" +
	"f\x00kqs\x00kqy\x00kraukrc\x00kri\x00krj\x00krl\x00krs\x00kru\x00ksasksb" +
	"\x00ksd\x00ksf\x00ksh\x00ksj\x00ksr\x00ktb\x00ktm\x00kto\x00kuurkub\x00k" +
	"ud\x00kue\x00kuj\x00kum\x00kun\x00kup\x00kus\x00kvomkvg\x00kvr\x00kvx" +
	"\x00kw\x00\x01kwj\x00kwo\x00kxa\x00kxc\x00kxm\x00kxp\x00kxw\x00kxz\x00ky" +
	"irkye\x00kyx\x00kzr\x00laatlab\x00lad\x00lag\x00lah\x00laj\x00las\x00lbt" +
	"zlbe\x00lbu\x00lbw\x00lcm\x00lcp\x00ldb\x00led\x00lee\x00lem\x00lep\x00l" +
	"eq\x00leu\x00lez\x00lguglgg\x00liimlia\x00lid\x00lif\x00lig\x00lih\x00li" +
	"j\x00lis\x00ljp\x00lki\x00lkt\x00lle\x00lln\x00lmn\x00lmo\x00lmp\x00lnin" +
	"lns\x00lnu\x00loaoloj\x00lok\x00lol\x00lor\x00los\x00loz\x00lrc\x00ltitl" +
	"tg\x00luublua\x00luo\x00luy\x00luz\x00lvavlwl\x00lzh\x00lzz\x00mad\x00ma" +
	"f\x00mag\x00mai\x00mak\x00man\x00mas\x00maw\x00maz\x00mbh\x00mbo\x00mbq" +
	"\x00mbu\x00mbw\x00mci\x00mcp\x00mcq\x00mcr\x00mcu\x00mda\x00mde\x00mdf" +
	"\x00mdh\x00mdj\x00mdr\x00mdx\x00med\x00mee\x00mek\x00men\x00mer\x00met" +
	"\x00meu\x00mfa\x00mfe\x00mfn\x00mfo\x00mfq\x00mglgmgh\x00mgl\x00mgo\x00m" +
	"gp\x00mgy\x00mhahmhi\x00mhl\x00mirimif\x00min\x00mis\x00miw\x00mkkdmki" +
	"\x00mkl\x00mkp\x00mkw\x00mlalmle\x00mlp\x00mls\x00mmo\x00mmu\x00mmx\x00m" +
	"nonmna\x00mnf\x00mni\x00mnw\x00moolmoa\x00moe\x00moh\x00mos\x00mox\x00mp" +
	"p\x00mps\x00mpt\x00mpx\x00mql\x00mrarmrd\x00mrj\x00mro\x00mssamtltmtc" +
	"\x00mtf\x00mti\x00mtr\x00mua\x00mul\x00mur\x00mus\x00mva\x00mvn\x00mvy" +
	"\x00mwk\x00mwr\x00mwv\x00mxc\x00mxm\x00myyamyk\x00mym\x00myv\x00myw\x00m" +
	"yx\x00myz\x00mzk\x00mzm\x00mzn\x00mzp\x00mzw\x00mzz\x00naaunac\x00naf" +
	"\x00nah\x00nak\x00nan\x00nap\x00naq\x00nas\x00nbobnca\x00nce\x00ncf\x00n" +
	"ch\x00nco\x00ncu\x00nddendc\x00nds\x00neepneb\x00new\x00nex\x00nfr\x00ng" +
	"donga\x00ngb\x00ngl\x00nhb\x00nhe\x00nhw\x00nif\x00nii\x00nij\x00nin\x00" +
	"niu\x00niy\x00niz\x00njo\x00nkg\x00nko\x00nlldnmg\x00nmz\x00nnnonnf\x00n" +
	"nh\x00nnk\x00nnm\x00noornod\x00noe\x00non\x00nop\x00nou\x00nqo\x00nrblnr" +
	"b\x00nsk\x00nsn\x00nso\x00nss\x00ntm\x00ntr\x00nui\x00nup\x00nus\x00nuv" +
	"\x00nux\x00nvavnwb\x00nxq\x00nxr\x00nyyanym\x00nyn\x00nzi\x00occiogc\x00" +
	"ojjiokr\x00okv\x00omrmong\x00onn\x00ons\x00opm\x00orrioro\x00oru\x00osss" +
	"osa\x00ota\x00otk\x00ozm\x00paanpag\x00pal\x00pam\x00pap\x00pau\x00pbi" +
	"\x00pcd\x00pcm\x00pdc\x00pdt\x00ped\x00peo\x00pex\x00pfl\x00phl\x00phn" +
	"\x00pilipil\x00pip\x00pka\x00pko\x00plolpla\x00pms\x00png\x00pnn\x00pnt" +
	"\x00pon\x00ppo\x00pra\x00prd\x00prg\x00psuspss\x00ptorptp\x00puu\x00pwa" +
	"\x00quuequc\x00qug\x00rai\x00raj\x00rao\x00rcf\x00rej\x00rel\x00res\x00r" +
	"gn\x00rhg\x00ria\x00rif\x00rjs\x00rkt\x00rmohrmf\x00rmo\x00rmt\x00rmu" +
	"\x00rnunrna\x00rng\x00roonrob\x00rof\x00roo\x00rro\x00rtm\x00ruusrue\x00" +
	"rug\x00rw\x00\x04rwk\x00rwo\x00ryu\x00saansaf\x00sah\x00saq\x00sas\x00sa" +
	"t\x00sav\x00saz\x00sba\x00sbe\x00sbp\x00scrdsck\x00scl\x00scn\x00sco\x00" +
	"scs\x00sdndsdc\x00sdh\x00semesef\x00seh\x00sei\x00ses\x00sgagsga\x00sgs" +
	"\x00sgw\x00sgz\x00sh\x00\x02shi\x00shk\x00shn\x00shu\x00siinsid\x00sig" +
	"\x00sil\x00sim\x00sjr\x00sklkskc\x00skr\x00sks\x00sllvsld\x00sli\x00sll" +
	"\x00sly\x00smmosma\x00smi\x00smj\x00smn\x00smp\x00smq\x00sms\x00snnasnc" +
	"\x00snk\x00snp\x00snx\x00sny\x00soomsok\x00soq\x00sou\x00soy\x00spd\x00s" +
	"pl\x00sps\x00sqqisrrpsrb\x00srn\x00srr\x00srx\x00ssswssd\x00ssg\x00ssy" +
	"\x00stotstk\x00stq\x00suunsua\x00sue\x00suk\x00sur\x00sus\x00svweswwaswb" +
	"\x00swc\x00swg\x00swp\x00swv\x00sxn\x00sxw\x00syl\x00syr\x00szl\x00taamt" +
	"aj\x00tal\x00tan\x00taq\x00tbc\x00tbd\x00tbf\x00tbg\x00tbo\x00tbw\x00tbz" +
	"\x00tci\x00tcy\x00tdd\x00tdg\x00tdh\x00teelted\x00tem\x00teo\x00tet\x00t" +
	"fi\x00tggktgc\x00tgo\x00tgu\x00thhathl\x00thq\x00thr\x00tiirtif\x00tig" +
	"\x00tik\x00tim\x00tio\x00tiv\x00tkuktkl\x00tkr\x00tkt\x00tlgltlf\x00tlx" +
	"\x00tly\x00tmh\x00tmy\x00tnsntnh\x00toontof\x00tog\x00toq\x00tpi\x00tpm" +
	"\x00tpz\x00tqo\x00trurtru\x00trv\x00trw\x00tssotsd\x00tsf\x00tsg\x00tsj" +
	"\x00tsw\x00ttatttd\x00tte\x00ttj\x00ttr\x00tts\x00ttt\x00tuh\x00tul\x00t" +
	"um\x00tuq\x00tvd\x00tvl\x00tvu\x00twwitwh\x00twq\x00txg\x00tyahtya\x00ty" +
	"v\x00tzm\x00ubu\x00udm\x00ugiguga\x00ukkruli\x00umb\x00und\x00unr\x00unx" +
	"\x00urrduri\x00urt\x00urw\x00usa\x00utr\x00uvh\x00uvl\x00uzzbvag\x00vai" +
	"\x00van\x00veenvec\x00vep\x00viievic\x00viv\x00vls\x00vmf\x00vmw\x00vool" +
	"vot\x00vro\x00vun\x00vut\x00walnwae\x00waj\x00wal\x00wan\x00war\x00wbp" +
	"\x00wbq\x00wbr\x00wci\x00wer\x00wgi\x00whg\x00wib\x00wiu\x00wiv\x00wja" +
	"\x00wji\x00wls\x00wmo\x00wnc\x00wni\x00wnu\x00woolwob\x00wos\x00wrs\x00w" +
	"sk\x00wtm\x00wuu\x00wuv\x00wwa\x00xav\x00xbi\x00xcr\x00xes\x00xhhoxla" +
	"\x00xlc\x00xld\x00xmf\x00xmn\x00xmr\x00xna\x00xnr\x00xog\x00xon\x00xpr" +
	"\x00xrb\x00xsa\x00xsi\x00xsm\x00xsr\x00xwe\x00yam\x00yao\x00yap\x00yas" +
	"\x00yat\x00yav\x00yay\x00yaz\x00yba\x00ybb\x00yby\x00yer\x00ygr\x00ygw" +
	"\x00yiidyko\x00yle\x00ylg\x00yll\x00yml\x00yooryon\x00yrb\x00yre\x00yrl" +
	"\x00yss\x00yua\x00yue\x00yuj\x00yut\x00yuw\x00zahazag\x00zbl\x00zdj\x00z" +
	"ea\x00zgh\x00zhhozia\x00zlm\x00zmi\x00zne\x00zuulzxx\x00zza\x00\xff\xff" +
	"\xff\xff"

const langNoIndexOffset = 1327

// langNoIndex is a bit vector of all 3-letter language codes that are not used as an index
// in lookup tables. The language ids for these language codes are derived directly
// from the letters and are not consecutive.
// Size: 2197 bytes, 2197 elements
var langNoIndex = [2197]uint8{
	// Entry 0 - 3F
	0xff, 0xf8, 0xed, 0xfe, 0xeb, 0xd3, 0x3b, 0xd2,
	0xfb, 0xbf, 0x7a, 0xfa, 0x37, 0x1d, 0x3c, 0x57,
	0x6e, 0x97, 0x73, 0x38, 0xfb, 0xea, 0xbf, 0x70,
	0xad, 0x03, 0xff, 0xff, 0xcf, 0x05, 0x84, 0x62,
	0xe9, 0xbf, 0xfd, 0xbf, 0xbf, 0xf7, 0xfd, 0x77,
	0x0f, 0xff, 0xef, 0x6f, 0xff, 0xfb, 0xdf, 0xe2,
	0xc9, 0xf8, 0x7f, 0x7e, 0x4d, 0xb8, 0x0a, 0x6a,
	0x7c, 0xea, 0xe3, 0xfa, 0x7a, 0xbf, 0x67, 0xff,
	// Entry 40 - 7F
	0xff, 0xff, 0xff, 0xdf, 0x2a, 0x54, 0x91, 0xc0,
	0x5d, 0xe3, 0x97, 0x14, 0x07, 0x20, 0xdd, 0xed,
	0x9f, 0x3f, 0xc9, 0x21, 0xf8, 0x3f, 0x94, 0x35,
	0x7c, 0x5f, 0xff, 0x5f, 0x8e, 0x6e, 0xdf, 0xff,
	0xff, 0xff, 0x55, 0x7c, 0xd3, 0xfd, 0xbf, 0xb5,
	0x7b, 0xdf, 0x7f, 0xf7, 0xca, 0xfe, 0xdb, 0xa3,
	0xa8, 0xff, 0x1f, 0x67, 0x7d, 0xeb, 0xef, 0xce,
	0xff, 0xff, 0x9f, 0xff, 0xb7, 0xef, 0xfe, 0xcf,
	// Entry 80 - BF
	0xdb, 0xff, 0xf3, 0xcd, 0xfb, 0x2f, 0xff, 0xff,
	0xbb, 0xee, 0xf7, 0xbd, 0xdb, 0xff, 0x5f, 0xf7,
	0xfd, 0xf2, 0xfd, 0xff, 0x5e, 0x2f, 0x3b, 0xba,
	0x7e, 0xff, 0xff, 0xfe, 0xf7, 0xff, 0xdd, 0xff,
	0xfd, 0xdf, 0xfb, 0xfe, 0x9d, 0xb4, 0xd3, 0xff,
	0xef, 0xff, 0xdf, 0xf7, 0x7f, 0xb7, 0xfd, 0xd5,
	0xa5, 0x77, 0x40, 0xff, 0x9c, 0xc1, 0x41, 0x2c,
	0x08, 0x20, 0x41, 0x00, 0x50, 0x40, 0x00, 0x80,
	// Entry C0 - FF
	0xfb, 0x4a, 0xf2, 0x9f, 0xb4, 0x42, 0x41, 0x96,
	0x1b, 0x14, 0x08, 0xf2, 0x2b, 0xe7, 0x17, 0x56,
	0x45, 0x7d, 0x0e, 0x1c, 0x37, 0x71, 0xf3, 0xef,
	0x97, 0xff, 0x5d, 0x38, 0x64, 0x08, 0x00, 0x10,
	0xbc, 0x85, 0xaf, 0xdf, 0xff, 0xf7, 0x73, 0x35,
	0x3e, 0x87, 0xc7, 0xdf, 0xff, 0x00, 0x81, 0x00,
	0xb0, 0x05, 0x80, 0x00, 0x00, 0x00, 0x00, 0x03,
	0x40, 0x00, 0x40, 0x92, 0x21, 0x50, 0xb1, 0x5d,
	// Entry 100 - 13F
	0xfd, 0xdc, 0xbe, 0x5e, 0x00, 0x00, 0x02, 0x64,
	0x0d, 0x19, 0x41, 0xdf, 0x79, 0x22, 0x00, 0x00,
	0x00, 0x5e, 0x64, 0xdc, 0x24, 0xe5, 0xd9, 0xe3,
	0xfe, 0xff, 0xfd, 0xcb, 0x9f, 0x14, 0x01, 0x0c,
	0x86, 0x00, 0xd1, 0x00, 0xf0, 0xc5, 0x67, 0x5f,
	0x56, 0x89, 0x5e, 0xb5, 0x6c, 0xaf, 0x03, 0x00,
	0x02, 0x00, 0x00, 0x00, 0xc0, 0x37, 0xda, 0x56,
	0x90, 0x69, 0x01, 0x2c, 0x96, 0x69, 0x20, 0xfb,
	// Entry 140 - 17F
	0xff, 0x3f, 0x00, 0x00, 0x00, 0x01, 0x08, 0x16,
	0x01, 0x00, 0x00, 0xb0, 0x14, 0x03, 0x50, 0x06,
	0x0a, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11, 0x09,
	0x00, 0x00, 0x60, 0x10, 0x00, 0x00, 0x00, 0x10,
	0x00, 0x00, 0x44, 0x00, 0x00, 0x10, 0x00, 0x04,
	0x08, 0x00, 0x00, 0x04, 0x00, 0x80, 0x28, 0x04,
	0x00, 0x00, 0x40, 0xd5, 0x2d, 0x00, 0x64, 0x35,
	0x24, 0x52, 0xf4, 0xd4, 0xbd, 0x62, 0xc9, 0x03,
	// Entry 180 - 1BF
	0x00, 0x80, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x13, 0x39, 0x01, 0xdd, 0x57, 0x98,
	0x21, 0x18, 0x81, 0x00, 0x00, 0x01, 0x40, 0x82,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x40, 0x00, 0x44, 0x00, 0x00, 0x80, 0xea,
	0xa9, 0x39, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00,
	// Entry 1C0 - 1FF
	0x00, 0x01, 0x28, 0x05, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x20, 0x04, 0xa6, 0x00, 0x04, 0x00, 0x00,
	0x81, 0x50, 0x00, 0x00, 0x00, 0x11, 0x84, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x55,
	0x02, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0x40,
	0x30, 0x83, 0x01, 0x00, 0x00, 0x00, 0x11, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1e, 0xcd, 0xbf, 0x7e, 0xbf,
	// Entry 200 - 23F
	0xdf, 0xc3, 0x83, 0x82, 0xc0, 0xfb, 0x57, 0x27,
	0xcd, 0x55, 0xe7, 0x01, 0x00, 0x20, 0xb2, 0xc5,
	0xa4, 0x45, 0x25, 0x9b, 0x02, 0xdf, 0xe0, 0xdf,
	0x03, 0x44, 0x08, 0x10, 0x01, 0x04, 0x01, 0xe3,
	0x92, 0x54, 0xdb, 0x28, 0xd1, 0x5f, 0xf6, 0x6d,
	0x79, 0xed, 0x1c, 0x7d, 0x04, 0x08, 0x00, 0x01,
	0x21, 0x12, 0x64, 0x5f, 0xdd, 0x0e, 0x85, 0x4f,
	0x40, 0x40, 0x00, 0x04, 0xf1, 0xfd, 0x3d, 0x54,
	// Entry 240 - 27F
	0xe8, 0x03, 0xb4, 0x27, 0x23, 0x0d, 0x00, 0x00,
	0x20, 0x7b, 0x38, 0x02, 0x05, 0x84, 0x00, 0xf0,
	0xbb, 0x7e, 0x5a, 0x00, 0x18, 0x04, 0x81, 0x00,
	0x00, 0x00, 0x80, 0x10, 0x90, 0x1c, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x40, 0x00, 0x04,
	0x08, 0xa0, 0x70, 0xa5, 0x0c, 0x40, 0x00, 0x00,
	0x11, 0x04, 0x04, 0x68, 0x00, 0x20, 0x70, 0xff,
	0x7b, 0x7f, 0x60, 0x00, 0x05, 0x9b, 0xdd, 0x66,
	// Entry 280 - 2BF
	0x03, 0x00, 0x11, 0x00, 0x00, 0x00, 0x40, 0x05,
	0xb5, 0xb6, 0x80, 0x08, 0x04, 0x00, 0x04, 0x51,
	0xe2, 0xef, 0xfd, 0x3f, 0x05, 0x09, 0x08, 0x05,
	0x40, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x00, 0x81, 0x00, 0x60,
	0xe7, 0x48, 0x00, 0x81, 0x20, 0xc0, 0x05, 0x80,
	0x03, 0x00, 0x00, 0x00, 0x8c, 0x50, 0x40, 0x04,
	0x84, 0x47, 0x84, 0x40, 0x20, 0x10, 0x00, 0x20,
	// Entry 2C0 - 2FF
	0x02, 0x50, 0x80, 0x11, 0x00, 0x91, 0x6c, 0xe2,
	0x50, 0x27, 0x1d, 0x11, 0x29, 0x06, 0x59, 0xe9,
	0x33, 0x08, 0x00, 0x20, 0x04, 0x40, 0x10, 0x00,
	0x00, 0x00, 0x50, 0x44, 0x92, 0x49, 0xd6, 0x5d,
	0xa7, 0x81, 0x47, 0x97, 0xfb, 0x00, 0x10, 0x00,
	0x08, 0x00, 0x80, 0x00, 0x40, 0x04, 0x00, 0x01,
	0x02, 0x00, 0x01, 0x40, 0x80, 0x00, 0x00, 0x08,
	0xd8, 0xeb, 0xf6, 0x39, 0xc4, 0x89, 0x12, 0x00,
	// Entry 300 - 33F
	0x00, 0x0c, 0x04, 0x01, 0x20, 0x20, 0xdd, 0xa0,
	0x01, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00,
	0x04, 0x10, 0xd0, 0x9d, 0x95, 0x13, 0x04, 0x80,
	0x00, 0x01, 0xd0, 0x12, 0x40, 0x00, 0x10, 0xb0,
	0x10, 0x62, 0x4c, 0xd2, 0x02, 0x01, 0x4a, 0x00,
	0x46, 0x04, 0x00, 0x08, 0x02, 0x00, 0x20, 0x80,
	0x00, 0x80, 0x06, 0x00, 0x08, 0x00, 0x00, 0x00,
	0x00, 0xf0, 0xd8, 0x6f, 0x15, 0x02, 0x08, 0x00,
	// Entry 340 - 37F
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x10, 0x01,
	0x00, 0x10, 0x00, 0x00, 0x00, 0xf0, 0x84, 0xe3,
	0xdd, 0xbf, 0xf9, 0xf9, 0x3b, 0x7f, 0x7f, 0xdb,
	0xfd, 0xfc, 0xfe, 0xdf, 0xff, 0xfd, 0xff, 0xf6,
	0xfb, 0xfc, 0xf7, 0x1f, 0xff, 0xb3, 0x6c, 0xff,
	0xd9, 0xad, 0xdf, 0xfe, 0xef, 0xba, 0xdf, 0xff,
	0xff, 0xff, 0xb7, 0xdd, 0x7d, 0xbf, 0xab, 0x7f,
	0xfd, 0xfd, 0xdf, 0x2f, 0x9c, 0xdf, 0xf3, 0x6f,
	// Entry 380 - 3BF
	0xdf, 0xdd, 0xff, 0xfb, 0xee, 0xd2, 0xab, 0x5f,
	0xd5, 0xdf, 0x7f, 0xff, 0xeb, 0xff, 0xe4, 0x4d,
	0xf9, 0xff, 0xfe, 0xf7, 0xfd, 0xdf, 0xfb, 0xbf,
	0xee, 0xdb, 0x6f, 0xef, 0xff, 0x7f, 0xff, 0xff,
	0xf7, 0x5f, 0xd3, 0x3b, 0xfd, 0xd9, 0xdf, 0xeb,
	0xbc, 0x08, 0x05, 0x24, 0xff, 0x07, 0x70, 0xfe,
	0xe6, 0x5e, 0x00, 0x08, 0x00, 0x83, 0x3d, 0x1b,
	0x06, 0xe6, 0x72, 0x60, 0xd1, 0x3c, 0x7f, 0x44,
	// Entry 3C0 - 3FF
	0x02, 0x30, 0x9f, 0x7a, 0x16, 0xbd, 0x7f, 0x57,
	0xf2, 0xff, 0x31, 0xff, 0xf2, 0x1e, 0x90, 0xf7,
	0xf1, 0xf9, 0x45, 0x80, 0x01, 0x02, 0x00, 0x00,
	0x40, 0x54, 0x9f, 0x8a, 0xd9, 0xd9, 0x0e, 0x11,
	0x86, 0x51, 0xc0, 0xf3, 0xfb, 0x47, 0x00, 0x01,
	0x05, 0xd1, 0x50, 0x58, 0x00, 0x00, 0x00, 0x10,
	0x04, 0x02, 0x00, 0x00, 0x0a, 0x00, 0x17, 0xd2,
	0xb9, 0xfd, 0xfc, 0xba, 0xfe, 0xef, 0xc7, 0xbe,
	// Entry 400 - 43F
	0x53, 0x6f, 0xdf, 0xe7, 0xdb, 0x65, 0xbb, 0x7f,
	0xfa, 0xff, 0x77, 0xf3, 0xef, 0xbf, 0xfd, 0xf7,
	0xdf, 0xdf, 0x9b, 0x7f, 0xff, 0xff, 0x7f, 0x6f,
	0xf7, 0xfb, 0xeb, 0xdf, 0xbc, 0xff, 0xbf, 0x6b,
	0x7b, 0xfb, 0xff, 0xce, 0x76, 0xbd, 0xf7, 0xf7,
	0xdf, 0xdc, 0xf7, 0xf7, 0xff, 0xdf, 0xf3, 0xfe,
	0xef, 0xff, 0xff, 0xff, 0xb6, 0x7f, 0x7f, 0xde,
	0xf7, 0xb9, 0xeb, 0x77, 0xff, 0xfb, 0xbf, 0xdf,
	// Entry 440 - 47F
	0xfd, 0xfe, 0xfb, 0xff, 0xfe, 0xeb, 0x1f, 0x7d,
	0x2f, 0xfd, 0xb6, 0xb5, 0xa5, 0xfc, 0xff, 0xfd,
	0x7f, 0x4e, 0xbf, 0x8f, 0xae, 0xff, 0xee, 0xdf,
	0x7f, 0xf7, 0x73, 0x02, 0x02, 0x04, 0xfc, 0xf7,
	0xff, 0xb7, 0xd7, 0xef, 0xfe, 0xcd, 0xf5, 0xce,
	0xe2, 0x8e, 0xe7, 0xbf, 0xb7, 0xff, 0x56, 0xbd,
	0xcd, 0xff, 0xfb, 0xff, 0xdf, 0xd7, 0xea, 0xff,
	0xe5, 0x5f, 0x6d, 0x0f, 0xa7, 0x51, 0x06, 0xc4,
	// Entry 480 - 4BF
	0x13, 0x50, 0x5d, 0xaf, 0xa6, 0xfd, 0x99, 0xfb,
	0x63, 0x1d, 0x53, 0xff, 0xef, 0xb7, 0x35, 0x20,
	0x14, 0x00, 0x55, 0x51, 0x82, 0x65, 0xf5, 0x41,
	0xe2, 0xff, 0xfc, 0xdf, 0x00, 0x05, 0xc5, 0x05,
	0x00, 0x22, 0x00, 0x74, 0x69, 0x10, 0x08, 0x04,
	0x41, 0x00, 0x01, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x51, 0x20, 0x05, 0x04, 0x01, 0x00, 0x00,
	0x06, 0x01, 0x20, 0x00, 0x18, 0x01, 0x92, 0xb1,
	// Entry 4C0 - 4FF
	0xfd, 0x47, 0x49, 0x06, 0x95, 0x06, 0x57, 0xed,
	0xfb, 0x4c, 0x1c, 0x6b, 0x83, 0x04, 0x62, 0x40,
	0x00, 0x11, 0x42, 0x00, 0x00, 0x00, 0x54, 0x83,
	0xb8, 0x4f, 0x10, 0x8c, 0x89, 0x46, 0xde, 0xf7,
	0x13, 0x31, 0x00, 0x20, 0x00, 0x00, 0x00, 0x90,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x10, 0x00,
	0x01, 0x00, 0x00, 0xf0, 0x5b, 0xf4, 0xbe, 0x3d,
	0xba, 0xcf, 0xf7, 0xaf, 0x42, 0x04, 0x84, 0x41,
	// Entry 500 - 53F
	0x30, 0xff, 0x79, 0x72, 0x04, 0x00, 0x00, 0x49,
	0x2d, 0x14, 0x27, 0x57, 0xed, 0xf1, 0x3f, 0xe7,
	0x3f, 0x00, 0x00, 0x02, 0xc6, 0xa0, 0x1e, 0xf8,
	0xbb, 0xff, 0xfd, 0xfb, 0xb7, 0xfd, 0xe5, 0xf7,
	0xfd, 0xfc, 0xd5, 0xed, 0x47, 0xf4, 0x7e, 0x10,
	0x01, 0x01, 0x84, 0x6d, 0xff, 0xf7, 0xdd, 0xf9,
	0x5b, 0x05, 0x86, 0xed, 0xf5, 0x77, 0xbd, 0x3c,
	0x00, 0x00, 0x00, 0x42, 0x71, 0x42, 0x00, 0x40,
	// Entry 540 - 57F
	0x00, 0x00, 0x01, 0x43, 0x19, 0x00, 0x08, 0x00,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	// Entry 580 - 5BF
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xab, 0xbd, 0xe7, 0x57, 0xee, 0x13, 0x5d,
	0x09, 0xc1, 0x40, 0x21, 0xfa, 0x17, 0x01, 0x80,
	0x00, 0x00, 0x00, 0x00, 0xf0, 0xce, 0xfb, 0xbf,
	0x00, 0x23, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
	0x00, 0x30, 0x15, 0xa3, 0x10, 0x00, 0x00, 0x00,
	0x11, 0x04, 0x16, 0x00, 0x00, 0x02, 0x00, 0x81,
	0xa3, 0x01, 0x50, 0x00, 0x00, 0x83, 0x11, 0x40,
	// Entry 5C0 - 5FF
	0x00, 0x00, 0x00, 0xf0, 0xdd, 0x7b, 0x3e, 0x02,
	0xaa, 0x10, 0x5d, 0x98, 0x52, 0x00, 0x80, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x02, 0x02,
	0x19, 0x00, 0x10, 0x02, 0x10, 0x61, 0x5a, 0x9d,
	0x31, 0x00, 0x00, 0x00, 0x01, 0x10, 0x02, 0x20,
	0x00, 0x00, 0x01, 0x00, 0x42, 0x00, 0x20, 0x00,
	0x00, 0x1f, 0xdf, 0xd2, 0xb9, 0xff, 0xfd, 0x3f,
	0x1f, 0x98, 0xcf, 0x9c, 0xbf, 0xaf, 0x5f, 0xfe,
	// Entry 600 - 63F
	0x7b, 0x4b, 0x40, 0x10, 0xe1, 0xfd, 0xaf, 0xd9,
	0xb7, 0xf6, 0xfb, 0xb3, 0xc7, 0xff, 0x6f, 0xf1,
	0x73, 0xb1, 0x7f, 0x9f, 0x7f, 0xbd, 0xfc, 0xb7,
	0xee, 0x1c, 0xfa, 0xcb, 0xef, 0xdd, 0xf9, 0xbd,
	0x6e, 0xae, 0x55, 0xfd, 0x6e, 0x81, 0x76, 0x1f,
	0xd4, 0x77, 0xf5, 0x7d, 0xfb, 0xff, 0xeb, 0xfe,
	0xbe, 0x5f, 0x46, 0x1b, 0xe9, 0x5f, 0x50, 0x18,
	0x02, 0xfa, 0xf7, 0x9d, 0x15, 0x97, 0x05, 0x0f,
	// Entry 640 - 67F
	0x75, 0xc4, 0x7d, 0x81, 0x92, 0xf1, 0x57, 0x6c,
	0xff, 0xe4, 0xef, 0x6f, 0xff, 0xfc, 0xdd, 0xde,
	0xfc, 0xfd, 0x76, 0x5f, 0x7a, 0x1f, 0x00, 0x98,
	0x02, 0xfb, 0xa3, 0xef, 0xf3, 0xd6, 0xf2, 0xff,
	0xb9, 0xda, 0x7d, 0x50, 0x1e, 0x15, 0x7b, 0xb4,
	0xf5, 0x3e, 0xff, 0xff, 0xf1, 0xf7, 0xff, 0xe7,
	0x5f, 0xff, 0xff, 0x9e, 0xdb, 0xf6, 0xd7, 0xb9,
	0xef, 0x27, 0x80, 0xbb, 0xc5, 0xff, 0xff, 0xe3,
	// Entry 680 - 6BF
	0x97, 0x9d, 0xbf, 0x9f, 0xf7, 0xc7, 0xfd, 0x37,
	0xce, 0x7f, 0x04, 0x1d, 0x53, 0x7f, 0xf8, 0xda,
	0x5d, 0xce, 0x7d, 0x06, 0xb9, 0xea, 0x69, 0xa0,
	0x1a, 0x20, 0x00, 0x30, 0x02, 0x04, 0x24, 0x08,
	0x04, 0x00, 0x00, 0x40, 0xd4, 0x02, 0x04, 0x00,
	0x00, 0x04, 0x00, 0x04, 0x00, 0x20, 0x01, 0x06,
	0x50, 0x00, 0x08, 0x00, 0x00, 0x00, 0x24, 0x00,
	0x04, 0x00, 0x10, 0xcc, 0x58, 0xd5, 0x0d, 0x0f,
	// Entry 6C0 - 6FF
	0x14, 0x4d, 0xf1, 0x16, 0x44, 0xd1, 0x42, 0x08,
	0x40, 0x00, 0x00, 0x40, 0x00, 0x08, 0x00, 0x00,
	0x00, 0xdc, 0xfb, 0xcb, 0x0e, 0x58, 0x08, 0x41,
	0x04, 0x20, 0x04, 0x00, 0x30, 0x12, 0x40, 0x00,
	0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x80, 0x10, 0x10, 0xab,
	0x6d, 0x93, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x80, 0x80, 0x25, 0x00, 0x00,
	// Entry 700 - 73F
	0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
	0x80, 0x86, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x01,
	0xdf, 0x18, 0x00, 0x00, 0x02, 0xf0, 0xfd, 0x79,
	0x3b, 0x00, 0x25, 0x00, 0x00, 0x00, 0x02, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
	0x03, 0x00, 0x09, 0x20, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 740 - 77F
	0x00, 0x00, 0x00, 0xef, 0xd5, 0xfd, 0xcf, 0x7e,
	0xb0, 0x11, 0x00, 0x00, 0x00, 0x92, 0x01, 0x44,
	0xcd, 0xf9, 0x5c, 0x00, 0x01, 0x00, 0x30, 0x04,
	0x04, 0x55, 0x00, 0x01, 0x04, 0xf4, 0x3f, 0x4a,
	0x01, 0x00, 0x00, 0xb0, 0x80, 0x00, 0x55, 0x55,
	0x97, 0x7c, 0x9f, 0x31, 0xcc, 0x68, 0xd1, 0x03,
	0xd5, 0x57, 0x27, 0x14, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x2c, 0xf7, 0xcb, 0x1f, 0x14, 0x60,
	// Entry 780 - 7BF
	0x03, 0x68, 0x01, 0x10, 0x8b, 0x38, 0x8a, 0x01,
	0x00, 0x00, 0x20, 0x00, 0x24, 0x44, 0x00, 0x00,
	0x10, 0x03, 0x11, 0x02, 0x01, 0x00, 0x00, 0xf0,
	0xf5, 0xff, 0xd5, 0x97, 0xbc, 0x70, 0xd6, 0x78,
	0x78, 0x15, 0x50, 0x01, 0xa4, 0x84, 0xa9, 0x41,
	0x00, 0x00, 0x00, 0x6b, 0x39, 0x52, 0x74, 0x00,
	0xe8, 0x30, 0x90, 0x6a, 0x92, 0x00, 0x00, 0x02,
	0xff, 0xef, 0xff, 0x4b, 0x85, 0x53, 0xf4, 0xed,
	// Entry 7C0 - 7FF
	0xdd, 0xbf, 0x72, 0x19, 0xc7, 0x0c, 0xd5, 0x42,
	0x54, 0xdd, 0x77, 0x14, 0x00, 0x80, 0x40, 0x56,
	0xcc, 0x16, 0x9e, 0xea, 0x35, 0x7d, 0xef, 0xff,
	0xbd, 0xa4, 0xaf, 0x01, 0x44, 0x18, 0x01, 0x4d,
	0x4e, 0x4a, 0x08, 0x50, 0x28, 0x30, 0xe0, 0x80,
	0x10, 0x20, 0x24, 0x00, 0xff, 0x2f, 0xd3, 0x60,
	0xfe, 0x01, 0x02, 0x88, 0x0a, 0x40, 0x16, 0x01,
	0x01, 0x15, 0x2b, 0x3c, 0x01, 0x00, 0x00, 0x10,
	// Entry 800 - 83F
	0x90, 0x49, 0x41, 0x02, 0x02, 0x01, 0xe1, 0xbf,
	0xbf, 0x03, 0x00, 0x00, 0x10, 0xd4, 0xa3, 0xd1,
	0x40, 0x9c, 0x44, 0xdf, 0xf5, 0x8f, 0x66, 0xb3,
	0x55, 0x20, 0xd4, 0xc1, 0xd8, 0x30, 0x3d, 0x80,
	0x00, 0x00, 0x00, 0x04, 0xd4, 0x11, 0xc5, 0x84,
	0x2e, 0x50, 0x00, 0x22, 0x50, 0x6e, 0xbd, 0x93,
	0x07, 0x00, 0x20, 0x10, 0x84, 0xb2, 0x45, 0x10,
	0x06, 0x44, 0x00, 0x00, 0x12, 0x02, 0x11, 0x00,
	// Entry 840 - 87F
	0xf0, 0xfb, 0xfd, 0x3f, 0x05, 0x00, 0x12, 0x81,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x02, 0x28,
	0x84, 0x00, 0x23, 0xc0, 0x23, 0x24, 0x00, 0x00,
	0x00, 0xcb, 0xe4, 0x3a, 0x42, 0x88, 0x14, 0xf1,
	0xef, 0xff, 0x7f, 0x12, 0x01, 0x01, 0x84, 0x50,
	0x07, 0xfc, 0xff, 0xff, 0x0f, 0x01, 0x00, 0x40,
	0x10, 0x38, 0x01, 0x01, 0x1c, 0x12, 0x40, 0xe1,
	// Entry 880 - 8BF
	0x76, 0x16, 0x08, 0x03, 0x10, 0x00, 0x00, 0x00,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x24,
	0x0a, 0x00, 0x80, 0x00, 0x00,
}

// altLangISO3 holds an alphabetically sorted list of 3-letter language code alternatives
// to 2-letter language codes that cannot be derived using the method described above.
// Each 3-letter code is followed by its 1-byte langID.
const altLangISO3 tag.Index = "---\x00cor\x00hbs\x01heb\x02kin\x03spa\x04yid\x05\xff\xff\xff\xff"

// altLangIndex is used to convert indexes in altLangISO3 to langIDs.
// Size: 12 bytes, 6 elements
var altLangIndex = [6]uint16{
	0x027f, 0x0405, 0x01f9, 0x03e3, 0x013d, 0x0206,
}

// langAliasMap maps langIDs to their suggested replacements.
// Size: 656 bytes, 164 elements
var langAliasMap = [164]fromTo{
	0:   {from: 0x82, to: 0x88},
	1:   {from: 0x185, to: 0x1ac},
	2:   {from: 0x1f1, to: 0x1df},
	3:   {from: 0x1f9, to: 0x1ba},
	4:   {from: 0x206, to: 0x510},
	5:   {from: 0x20d, to: 0x20c},
	6:   {from: 0x30e, to: 0x3da},
	7:   {from: 0x345, to: 0x36d},
	8:   {from: 0x405, to: 0x430},
	9:   {from: 0x478, to: 0x152},
	10:  {from: 0x48e, to: 0x44f},
	11:  {from: 0x4a0, to: 0x21},
	12:  {from: 0x53b, to: 0x541},
	13:  {from: 0x58c, to: 0x12c},
	14:  {from: 0x62d, to: 0x1eae},
	15:  {from: 0x64e, to: 0x42f},
	16:  {from: 0x65f, to: 0x42f},
	17:  {from: 0x6ea, to: 0x3a},
	18:  {from: 0x6f5, to: 0x1d5},
	19:  {from: 0x73b, to: 0x219e},
	20:  {from: 0x7b0, to: 0x56},
	21:  {from: 0x7b6, to: 0x2998},
	22:  {from: 0x7c2, to: 0x58},
	23:  {from: 0x7e3, to: 0x144},
	24:  {from: 0x809, to: 0x5a},
	25:  {from: 0x812, to: 0x8d},
	26:  {from: 0x87b, to: 0x80d},
	27:  {from: 0x8c0, to: 0xee0},
	28:  {from: 0x9ec, to: 0x32f},
	29:  {from: 0xa33, to: 0x2c3},
	30:  {from: 0xa3a, to: 0xbf},
	31:  {from: 0xabb, to: 0x331f},
	32:  {from: 0xb35, to: 0x527},
	33:  {from: 0xb72, to: 0x2657},
	34:  {from: 0xb7b, to: 0xbc0},
	35:  {from: 0xb98, to: 0x44c},
	36:  {from: 0xbb9, to: 0x4226},
	37:  {from: 0xbbc, to: 0x527},
	38:  {from: 0xbfb, to: 0x2da4},
	39:  {from: 0xc2b, to: 0x317e},
	40:  {from: 0xcb6, to: 0xf2},
	41:  {from: 0xd05, to: 0xf9},
	42:  {from: 0xdc5, to: 0x119},
	43:  {from: 0xdd4, to: 0x32b},
	44:  {from: 0xdf5, to: 0xdf8},
	45:  {from: 0xdfb, to: 0x52e},
	46:  {from: 0xedc, to: 0x2057},
	47:  {from: 0xeeb, to: 0x2e97},
	48:  {from: 0xf36, to: 0x365},
	49:  {from: 0x10cd, to: 0x13f},
	50:  {from: 0x1101, to: 0x2ce},
	51:  {from: 0x119d, to: 0x1ea},
	52:  {from: 0x1276, to: 0x21},
	53:  {from: 0x1421, to: 0x15d},
	54:  {from: 0x146d, to: 0x14d},
	55:  {from: 0x151c, to: 0xd98},
	56:  {from: 0x1520, to: 0x38e},
	57:  {from: 0x152f, to: 0x19d},
	58:  {from: 0x157d, to: 0x20e},
	59:  {from: 0x1580, to: 0x10c},
	60:  {from: 0x15a0, to: 0x3cac},
	61:  {from: 0x1667, to: 0x199},
	62:  {from: 0x16c5, to: 0x135},
	63:  {from: 0x16fd, to: 0x29f5},
	64:  {from: 0x1715, to: 0x192},
	65:  {from: 0x1724, to: 0xf3c},
	66:  {from: 0x1777, to: 0x1521},
	67:  {from: 0x1806, to: 0x17b3},
	68:  {from: 0x1813, to: 0x18f0},
	69:  {from: 0x1887, to: 0x434},
	70:  {from: 0x1976, to: 0x1cfe},
	71:  {from: 0x1a71, to: 0x2bad},
	72:  {from: 0x1a87, to: 0x1f6},
	73:  {from: 0x1b57, to: 0x1f8},
	74:  {from: 0x1b83, to: 0x1512},
	75:  {from: 0x1d61, to: 0x2c98},
	76:  {from: 0x2035, to: 0x37ae},
	77:  {from: 0x203a, to: 0x20da},
	78:  {from: 0x2057, to: 0x309},
	79:  {from: 0x20e0, to: 0x272},
	80:  {from: 0x20eb, to: 0x261},
	81:  {from: 0x20ef, to: 0x22b},
	82:  {from: 0x20f6, to: 0x254},
	83:  {from: 0x210c, to: 0x21e8},
	84:  {from: 0x2132, to: 0x27b},
	85:  {from: 0x215d, to: 0x910},
	86:  {from: 0x2196, to: 0x120},
	87:  {from: 0x21cb, to: 0x155e},
	88:  {from: 0x21e3, to: 0x502},
	89:  {from: 0x21f1, to: 0x49d},
	90:  {from: 0x222a, to: 0x120},
	91:  {from: 0x2234, to: 0x120},
	92:  {from: 0x225f, to: 0x927},
	93:  {from: 0x2313, to: 0x3223},
	94:  {from: 0x237f, to: 0x3362},
	95:  {from: 0x246f, to: 0x2c5},
	96:  {from: 0x24e1, to: 0x2fd},
	97:  {from: 0x24ed, to: 0x2f8},
	98:  {from: 0x24f7, to: 0x31d},
	99:  {from: 0x254d, to: 0xb58},
	100: {from: 0x25a6, to: 0xe2},
	101: {from: 0x263b, to: 0x2ce},
	102: {from: 0x26c6, to: 0x26b1},
	103: {from: 0x26f6, to: 0x3c6},
	104: {from: 0x2724, to: 0x3cac},
	105: {from: 0x2762, to: 0x26b1},
	106: {from: 0x2786, to: 0x4355},
	107: {from: 0x28ec, to: 0x2834},
	108: {from: 0x2911, to: 0x34f},
	109: {from: 0x2983, to: 0x2da4},
	110: {from: 0x2b17, to: 0x38b},
	111: {from: 0x2bf9, to: 0x393},
	112: {from: 0x2c3c, to: 0x3cac},
	113: {from: 0x2cf9, to: 0x3bc},
	114: {from: 0x2d10, to: 0x594},
	115: {from: 0x2d44, to: 0x147},
	116: {from: 0x2d45, to: 0x147},
	117: {from: 0x2dfc, to: 0x2ef},
	118: {from: 0x2e05, to: 0x19c9},
	119: {from: 0x2e17, to: 0x2d92},
	120: {from: 0x2e1e, to: 0x290},
	121: {from: 0x2e51, to: 0x7d},
	122: {from: 0x2e62, to: 0x227f},
	123: {from: 0x2e9d, to: 0x2e98},
	124: {from: 0x2eec, to: 0x2ed4},
	125: {from: 0x3190, to: 0x3c2},
	126: {from: 0x3363, to: 0x338b},
	127: {from: 0x3427, to: 0x3da},
	128: {from: 0x34eb, to: 0x18cd},
	129: {from: 0x35c5, to: 0x2c98},
	130: {from: 0x35e3, to: 0x410},
	131: {from: 0x3655, to: 0x244},
	132: {from: 0x3673, to: 0x3f2},
	133: {from: 0x36fa, to: 0x443},
	134: {from: 0x37bd, to: 0x120},
	135: {from: 0x3813, to: 0x38ef},
	136: {from: 0x3828, to: 0x2c98},
	137: {from: 0x382c, to: 0xa9},
	138: {from: 0x382f, to: 0x3225},
	139: {from: 0x3869, to: 0x39a3},
	140: {from: 0x388f, to: 0x3fbd},
	141: {from: 0x38a2, to: 0x39d4},
	142: {from: 0x38b1, to: 0x1fa1},
	143: {from: 0x38b2, to: 0x2e97},
	144: {from: 0x3959, to: 0x47c},
	145: {from: 0x3b4b, to: 0xd8e},
	146: {from: 0x3b75, to: 0x136},
	147: {from: 0x3c96, to: 0x4ba},
	148: {from: 0x3fba, to: 0xff},
	149: {from: 0x4205, to: 0xa8e},
	150: {from: 0x42bb, to: 0x570},
	151: {from: 0x42f6, to: 0x3f5d},
	152: {from: 0x4375, to: 0x258},
	153: {from: 0x43c8, to: 0x36c8},
	154: {from: 0x43ca, to: 0x10e},
	155: {from: 0x44ac, to: 0x331f},
	156: {from: 0x44e0, to: 0x510},
	157: {from: 0x45c7, to: 0x2406},
	158: {from: 0x45da, to: 0x26d9},
	159: {from: 0x460d, to: 0x48ab},
	160: {from: 0x46ab, to: 0x469d},
	161: {from: 0x473b, to: 0x4742},
	162: {from: 0x4913, to: 0x31d},
	163: {from: 0x49a4, to: 0x521},
}

// Size: 164 bytes, 164 elements
var langAliasTypes = [164]langAliasType{
	// Entry 0 - 3F
	1, 0, 0, 0, 0, 0, 0, 1, 2, 2, 0, 1, 0, 0, 1, 2,
	1, 1, 2, 0, 1, 0, 1, 2, 1, 1, 0, 0, 2, 1, 1, 0,
	2, 0, 0, 1, 0, 1, 0, 0, 1, 2, 1, 1, 1, 1, 0, 0,
	2, 1, 1, 1, 1, 2, 1, 0, 1, 1, 2, 2, 0, 1, 2, 0,
	// Entry 40 - 7F
	1, 0, 1, 1, 1, 1, 0, 0, 2, 1, 0, 0, 0, 0, 1, 1,
	1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1,
	2, 2, 2, 0, 1, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1,
	0, 1, 0, 2, 1, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 2,
	// Entry 80 - BF
	0, 0, 2, 1, 1, 1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0,
	1, 1, 0, 1, 2, 0, 0, 0, 1, 0, 1, 0, 1, 0, 0, 0,
	0, 1, 1, 1,
}

const (
	_Latn = 85
	_Hani = 53
	_Hans = 55
	_Hant = 56
	_Qaaa = 136
	_Qaai = 144
	_Qabx = 185
	_Zinh = 231
	_Zyyy = 236
	_Zzzz = 237
)

// script is an alphabetically sorted list of ISO 15924 codes. The index
// of the script in the string, divided by 4, is the internal scriptID.
const script tag.Index = "" + // Size: 956 bytes
	"----AdlmAfakAghbAhomArabAranArmiArmnAvstBaliBamuBassBatkBengBhksBlisBopo" +
	"BrahBraiBugiBuhdCakmCansCariChamCherCirtCoptCprtCyrlCyrsDevaDogrDsrtDupl" +
	"EgydEgyhEgypElbaEthiGeokGeorGlagGongGonmGothGranGrekGujrGuruHanbHangHani" +
	"HanoHansHantHatrHebrHiraHluwHmngHrktHungIndsItalJamoJavaJpanJurcKaliKana" +
	"KharKhmrKhojKitlKitsKndaKoreKpelKthiLanaLaooLatfLatgLatnLekeLepcLimbLina" +
	"LinbLisuLomaLyciLydiMahjMakaMandManiMarcMayaMedfMendMercMeroMlymModiMong" +
	"MoonMrooMteiMultMymrNarbNbatNewaNkgbNkooNshuOgamOlckOrkhOryaOsgeOsmaPalm" +
	"PaucPermPhagPhliPhlpPhlvPhnxPiqdPlrdPrtiQaaaQaabQaacQaadQaaeQaafQaagQaah" +
	"QaaiQaajQaakQaalQaamQaanQaaoQaapQaaqQaarQaasQaatQaauQaavQaawQaaxQaayQaaz" +
	"QabaQabbQabcQabdQabeQabfQabgQabhQabiQabjQabkQablQabmQabnQaboQabpQabqQabr" +
	"QabsQabtQabuQabvQabwQabxRjngRoroRunrSamrSaraSarbSaurSgnwShawShrdSiddSind" +
	"SinhSoraSoyoSundSyloSyrcSyreSyrjSyrnTagbTakrTaleTaluTamlTangTavtTeluTeng" +
	"TfngTglgThaaThaiTibtTirhUgarVaiiVispWaraWoleXpeoXsuxYiiiZanbZinhZmthZsye" +
	"ZsymZxxxZyyyZzzz\xff\xff\xff\xff"

// suppressScript is an index from langID to the dominant script for that language,
// if it exists.  If a script is given, it should be suppressed from the language tag.
// Size: 1327 bytes, 1327 elements
var suppressScript = [1327]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x28,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 40 - 7F
	0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00,
	// Entry 80 - BF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry C0 - FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55,
	// Entry 100 - 13F
	0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xda,
	0x00, 0x00, 0x00, 0x00, 0xdc, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00,
	0x55, 0x00, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55,
	// Entry 140 - 17F
	0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x05,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x55, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x55,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00,
	0x55, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x55, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 180 - 1BF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00,
	0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x55, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x3a, 0x00, 0x20, 0x00, 0x00, 0x00,
	// Entry 1C0 - 1FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55,
	0x55, 0x00, 0x55, 0x55, 0x00, 0x08, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x55,
	0x00, 0x3a, 0x00, 0x00, 0x00, 0x00, 0x44, 0x00,
	// Entry 200 - 23F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 240 - 27F
	0x1e, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00,
	0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4d,
	0x00, 0x00, 0x4e, 0x00, 0x20, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 280 - 2BF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x52, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00,
	// Entry 2C0 - 2FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00,
	// Entry 300 - 33F
	0x00, 0x00, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x20, 0x00, 0x00, 0x00, 0x55, 0x55, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00,
	// Entry 340 - 37F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x55, 0x20,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00,
	0x55, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x75, 0x55, 0x00, 0x00, 0x00,
	0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 380 - 3BF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00,
	0x00, 0x00, 0x00, 0x7a, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x55, 0x00,
	// Entry 3C0 - 3FF
	0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x55,
	0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x1e, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 400 - 43F
	0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0xc6, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x55, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00,
	0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00,
	0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 440 - 47F
	0x00, 0x00, 0x55, 0x55, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd3, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xd6,
	0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0xdb, 0x00, 0x00, 0x00, 0x28, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00,
	0x55, 0x00, 0x00, 0x00, 0x55, 0x00, 0x55, 0x00,
	// Entry 480 - 4BF
	0x55, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00,
	0x55, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x55, 0x00,
	// Entry 4C0 - 4FF
	0x00, 0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 500 - 53F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x3a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x55, 0x00, 0x00,
}

const (
	_001 = 1
	_419 = 31
	_BR  = 65
	_CA  = 73
	_ES  = 110
	_GB  = 123
	_MD  = 188
	_PT  = 238
	_UK  = 306
	_US  = 309
	_ZZ  = 357
	_XA  = 323
	_XC  = 325
	_XK  = 333
)

// isoRegionOffset needs to be added to the index of regionISO to obtain the regionID
// for 2-letter ISO codes. (The first isoRegionOffset regionIDs are reserved for
// the UN.M49 codes used for groups.)
const isoRegionOffset = 32

// regionTypes defines the status of a region for various standards.
// Size: 358 bytes, 358 elements
var regionTypes = [358]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x05, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry 40 - 7F
	0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06, 0x04,
	0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04,
	0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x00, 0x06,
	0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,
	0x06, 0x04, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry 80 - BF
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x00, 0x04, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x00, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry C0 - FF
	0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,
	0x06, 0x06, 0x06, 0x06, 0x00, 0x06, 0x04, 0x06,
	0x06, 0x06, 0x06, 0x00, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x00,
	0x06, 0x06, 0x00, 0x06, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	// Entry 100 - 13F
	0x05, 0x05, 0x06, 0x00, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x04, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x02, 0x06, 0x04, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06,
	// Entry 140 - 17F
	0x06, 0x00, 0x06, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x06, 0x06,
	0x04, 0x06, 0x06, 0x04, 0x06, 0x05,
}

// regionISO holds a list of alphabetically sorted 2-letter ISO region codes.
// Each 2-letter codes is followed by two bytes with the following meaning:
//     - [A-Z}{2}: the first letter of the 2-letter code plus these two
//                 letters form the 3-letter ISO code.
//     - 0, n:     index into altRegionISO3.
const regionISO tag.Index = "" + // Size: 1308 bytes
	"AAAAACSCADNDAEREAFFGAGTGAIIAALLBAMRMANNTAOGOAQTAARRGASSMATUTAUUSAWBWAXLA" +
	"AZZEBAIHBBRBBDGDBEELBFFABGGRBHHRBIDIBJENBLLMBMMUBNRNBOOLBQESBRRABSHSBTTN" +
	"BUURBVVTBWWABYLRBZLZCAANCCCKCDODCFAFCGOGCHHECIIVCKOKCLHLCMMRCNHNCOOLCPPT" +
	"CRRICS\x00\x00CTTECUUBCVPVCWUWCXXRCYYPCZZEDDDRDEEUDGGADJJIDKNKDMMADOOMDY" +
	"HYDZZAEA  ECCUEESTEGGYEHSHERRIESSPETTHEU\x00\x03EZ  FIINFJJIFKLKFMSMFORO" +
	"FQ\x00\x18FRRAFXXXGAABGBBRGDRDGEEOGFUFGGGYGHHAGIIBGLRLGMMBGNINGPLPGQNQGR" +
	"RCGS\x00\x06GTTMGUUMGWNBGYUYHKKGHMMDHNNDHRRVHTTIHUUNHVVOIC  IDDNIERLILSR" +
	"IMMNINNDIOOTIQRQIRRNISSLITTAJEEYJMAMJOORJPPNJTTNKEENKGGZKHHMKIIRKM\x00" +
	"\x09KNNAKP\x00\x0cKRORKWWTKY\x00\x0fKZAZLAAOLBBNLCCALIIELKKALRBRLSSOLTTU" +
	"LUUXLVVALYBYMAARMCCOMDDAMENEMFAFMGDGMHHLMIIDMKKDMLLIMMMRMNNGMOACMPNPMQTQ" +
	"MRRTMSSRMTLTMUUSMVDVMWWIMXEXMYYSMZOZNAAMNCCLNEERNFFKNGGANHHBNIICNLLDNOOR" +
	"NPPLNQ\x00\x1eNRRUNTTZNUIUNZZLOMMNPAANPCCIPEERPFYFPGNGPHHLPKAKPLOLPM\x00" +
	"\x12PNCNPRRIPSSEPTRTPUUSPWLWPYRYPZCZQAATQMMMQNNNQOOOQPPPQQQQQRRRQSSSQTTT" +
	"QU\x00\x03QVVVQWWWQXXXQYYYQZZZREEURHHOROOURS\x00\x15RUUSRWWASAAUSBLBSCYC" +
	"SDDNSEWESGGPSHHNSIVNSJJMSKVKSLLESMMRSNENSOOMSRURSSSDSTTPSUUNSVLVSXXMSYYR" +
	"SZWZTAAATCCATDCDTF\x00\x18TGGOTHHATJJKTKKLTLLSTMKMTNUNTOONTPMPTRURTTTOTV" +
	"UVTWWNTZZAUAKRUGGAUK  UMMIUN  USSAUYRYUZZBVAATVCCTVDDRVEENVGGBVIIRVNNMVU" +
	"UTWFLFWKAKWSSMXAAAXBBBXCCCXDDDXEEEXFFFXGGGXHHHXIIIXJJJXKKKXLLLXMMMXNNNXO" +
	"OOXPPPXQQQXRRRXSSSXTTTXUUUXVVVXWWWXXXXXYYYXZZZYDMDYEEMYT\x00\x1bYUUGZAAF" +
	"ZMMBZRARZWWEZZZZ\xff\xff\xff\xff"

// altRegionISO3 holds a list of 3-letter region codes that cannot be
// mapped to 2-letter codes using the default algorithm. This is a short list.
const altRegionISO3 string = "SCGQUUSGSCOMPRKCYMSPMSRBATFMYTATN"

// altRegionIDs holds a list of regionIDs the positions of which match those
// of the 3-letter ISO codes in altRegionISO3.
// Size: 22 bytes, 11 elements
var altRegionIDs = [11]uint16{
	0x0057, 0x0070, 0x0088, 0x00a8, 0x00aa, 0x00ad, 0x00ea, 0x0105,
	0x0121, 0x015f, 0x00dc,
}

// Size: 80 bytes, 20 elements
var regionOldMap = [20]fromTo{
	0:  {from: 0x44, to: 0xc4},
	1:  {from: 0x58, to: 0xa7},
	2:  {from: 0x5f, to: 0x60},
	3:  {from: 0x66, to: 0x3b},
	4:  {from: 0x79, to: 0x78},
	5:  {from: 0x93, to: 0x37},
	6:  {from: 0xa3, to: 0x133},
	7:  {from: 0xc1, to: 0x133},
	8:  {from: 0xd7, to: 0x13f},
	9:  {from: 0xdc, to: 0x2b},
	10: {from: 0xef, to: 0x133},
	11: {from: 0xf2, to: 0xe2},
	12: {from: 0xfc, to: 0x70},
	13: {from: 0x103, to: 0x164},
	14: {from: 0x12a, to: 0x126},
	15: {from: 0x132, to: 0x7b},
	16: {from: 0x13a, to: 0x13e},
	17: {from: 0x141, to: 0x133},
	18: {from: 0x15d, to: 0x15e},
	19: {from: 0x163, to: 0x4b},
}

// m49 maps regionIDs to UN.M49 codes. The first isoRegionOffset entries are
// codes indicating collections of regions.
// Size: 716 bytes, 358 elements
var m49 = [358]int16{
	// Entry 0 - 3F
	0, 1, 2, 3, 5, 9, 11, 13,
	14, 15, 17, 18, 19, 21, 29, 30,
	34, 35, 39, 53, 54, 57, 61, 142,
	143, 145, 150, 151, 154, 155, 202, 419,
	958, 0, 20, 784, 4, 28, 660, 8,
	51, 530, 24, 10, 32, 16, 40, 36,
	533, 248, 31, 70, 52, 50, 56, 854,
	100, 48, 108, 204, 652, 60, 96, 68,
	// Entry 40 - 7F
	535, 76, 44, 64, 104, 74, 72, 112,
	84, 124, 166, 180, 140, 178, 756, 384,
	184, 152, 120, 156, 170, 0, 188, 891,
	296, 192, 132, 531, 162, 196, 203, 278,
	276, 0, 262, 208, 212, 214, 204, 12,
	0, 218, 233, 818, 732, 232, 724, 231,
	967, 0, 246, 242, 238, 583, 234, 0,
	250, 249, 266, 826, 308, 268, 254, 831,
	// Entry 80 - BF
	288, 292, 304, 270, 324, 312, 226, 300,
	239, 320, 316, 624, 328, 344, 334, 340,
	191, 332, 348, 854, 0, 360, 372, 376,
	833, 356, 86, 368, 364, 352, 380, 832,
	388, 400, 392, 581, 404, 417, 116, 296,
	174, 659, 408, 410, 414, 136, 398, 418,
	422, 662, 438, 144, 430, 426, 440, 442,
	428, 434, 504, 492, 498, 499, 663, 450,
	// Entry C0 - FF
	584, 581, 807, 466, 104, 496, 446, 580,
	474, 478, 500, 470, 480, 462, 454, 484,
	458, 508, 516, 540, 562, 574, 566, 548,
	558, 528, 578, 524, 10, 520, 536, 570,
	554, 512, 591, 0, 604, 258, 598, 608,
	586, 616, 666, 612, 630, 275, 620, 581,
	585, 600, 591, 634, 959, 960, 961, 962,
	963, 964, 965, 966, 967, 968, 969, 970,
	// Entry 100 - 13F
	971, 972, 638, 716, 642, 688, 643, 646,
	682, 90, 690, 729, 752, 702, 654, 705,
	744, 703, 694, 674, 686, 706, 740, 728,
	678, 810, 222, 534, 760, 748, 0, 796,
	148, 260, 768, 764, 762, 772, 626, 795,
	788, 776, 626, 792, 780, 798, 158, 834,
	804, 800, 826, 581, 0, 840, 858, 860,
	336, 670, 704, 862, 92, 850, 704, 548,
	// Entry 140 - 17F
	876, 581, 882, 973, 974, 975, 976, 977,
	978, 979, 980, 981, 982, 983, 984, 985,
	986, 987, 988, 989, 990, 991, 992, 993,
	994, 995, 996, 997, 998, 720, 887, 175,
	891, 710, 894, 180, 716, 999,
}

// m49Index gives indexes into fromM49 based on the three most significant bits
// of a 10-bit UN.M49 code. To search an UN.M49 code in fromM49, search in
//    fromM49[m49Index[msb39(code)]:m49Index[msb3(code)+1]]
// for an entry where the first 7 bits match the 7 lsb of the UN.M49 code.
// The region code is stored in the 9 lsb of the indexed value.
// Size: 18 bytes, 9 elements
var m49Index = [9]int16{
	0, 59, 108, 143, 181, 220, 259, 291,
	333,
}

// fromM49 contains entries to map UN.M49 codes to regions. See m49Index for details.
// Size: 666 bytes, 333 elements
var fromM49 = [333]uint16{
	// Entry 0 - 3F
	0x0201, 0x0402, 0x0603, 0x0824, 0x0a04, 0x1027, 0x1205, 0x142b,
	0x1606, 0x1867, 0x1a07, 0x1c08, 0x1e09, 0x202d, 0x220a, 0x240b,
	0x260c, 0x2822, 0x2a0d, 0x302a, 0x3825, 0x3a0e, 0x3c0f, 0x3e32,
	0x402c, 0x4410, 0x4611, 0x482f, 0x4e12, 0x502e, 0x5842, 0x6039,
	0x6435, 0x6628, 0x6834, 0x6a13, 0x6c14, 0x7036, 0x7215, 0x783d,
	0x7a16, 0x8043, 0x883f, 0x8c33, 0x9046, 0x9445, 0x9841, 0xa848,
	0xac9a, 0xb509, 0xb93c, 0xc03e, 0xc838, 0xd0c4, 0xd83a, 0xe047,
	0xe8a6, 0xf052, 0xf849, 0x085a, 0x10ad, 0x184c, 0x1c17, 0x1e18,
	// Entry 40 - 7F
	0x20b3, 0x2219, 0x2920, 0x2c1a, 0x2e1b, 0x3051, 0x341c, 0x361d,
	0x3853, 0x3d2e, 0x445c, 0x4c4a, 0x5454, 0x5ca8, 0x5f5f, 0x644d,
	0x684b, 0x7050, 0x7856, 0x7e90, 0x8059, 0x885d, 0x941e, 0x965e,
	0x983b, 0xa063, 0xa864, 0xac65, 0xb469, 0xbd1a, 0xc486, 0xcc6f,
	0xce6f, 0xd06d, 0xd26a, 0xd476, 0xdc74, 0xde88, 0xe473, 0xec72,
	0xf031, 0xf279, 0xf478, 0xfc7e, 0x04e5, 0x0921, 0x0c62, 0x147a,
	0x187d, 0x1c83, 0x26ed, 0x2860, 0x2c5f, 0x3060, 0x4080, 0x4881,
	0x50a7, 0x5887, 0x6082, 0x687c, 0x7085, 0x788a, 0x8089, 0x8884,
	// Entry 80 - BF
	0x908c, 0x9891, 0x9c8e, 0xa138, 0xa88f, 0xb08d, 0xb892, 0xc09d,
	0xc899, 0xd095, 0xd89c, 0xe09b, 0xe896, 0xf097, 0xf89e, 0x004f,
	0x08a0, 0x10a2, 0x1cae, 0x20a1, 0x28a4, 0x30aa, 0x34ab, 0x3cac,
	0x42a5, 0x44af, 0x461f, 0x4cb0, 0x54b5, 0x58b8, 0x5cb4, 0x64b9,
	0x6cb2, 0x70b6, 0x74b7, 0x7cc6, 0x84bf, 0x8cce, 0x94d0, 0x9ccd,
	0xa4c3, 0xaccb, 0xb4c8, 0xbcc9, 0xc0cc, 0xc8cf, 0xd8bb, 0xe0c5,
	0xe4bc, 0xe6bd, 0xe8ca, 0xf0ba, 0xf8d1, 0x00e1, 0x08d2, 0x10dd,
	0x18db, 0x20d9, 0x2429, 0x265b, 0x2a30, 0x2d1b, 0x2e40, 0x30de,
	// Entry C0 - FF
	0x38d3, 0x493f, 0x54e0, 0x5cd8, 0x64d4, 0x6cd6, 0x74df, 0x7cd5,
	0x84da, 0x88c7, 0x8b33, 0x8e75, 0x90c0, 0x92f0, 0x94e8, 0x9ee2,
	0xace6, 0xb0f1, 0xb8e4, 0xc0e7, 0xc8eb, 0xd0e9, 0xd8ee, 0xe08b,
	0xe526, 0xecec, 0xf4f3, 0xfd02, 0x0504, 0x0706, 0x0d07, 0x183c,
	0x1d0e, 0x26a9, 0x2826, 0x2cb1, 0x2ebe, 0x34ea, 0x3d39, 0x4513,
	0x4d18, 0x5508, 0x5d14, 0x6105, 0x650a, 0x6d12, 0x7d0d, 0x7f11,
	0x813e, 0x830f, 0x8515, 0x8d61, 0x9964, 0xa15d, 0xa86e, 0xb117,
	0xb30b, 0xb86c, 0xc10b, 0xc916, 0xd110, 0xd91d, 0xe10c, 0xe84e,
	// Entry 100 - 13F
	0xf11c, 0xf524, 0xf923, 0x0122, 0x0925, 0x1129, 0x192c, 0x2023,
	0x2928, 0x312b, 0x3727, 0x391f, 0x3d2d, 0x4131, 0x4930, 0x4ec2,
	0x5519, 0x646b, 0x747b, 0x7e7f, 0x809f, 0x8298, 0x852f, 0x9135,
	0xa53d, 0xac37, 0xb536, 0xb937, 0xbd3b, 0xd940, 0xe542, 0xed5e,
	0xef5e, 0xf657, 0xfd62, 0x7c20, 0x7ef4, 0x80f5, 0x82f6, 0x84f7,
	0x86f8, 0x88f9, 0x8afa, 0x8cfb, 0x8e70, 0x90fd, 0x92fe, 0x94ff,
	0x9700, 0x9901, 0x9b43, 0x9d44, 0x9f45, 0xa146, 0xa347, 0xa548,
	0xa749, 0xa94a, 0xab4b, 0xad4c, 0xaf4d, 0xb14e, 0xb34f, 0xb550,
	// Entry 140 - 17F
	0xb751, 0xb952, 0xbb53, 0xbd54, 0xbf55, 0xc156, 0xc357, 0xc558,
	0xc759, 0xc95a, 0xcb5b, 0xcd5c, 0xcf65,
}

// Size: 1615 bytes
var variantIndex = map[string]uint8{
	"1606nict": 0x0,
	"1694acad": 0x1,
	"1901":     0x2,
	"1959acad": 0x3,
	"1994":     0x4d,
	"1996":     0x4,
	"abl1943":  0x5,
	"akuapem":  0x6,
	"alalc97":  0x4f,
	"aluku":    0x7,
	"ao1990":   0x8,
	"arevela":  0x9,
	"arevmda":  0xa,
	"asante":   0xb,
	"baku1926": 0xc,
	"balanka":  0xd,
	"barla":    0xe,
	"basiceng": 0xf,
	"bauddha":  0x10,
	"biscayan": 0x11,
	"biske":    0x48,
	"bohoric":  0x12,
	"boont":    0x13,
	"colb1945": 0x14,
	"cornu":    0x15,
	"dajnko":   0x16,
	"ekavsk":   0x17,
	"emodeng":  0x18,
	"fonipa":   0x50,
	"fonnapa":  0x51,
	"fonupa":   0x52,
	"fonxsamp": 0x53,
	"hepburn":  0x19,
	"heploc":   0x4e,
	"hognorsk": 0x1a,
	"hsistemo": 0x1b,
	"ijekavsk": 0x1c,
	"itihasa":  0x1d,
	"jauer":    0x1e,
	"jyutping": 0x1f,
	"kkcor":    0x20,
	"kociewie": 0x21,
	"kscor":    0x22,
	"laukika":  0x23,
	"lipaw":    0x49,
	"luna1918": 0x24,
	"metelko":  0x25,
	"monoton":  0x26,
	"ndyuka":   0x27,
	"nedis":    0x28,
	"newfound": 0x29,
	"njiva":    0x4a,
	"nulik":    0x2a,
	"osojs":    0x4b,
	"oxendict": 0x2b,
	"pahawh2":  0x2c,
	"pahawh3":  0x2d,
	"pahawh4":  0x2e,
	"pamaka":   0x2f,
	"petr1708": 0x30,
	"pinyin":   0x31,
	"polyton":  0x32,
	"puter":    0x33,
	"rigik":    0x34,
	"rozaj":    0x35,
	"rumgr":    0x36,
	"scotland": 0x37,
	"scouse":   0x38,
	"simple":   0x54,
	"solba":    0x4c,
	"sotav":    0x39,
	"spanglis": 0x3a,
	"surmiran": 0x3b,
	"sursilv":  0x3c,
	"sutsilv":  0x3d,
	"tarask":   0x3e,
	"uccor":    0x3f,
	"ucrcor":   0x40,
	"ulster":   0x41,
	"unifon":   0x42,
	"vaidika":  0x43,
	"valencia": 0x44,
	"vallader": 0x45,
	"wadegile": 0x46,
	"xsistemo": 0x47,
}

// variantNumSpecialized is the number of specialized variants in variants.
const variantNumSpecialized = 79

// nRegionGroups is the number of region groups.
const nRegionGroups = 33

type likelyLangRegion struct {
	lang   uint16
	region uint16
}

// likelyScript is a lookup table, indexed by scriptID, for the most likely
// languages and regions given a script.
// Size: 956 bytes, 239 elements
var likelyScript = [239]likelyLangRegion{
	1:   {lang: 0x14d, region: 0x84},
	3:   {lang: 0x2a0, region: 0x106},
	4:   {lang: 0x1f, region: 0x99},
	5:   {lang: 0x3a, region: 0x6b},
	7:   {lang: 0x3b, region: 0x9c},
	8:   {lang: 0x1d5, region: 0x28},
	9:   {lang: 0x13, region: 0x9c},
	10:  {lang: 0x5b, region: 0x95},
	11:  {lang: 0x60, region: 0x52},
	12:  {lang: 0xb9, region: 0xb4},
	13:  {lang: 0x63, region: 0x95},
	14:  {lang: 0xa5, region: 0x35},
	15:  {lang: 0x3e7, region: 0x99},
	17:  {lang: 0x527, region: 0x12e},
	18:  {lang: 0x3af, region: 0x99},
	19:  {lang: 0x15d, region: 0x78},
	20:  {lang: 0xc2, region: 0x95},
	21:  {lang: 0x9d, region: 0xe7},
	22:  {lang: 0xdb, region: 0x35},
	23:  {lang: 0xf2, region: 0x49},
	24:  {lang: 0x4ee, region: 0x12b},
	25:  {lang: 0xe7, region: 0x13e},
	26:  {lang: 0xe5, region: 0x135},
	28:  {lang: 0xf0, region: 0x6b},
	29:  {lang: 0x19e, region: 0x5d},
	30:  {lang: 0x3e0, region: 0x106},
	32:  {lang: 0x1bc, region: 0x99},
	35:  {lang: 0x15d, region: 0x78},
	38:  {lang: 0x132, region: 0x6b},
	39:  {lang: 0x42f, region: 0x27},
	40:  {lang: 0x27, region: 0x6f},
	42:  {lang: 0x20e, region: 0x7d},
	43:  {lang: 0xfd, region: 0x38},
	46:  {lang: 0x19c, region: 0x130},
	47:  {lang: 0x3e7, region: 0x99},
	48:  {lang: 0x135, region: 0x87},
	49:  {lang: 0x1a2, region: 0x99},
	50:  {lang: 0x39b, region: 0x99},
	51:  {lang: 0x527, region: 0x12e},
	52:  {lang: 0x252, region: 0xab},
	53:  {lang: 0x527, region: 0x53},
	54:  {lang: 0x1c9, region: 0xe7},
	55:  {lang: 0x527, region: 0x53},
	56:  {lang: 0x527, region: 0x12e},
	57:  {lang: 0x2fb, region: 0x9b},
	58:  {lang: 0x1ba, region: 0x97},
	59:  {lang: 0x1fe, region: 0xa2},
	60:  {lang: 0x1c3, region: 0x12b},
	61:  {lang: 0x1c8, region: 0xaf},
	63:  {lang: 0x1d3, region: 0x92},
	65:  {lang: 0x141, region: 0x9e},
	66:  {lang: 0x252, region: 0xab},
	67:  {lang: 0x20c, region: 0x95},
	68:  {lang: 0x1fe, region: 0xa2},
	70:  {lang: 0x134, region: 0xc4},
	71:  {lang: 0x1fe, region: 0xa2},
	72:  {lang: 0x3b9, region: 0xe8},
	73:  {lang: 0x248, region: 0xa6},
	74:  {lang: 0x3f8, region: 0x99},
	77:  {lang: 0x24f, region: 0x99},
	78:  {lang: 0x252, region: 0xab},
	80:  {lang: 0x88, region: 0x99},
	81:  {lang: 0x36e, region: 0x123},
	82:  {lang: 0x2b6, region: 0xaf},
	87:  {lang: 0x29d, region: 0x99},
	88:  {lang: 0x2a6, region: 0x99},
	89:  {lang: 0x28d, region: 0x87},
	90:  {lang: 0x19e, region: 0x87},
	91:  {lang: 0x2aa, region: 0x53},
	93:  {lang: 0x4f2, region: 0x12b},
	94:  {lang: 0x4f3, region: 0x12b},
	95:  {lang: 0x1bc, region: 0x99},
	97:  {lang: 0x335, region: 0x9c},
	98:  {lang: 0x4f5, region: 0x53},
	99:  {lang: 0xa9, region: 0x53},
	102: {lang: 0x2e6, region: 0x112},
	103: {lang: 0x4f6, region: 0x10b},
	104: {lang: 0x4f6, region: 0x10b},
	105: {lang: 0x302, region: 0x99},
	106: {lang: 0x319, region: 0x99},
	107: {lang: 0x309, region: 0x53},
	109: {lang: 0x31c, region: 0x35},
	110: {lang: 0x30c, region: 0x99},
	111: {lang: 0x412, region: 0xe8},
	112: {lang: 0x32f, region: 0xc4},
	113: {lang: 0x4f7, region: 0x108},
	114: {lang: 0x3b, region: 0xa1},
	115: {lang: 0x351, region: 0xdb},
	117: {lang: 0x2ce, region: 0x84},
	119: {lang: 0x401, region: 0x96},
	120: {lang: 0x3ec, region: 0x99},
	121: {lang: 0x399, region: 0xc5},
	122: {lang: 0x393, region: 0x99},
	123: {lang: 0x397, region: 0x135},
	124: {lang: 0x427, region: 0x115},
	125: {lang: 0x3b, region: 0x11c},
	126: {lang: 0xfc, region: 0xc4},
	127: {lang: 0x27b, region: 0x106},
	128: {lang: 0x2c7, region: 0x53},
	129: {lang: 0x39d, region: 0x9c},
	130: {lang: 0x39d, region: 0x53},
	132: {lang: 0x3ab, region: 0xb0},
	134: {lang: 0x1c4, region: 0x53},
	135: {lang: 0x4fb, region: 0x9c},
	186: {lang: 0x3c9, region: 0x95},
	188: {lang: 0x370, region: 0x10c},
	189: {lang: 0x41e, region: 0x97},
	191: {lang: 0x4fd, region: 0x15e},
	192: {lang: 0x3ee, region: 0x99},
	193: {lang: 0x45, region: 0x135},
	194: {lang: 0x138, region: 0x7b},
	195: {lang: 0x3e7, region: 0x99},
	196: {lang: 0x3e7, region: 0x99},
	197: {lang: 0x3f8, region: 0x99},
	198: {lang: 0x40a, region: 0xb3},
	199: {lang: 0x431, region: 0x99},
	201: {lang: 0x43c, region: 0x95},
	202: {lang: 0x44b, region: 0x35},
	203: {lang: 0x44c, region: 0x9b},
	207: {lang: 0x458, region: 0xe7},
	208: {lang: 0x119, region: 0x99},
	209: {lang: 0x45c, region: 0x53},
	210: {lang: 0x230, region: 0x53},
	211: {lang: 0x44e, region: 0x99},
	212: {lang: 0x4a3, region: 0x53},
	213: {lang: 0x9f, region: 0x13e},
	214: {lang: 0x45f, region: 0x99},
	216: {lang: 0x526, region: 0xba},
	217: {lang: 0x152, region: 0xe7},
	218: {lang: 0x127, region: 0xcd},
	219: {lang: 0x469, region: 0x123},
	220: {lang: 0xa9, region: 0x53},
	221: {lang: 0x2cc, region: 0x99},
	222: {lang: 0x4ab, region: 0x11c},
	223: {lang: 0x4bc, region: 0xb4},
	225: {lang: 0x1cc, region: 0x99},
	227: {lang: 0x3a7, region: 0x9c},
	228: {lang: 0x22, region: 0x9b},
	229: {lang: 0x1e8, region: 0x53},
}

type likelyScriptRegion struct {
	region uint16
	script uint8
	flags  uint8
}

// likelyLang is a lookup table, indexed by langID, for the most likely
// scripts and regions given incomplete information. If more entries exist for a
// given language, region and script are the index and size respectively
// of the list in likelyLangList.
// Size: 5308 bytes, 1327 elements
var likelyLang = [1327]likelyScriptRegion{
	0:    {region: 0x135, script: 0x55, flags: 0x0},
	1:    {region: 0x6f, script: 0x55, flags: 0x0},
	2:    {region: 0x165, script: 0x55, flags: 0x0},
	3:    {region: 0x165, script: 0x55, flags: 0x0},
	4:    {region: 0x165, script: 0x55, flags: 0x0},
	5:    {region: 0x7d, script: 0x1e, flags: 0x0},
	6:    {region: 0x165, script: 0x55, flags: 0x0},
	7:    {region: 0x165, script: 0x1e, flags: 0x0},
	8:    {region: 0x80, script: 0x55, flags: 0x0},
	9:    {region: 0x165, script: 0x55, flags: 0x0},
	10:   {region: 0x165, script: 0x55, flags: 0x0},
	11:   {region: 0x165, script: 0x55, flags: 0x0},
	12:   {region: 0x95, script: 0x55, flags: 0x0},
	13:   {region: 0x131, script: 0x55, flags: 0x0},
	14:   {region: 0x80, script: 0x55, flags: 0x0},
	15:   {region: 0x165, script: 0x55, flags: 0x0},
	16:   {region: 0x165, script: 0x55, flags: 0x0},
	17:   {region: 0x106, script: 0x1e, flags: 0x0},
	18:   {region: 0x165, script: 0x55, flags: 0x0},
	19:   {region: 0x9c, script: 0x9, flags: 0x0},
	20:   {region: 0x128, script: 0x5, flags: 0x0},
	21:   {region: 0x165, script: 0x55, flags: 0x0},
	22:   {region: 0x161, script: 0x55, flags: 0x0},
	23:   {region: 0x165, script: 0x55, flags: 0x0},
	24:   {region: 0x165, script: 0x55, flags: 0x0},
	25:   {region: 0x165, script: 0x55, flags: 0x0},
	26:   {region: 0x165, script: 0x55, flags: 0x0},
	27:   {region: 0x165, script: 0x55, flags: 0x0},
	28:   {region: 0x52, script: 0x55, flags: 0x0},
	29:   {region: 0x165, script: 0x55, flags: 0x0},
	30:   {region: 0x165, script: 0x55, flags: 0x0},
	31:   {region: 0x99, script: 0x4, flags: 0x0},
	32:   {region: 0x165, script: 0x55, flags: 0x0},
	33:   {region: 0x80, script: 0x55, flags: 0x0},
	34:   {region: 0x9b, script: 0xe4, flags: 0x0},
	35:   {region: 0x165, script: 0x55, flags: 0x0},
	36:   {region: 0x165, script: 0x55, flags: 0x0},
	37:   {region: 0x14d, script: 0x55, flags: 0x0},
	38:   {region: 0x106, script: 0x1e, flags: 0x0},
	39:   {region: 0x6f, script: 0x28, flags: 0x0},
	40:   {region: 0x165, script: 0x55, flags: 0x0},
	41:   {region: 0x165, script: 0x55, flags: 0x0},
	42:   {region: 0xd6, script: 0x55, flags: 0x0},
	43:   {region: 0x165, script: 0x55, flags: 0x0},
	45:   {region: 0x165, script: 0x55, flags: 0x0},
	46:   {region: 0x165, script: 0x55, flags: 0x0},
	47:   {region: 0x165, script: 0x55, flags: 0x0},
	48:   {region: 0x165, script: 0x55, flags: 0x0},
	49:   {region: 0x165, script: 0x55, flags: 0x0},
	50:   {region: 0x165, script: 0x55, flags: 0x0},
	51:   {region: 0x95, script: 0x55, flags: 0x0},
	52:   {region: 0x165, script: 0x5, flags: 0x0},
	53:   {region: 0x122, script: 0x5, flags: 0x0},
	54:   {region: 0x165, script: 0x55, flags: 0x0},
	55:   {region: 0x165, script: 0x55, flags: 0x0},
	56:   {region: 0x165, script: 0x55, flags: 0x0},
	57:   {region: 0x165, script: 0x55, flags: 0x0},
	58:   {region: 0x6b, script: 0x5, flags: 0x0},
	59:   {region: 0x0, script: 0x3, flags: 0x1},
	60:   {region: 0x165, script: 0x55, flags: 0x0},
	61:   {region: 0x51, script: 0x55, flags: 0x0},
	62:   {region: 0x3f, script: 0x55, flags: 0x0},
	63:   {region: 0x67, script: 0x5, flags: 0x0},
	65:   {region: 0xba, script: 0x5, flags: 0x0},
	66:   {region: 0x6b, script: 0x5, flags: 0x0},
	67:   {region: 0x99, script: 0xe, flags: 0x0},
	68:   {region: 0x12f, script: 0x55, flags: 0x0},
	69:   {region: 0x135, script: 0xc1, flags: 0x0},
	70:   {region: 0x165, script: 0x55, flags: 0x0},
	71:   {region: 0x165, script: 0x55, flags: 0x0},
	72:   {region: 0x6e, script: 0x55, flags: 0x0},
	73:   {region: 0x165, script: 0x55, flags: 0x0},
	74:   {region: 0x165, script: 0x55, flags: 0x0},
	75:   {region: 0x49, script: 0x55, flags: 0x0},
	76:   {region: 0x165, script: 0x55, flags: 0x0},
	77:   {region: 0x106, script: 0x1e, flags: 0x0},
	78:   {region: 0x165, script: 0x5, flags: 0x0},
	79:   {region: 0x165, script: 0x55, flags: 0x0},
	80:   {region: 0x165, script: 0x55, flags: 0x0},
	81:   {region: 0x165, script: 0x55, flags: 0x0},
	82:   {region: 0x99, script: 0x20, flags: 0x0},
	83:   {region: 0x165, script: 0x55, flags: 0x0},
	84:   {region: 0x165, script: 0x55, flags: 0x0},
	85:   {region: 0x165, script: 0x55, flags: 0x0},
	86:   {region: 0x3f, script: 0x55, flags: 0x0},
	87:   {region: 0x165, script: 0x55, flags: 0x0},
	88:   {region: 0x3, script: 0x5, flags: 0x1},
	89:   {region: 0x106, script: 0x1e, flags: 0x0},
	90:   {region: 0xe8, script: 0x5, flags: 0x0},
	91:   {region: 0x95, script: 0x55, flags: 0x0},
	92:   {region: 0xdb, script: 0x20, flags: 0x0},
	93:   {region: 0x2e, script: 0x55, flags: 0x0},
	94:   {region: 0x52, script: 0x55, flags: 0x0},
	95:   {region: 0x165, script: 0x55, flags: 0x0},
	96:   {region: 0x52, script: 0xb, flags: 0x0},
	97:   {region: 0x165, script: 0x55, flags: 0x0},
	98:   {region: 0x165, script: 0x55, flags: 0x0},
	99:   {region: 0x95, script: 0x55, flags: 0x0},
	100:  {region: 0x165, script: 0x55, flags: 0x0},
	101:  {region: 0x52, script: 0x55, flags: 0x0},
	102:  {region: 0x165, script: 0x55, flags: 0x0},
	103:  {region: 0x165, script: 0x55, flags: 0x0},
	104:  {region: 0x165, script: 0x55, flags: 0x0},
	105:  {region: 0x165, script: 0x55, flags: 0x0},
	106:  {region: 0x4f, script: 0x55, flags: 0x0},
	107:  {region: 0x165, script: 0x55, flags: 0x0},
	108:  {region: 0x165, script: 0x55, flags: 0x0},
	109:  {region: 0x165, script: 0x55, flags: 0x0},
	110:  {region: 0x165, script: 0x28, flags: 0x0},
	111:  {region: 0x165, script: 0x55, flags: 0x0},
	112:  {region: 0x165, script: 0x55, flags: 0x0},
	113:  {region: 0x47, script: 0x1e, flags: 0x0},
	114:  {region: 0x165, script: 0x55, flags: 0x0},
	115:  {region: 0x165, script: 0x55, flags: 0x0},
	116:  {region: 0x10b, script: 0x5, flags: 0x0},
	117:  {region: 0x162, script: 0x55, flags: 0x0},
	118:  {region: 0x165, script: 0x55, flags: 0x0},
	119:  {region: 0x95, script: 0x55, flags: 0x0},
	120:  {region: 0x165, script: 0x55, flags: 0x0},
	121:  {region: 0x12f, script: 0x55, flags: 0x0},
	122:  {region: 0x52, script: 0x55, flags: 0x0},
	123:  {region: 0x99, script: 0xd3, flags: 0x0},
	124:  {region: 0xe8, script: 0x5, flags: 0x0},
	125:  {region: 0x99, script: 0x20, flags: 0x0},
	126:  {region: 0x38, script: 0x1e, flags: 0x0},
	127:  {region: 0x99, script: 0x20, flags: 0x0},
	128:  {region: 0xe8, script: 0x5, flags: 0x0},
	129:  {region: 0x12b, script: 0x30, flags: 0x0},
	131:  {region: 0x99, script: 0x20, flags: 0x0},
	132:  {region: 0x165, script: 0x55, flags: 0x0},
	133:  {region: 0x99, script: 0x20, flags: 0x0},
	134:  {region: 0xe7, script: 0x55, flags: 0x0},
	135:  {region: 0x165, script: 0x55, flags: 0x0},
	136:  {region: 0x99, script: 0x20, flags: 0x0},
	137:  {region: 0x165, script: 0x55, flags: 0x0},
	138:  {region: 0x13f, script: 0x55, flags: 0x0},
	139:  {region: 0x165, script: 0x55, flags: 0x0},
	140:  {region: 0x165, script: 0x55, flags: 0x0},
	141:  {region: 0xe7, script: 0x55, flags: 0x0},
	142:  {region: 0x165, script: 0x55, flags: 0x0},
	143:  {region: 0xd6, script: 0x55, flags: 0x0},
	144:  {region: 0x165, script: 0x55, flags: 0x0},
	145:  {region: 0x165, script: 0x55, flags: 0x0},
	146:  {region: 0x165, script: 0x55, flags: 0x0},
	147:  {region: 0x165, script: 0x28, flags: 0x0},
	148:  {region: 0x99, script: 0x20, flags: 0x0},
	149:  {region: 0x95, script: 0x55, flags: 0x0},
	150:  {region: 0x165, script: 0x55, flags: 0x0},
	151:  {region: 0x165, script: 0x55, flags: 0x0},
	152:  {region: 0x114, script: 0x55, flags: 0x0},
	153:  {region: 0x165, script: 0x55, flags: 0x0},
	154:  {region: 0x165, script: 0x55, flags: 0x0},
	155:  {region: 0x52, script: 0x55, flags: 0x0},
	156:  {region: 0x165, script: 0x55, flags: 0x0},
	157:  {region: 0xe7, script: 0x55, flags: 0x0},
	158:  {region: 0x165, script: 0x55, flags: 0x0},
	159:  {region: 0x13e, script: 0xd5, flags: 0x0},
	160:  {region: 0xc3, script: 0x55, flags: 0x0},
	161:  {region: 0x165, script: 0x55, flags: 0x0},
	162:  {region: 0x165, script: 0x55, flags: 0x0},
	163:  {region: 0xc3, script: 0x55, flags: 0x0},
	164:  {region: 0x165, script: 0x55, flags: 0x0},
	165:  {region: 0x35, script: 0xe, flags: 0x0},
	166:  {region: 0x165, script: 0x55, flags: 0x0},
	167:  {region: 0x165, script: 0x55, flags: 0x0},
	168:  {region: 0x165, script: 0x55, flags: 0x0},
	169:  {region: 0x53, script: 0xdc, flags: 0x0},
	170:  {region: 0x165, script: 0x55, flags: 0x0},
	171:  {region: 0x165, script: 0x55, flags: 0x0},
	172:  {region: 0x165, script: 0x55, flags: 0x0},
	173:  {region: 0x99, script: 0xe, flags: 0x0},
	174:  {region: 0x165, script: 0x55, flags: 0x0},
	175:  {region: 0x9c, script: 0x5, flags: 0x0},
	176:  {region: 0x165, script: 0x55, flags: 0x0},
	177:  {region: 0x4f, script: 0x55, flags: 0x0},
	178:  {region: 0x78, script: 0x55, flags: 0x0},
	179:  {region: 0x99, script: 0x20, flags: 0x0},
	180:  {region: 0xe8, script: 0x5, flags: 0x0},
	181:  {region: 0x99, script: 0x20, flags: 0x0},
	182:  {region: 0x165, script: 0x55, flags: 0x0},
	183:  {region: 0x33, script: 0x55, flags: 0x0},
	184:  {region: 0x165, script: 0x55, flags: 0x0},
	185:  {region: 0xb4, script: 0xc, flags: 0x0},
	186:  {region: 0x52, script: 0x55, flags: 0x0},
	187:  {region: 0x165, script: 0x28, flags: 0x0},
	188:  {region: 0xe7, script: 0x55, flags: 0x0},
	189:  {region: 0x165, script: 0x55, flags: 0x0},
	190:  {region: 0xe8, script: 0x20, flags: 0x0},
	191:  {region: 0x106, script: 0x1e, flags: 0x0},
	192:  {region: 0x15f, script: 0x55, flags: 0x0},
	193:  {region: 0x165, script: 0x55, flags: 0x0},
	194:  {region: 0x95, script: 0x55, flags: 0x0},
	195:  {region: 0x165, script: 0x55, flags: 0x0},
	196:  {region: 0x52, script: 0x55, flags: 0x0},
	197:  {region: 0x165, script: 0x55, flags: 0x0},
	198:  {region: 0x165, script: 0x55, flags: 0x0},
	199:  {region: 0x165, script: 0x55, flags: 0x0},
	200:  {region: 0x86, script: 0x55, flags: 0x0},
	201:  {region: 0x165, script: 0x55, flags: 0x0},
	202:  {region: 0x165, script: 0x55, flags: 0x0},
	203:  {region: 0x165, script: 0x55, flags: 0x0},
	204:  {region: 0x165, script: 0x55, flags: 0x0},
	205:  {region: 0x6d, script: 0x28, flags: 0x0},
	206:  {region: 0x165, script: 0x55, flags: 0x0},
	207:  {region: 0x165, script: 0x55, flags: 0x0},
	208:  {region: 0x52, script: 0x55, flags: 0x0},
	209:  {region: 0x165, script: 0x55, flags: 0x0},
	210:  {region: 0x165, script: 0x55, flags: 0x0},
	211:  {region: 0xc3, script: 0x55, flags: 0x0},
	212:  {region: 0x165, script: 0x55, flags: 0x0},
	213:  {region: 0x165, script: 0x55, flags: 0x0},
	214:  {region: 0x165, script: 0x55, flags: 0x0},
	215:  {region: 0x6e, script: 0x55, flags: 0x0},
	216:  {region: 0x165, script: 0x55, flags: 0x0},
	217:  {region: 0x165, script: 0x55, flags: 0x0},
	218:  {region: 0xd6, script: 0x55, flags: 0x0},
	219:  {region: 0x35, script: 0x16, flags: 0x0},
	220:  {region: 0x106, script: 0x1e, flags: 0x0},
	221:  {region: 0xe7, script: 0x55, flags: 0x0},
	222:  {region: 0x165, script: 0x55, flags: 0x0},
	223:  {region: 0x131, script: 0x55, flags: 0x0},
	224:  {region: 0x8a, script: 0x55, flags: 0x0},
	225:  {region: 0x75, script: 0x55, flags: 0x0},
	226:  {region: 0x106, script: 0x1e, flags: 0x0},
	227:  {region: 0x135, script: 0x55, flags: 0x0},
	228:  {region: 0x49, script: 0x55, flags: 0x0},
	229:  {region: 0x135, script: 0x1a, flags: 0x0},
	230:  {region: 0xa6, script: 0x5, flags: 0x0},
	231:  {region: 0x13e, script: 0x19, flags: 0x0},
	232:  {region: 0x165, script: 0x55, flags: 0x0},
	233:  {region: 0x9b, script: 0x5, flags: 0x0},
	234:  {region: 0x165, script: 0x55, flags: 0x0},
	235:  {region: 0x165, script: 0x55, flags: 0x0},
	236:  {region: 0x165, script: 0x55, flags: 0x0},
	237:  {region: 0x165, script: 0x55, flags: 0x0},
	238:  {region: 0x165, script: 0x55, flags: 0x0},
	239:  {region: 0x78, script: 0x55, flags: 0x0},
	240:  {region: 0x6b, script: 0x1c, flags: 0x0},
	241:  {region: 0xe7, script: 0x55, flags: 0x0},
	242:  {region: 0x49, script: 0x17, flags: 0x0},
	243:  {region: 0x130, script: 0x1e, flags: 0x0},
	244:  {region: 0x49, script: 0x17, flags: 0x0},
	245:  {region: 0x49, script: 0x17, flags: 0x0},
	246:  {region: 0x49, script: 0x17, flags: 0x0},
	247:  {region: 0x49, script: 0x17, flags: 0x0},
	248:  {region: 0x10a, script: 0x55, flags: 0x0},
	249:  {region: 0x5e, script: 0x55, flags: 0x0},
	250:  {region: 0xe9, script: 0x55, flags: 0x0},
	251:  {region: 0x49, script: 0x17, flags: 0x0},
	252:  {region: 0xc4, script: 0x7e, flags: 0x0},
	253:  {region: 0x8, script: 0x2, flags: 0x1},
	254:  {region: 0x106, script: 0x1e, flags: 0x0},
	255:  {region: 0x7b, script: 0x55, flags: 0x0},
	256:  {region: 0x63, script: 0x55, flags: 0x0},
	257:  {region: 0x165, script: 0x55, flags: 0x0},
	258:  {region: 0x165, script: 0x55, flags: 0x0},
	259:  {region: 0x165, script: 0x55, flags: 0x0},
	260:  {region: 0x165, script: 0x55, flags: 0x0},
	261:  {region: 0x135, script: 0x55, flags: 0x0},
	262:  {region: 0x106, script: 0x1e, flags: 0x0},
	263:  {region: 0xa4, script: 0x55, flags: 0x0},
	264:  {region: 0x165, script: 0x55, flags: 0x0},
	265:  {region: 0x165, script: 0x55, flags: 0x0},
	266:  {region: 0x99, script: 0x5, flags: 0x0},
	267:  {region: 0x165, script: 0x55, flags: 0x0},
	268:  {region: 0x60, script: 0x55, flags: 0x0},
	269:  {region: 0x165, script: 0x55, flags: 0x0},
	270:  {region: 0x49, script: 0x55, flags: 0x0},
	271:  {region: 0x165, script: 0x55, flags: 0x0},
	272:  {region: 0x165, script: 0x55, flags: 0x0},
	273:  {region: 0x165, script: 0x55, flags: 0x0},
	274:  {region: 0x165, script: 0x5, flags: 0x0},
	275:  {region: 0x49, script: 0x55, flags: 0x0},
	276:  {region: 0x165, script: 0x55, flags: 0x0},
	277:  {region: 0x165, script: 0x55, flags: 0x0},
	278:  {region: 0xd4, script: 0x55, flags: 0x0},
	279:  {region: 0x4f, script: 0x55, flags: 0x0},
	280:  {region: 0x165, script: 0x55, flags: 0x0},
	281:  {region: 0x99, script: 0x5, flags: 0x0},
	282:  {region: 0x165, script: 0x55, flags: 0x0},
	283:  {region: 0x165, script: 0x55, flags: 0x0},
	284:  {region: 0x165, script: 0x55, flags: 0x0},
	285:  {region: 0x165, script: 0x28, flags: 0x0},
	286:  {region: 0x60, script: 0x55, flags: 0x0},
	287:  {region: 0xc3, script: 0x55, flags: 0x0},
	288:  {region: 0xd0, script: 0x55, flags: 0x0},
	289:  {region: 0x165, script: 0x55, flags: 0x0},
	290:  {region: 0xdb, script: 0x20, flags: 0x0},
	291:  {region: 0x52, script: 0x55, flags: 0x0},
	292:  {region: 0x165, script: 0x55, flags: 0x0},
	293:  {region: 0x165, script: 0x55, flags: 0x0},
	294:  {region: 0x165, script: 0x55, flags: 0x0},
	295:  {region: 0xcd, script: 0xda, flags: 0x0},
	296:  {region: 0x165, script: 0x55, flags: 0x0},
	297:  {region: 0x165, script: 0x55, flags: 0x0},
	298:  {region: 0x114, script: 0x55, flags: 0x0},
	299:  {region: 0x37, script: 0x55, flags: 0x0},
	300:  {region: 0x43, script: 0xdc, flags: 0x0},
	301:  {region: 0x165, script: 0x55, flags: 0x0},
	302:  {region: 0xa4, script: 0x55, flags: 0x0},
	303:  {region: 0x80, script: 0x55, flags: 0x0},
	304:  {region: 0xd6, script: 0x55, flags: 0x0},
	305:  {region: 0x9e, script: 0x55, flags: 0x0},
	306:  {region: 0x6b, script: 0x26, flags: 0x0},
	307:  {region: 0x165, script: 0x55, flags: 0x0},
	308:  {region: 0xc4, script: 0x46, flags: 0x0},
	309:  {region: 0x87, script: 0x30, flags: 0x0},
	310:  {region: 0x165, script: 0x55, flags: 0x0},
	311:  {region: 0x165, script: 0x55, flags: 0x0},
	312:  {region: 0xa, script: 0x2, flags: 0x1},
	313:  {region: 0x165, script: 0x55, flags: 0x0},
	314:  {region: 0x165, script: 0x55, flags: 0x0},
	315:  {region: 0x1, script: 0x55, flags: 0x0},
	316:  {region: 0x165, script: 0x55, flags: 0x0},
	317:  {region: 0x6e, script: 0x55, flags: 0x0},
	318:  {region: 0x135, script: 0x55, flags: 0x0},
	319:  {region: 0x6a, script: 0x55, flags: 0x0},
	320:  {region: 0x165, script: 0x55, flags: 0x0},
	321:  {region: 0x9e, script: 0x41, flags: 0x0},
	322:  {region: 0x165, script: 0x55, flags: 0x0},
	323:  {region: 0x165, script: 0x55, flags: 0x0},
	324:  {region: 0x6e, script: 0x55, flags: 0x0},
	325:  {region: 0x52, script: 0x55, flags: 0x0},
	326:  {region: 0x6e, script: 0x55, flags: 0x0},
	327:  {region: 0x9c, script: 0x5, flags: 0x0},
	328:  {region: 0x165, script: 0x55, flags: 0x0},
	329:  {region: 0x165, script: 0x55, flags: 0x0},
	330:  {region: 0x165, script: 0x55, flags: 0x0},
	331:  {region: 0x165, script: 0x55, flags: 0x0},
	332:  {region: 0x86, script: 0x55, flags: 0x0},
	333:  {region: 0xc, script: 0x2, flags: 0x1},
	334:  {region: 0x165, script: 0x55, flags: 0x0},
	335:  {region: 0xc3, script: 0x55, flags: 0x0},
	336:  {region: 0x72, script: 0x55, flags: 0x0},
	337:  {region: 0x10b, script: 0x5, flags: 0x0},
	338:  {region: 0xe7, script: 0x55, flags: 0x0},
	339:  {region: 0x10c, script: 0x55, flags: 0x0},
	340:  {region: 0x73, script: 0x55, flags: 0x0},
	341:  {region: 0x165, script: 0x55, flags: 0x0},
	342:  {region: 0x165, script: 0x55, flags: 0x0},
	343:  {region: 0x76, script: 0x55, flags: 0x0},
	344:  {region: 0x165, script: 0x55, flags: 0x0},
	345:  {region: 0x3b, script: 0x55, flags: 0x0},
	346:  {region: 0x165, script: 0x55, flags: 0x0},
	347:  {region: 0x165, script: 0x55, flags: 0x0},
	348:  {region: 0x165, script: 0x55, flags: 0x0},
	349:  {region: 0x78, script: 0x55, flags: 0x0},
	350:  {region: 0x135, script: 0x55, flags: 0x0},
	351:  {region: 0x78, script: 0x55, flags: 0x0},
	352:  {region: 0x60, script: 0x55, flags: 0x0},
	353:  {region: 0x60, script: 0x55, flags: 0x0},
	354:  {region: 0x52, script: 0x5, flags: 0x0},
	355:  {region: 0x140, script: 0x55, flags: 0x0},
	356:  {region: 0x165, script: 0x55, flags: 0x0},
	357:  {region: 0x84, script: 0x55, flags: 0x0},
	358:  {region: 0x165, script: 0x55, flags: 0x0},
	359:  {region: 0xd4, script: 0x55, flags: 0x0},
	360:  {region: 0x9e, script: 0x55, flags: 0x0},
	361:  {region: 0xd6, script: 0x55, flags: 0x0},
	362:  {region: 0x165, script: 0x55, flags: 0x0},
	363:  {region: 0x10b, script: 0x55, flags: 0x0},
	364:  {region: 0xd9, script: 0x55, flags: 0x0},
	365:  {region: 0x96, script: 0x55, flags: 0x0},
	366:  {region: 0x80, script: 0x55, flags: 0x0},
	367:  {region: 0x165, script: 0x55, flags: 0x0},
	368:  {region: 0xbc, script: 0x55, flags: 0x0},
	369:  {region: 0x165, script: 0x55, flags: 0x0},
	370:  {region: 0x165, script: 0x55, flags: 0x0},
	371:  {region: 0x165, script: 0x55, flags: 0x0},
	372:  {region: 0x53, script: 0x37, flags: 0x0},
	373:  {region: 0x165, script: 0x55, flags: 0x0},
	374:  {region: 0x95, script: 0x55, flags: 0x0},
	375:  {region: 0x165, script: 0x55, flags: 0x0},
	376:  {region: 0x99, script: 0x20, flags: 0x0},
	377:  {region: 0x165, script: 0x55, flags: 0x0},
	378:  {region: 0x9c, script: 0x5, flags: 0x0},
	379:  {region: 0x7e, script: 0x55, flags: 0x0},
	380:  {region: 0x7b, script: 0x55, flags: 0x0},
	381:  {region: 0x165, script: 0x55, flags: 0x0},
	382:  {region: 0x165, script: 0x55, flags: 0x0},
	383:  {region: 0x165, script: 0x55, flags: 0x0},
	384:  {region: 0x165, script: 0x55, flags: 0x0},
	385:  {region: 0x165, script: 0x55, flags: 0x0},
	386:  {region: 0x165, script: 0x55, flags: 0x0},
	387:  {region: 0x6f, script: 0x28, flags: 0x0},
	388:  {region: 0x165, script: 0x55, flags: 0x0},
	389:  {region: 0xdb, script: 0x20, flags: 0x0},
	390:  {region: 0x165, script: 0x55, flags: 0x0},
	391:  {region: 0xa7, script: 0x55, flags: 0x0},
	392:  {region: 0x165, script: 0x55, flags: 0x0},
	393:  {region: 0xe8, script: 0x5, flags: 0x0},
	394:  {region: 0x165, script: 0x55, flags: 0x0},
	395:  {region: 0xe8, script: 0x5, flags: 0x0},
	396:  {region: 0x165, script: 0x55, flags: 0x0},
	397:  {region: 0x165, script: 0x55, flags: 0x0},
	398:  {region: 0x6e, script: 0x55, flags: 0x0},
	399:  {region: 0x9c, script: 0x5, flags: 0x0},
	400:  {region: 0x165, script: 0x55, flags: 0x0},
	401:  {region: 0x165, script: 0x28, flags: 0x0},
	402:  {region: 0xf1, script: 0x55, flags: 0x0},
	403:  {region: 0x165, script: 0x55, flags: 0x0},
	404:  {region: 0x165, script: 0x55, flags: 0x0},
	405:  {region: 0x165, script: 0x55, flags: 0x0},
	406:  {region: 0x165, script: 0x28, flags: 0x0},
	407:  {region: 0x165, script: 0x55, flags: 0x0},
	408:  {region: 0x99, script: 0x20, flags: 0x0},
	409:  {region: 0x99, script: 0xd6, flags: 0x0},
	410:  {region: 0x95, script: 0x55, flags: 0x0},
	411:  {region: 0xd9, script: 0x55, flags: 0x0},
	412:  {region: 0x130, script: 0x2e, flags: 0x0},
	413:  {region: 0x165, script: 0x55, flags: 0x0},
	414:  {region: 0xe, script: 0x2, flags: 0x1},
	415:  {region: 0x99, script: 0xe, flags: 0x0},
	416:  {region: 0x165, script: 0x55, flags: 0x0},
	417:  {region: 0x4e, script: 0x55, flags: 0x0},
	418:  {region: 0x99, script: 0x31, flags: 0x0},
	419:  {region: 0x41, script: 0x55, flags: 0x0},
	420:  {region: 0x54, script: 0x55, flags: 0x0},
	421:  {region: 0x165, script: 0x55, flags: 0x0},
	422:  {region: 0x80, script: 0x55, flags: 0x0},
	423:  {region: 0x165, script: 0x55, flags: 0x0},
	424:  {region: 0x165, script: 0x55, flags: 0x0},
	425:  {region: 0xa4, script: 0x55, flags: 0x0},
	426:  {region: 0x98, script: 0x55, flags: 0x0},
	427:  {region: 0x165, script: 0x55, flags: 0x0},
	428:  {region: 0xdb, script: 0x20, flags: 0x0},
	429:  {region: 0x165, script: 0x55, flags: 0x0},
	430:  {region: 0x165, script: 0x5, flags: 0x0},
	431:  {region: 0x49, script: 0x55, flags: 0x0},
	432:  {region: 0x165, script: 0x5, flags: 0x0},
	433:  {region: 0x165, script: 0x55, flags: 0x0},
	434:  {region: 0x10, script: 0x3, flags: 0x1},
	435:  {region: 0x165, script: 0x55, flags: 0x0},
	436:  {region: 0x53, script: 0x37, flags: 0x0},
	437:  {region: 0x165, script: 0x55, flags: 0x0},
	438:  {region: 0x135, script: 0x55, flags: 0x0},
	439:  {region: 0x24, script: 0x5, flags: 0x0},
	440:  {region: 0x165, script: 0x55, flags: 0x0},
	441:  {region: 0x165, script: 0x28, flags: 0x0},
	442:  {region: 0x97, script: 0x3a, flags: 0x0},
	443:  {region: 0x165, script: 0x55, flags: 0x0},
	444:  {region: 0x99, script: 0x20, flags: 0x0},
	445:  {region: 0x165, script: 0x55, flags: 0x0},
	446:  {region: 0x73, script: 0x55, flags: 0x0},
	447:  {region: 0x165, script: 0x55, flags: 0x0},
	448:  {region: 0x165, script: 0x55, flags: 0x0},
	449:  {region: 0xe7, script: 0x55, flags: 0x0},
	450:  {region: 0x165, script: 0x55, flags: 0x0},
	451:  {region: 0x12b, script: 0x3c, flags: 0x0},
	452:  {region: 0x53, script: 0x86, flags: 0x0},
	453:  {region: 0x165, script: 0x55, flags: 0x0},
	454:  {region: 0xe8, script: 0x5, flags: 0x0},
	455:  {region: 0x99, script: 0x20, flags: 0x0},
	456:  {region: 0xaf, script: 0x3d, flags: 0x0},
	457:  {region: 0xe7, script: 0x55, flags: 0x0},
	458:  {region: 0xe8, script: 0x5, flags: 0x0},
	459:  {region: 0xe6, script: 0x55, flags: 0x0},
	460:  {region: 0x99, script: 0x20, flags: 0x0},
	461:  {region: 0x99, script: 0x20, flags: 0x0},
	462:  {region: 0x165, script: 0x55, flags: 0x0},
	463:  {region: 0x90, script: 0x55, flags: 0x0},
	464:  {region: 0x60, script: 0x55, flags: 0x0},
	465:  {region: 0x53, script: 0x37, flags: 0x0},
	466:  {region: 0x91, script: 0x55, flags: 0x0},
	467:  {region: 0x92, script: 0x55, flags: 0x0},
	468:  {region: 0x165, script: 0x55, flags: 0x0},
	469:  {region: 0x28, script: 0x8, flags: 0x0},
	470:  {region: 0xd2, script: 0x55, flags: 0x0},
	471:  {region: 0x78, script: 0x55, flags: 0x0},
	472:  {region: 0x165, script: 0x55, flags: 0x0},
	473:  {region: 0x165, script: 0x55, flags: 0x0},
	474:  {region: 0xd0, script: 0x55, flags: 0x0},
	475:  {region: 0xd6, script: 0x55, flags: 0x0},
	476:  {region: 0x165, script: 0x55, flags: 0x0},
	477:  {region: 0x165, script: 0x55, flags: 0x0},
	478:  {region: 0x165, script: 0x55, flags: 0x0},
	479:  {region: 0x95, script: 0x55, flags: 0x0},
	480:  {region: 0x165, script: 0x55, flags: 0x0},
	481:  {region: 0x165, script: 0x55, flags: 0x0},
	482:  {region: 0x165, script: 0x55, flags: 0x0},
	484:  {region: 0x122, script: 0x55, flags: 0x0},
	485:  {region: 0xd6, script: 0x55, flags: 0x0},
	486:  {region: 0x165, script: 0x55, flags: 0x0},
	487:  {region: 0x165, script: 0x55, flags: 0x0},
	488:  {region: 0x53, script: 0xe5, flags: 0x0},
	489:  {region: 0x165, script: 0x55, flags: 0x0},
	490:  {region: 0x135, script: 0x55, flags: 0x0},
	491:  {region: 0x165, script: 0x55, flags: 0x0},
	492:  {region: 0x49, script: 0x55, flags: 0x0},
	493:  {region: 0x165, script: 0x55, flags: 0x0},
	494:  {region: 0x165, script: 0x55, flags: 0x0},
	495:  {region: 0xe7, script: 0x55, flags: 0x0},
	496:  {region: 0x165, script: 0x55, flags: 0x0},
	497:  {region: 0x95, script: 0x55, flags: 0x0},
	498:  {region: 0x106, script: 0x1e, flags: 0x0},
	500:  {region: 0x165, script: 0x55, flags: 0x0},
	501:  {region: 0x165, script: 0x55, flags: 0x0},
	502:  {region: 0x9d, script: 0x55, flags: 0x0},
	503:  {region: 0x9e, script: 0x55, flags: 0x0},
	504:  {region: 0x49, script: 0x17, flags: 0x0},
	505:  {region: 0x97, script: 0x3a, flags: 0x0},
	506:  {region: 0x165, script: 0x55, flags: 0x0},
	507:  {region: 0x165, script: 0x55, flags: 0x0},
	508:  {region: 0x106, script: 0x55, flags: 0x0},
	509:  {region: 0x165, script: 0x55, flags: 0x0},
	510:  {region: 0xa2, script: 0x44, flags: 0x0},
	511:  {region: 0x165, script: 0x55, flags: 0x0},
	512:  {region: 0xa0, script: 0x55, flags: 0x0},
	514:  {region: 0x165, script: 0x55, flags: 0x0},
	515:  {region: 0x165, script: 0x55, flags: 0x0},
	516:  {region: 0x165, script: 0x55, flags: 0x0},
	517:  {region: 0x52, script: 0x55, flags: 0x0},
	518:  {region: 0x130, script: 0x3a, flags: 0x0},
	519:  {region: 0x165, script: 0x55, flags: 0x0},
	520:  {region: 0x12f, script: 0x55, flags: 0x0},
	521:  {region: 0xdb, script: 0x20, flags: 0x0},
	522:  {region: 0x165, script: 0x55, flags: 0x0},
	523:  {region: 0x63, script: 0x55, flags: 0x0},
	524:  {region: 0x95, script: 0x55, flags: 0x0},
	525:  {region: 0x95, script: 0x55, flags: 0x0},
	526:  {region: 0x7d, script: 0x2a, flags: 0x0},
	527:  {region: 0x137, script: 0x1e, flags: 0x0},
	528:  {region: 0x67, script: 0x55, flags: 0x0},
	529:  {region: 0xc4, script: 0x55, flags: 0x0},
	530:  {region: 0x165, script: 0x55, flags: 0x0},
	531:  {region: 0x165, script: 0x55, flags: 0x0},
	532:  {region: 0xd6, script: 0x55, flags: 0x0},
	533:  {region: 0xa4, script: 0x55, flags: 0x0},
	534:  {region: 0xc3, script: 0x55, flags: 0x0},
	535:  {region: 0x106, script: 0x1e, flags: 0x0},
	536:  {region: 0x165, script: 0x55, flags: 0x0},
	537:  {region: 0x165, script: 0x55, flags: 0x0},
	538:  {region: 0x165, script: 0x55, flags: 0x0},
	539:  {region: 0x165, script: 0x55, flags: 0x0},
	540:  {region: 0xd4, script: 0x5, flags: 0x0},
	541:  {region: 0xd6, script: 0x55, flags: 0x0},
	542:  {region: 0x164, script: 0x55, flags: 0x0},
	543:  {region: 0x165, script: 0x55, flags: 0x0},
	544:  {region: 0x165, script: 0x55, flags: 0x0},
	545:  {region: 0x12f, script: 0x55, flags: 0x0},
	546:  {region: 0x122, script: 0x5, flags: 0x0},
	547:  {region: 0x165, script: 0x55, flags: 0x0},
	548:  {region: 0x123, script: 0xdb, flags: 0x0},
	549:  {region: 0x5a, script: 0x55, flags: 0x0},
	550:  {region: 0x52, script: 0x55, flags: 0x0},
	551:  {region: 0x165, script: 0x55, flags: 0x0},
	552:  {region: 0x4f, script: 0x55, flags: 0x0},
	553:  {region: 0x99, script: 0x20, flags: 0x0},
	554:  {region: 0x99, script: 0x20, flags: 0x0},
	555:  {region: 0x4b, script: 0x55, flags: 0x0},
	556:  {region: 0x95, script: 0x55, flags: 0x0},
	557:  {region: 0x165, script: 0x55, flags: 0x0},
	558:  {region: 0x41, script: 0x55, flags: 0x0},
	559:  {region: 0x99, script: 0x55, flags: 0x0},
	560:  {region: 0x53, script: 0xd2, flags: 0x0},
	561:  {region: 0x99, script: 0x20, flags: 0x0},
	562:  {region: 0xc3, script: 0x55, flags: 0x0},
	563:  {region: 0x165, script: 0x55, flags: 0x0},
	564:  {region: 0x99, script: 0x70, flags: 0x0},
	565:  {region: 0xe8, script: 0x5, flags: 0x0},
	566:  {region: 0x165, script: 0x55, flags: 0x0},
	567:  {region: 0xa4, script: 0x55, flags: 0x0},
	568:  {region: 0x165, script: 0x55, flags: 0x0},
	569:  {region: 0x12b, script: 0x55, flags: 0x0},
	570:  {region: 0x165, script: 0x55, flags: 0x0},
	571:  {region: 0xd2, script: 0x55, flags: 0x0},
	572:  {region: 0x165, script: 0x55, flags: 0x0},
	573:  {region: 0xaf, script: 0x52, flags: 0x0},
	574:  {region: 0x165, script: 0x55, flags: 0x0},
	575:  {region: 0x165, script: 0x55, flags: 0x0},
	576:  {region: 0x13, script: 0x6, flags: 0x1},
	577:  {region: 0x165, script: 0x55, flags: 0x0},
	578:  {region: 0x52, script: 0x55, flags: 0x0},
	579:  {region: 0x82, script: 0x55, flags: 0x0},
	580:  {region: 0xa4, script: 0x55, flags: 0x0},
	581:  {region: 0x165, script: 0x55, flags: 0x0},
	582:  {region: 0x165, script: 0x55, flags: 0x0},
	583:  {region: 0x165, script: 0x55, flags: 0x0},
	584:  {region: 0xa6, script: 0x49, flags: 0x0},
	585:  {region: 0x2a, script: 0x55, flags: 0x0},
	586:  {region: 0x165, script: 0x55, flags: 0x0},
	587:  {region: 0x165, script: 0x55, flags: 0x0},
	588:  {region: 0x165, script: 0x55, flags: 0x0},
	589:  {region: 0x165, script: 0x55, flags: 0x0},
	590:  {region: 0x165, script: 0x55, flags: 0x0},
	591:  {region: 0x99, script: 0x4d, flags: 0x0},
	592:  {region: 0x114, script: 0x55, flags: 0x0},
	593:  {region: 0x165, script: 0x55, flags: 0x0},
	594:  {region: 0xab, script: 0x4e, flags: 0x0},
	595:  {region: 0x106, script: 0x1e, flags: 0x0},
	596:  {region: 0x99, script: 0x20, flags: 0x0},
	597:  {region: 0x165, script: 0x55, flags: 0x0},
	598:  {region: 0x75, script: 0x55, flags: 0x0},
	599:  {region: 0x165, script: 0x55, flags: 0x0},
	600:  {region: 0xb4, script: 0x55, flags: 0x0},
	601:  {region: 0x165, script: 0x55, flags: 0x0},
	602:  {region: 0x165, script: 0x55, flags: 0x0},
	603:  {region: 0x165, script: 0x55, flags: 0x0},
	604:  {region: 0x165, script: 0x55, flags: 0x0},
	605:  {region: 0x165, script: 0x55, flags: 0x0},
	606:  {region: 0x165, script: 0x55, flags: 0x0},
	607:  {region: 0x165, script: 0x55, flags: 0x0},
	608:  {region: 0x165, script: 0x28, flags: 0x0},
	610:  {region: 0x106, script: 0x1e, flags: 0x0},
	611:  {region: 0x112, script: 0x55, flags: 0x0},
	612:  {region: 0xe7, script: 0x55, flags: 0x0},
	613:  {region: 0x106, script: 0x55, flags: 0x0},
	614:  {region: 0x165, script: 0x55, flags: 0x0},
	615:  {region: 0x99, script: 0x20, flags: 0x0},
	616:  {region: 0x99, script: 0x5, flags: 0x0},
	617:  {region: 0x12f, script: 0x55, flags: 0x0},
	618:  {region: 0x165, script: 0x55, flags: 0x0},
	619:  {region: 0x52, script: 0x55, flags: 0x0},
	620:  {region: 0x60, script: 0x55, flags: 0x0},
	621:  {region: 0x165, script: 0x55, flags: 0x0},
	622:  {region: 0x165, script: 0x55, flags: 0x0},
	623:  {region: 0x165, script: 0x28, flags: 0x0},
	624:  {region: 0x165, script: 0x55, flags: 0x0},
	625:  {region: 0x165, script: 0x55, flags: 0x0},
	626:  {region: 0x19, script: 0x3, flags: 0x1},
	627:  {region: 0x165, script: 0x55, flags: 0x0},
	628:  {region: 0x165, script: 0x55, flags: 0x0},
	629:  {region: 0x165, script: 0x55, flags: 0x0},
	630:  {region: 0x165, script: 0x55, flags: 0x0},
	631:  {region: 0x106, script: 0x1e, flags: 0x0},
	632:  {region: 0x165, script: 0x55, flags: 0x0},
	633:  {region: 0x165, script: 0x55, flags: 0x0},
	634:  {region: 0x165, script: 0x55, flags: 0x0},
	635:  {region: 0x106, script: 0x1e, flags: 0x0},
	636:  {region: 0x165, script: 0x55, flags: 0x0},
	637:  {region: 0x95, script: 0x55, flags: 0x0},
	638:  {region: 0xe8, script: 0x5, flags: 0x0},
	639:  {region: 0x7b, script: 0x55, flags: 0x0},
	640:  {region: 0x165, script: 0x55, flags: 0x0},
	641:  {region: 0x165, script: 0x55, flags: 0x0},
	642:  {region: 0x165, script: 0x55, flags: 0x0},
	643:  {region: 0x165, script: 0x28, flags: 0x0},
	644:  {region: 0x123, script: 0xdb, flags: 0x0},
	645:  {region: 0xe8, script: 0x5, flags: 0x0},
	646:  {region: 0x165, script: 0x55, flags: 0x0},
	647:  {region: 0x165, script: 0x55, flags: 0x0},
	648:  {region: 0x1c, script: 0x5, flags: 0x1},
	649:  {region: 0x165, script: 0x55, flags: 0x0},
	650:  {region: 0x165, script: 0x55, flags: 0x0},
	651:  {region: 0x165, script: 0x55, flags: 0x0},
	652:  {region: 0x138, script: 0x55, flags: 0x0},
	653:  {region: 0x87, script: 0x59, flags: 0x0},
	654:  {region: 0x97, script: 0x3a, flags: 0x0},
	655:  {region: 0x12f, script: 0x55, flags: 0x0},
	656:  {region: 0xe8, script: 0x5, flags: 0x0},
	657:  {region: 0x131, script: 0x55, flags: 0x0},
	658:  {region: 0x165, script: 0x55, flags: 0x0},
	659:  {region: 0xb7, script: 0x55, flags: 0x0},
	660:  {region: 0x106, script: 0x1e, flags: 0x0},
	661:  {region: 0x165, script: 0x55, flags: 0x0},
	662:  {region: 0x95, script: 0x55, flags: 0x0},
	663:  {region: 0x165, script: 0x55, flags: 0x0},
	664:  {region: 0x53, script: 0xdb, flags: 0x0},
	665:  {region: 0x165, script: 0x55, flags: 0x0},
	666:  {region: 0x165, script: 0x55, flags: 0x0},
	667:  {region: 0x165, script: 0x55, flags: 0x0},
	668:  {region: 0x165, script: 0x55, flags: 0x0},
	669:  {region: 0x99, script: 0x57, flags: 0x0},
	670:  {region: 0x165, script: 0x55, flags: 0x0},
	671:  {region: 0x165, script: 0x55, flags: 0x0},
	672:  {region: 0x106, script: 0x1e, flags: 0x0},
	673:  {region: 0x131, script: 0x55, flags: 0x0},
	674:  {region: 0x165, script: 0x55, flags: 0x0},
	675:  {region: 0xd9, script: 0x55, flags: 0x0},
	676:  {region: 0x165, script: 0x55, flags: 0x0},
	677:  {region: 0x165, script: 0x55, flags: 0x0},
	678:  {region: 0x21, script: 0x2, flags: 0x1},
	679:  {region: 0x165, script: 0x55, flags: 0x0},
	680:  {region: 0x165, script: 0x55, flags: 0x0},
	681:  {region: 0x9e, script: 0x55, flags: 0x0},
	682:  {region: 0x53, script: 0x5b, flags: 0x0},
	683:  {region: 0x95, script: 0x55, flags: 0x0},
	684:  {region: 0x9c, script: 0x5, flags: 0x0},
	685:  {region: 0x135, script: 0x55, flags: 0x0},
	686:  {region: 0x165, script: 0x55, flags: 0x0},
	687:  {region: 0x165, script: 0x55, flags: 0x0},
	688:  {region: 0x99, script: 0xd6, flags: 0x0},
	689:  {region: 0x9e, script: 0x55, flags: 0x0},
	690:  {region: 0x165, script: 0x55, flags: 0x0},
	691:  {region: 0x4b, script: 0x55, flags: 0x0},
	692:  {region: 0x165, script: 0x55, flags: 0x0},
	693:  {region: 0x165, script: 0x55, flags: 0x0},
	694:  {region: 0xaf, script: 0x52, flags: 0x0},
	695:  {region: 0x165, script: 0x55, flags: 0x0},
	696:  {region: 0x165, script: 0x55, flags: 0x0},
	697:  {region: 0x4b, script: 0x55, flags: 0x0},
	698:  {region: 0x165, script: 0x55, flags: 0x0},
	699:  {region: 0x165, script: 0x55, flags: 0x0},
	700:  {region: 0x162, script: 0x55, flags: 0x0},
	701:  {region: 0x9c, script: 0x5, flags: 0x0},
	702:  {region: 0xb6, script: 0x55, flags: 0x0},
	703:  {region: 0xb8, script: 0x55, flags: 0x0},
	704:  {region: 0x4b, script: 0x55, flags: 0x0},
	705:  {region: 0x4b, script: 0x55, flags: 0x0},
	706:  {region: 0xa4, script: 0x55, flags: 0x0},
	707:  {region: 0xa4, script: 0x55, flags: 0x0},
	708:  {region: 0x9c, script: 0x5, flags: 0x0},
	709:  {region: 0xb8, script: 0x55, flags: 0x0},
	710:  {region: 0x123, script: 0xdb, flags: 0x0},
	711:  {region: 0x53, script: 0x37, flags: 0x0},
	712:  {region: 0x12b, script: 0x55, flags: 0x0},
	713:  {region: 0x95, script: 0x55, flags: 0x0},
	714:  {region: 0x52, script: 0x55, flags: 0x0},
	715:  {region: 0x99, script: 0x20, flags: 0x0},
	716:  {region: 0x99, script: 0x20, flags: 0x0},
	717:  {region: 0x95, script: 0x55, flags: 0x0},
	718:  {region: 0x23, script: 0x3, flags: 0x1},
	719:  {region: 0xa4, script: 0x55, flags: 0x0},
	720:  {region: 0x165, script: 0x55, flags: 0x0},
	721:  {region: 0xcf, script: 0x55, flags: 0x0},
	722:  {region: 0x165, script: 0x55, flags: 0x0},
	723:  {region: 0x165, script: 0x55, flags: 0x0},
	724:  {region: 0x165, script: 0x55, flags: 0x0},
	725:  {region: 0x165, script: 0x55, flags: 0x0},
	726:  {region: 0x165, script: 0x55, flags: 0x0},
	727:  {region: 0x165, script: 0x55, flags: 0x0},
	728:  {region: 0x165, script: 0x55, flags: 0x0},
	729:  {region: 0x165, script: 0x55, flags: 0x0},
	730:  {region: 0x165, script: 0x55, flags: 0x0},
	731:  {region: 0x165, script: 0x55, flags: 0x0},
	732:  {region: 0x165, script: 0x55, flags: 0x0},
	733:  {region: 0x165, script: 0x5, flags: 0x0},
	734:  {region: 0x106, script: 0x1e, flags: 0x0},
	735:  {region: 0xe7, script: 0x55, flags: 0x0},
	736:  {region: 0x165, script: 0x55, flags: 0x0},
	737:  {region: 0x95, script: 0x55, flags: 0x0},
	738:  {region: 0x165, script: 0x28, flags: 0x0},
	739:  {region: 0x165, script: 0x55, flags: 0x0},
	740:  {region: 0x165, script: 0x55, flags: 0x0},
	741:  {region: 0x165, script: 0x55, flags: 0x0},
	742:  {region: 0x112, script: 0x55, flags: 0x0},
	743:  {region: 0xa4, script: 0x55, flags: 0x0},
	744:  {region: 0x165, script: 0x55, flags: 0x0},
	745:  {region: 0x165, script: 0x55, flags: 0x0},
	746:  {region: 0x123, script: 0x5, flags: 0x0},
	747:  {region: 0xcc, script: 0x55, flags: 0x0},
	748:  {region: 0x165, script: 0x55, flags: 0x0},
	749:  {region: 0x165, script: 0x55, flags: 0x0},
	750:  {region: 0x165, script: 0x55, flags: 0x0},
	751:  {region: 0xbf, script: 0x55, flags: 0x0},
	752:  {region: 0xd1, script: 0x55, flags: 0x0},
	753:  {region: 0x165, script: 0x55, flags: 0x0},
	754:  {region: 0x52, script: 0x55, flags: 0x0},
	755:  {region: 0xdb, script: 0x20, flags: 0x0},
	756:  {region: 0x12f, script: 0x55, flags: 0x0},
	757:  {region: 0xc0, script: 0x55, flags: 0x0},
	758:  {region: 0x165, script: 0x55, flags: 0x0},
	759:  {region: 0x165, script: 0x55, flags: 0x0},
	760:  {region: 0xe0, script: 0x55, flags: 0x0},
	761:  {region: 0x165, script: 0x55, flags: 0x0},
	762:  {region: 0x95, script: 0x55, flags: 0x0},
	763:  {region: 0x9b, script: 0x39, flags: 0x0},
	764:  {region: 0x165, script: 0x55, flags: 0x0},
	765:  {region: 0xc2, script: 0x1e, flags: 0x0},
	766:  {region: 0x165, script: 0x5, flags: 0x0},
	767:  {region: 0x165, script: 0x55, flags: 0x0},
	768:  {region: 0x165, script: 0x55, flags: 0x0},
	769:  {region: 0x165, script: 0x55, flags: 0x0},
	770:  {region: 0x99, script: 0x69, flags: 0x0},
	771:  {region: 0x165, script: 0x55, flags: 0x0},
	772:  {region: 0x165, script: 0x55, flags: 0x0},
	773:  {region: 0x10b, script: 0x55, flags: 0x0},
	774:  {region: 0x165, script: 0x55, flags: 0x0},
	775:  {region: 0x165, script: 0x55, flags: 0x0},
	776:  {region: 0x165, script: 0x55, flags: 0x0},
	777:  {region: 0x26, script: 0x3, flags: 0x1},
	778:  {region: 0x165, script: 0x55, flags: 0x0},
	779:  {region: 0x165, script: 0x55, flags: 0x0},
	780:  {region: 0x99, script: 0xe, flags: 0x0},
	781:  {region: 0xc4, script: 0x70, flags: 0x0},
	783:  {region: 0x165, script: 0x55, flags: 0x0},
	784:  {region: 0x49, script: 0x55, flags: 0x0},
	785:  {region: 0x49, script: 0x55, flags: 0x0},
	786:  {region: 0x37, script: 0x55, flags: 0x0},
	787:  {region: 0x165, script: 0x55, flags: 0x0},
	788:  {region: 0x165, script: 0x55, flags: 0x0},
	789:  {region: 0x165, script: 0x55, flags: 0x0},
	790:  {region: 0x165, script: 0x55, flags: 0x0},
	791:  {region: 0x165, script: 0x55, flags: 0x0},
	792:  {region: 0x165, script: 0x55, flags: 0x0},
	793:  {region: 0x99, script: 0x20, flags: 0x0},
	794:  {region: 0xdb, script: 0x20, flags: 0x0},
	795:  {region: 0x106, script: 0x1e, flags: 0x0},
	796:  {region: 0x35, script: 0x6d, flags: 0x0},
	797:  {region: 0x29, script: 0x3, flags: 0x1},
	798:  {region: 0xcb, script: 0x55, flags: 0x0},
	799:  {region: 0x165, script: 0x55, flags: 0x0},
	800:  {region: 0x165, script: 0x55, flags: 0x0},
	801:  {region: 0x165, script: 0x55, flags: 0x0},
	802:  {region: 0x99, script: 0x20, flags: 0x0},
	803:  {region: 0x52, script: 0x55, flags: 0x0},
	805:  {region: 0x165, script: 0x55, flags: 0x0},
	806:  {region: 0x135, script: 0x55, flags: 0x0},
	807:  {region: 0x165, script: 0x55, flags: 0x0},
	808:  {region: 0x165, script: 0x55, flags: 0x0},
	809:  {region: 0xe8, script: 0x5, flags: 0x0},
	810:  {region: 0xc3, script: 0x55, flags: 0x0},
	811:  {region: 0x99, script: 0x20, flags: 0x0},
	812:  {region: 0x95, script: 0x55, flags: 0x0},
	813:  {region: 0x164, script: 0x55, flags: 0x0},
	814:  {region: 0x165, script: 0x55, flags: 0x0},
	815:  {region: 0xc4, script: 0x70, flags: 0x0},
	816:  {region: 0x165, script: 0x55, flags: 0x0},
	817:  {region: 0x165, script: 0x28, flags: 0x0},
	818:  {region: 0x106, script: 0x1e, flags: 0x0},
	819:  {region: 0x165, script: 0x55, flags: 0x0},
	820:  {region: 0x131, script: 0x55, flags: 0x0},
	821:  {region: 0x9c, script: 0x61, flags: 0x0},
	822:  {region: 0x165, script: 0x55, flags: 0x0},
	823:  {region: 0x165, script: 0x55, flags: 0x0},
	824:  {region: 0x9c, script: 0x5, flags: 0x0},
	825:  {region: 0x165, script: 0x55, flags: 0x0},
	826:  {region: 0x165, script: 0x55, flags: 0x0},
	827:  {region: 0x165, script: 0x55, flags: 0x0},
	828:  {region: 0xdd, script: 0x55, flags: 0x0},
	829:  {region: 0x165, script: 0x55, flags: 0x0},
	830:  {region: 0x165, script: 0x55, flags: 0x0},
	832:  {region: 0x165, script: 0x55, flags: 0x0},
	833:  {region: 0x53, script: 0x37, flags: 0x0},
	834:  {region: 0x9e, script: 0x55, flags: 0x0},
	835:  {region: 0xd2, script: 0x55, flags: 0x0},
	836:  {region: 0x165, script: 0x55, flags: 0x0},
	837:  {region: 0xda, script: 0x55, flags: 0x0},
	838:  {region: 0x165, script: 0x55, flags: 0x0},
	839:  {region: 0x165, script: 0x55, flags: 0x0},
	840:  {region: 0x165, script: 0x55, flags: 0x0},
	841:  {region: 0xcf, script: 0x55, flags: 0x0},
	842:  {region: 0x165, script: 0x55, flags: 0x0},
	843:  {region: 0x165, script: 0x55, flags: 0x0},
	844:  {region: 0x164, script: 0x55, flags: 0x0},
	845:  {region: 0xd1, script: 0x55, flags: 0x0},
	846:  {region: 0x60, script: 0x55, flags: 0x0},
	847:  {region: 0xdb, script: 0x20, flags: 0x0},
	848:  {region: 0x165, script: 0x55, flags: 0x0},
	849:  {region: 0xdb, script: 0x20, flags: 0x0},
	850:  {region: 0x165, script: 0x55, flags: 0x0},
	851:  {region: 0x165, script: 0x55, flags: 0x0},
	852:  {region: 0xd2, script: 0x55, flags: 0x0},
	853:  {region: 0x165, script: 0x55, flags: 0x0},
	854:  {region: 0x165, script: 0x55, flags: 0x0},
	855:  {region: 0xd1, script: 0x55, flags: 0x0},
	856:  {region: 0x165, script: 0x55, flags: 0x0},
	857:  {region: 0xcf, script: 0x55, flags: 0x0},
	858:  {region: 0xcf, script: 0x55, flags: 0x0},
	859:  {region: 0x165, script: 0x55, flags: 0x0},
	860:  {region: 0x165, script: 0x55, flags: 0x0},
	861:  {region: 0x95, script: 0x55, flags: 0x0},
	862:  {region: 0x165, script: 0x55, flags: 0x0},
	863:  {region: 0xdf, script: 0x55, flags: 0x0},
	864:  {region: 0x165, script: 0x55, flags: 0x0},
	865:  {region: 0x165, script: 0x55, flags: 0x0},
	866:  {region: 0x99, script: 0x55, flags: 0x0},
	867:  {region: 0x165, script: 0x55, flags: 0x0},
	868:  {region: 0x165, script: 0x55, flags: 0x0},
	869:  {region: 0xd9, script: 0x55, flags: 0x0},
	870:  {region: 0x52, script: 0x55, flags: 0x0},
	871:  {region: 0x165, script: 0x55, flags: 0x0},
	872:  {region: 0xda, script: 0x55, flags: 0x0},
	873:  {region: 0x165, script: 0x55, flags: 0x0},
	874:  {region: 0x52, script: 0x55, flags: 0x0},
	875:  {region: 0x165, script: 0x55, flags: 0x0},
	876:  {region: 0x165, script: 0x55, flags: 0x0},
	877:  {region: 0xda, script: 0x55, flags: 0x0},
	878:  {region: 0x123, script: 0x51, flags: 0x0},
	879:  {region: 0x99, script: 0x20, flags: 0x0},
	880:  {region: 0x10c, script: 0xbc, flags: 0x0},
	881:  {region: 0x165, script: 0x55, flags: 0x0},
	882:  {region: 0x165, script: 0x55, flags: 0x0},
	883:  {region: 0x84, script: 0x75, flags: 0x0},
	884:  {region: 0x161, script: 0x55, flags: 0x0},
	885:  {region: 0x165, script: 0x55, flags: 0x0},
	886:  {region: 0x49, script: 0x17, flags: 0x0},
	887:  {region: 0x165, script: 0x55, flags: 0x0},
	888:  {region: 0x161, script: 0x55, flags: 0x0},
	889:  {region: 0x165, script: 0x55, flags: 0x0},
	890:  {region: 0x165, script: 0x55, flags: 0x0},
	891:  {region: 0x165, script: 0x55, flags: 0x0},
	892:  {region: 0x165, script: 0x55, flags: 0x0},
	893:  {region: 0x165, script: 0x55, flags: 0x0},
	894:  {region: 0x117, script: 0x55, flags: 0x0},
	895:  {region: 0x165, script: 0x55, flags: 0x0},
	896:  {region: 0x165, script: 0x55, flags: 0x0},
	897:  {region: 0x135, script: 0x55, flags: 0x0},
	898:  {region: 0x165, script: 0x55, flags: 0x0},
	899:  {region: 0x53, script: 0x55, flags: 0x0},
	900:  {region: 0x165, script: 0x55, flags: 0x0},
	901:  {region: 0xce, script: 0x55, flags: 0x0},
	902:  {region: 0x12f, script: 0x55, flags: 0x0},
	903:  {region: 0x131, script: 0x55, flags: 0x0},
	904:  {region: 0x80, script: 0x55, flags: 0x0},
	905:  {region: 0x78, script: 0x55, flags: 0x0},
	906:  {region: 0x165, script: 0x55, flags: 0x0},
	908:  {region: 0x165, script: 0x55, flags: 0x0},
	909:  {region: 0x165, script: 0x55, flags: 0x0},
	910:  {region: 0x6f, script: 0x55, flags: 0x0},
	911:  {region: 0x165, script: 0x55, flags: 0x0},
	912:  {region: 0x165, script: 0x55, flags: 0x0},
	913:  {region: 0x165, script: 0x55, flags: 0x0},
	914:  {region: 0x165, script: 0x55, flags: 0x0},
	915:  {region: 0x99, script: 0x7a, flags: 0x0},
	916:  {region: 0x165, script: 0x55, flags: 0x0},
	917:  {region: 0x165, script: 0x5, flags: 0x0},
	918:  {region: 0x7d, script: 0x1e, flags: 0x0},
	919:  {region: 0x135, script: 0x7b, flags: 0x0},
	920:  {region: 0x165, script: 0x5, flags: 0x0},
	921:  {region: 0xc5, script: 0x79, flags: 0x0},
	922:  {region: 0x165, script: 0x55, flags: 0x0},
	923:  {region: 0x2c, script: 0x3, flags: 0x1},
	924:  {region: 0xe7, script: 0x55, flags: 0x0},
	925:  {region: 0x2f, script: 0x2, flags: 0x1},
	926:  {region: 0xe7, script: 0x55, flags: 0x0},
	927:  {region: 0x30, script: 0x55, flags: 0x0},
	928:  {region: 0xf0, script: 0x55, flags: 0x0},
	929:  {region: 0x165, script: 0x55, flags: 0x0},
	930:  {region: 0x78, script: 0x55, flags: 0x0},
	931:  {region: 0xd6, script: 0x55, flags: 0x0},
	932:  {region: 0x135, script: 0x55, flags: 0x0},
	933:  {region: 0x49, script: 0x55, flags: 0x0},
	934:  {region: 0x165, script: 0x55, flags: 0x0},
	935:  {region: 0x9c, script: 0xe3, flags: 0x0},
	936:  {region: 0x165, script: 0x55, flags: 0x0},
	937:  {region: 0x60, script: 0x55, flags: 0x0},
	938:  {region: 0x165, script: 0x5, flags: 0x0},
	939:  {region: 0xb0, script: 0x84, flags: 0x0},
	941:  {region: 0x165, script: 0x55, flags: 0x0},
	942:  {region: 0x165, script: 0x55, flags: 0x0},
	943:  {region: 0x99, script: 0x12, flags: 0x0},
	944:  {region: 0xa4, script: 0x55, flags: 0x0},
	945:  {region: 0xe9, script: 0x55, flags: 0x0},
	946:  {region: 0x165, script: 0x55, flags: 0x0},
	947:  {region: 0x9e, script: 0x55, flags: 0x0},
	948:  {region: 0x165, script: 0x55, flags: 0x0},
	949:  {region: 0x165, script: 0x55, flags: 0x0},
	950:  {region: 0x87, script: 0x30, flags: 0x0},
	951:  {region: 0x75, script: 0x55, flags: 0x0},
	952:  {region: 0x165, script: 0x55, flags: 0x0},
	953:  {region: 0xe8, script: 0x48, flags: 0x0},
	954:  {region: 0x9c, script: 0x5, flags: 0x0},
	955:  {region: 0x1, script: 0x55, flags: 0x0},
	956:  {region: 0x24, script: 0x5, flags: 0x0},
	957:  {region: 0x165, script: 0x55, flags: 0x0},
	958:  {region: 0x41, script: 0x55, flags: 0x0},
	959:  {region: 0x165, script: 0x55, flags: 0x0},
	960:  {region: 0x7a, script: 0x55, flags: 0x0},
	961:  {region: 0x165, script: 0x55, flags: 0x0},
	962:  {region: 0xe4, script: 0x55, flags: 0x0},
	963:  {region: 0x89, script: 0x55, flags: 0x0},
	964:  {region: 0x69, script: 0x55, flags: 0x0},
	965:  {region: 0x165, script: 0x55, flags: 0x0},
	966:  {region: 0x99, script: 0x20, flags: 0x0},
	967:  {region: 0x165, script: 0x55, flags: 0x0},
	968:  {region: 0x102, script: 0x55, flags: 0x0},
	969:  {region: 0x95, script: 0x55, flags: 0x0},
	970:  {region: 0x165, script: 0x55, flags: 0x0},
	971:  {region: 0x165, script: 0x55, flags: 0x0},
	972:  {region: 0x9e, script: 0x55, flags: 0x0},
	973:  {region: 0x165, script: 0x5, flags: 0x0},
	974:  {region: 0x99, script: 0x55, flags: 0x0},
	975:  {region: 0x31, script: 0x2, flags: 0x1},
	976:  {region: 0xdb, script: 0x20, flags: 0x0},
	977:  {region: 0x35, script: 0xe, flags: 0x0},
	978:  {region: 0x4e, script: 0x55, flags: 0x0},
	979:  {region: 0x72, script: 0x55, flags: 0x0},
	980:  {region: 0x4e, script: 0x55, flags: 0x0},
	981:  {region: 0x9c, script: 0x5, flags: 0x0},
	982:  {region: 0x10c, script: 0x55, flags: 0x0},
	983:  {region: 0x3a, script: 0x55, flags: 0x0},
	984:  {region: 0x165, script: 0x55, flags: 0x0},
	985:  {region: 0xd1, script: 0x55, flags: 0x0},
	986:  {region: 0x104, script: 0x55, flags: 0x0},
	987:  {region: 0x95, script: 0x55, flags: 0x0},
	988:  {region: 0x12f, script: 0x55, flags: 0x0},
	989:  {region: 0x165, script: 0x55, flags: 0x0},
	990:  {region: 0x165, script: 0x55, flags: 0x0},
	991:  {region: 0x73, script: 0x55, flags: 0x0},
	992:  {region: 0x106, script: 0x1e, flags: 0x0},
	993:  {region: 0x130, script: 0x1e, flags: 0x0},
	994:  {region: 0x109, script: 0x55, flags: 0x0},
	995:  {region: 0x107, script: 0x55, flags: 0x0},
	996:  {region: 0x12f, script: 0x55, flags: 0x0},
	997:  {region: 0x165, script: 0x55, flags: 0x0},
	998:  {region: 0xa2, script: 0x47, flags: 0x0},
	999:  {region: 0x99, script: 0x20, flags: 0x0},
	1000: {region: 0x80, script: 0x55, flags: 0x0},
	1001: {region: 0x106, script: 0x1e, flags: 0x0},
	1002: {region: 0xa4, script: 0x55, flags: 0x0},
	1003: {region: 0x95, script: 0x55, flags: 0x0},
	1004: {region: 0x99, script: 0x55, flags: 0x0},
	1005: {region: 0x114, script: 0x55, flags: 0x0},
	1006: {region: 0x99, script: 0xc0, flags: 0x0},
	1007: {region: 0x165, script: 0x55, flags: 0x0},
	1008: {region: 0x165, script: 0x55, flags: 0x0},
	1009: {region: 0x12f, script: 0x55, flags: 0x0},
	1010: {region: 0x9e, script: 0x55, flags: 0x0},
	1011: {region: 0x99, script: 0x20, flags: 0x0},
	1012: {region: 0x165, script: 0x5, flags: 0x0},
	1013: {region: 0x9e, script: 0x55, flags: 0x0},
	1014: {region: 0x7b, script: 0x55, flags: 0x0},
	1015: {region: 0x49, script: 0x55, flags: 0x0},
	1016: {region: 0x33, script: 0x4, flags: 0x1},
	1017: {region: 0x9e, script: 0x55, flags: 0x0},
	1018: {region: 0x9c, script: 0x5, flags: 0x0},
	1019: {region: 0xda, script: 0x55, flags: 0x0},
	1020: {region: 0x4f, script: 0x55, flags: 0x0},
	1021: {region: 0xd1, script: 0x55, flags: 0x0},
	1022: {region: 0xcf, script: 0x55, flags: 0x0},
	1023: {region: 0xc3, script: 0x55, flags: 0x0},
	1024: {region: 0x4c, script: 0x55, flags: 0x0},
	1025: {region: 0x96, script: 0x77, flags: 0x0},
	1026: {region: 0xb6, script: 0x55, flags: 0x0},
	1027: {region: 0x165, script: 0x28, flags: 0x0},
	1028: {region: 0x165, script: 0x55, flags: 0x0},
	1030: {region: 0xba, script: 0xd8, flags: 0x0},
	1031: {region: 0x165, script: 0x55, flags: 0x0},
	1032: {region: 0xc4, script: 0x70, flags: 0x0},
	1033: {region: 0x165, script: 0x5, flags: 0x0},
	1034: {region: 0xb3, script: 0xc6, flags: 0x0},
	1035: {region: 0x6f, script: 0x55, flags: 0x0},
	1036: {region: 0x165, script: 0x55, flags: 0x0},
	1037: {region: 0x165, script: 0x55, flags: 0x0},
	1038: {region: 0x165, script: 0x55, flags: 0x0},
	1039: {region: 0x165, script: 0x55, flags: 0x0},
	1040: {region: 0x111, script: 0x55, flags: 0x0},
	1041: {region: 0x165, script: 0x55, flags: 0x0},
	1042: {region: 0xe8, script: 0x5, flags: 0x0},
	1043: {region: 0x165, script: 0x55, flags: 0x0},
	1044: {region: 0x10f, script: 0x55, flags: 0x0},
	1045: {region: 0x165, script: 0x55, flags: 0x0},
	1046: {region: 0xe9, script: 0x55, flags: 0x0},
	1047: {region: 0x165, script: 0x55, flags: 0x0},
	1048: {region: 0x95, script: 0x55, flags: 0x0},
	1049: {region: 0x142, script: 0x55, flags: 0x0},
	1050: {region: 0x10c, script: 0x55, flags: 0x0},
	1052: {region: 0x10c, script: 0x55, flags: 0x0},
	1053: {region: 0x72, script: 0x55, flags: 0x0},
	1054: {region: 0x97, script: 0xbd, flags: 0x0},
	1055: {region: 0x165, script: 0x55, flags: 0x0},
	1056: {region: 0x72, script: 0x55, flags: 0x0},
	1057: {region: 0x164, script: 0x55, flags: 0x0},
	1058: {region: 0x165, script: 0x55, flags: 0x0},
	1059: {region: 0xc3, script: 0x55, flags: 0x0},
	1060: {region: 0x165, script: 0x55, flags: 0x0},
	1061: {region: 0x165, script: 0x55, flags: 0x0},
	1062: {region: 0x165, script: 0x55, flags: 0x0},
	1063: {region: 0x115, script: 0x55, flags: 0x0},
	1064: {region: 0x165, script: 0x55, flags: 0x0},
	1065: {region: 0x165, script: 0x55, flags: 0x0},
	1066: {region: 0x123, script: 0xdb, flags: 0x0},
	1067: {region: 0x165, script: 0x55, flags: 0x0},
	1068: {region: 0x165, script: 0x55, flags: 0x0},
	1069: {region: 0x165, script: 0x55, flags: 0x0},
	1070: {region: 0x165, script: 0x55, flags: 0x0},
	1071: {region: 0x27, script: 0x55, flags: 0x0},
	1072: {region: 0x37, script: 0x5, flags: 0x1},
	1073: {region: 0x99, script: 0xc7, flags: 0x0},
	1074: {region: 0x116, script: 0x55, flags: 0x0},
	1075: {region: 0x114, script: 0x55, flags: 0x0},
	1076: {region: 0x99, script: 0x20, flags: 0x0},
	1077: {region: 0x161, script: 0x55, flags: 0x0},
	1078: {region: 0x165, script: 0x55, flags: 0x0},
	1079: {region: 0x165, script: 0x55, flags: 0x0},
	1080: {region: 0x6d, script: 0x55, flags: 0x0},
	1081: {region: 0x161, script: 0x55, flags: 0x0},
	1082: {region: 0x165, script: 0x55, flags: 0x0},
	1083: {region: 0x60, script: 0x55, flags: 0x0},
	1084: {region: 0x95, script: 0x55, flags: 0x0},
	1085: {region: 0x165, script: 0x55, flags: 0x0},
	1086: {region: 0x165, script: 0x55, flags: 0x0},
	1087: {region: 0x12f, script: 0x55, flags: 0x0},
	1088: {region: 0x165, script: 0x55, flags: 0x0},
	1089: {region: 0x84, script: 0x55, flags: 0x0},
	1090: {region: 0x10c, script: 0x55, flags: 0x0},
	1091: {region: 0x12f, script: 0x55, flags: 0x0},
	1092: {region: 0x15f, script: 0x5, flags: 0x0},
	1093: {region: 0x4b, script: 0x55, flags: 0x0},
	1094: {region: 0x60, script: 0x55, flags: 0x0},
	1095: {region: 0x165, script: 0x55, flags: 0x0},
	1096: {region: 0x99, script: 0x20, flags: 0x0},
	1097: {region: 0x95, script: 0x55, flags: 0x0},
	1098: {region: 0x165, script: 0x55, flags: 0x0},
	1099: {region: 0x35, script: 0xe, flags: 0x0},
	1100: {region: 0x9b, script: 0xcb, flags: 0x0},
	1101: {region: 0xe9, script: 0x55, flags: 0x0},
	1102: {region: 0x99, script: 0xd3, flags: 0x0},
	1103: {region: 0xdb, script: 0x20, flags: 0x0},
	1104: {region: 0x165, script: 0x55, flags: 0x0},
	1105: {region: 0x165, script: 0x55, flags: 0x0},
	1106: {region: 0x165, script: 0x55, flags: 0x0},
	1107: {region: 0x165, script: 0x55, flags: 0x0},
	1108: {region: 0x165, script: 0x55, flags: 0x0},
	1109: {region: 0x165, script: 0x55, flags: 0x0},
	1110: {region: 0x165, script: 0x55, flags: 0x0},
	1111: {region: 0x165, script: 0x55, flags: 0x0},
	1112: {region: 0xe7, script: 0x55, flags: 0x0},
	1113: {region: 0x165, script: 0x55, flags: 0x0},
	1114: {region: 0x165, script: 0x55, flags: 0x0},
	1115: {region: 0x99, script: 0x4d, flags: 0x0},
	1116: {region: 0x53, script: 0xd1, flags: 0x0},
	1117: {region: 0xdb, script: 0x20, flags: 0x0},
	1118: {region: 0xdb, script: 0x20, flags: 0x0},
	1119: {region: 0x99, script: 0xd6, flags: 0x0},
	1120: {region: 0x165, script: 0x55, flags: 0x0},
	1121: {region: 0x112, script: 0x55, flags: 0x0},
	1122: {region: 0x131, script: 0x55, flags: 0x0},
	1123: {region: 0x126, script: 0x55, flags: 0x0},
	1124: {region: 0x165, script: 0x55, flags: 0x0},
	1125: {region: 0x3c, script: 0x3, flags: 0x1},
	1126: {region: 0x165, script: 0x55, flags: 0x0},
	1127: {region: 0x165, script: 0x55, flags: 0x0},
	1128: {region: 0x165, script: 0x55, flags: 0x0},
	1129: {region: 0x123, script: 0xdb, flags: 0x0},
	1130: {region: 0xdb, script: 0x20, flags: 0x0},
	1131: {region: 0xdb, script: 0x20, flags: 0x0},
	1132: {region: 0xdb, script: 0x20, flags: 0x0},
	1133: {region: 0x6f, script: 0x28, flags: 0x0},
	1134: {region: 0x165, script: 0x55, flags: 0x0},
	1135: {region: 0x6d, script: 0x28, flags: 0x0},
	1136: {region: 0x165, script: 0x55, flags: 0x0},
	1137: {region: 0x165, script: 0x55, flags: 0x0},
	1138: {region: 0x165, script: 0x55, flags: 0x0},
	1139: {region: 0xd6, script: 0x55, flags: 0x0},
	1140: {region: 0x127, script: 0x55, flags: 0x0},
	1141: {region: 0x125, script: 0x55, flags: 0x0},
	1142: {region: 0x32, script: 0x55, flags: 0x0},
	1143: {region: 0xdb, script: 0x20, flags: 0x0},
	1144: {region: 0xe7, script: 0x55, flags: 0x0},
	1145: {region: 0x165, script: 0x55, flags: 0x0},
	1146: {region: 0x165, script: 0x55, flags: 0x0},
	1147: {region: 0x32, script: 0x55, flags: 0x0},
	1148: {region: 0xd4, script: 0x55, flags: 0x0},
	1149: {region: 0x165, script: 0x55, flags: 0x0},
	1150: {region: 0x161, script: 0x55, flags: 0x0},
	1151: {region: 0x165, script: 0x55, flags: 0x0},
	1152: {region: 0x129, script: 0x55, flags: 0x0},
	1153: {region: 0x165, script: 0x55, flags: 0x0},
	1154: {region: 0xce, script: 0x55, flags: 0x0},
	1155: {region: 0x165, script: 0x55, flags: 0x0},
	1156: {region: 0xe6, script: 0x55, flags: 0x0},
	1157: {region: 0x165, script: 0x55, flags: 0x0},
	1158: {region: 0x165, script: 0x55, flags: 0x0},
	1159: {region: 0x165, script: 0x55, flags: 0x0},
	1160: {region: 0x12b, script: 0x55, flags: 0x0},
	1161: {region: 0x12b, script: 0x55, flags: 0x0},
	1162: {region: 0x12e, script: 0x55, flags: 0x0},
	1163: {region: 0x165, script: 0x5, flags: 0x0},
	1164: {region: 0x161, script: 0x55, flags: 0x0},
	1165: {region: 0x87, script: 0x30, flags: 0x0},
	1166: {region: 0xdb, script: 0x20, flags: 0x0},
	1167: {region: 0xe7, script: 0x55, flags: 0x0},
	1168: {region: 0x43, script: 0xdc, flags: 0x0},
	1169: {region: 0x165, script: 0x55, flags: 0x0},
	1170: {region: 0x106, script: 0x1e, flags: 0x0},
	1171: {region: 0x165, script: 0x55, flags: 0x0},
	1172: {region: 0x165, script: 0x55, flags: 0x0},
	1173: {region: 0x131, script: 0x55, flags: 0x0},
	1174: {region: 0x165, script: 0x55, flags: 0x0},
	1175: {region: 0x123, script: 0xdb, flags: 0x0},
	1176: {region: 0x32, script: 0x55, flags: 0x0},
	1177: {region: 0x165, script: 0x55, flags: 0x0},
	1178: {region: 0x165, script: 0x55, flags: 0x0},
	1179: {region: 0xce, script: 0x55, flags: 0x0},
	1180: {region: 0x165, script: 0x55, flags: 0x0},
	1181: {region: 0x165, script: 0x55, flags: 0x0},
	1182: {region: 0x12d, script: 0x55, flags: 0x0},
	1183: {region: 0x165, script: 0x55, flags: 0x0},
	1185: {region: 0x165, script: 0x55, flags: 0x0},
	1186: {region: 0xd4, script: 0x55, flags: 0x0},
	1187: {region: 0x53, script: 0xd4, flags: 0x0},
	1188: {region: 0xe5, script: 0x55, flags: 0x0},
	1189: {region: 0x165, script: 0x55, flags: 0x0},
	1190: {region: 0x106, script: 0x1e, flags: 0x0},
	1191: {region: 0xba, script: 0x55, flags: 0x0},
	1192: {region: 0x165, script: 0x55, flags: 0x0},
	1193: {region: 0x106, script: 0x1e, flags: 0x0},
	1194: {region: 0x3f, script: 0x4, flags: 0x1},
	1195: {region: 0x11c, script: 0xde, flags: 0x0},
	1196: {region: 0x130, script: 0x1e, flags: 0x0},
	1197: {region: 0x75, script: 0x55, flags: 0x0},
	1198: {region: 0x2a, script: 0x55, flags: 0x0},
	1200: {region: 0x43, script: 0x3, flags: 0x1},
	1201: {region: 0x99, script: 0xe, flags: 0x0},
	1202: {region: 0xe8, script: 0x5, flags: 0x0},
	1203: {region: 0x165, script: 0x55, flags: 0x0},
	1204: {region: 0x165, script: 0x55, flags: 0x0},
	1205: {region: 0x165, script: 0x55, flags: 0x0},
	1206: {region: 0x165, script: 0x55, flags: 0x0},
	1207: {region: 0x165, script: 0x55, flags: 0x0},
	1208: {region: 0x165, script: 0x55, flags: 0x0},
	1209: {region: 0x165, script: 0x55, flags: 0x0},
	1210: {region: 0x46, script: 0x4, flags: 0x1},
	1211: {region: 0x165, script: 0x55, flags: 0x0},
	1212: {region: 0xb4, script: 0xdf, flags: 0x0},
	1213: {region: 0x165, script: 0x55, flags: 0x0},
	1214: {region: 0x161, script: 0x55, flags: 0x0},
	1215: {region: 0x9e, script: 0x55, flags: 0x0},
	1216: {region: 0x106, script: 0x55, flags: 0x0},
	1217: {region: 0x13e, script: 0x55, flags: 0x0},
	1218: {region: 0x11b, script: 0x55, flags: 0x0},
	1219: {region: 0x165, script: 0x55, flags: 0x0},
	1220: {region: 0x36, script: 0x55, flags: 0x0},
	1221: {region: 0x60, script: 0x55, flags: 0x0},
	1222: {region: 0xd1, script: 0x55, flags: 0x0},
	1223: {region: 0x1, script: 0x55, flags: 0x0},
	1224: {region: 0x106, script: 0x55, flags: 0x0},
	1225: {region: 0x6a, script: 0x55, flags: 0x0},
	1226: {region: 0x12f, script: 0x55, flags: 0x0},
	1227: {region: 0x165, script: 0x55, flags: 0x0},
	1228: {region: 0x36, script: 0x55, flags: 0x0},
	1229: {region: 0x4e, script: 0x55, flags: 0x0},
	1230: {region: 0x165, script: 0x55, flags: 0x0},
	1231: {region: 0x6f, script: 0x28, flags: 0x0},
	1232: {region: 0x165, script: 0x55, flags: 0x0},
	1233: {region: 0xe7, script: 0x55, flags: 0x0},
	1234: {region: 0x2f, script: 0x55, flags: 0x0},
	1235: {region: 0x99, script: 0xd6, flags: 0x0},
	1236: {region: 0x99, script: 0x20, flags: 0x0},
	1237: {region: 0x165, script: 0x55, flags: 0x0},
	1238: {region: 0x165, script: 0x55, flags: 0x0},
	1239: {region: 0x165, script: 0x55, flags: 0x0},
	1240: {region: 0x165, script: 0x55, flags: 0x0},
	1241: {region: 0x165, script: 0x55, flags: 0x0},
	1242: {region: 0x165, script: 0x55, flags: 0x0},
	1243: {region: 0x165, script: 0x55, flags: 0x0},
	1244: {region: 0x165, script: 0x55, flags: 0x0},
	1245: {region: 0x165, script: 0x55, flags: 0x0},
	1246: {region: 0x140, script: 0x55, flags: 0x0},
	1247: {region: 0x165, script: 0x55, flags: 0x0},
	1248: {region: 0x165, script: 0x55, flags: 0x0},
	1249: {region: 0xa8, script: 0x5, flags: 0x0},
	1250: {region: 0x165, script: 0x55, flags: 0x0},
	1251: {region: 0x114, script: 0x55, flags: 0x0},
	1252: {region: 0x165, script: 0x55, flags: 0x0},
	1253: {region: 0x165, script: 0x55, flags: 0x0},
	1254: {region: 0x165, script: 0x55, flags: 0x0},
	1255: {region: 0x165, script: 0x55, flags: 0x0},
	1256: {region: 0x99, script: 0x20, flags: 0x0},
	1257: {region: 0x53, script: 0x37, flags: 0x0},
	1258: {region: 0x165, script: 0x55, flags: 0x0},
	1259: {region: 0x165, script: 0x55, flags: 0x0},
	1260: {region: 0x41, script: 0x55, flags: 0x0},
	1261: {region: 0x165, script: 0x55, flags: 0x0},
	1262: {region: 0x12b, script: 0x18, flags: 0x0},
	1263: {region: 0x165, script: 0x55, flags: 0x0},
	1264: {region: 0x161, script: 0x55, flags: 0x0},
	1265: {region: 0x165, script: 0x55, flags: 0x0},
	1266: {region: 0x12b, script: 0x5d, flags: 0x0},
	1267: {region: 0x12b, script: 0x5e, flags: 0x0},
	1268: {region: 0x7d, script: 0x2a, flags: 0x0},
	1269: {region: 0x53, script: 0x62, flags: 0x0},
	1270: {region: 0x10b, script: 0x67, flags: 0x0},
	1271: {region: 0x108, script: 0x71, flags: 0x0},
	1272: {region: 0x99, script: 0x20, flags: 0x0},
	1273: {region: 0x131, script: 0x55, flags: 0x0},
	1274: {region: 0x165, script: 0x55, flags: 0x0},
	1275: {region: 0x9c, script: 0x87, flags: 0x0},
	1276: {region: 0x165, script: 0x55, flags: 0x0},
	1277: {region: 0x15e, script: 0xbf, flags: 0x0},
	1278: {region: 0x165, script: 0x55, flags: 0x0},
	1279: {region: 0x165, script: 0x55, flags: 0x0},
	1280: {region: 0xdb, script: 0x20, flags: 0x0},
	1281: {region: 0x165, script: 0x55, flags: 0x0},
	1282: {region: 0x165, script: 0x55, flags: 0x0},
	1283: {region: 0xd1, script: 0x55, flags: 0x0},
	1284: {region: 0x75, script: 0x55, flags: 0x0},
	1285: {region: 0x165, script: 0x55, flags: 0x0},
	1286: {region: 0x165, script: 0x55, flags: 0x0},
	1287: {region: 0x52, script: 0x55, flags: 0x0},
	1288: {region: 0x165, script: 0x55, flags: 0x0},
	1289: {region: 0x165, script: 0x55, flags: 0x0},
	1290: {region: 0x165, script: 0x55, flags: 0x0},
	1291: {region: 0x52, script: 0x55, flags: 0x0},
	1292: {region: 0x165, script: 0x55, flags: 0x0},
	1293: {region: 0x165, script: 0x55, flags: 0x0},
	1294: {region: 0x165, script: 0x55, flags: 0x0},
	1295: {region: 0x165, script: 0x55, flags: 0x0},
	1296: {region: 0x1, script: 0x3a, flags: 0x0},
	1297: {region: 0x165, script: 0x55, flags: 0x0},
	1298: {region: 0x165, script: 0x55, flags: 0x0},
	1299: {region: 0x165, script: 0x55, flags: 0x0},
	1300: {region: 0x165, script: 0x55, flags: 0x0},
	1301: {region: 0x165, script: 0x55, flags: 0x0},
	1302: {region: 0xd6, script: 0x55, flags: 0x0},
	1303: {region: 0x165, script: 0x55, flags: 0x0},
	1304: {region: 0x165, script: 0x55, flags: 0x0},
	1305: {region: 0x165, script: 0x55, flags: 0x0},
	1306: {region: 0x41, script: 0x55, flags: 0x0},
	1307: {region: 0x165, script: 0x55, flags: 0x0},
	1308: {region: 0xcf, script: 0x55, flags: 0x0},
	1309: {region: 0x4a, script: 0x3, flags: 0x1},
	1310: {region: 0x165, script: 0x55, flags: 0x0},
	1311: {region: 0x165, script: 0x55, flags: 0x0},
	1312: {region: 0x165, script: 0x55, flags: 0x0},
	1313: {region: 0x53, script: 0x55, flags: 0x0},
	1314: {region: 0x10b, script: 0x55, flags: 0x0},
	1316: {region: 0xa8, script: 0x5, flags: 0x0},
	1317: {region: 0xd9, script: 0x55, flags: 0x0},
	1318: {region: 0xba, script: 0xd8, flags: 0x0},
	1319: {region: 0x4d, script: 0x14, flags: 0x1},
	1320: {region: 0x165, script: 0x55, flags: 0x0},
	1321: {region: 0x122, script: 0x55, flags: 0x0},
	1322: {region: 0xd0, script: 0x55, flags: 0x0},
	1323: {region: 0x165, script: 0x55, flags: 0x0},
	1324: {region: 0x161, script: 0x55, flags: 0x0},
	1326: {region: 0x12b, script: 0x55, flags: 0x0},
}

// likelyLangList holds lists info associated with likelyLang.
// Size: 388 bytes, 97 elements
var likelyLangList = [97]likelyScriptRegion{
	0:  {region: 0x9c, script: 0x7, flags: 0x0},
	1:  {region: 0xa1, script: 0x72, flags: 0x2},
	2:  {region: 0x11c, script: 0x7d, flags: 0x2},
	3:  {region: 0x32, script: 0x55, flags: 0x0},
	4:  {region: 0x9b, script: 0x5, flags: 0x4},
	5:  {region: 0x9c, script: 0x5, flags: 0x4},
	6:  {region: 0x106, script: 0x1e, flags: 0x4},
	7:  {region: 0x9c, script: 0x5, flags: 0x2},
	8:  {region: 0x106, script: 0x1e, flags: 0x0},
	9:  {region: 0x38, script: 0x2b, flags: 0x2},
	10: {region: 0x135, script: 0x55, flags: 0x0},
	11: {region: 0x7b, script: 0xc2, flags: 0x2},
	12: {region: 0x114, script: 0x55, flags: 0x0},
	13: {region: 0x84, script: 0x1, flags: 0x2},
	14: {region: 0x5d, script: 0x1d, flags: 0x0},
	15: {region: 0x87, script: 0x5a, flags: 0x2},
	16: {region: 0xd6, script: 0x55, flags: 0x0},
	17: {region: 0x52, script: 0x5, flags: 0x4},
	18: {region: 0x10b, script: 0x5, flags: 0x4},
	19: {region: 0xae, script: 0x1e, flags: 0x0},
	20: {region: 0x24, script: 0x5, flags: 0x4},
	21: {region: 0x53, script: 0x5, flags: 0x4},
	22: {region: 0x9c, script: 0x5, flags: 0x4},
	23: {region: 0xc5, script: 0x5, flags: 0x4},
	24: {region: 0x53, script: 0x5, flags: 0x2},
	25: {region: 0x12b, script: 0x55, flags: 0x0},
	26: {region: 0xb0, script: 0x5, flags: 0x4},
	27: {region: 0x9b, script: 0x5, flags: 0x2},
	28: {region: 0xa5, script: 0x1e, flags: 0x0},
	29: {region: 0x53, script: 0x5, flags: 0x4},
	30: {region: 0x12b, script: 0x55, flags: 0x4},
	31: {region: 0x53, script: 0x5, flags: 0x2},
	32: {region: 0x12b, script: 0x55, flags: 0x2},
	33: {region: 0xdb, script: 0x20, flags: 0x0},
	34: {region: 0x99, script: 0x58, flags: 0x2},
	35: {region: 0x83, script: 0x55, flags: 0x0},
	36: {region: 0x84, script: 0x75, flags: 0x4},
	37: {region: 0x84, script: 0x75, flags: 0x2},
	38: {region: 0xc5, script: 0x1e, flags: 0x0},
	39: {region: 0x53, script: 0x6b, flags: 0x4},
	40: {region: 0x53, script: 0x6b, flags: 0x2},
	41: {region: 0xd0, script: 0x55, flags: 0x0},
	42: {region: 0x4a, script: 0x5, flags: 0x4},
	43: {region: 0x95, script: 0x5, flags: 0x4},
	44: {region: 0x99, script: 0x32, flags: 0x0},
	45: {region: 0xe8, script: 0x5, flags: 0x4},
	46: {region: 0xe8, script: 0x5, flags: 0x2},
	47: {region: 0x9c, script: 0x81, flags: 0x0},
	48: {region: 0x53, script: 0x82, flags: 0x2},
	49: {region: 0xba, script: 0xd8, flags: 0x0},
	50: {region: 0xd9, script: 0x55, flags: 0x4},
	51: {region: 0xe8, script: 0x5, flags: 0x0},
	52: {region: 0x99, script: 0x20, flags: 0x2},
	53: {region: 0x99, script: 0x4a, flags: 0x2},
	54: {region: 0x99, script: 0xc5, flags: 0x2},
	55: {region: 0x105, script: 0x1e, flags: 0x0},
	56: {region: 0xbd, script: 0x55, flags: 0x4},
	57: {region: 0x104, script: 0x55, flags: 0x4},
	58: {region: 0x106, script: 0x55, flags: 0x4},
	59: {region: 0x12b, script: 0x55, flags: 0x4},
	60: {region: 0x124, script: 0x1e, flags: 0x0},
	61: {region: 0xe8, script: 0x5, flags: 0x4},
	62: {region: 0xe8, script: 0x5, flags: 0x2},
	63: {region: 0x53, script: 0x5, flags: 0x0},
	64: {region: 0xae, script: 0x1e, flags: 0x4},
	65: {region: 0xc5, script: 0x1e, flags: 0x4},
	66: {region: 0xae, script: 0x1e, flags: 0x2},
	67: {region: 0x99, script: 0xe, flags: 0x0},
	68: {region: 0xdb, script: 0x20, flags: 0x4},
	69: {region: 0xdb, script: 0x20, flags: 0x2},
	70: {region: 0x137, script: 0x55, flags: 0x0},
	71: {region: 0x24, script: 0x5, flags: 0x4},
	72: {region: 0x53, script: 0x1e, flags: 0x4},
	73: {region: 0x24, script: 0x5, flags: 0x2},
	74: {region: 0x8d, script: 0x38, flags: 0x0},
	75: {region: 0x53, script: 0x37, flags: 0x4},
	76: {region: 0x53, script: 0x37, flags: 0x2},
	77: {region: 0x53, script: 0x37, flags: 0x0},
	78: {region: 0x2f, script: 0x38, flags: 0x4},
	79: {region: 0x3e, script: 0x38, flags: 0x4},
	80: {region: 0x7b, script: 0x38, flags: 0x4},
	81: {region: 0x7e, script: 0x38, flags: 0x4},
	82: {region: 0x8d, script: 0x38, flags: 0x4},
	83: {region: 0x95, script: 0x38, flags: 0x4},
	84: {region: 0xc6, script: 0x38, flags: 0x4},
	85: {region: 0xd0, script: 0x38, flags: 0x4},
	86: {region: 0xe2, script: 0x38, flags: 0x4},
	87: {region: 0xe5, script: 0x38, flags: 0x4},
	88: {region: 0xe7, script: 0x38, flags: 0x4},
	89: {region: 0x116, script: 0x38, flags: 0x4},
	90: {region: 0x123, script: 0x38, flags: 0x4},
	91: {region: 0x12e, script: 0x38, flags: 0x4},
	92: {region: 0x135, script: 0x38, flags: 0x4},
	93: {region: 0x13e, script: 0x38, flags: 0x4},
	94: {region: 0x12e, script: 0x11, flags: 0x2},
	95: {region: 0x12e, script: 0x33, flags: 0x2},
	96: {region: 0x12e, script: 0x38, flags: 0x2},
}

type likelyLangScript struct {
	lang   uint16
	script uint8
	flags  uint8
}

// likelyRegion is a lookup table, indexed by regionID, for the most likely
// languages and scripts given incomplete information. If more entries exist
// for a given regionID, lang and script are the index and size respectively
// of the list in likelyRegionList.
// TODO: exclude containers and user-definable regions from the list.
// Size: 1432 bytes, 358 elements
var likelyRegion = [358]likelyLangScript{
	34:  {lang: 0xd7, script: 0x55, flags: 0x0},
	35:  {lang: 0x3a, script: 0x5, flags: 0x0},
	36:  {lang: 0x0, script: 0x2, flags: 0x1},
	39:  {lang: 0x2, script: 0x2, flags: 0x1},
	40:  {lang: 0x4, script: 0x2, flags: 0x1},
	42:  {lang: 0x3be, script: 0x55, flags: 0x0},
	43:  {lang: 0x0, script: 0x55, flags: 0x0},
	44:  {lang: 0x13d, script: 0x55, flags: 0x0},
	45:  {lang: 0x419, script: 0x55, flags: 0x0},
	46:  {lang: 0x10c, script: 0x55, flags: 0x0},
	48:  {lang: 0x365, script: 0x55, flags: 0x0},
	49:  {lang: 0x442, script: 0x55, flags: 0x0},
	50:  {lang: 0x58, script: 0x55, flags: 0x0},
	51:  {lang: 0x6, script: 0x2, flags: 0x1},
	53:  {lang: 0xa5, script: 0xe, flags: 0x0},
	54:  {lang: 0x365, script: 0x55, flags: 0x0},
	55:  {lang: 0x15d, script: 0x55, flags: 0x0},
	56:  {lang: 0x7e, script: 0x1e, flags: 0x0},
	57:  {lang: 0x3a, script: 0x5, flags: 0x0},
	58:  {lang: 0x3d7, script: 0x55, flags: 0x0},
	59:  {lang: 0x15d, script: 0x55, flags: 0x0},
	60:  {lang: 0x15d, script: 0x55, flags: 0x0},
	62:  {lang: 0x31d, script: 0x55, flags: 0x0},
	63:  {lang: 0x13d, script: 0x55, flags: 0x0},
	64:  {lang: 0x39f, script: 0x55, flags: 0x0},
	65:  {lang: 0x3be, script: 0x55, flags: 0x0},
	67:  {lang: 0x8, script: 0x2, flags: 0x1},
	69:  {lang: 0x0, script: 0x55, flags: 0x0},
	71:  {lang: 0x71, script: 0x1e, flags: 0x0},
	73:  {lang: 0x510, script: 0x3a, flags: 0x2},
	74:  {lang: 0x31d, script: 0x5, flags: 0x2},
	75:  {lang: 0x443, script: 0x55, flags: 0x0},
	76:  {lang: 0x15d, script: 0x55, flags: 0x0},
	77:  {lang: 0x15d, script: 0x55, flags: 0x0},
	78:  {lang: 0x10c, script: 0x55, flags: 0x0},
	79:  {lang: 0x15d, script: 0x55, flags: 0x0},
	81:  {lang: 0x13d, script: 0x55, flags: 0x0},
	82:  {lang: 0x15d, script: 0x55, flags: 0x0},
	83:  {lang: 0xa, script: 0x5, flags: 0x1},
	84:  {lang: 0x13d, script: 0x55, flags: 0x0},
	85:  {lang: 0x0, script: 0x55, flags: 0x0},
	86:  {lang: 0x13d, script: 0x55, flags: 0x0},
	89:  {lang: 0x13d, script: 0x55, flags: 0x0},
	90:  {lang: 0x3be, script: 0x55, flags: 0x0},
	91:  {lang: 0x39f, script: 0x55, flags: 0x0},
	93:  {lang: 0xf, script: 0x2, flags: 0x1},
	94:  {lang: 0xf9, script: 0x55, flags: 0x0},
	96:  {lang: 0x10c, script: 0x55, flags: 0x0},
	98:  {lang: 0x1, script: 0x55, flags: 0x0},
	99:  {lang: 0x100, script: 0x55, flags: 0x0},
	101: {lang: 0x13d, script: 0x55, flags: 0x0},
	103: {lang: 0x11, script: 0x2, flags: 0x1},
	104: {lang: 0x13d, script: 0x55, flags: 0x0},
	105: {lang: 0x13d, script: 0x55, flags: 0x0},
	106: {lang: 0x13f, script: 0x55, flags: 0x0},
	107: {lang: 0x3a, script: 0x5, flags: 0x0},
	108: {lang: 0x3a, script: 0x5, flags: 0x0},
	109: {lang: 0x46d, script: 0x28, flags: 0x0},
	110: {lang: 0x13d, script: 0x55, flags: 0x0},
	111: {lang: 0x13, script: 0x2, flags: 0x1},
	113: {lang: 0x10c, script: 0x55, flags: 0x0},
	114: {lang: 0x150, script: 0x55, flags: 0x0},
	115: {lang: 0x1be, script: 0x20, flags: 0x2},
	118: {lang: 0x157, script: 0x55, flags: 0x0},
	120: {lang: 0x15d, script: 0x55, flags: 0x0},
	122: {lang: 0x15d, script: 0x55, flags: 0x0},
	123: {lang: 0x15, script: 0x2, flags: 0x1},
	125: {lang: 0x17, script: 0x3, flags: 0x1},
	126: {lang: 0x15d, script: 0x55, flags: 0x0},
	128: {lang: 0x21, script: 0x55, flags: 0x0},
	130: {lang: 0x243, script: 0x55, flags: 0x0},
	132: {lang: 0x15d, script: 0x55, flags: 0x0},
	133: {lang: 0x15d, script: 0x55, flags: 0x0},
	134: {lang: 0x13d, script: 0x55, flags: 0x0},
	135: {lang: 0x1a, script: 0x2, flags: 0x1},
	136: {lang: 0x0, script: 0x55, flags: 0x0},
	137: {lang: 0x13d, script: 0x55, flags: 0x0},
	139: {lang: 0x3be, script: 0x55, flags: 0x0},
	141: {lang: 0x527, script: 0x38, flags: 0x0},
	142: {lang: 0x0, script: 0x55, flags: 0x0},
	143: {lang: 0x13d, script: 0x55, flags: 0x0},
	144: {lang: 0x1cf, script: 0x55, flags: 0x0},
	145: {lang: 0x1d2, script: 0x55, flags: 0x0},
	146: {lang: 0x1d3, script: 0x55, flags: 0x0},
	148: {lang: 0x13d, script: 0x55, flags: 0x0},
	149: {lang: 0x1c, script: 0x2, flags: 0x1},
	151: {lang: 0x1ba, script: 0x3a, flags: 0x0},
	153: {lang: 0x1e, script: 0x3, flags: 0x1},
	155: {lang: 0x3a, script: 0x5, flags: 0x0},
	156: {lang: 0x21, script: 0x2, flags: 0x1},
	157: {lang: 0x1f6, script: 0x55, flags: 0x0},
	158: {lang: 0x1f7, script: 0x55, flags: 0x0},
	161: {lang: 0x3a, script: 0x5, flags: 0x0},
	162: {lang: 0x1fe, script: 0x44, flags: 0x0},
	164: {lang: 0x443, script: 0x55, flags: 0x0},
	165: {lang: 0x288, script: 0x1e, flags: 0x0},
	166: {lang: 0x23, script: 0x3, flags: 0x1},
	168: {lang: 0x26, script: 0x2, flags: 0x1},
	170: {lang: 0x252, script: 0x4e, flags: 0x0},
	171: {lang: 0x252, script: 0x4e, flags: 0x0},
	172: {lang: 0x3a, script: 0x5, flags: 0x0},
	174: {lang: 0x3e0, script: 0x1e, flags: 0x0},
	175: {lang: 0x28, script: 0x2, flags: 0x1},
	176: {lang: 0x3a, script: 0x5, flags: 0x0},
	178: {lang: 0x10c, script: 0x55, flags: 0x0},
	179: {lang: 0x40a, script: 0xc6, flags: 0x0},
	181: {lang: 0x439, script: 0x55, flags: 0x0},
	182: {lang: 0x2be, script: 0x55, flags: 0x0},
	183: {lang: 0x15d, script: 0x55, flags: 0x0},
	184: {lang: 0x2c5, script: 0x55, flags: 0x0},
	185: {lang: 0x3a, script: 0x5, flags: 0x0},
	186: {lang: 0x2a, script: 0x2, flags: 0x1},
	187: {lang: 0x15d, script: 0x55, flags: 0x0},
	188: {lang: 0x2c, script: 0x2, flags: 0x1},
	189: {lang: 0x430, script: 0x55, flags: 0x0},
	190: {lang: 0x15d, script: 0x55, flags: 0x0},
	191: {lang: 0x2ef, script: 0x55, flags: 0x0},
	194: {lang: 0x2e, script: 0x2, flags: 0x1},
	195: {lang: 0xa0, script: 0x55, flags: 0x0},
	196: {lang: 0x30, script: 0x2, flags: 0x1},
	197: {lang: 0x32, script: 0x2, flags: 0x1},
	198: {lang: 0x34, script: 0x2, flags: 0x1},
	200: {lang: 0x15d, script: 0x55, flags: 0x0},
	201: {lang: 0x36, script: 0x2, flags: 0x1},
	203: {lang: 0x31e, script: 0x55, flags: 0x0},
	204: {lang: 0x38, script: 0x3, flags: 0x1},
	205: {lang: 0x127, script: 0xda, flags: 0x0},
	207: {lang: 0x13d, script: 0x55, flags: 0x0},
	208: {lang: 0x31d, script: 0x55, flags: 0x0},
	209: {lang: 0x3be, script: 0x55, flags: 0x0},
	210: {lang: 0x16, script: 0x55, flags: 0x0},
	211: {lang: 0x15d, script: 0x55, flags: 0x0},
	212: {lang: 0x1b2, script: 0x55, flags: 0x0},
	214: {lang: 0x1b2, script: 0x5, flags: 0x2},
	216: {lang: 0x13d, script: 0x55, flags: 0x0},
	217: {lang: 0x365, script: 0x55, flags: 0x0},
	218: {lang: 0x345, script: 0x55, flags: 0x0},
	219: {lang: 0x34f, script: 0x20, flags: 0x0},
	225: {lang: 0x3a, script: 0x5, flags: 0x0},
	226: {lang: 0x13d, script: 0x55, flags: 0x0},
	228: {lang: 0x13d, script: 0x55, flags: 0x0},
	229: {lang: 0x15d, script: 0x55, flags: 0x0},
	230: {lang: 0x484, script: 0x55, flags: 0x0},
	231: {lang: 0x152, script: 0x55, flags: 0x0},
	232: {lang: 0x3b, script: 0x3, flags: 0x1},
	233: {lang: 0x3b1, script: 0x55, flags: 0x0},
	234: {lang: 0x15d, script: 0x55, flags: 0x0},
	236: {lang: 0x13d, script: 0x55, flags: 0x0},
	237: {lang: 0x3a, script: 0x5, flags: 0x0},
	238: {lang: 0x3be, script: 0x55, flags: 0x0},
	240: {lang: 0x3a0, script: 0x55, flags: 0x0},
	241: {lang: 0x192, script: 0x55, flags: 0x0},
	243: {lang: 0x3a, script: 0x5, flags: 0x0},
	258: {lang: 0x15d, script: 0x55, flags: 0x0},
	260: {lang: 0x3e, script: 0x2, flags: 0x1},
	261: {lang: 0x430, script: 0x1e, flags: 0x0},
	262: {lang: 0x40, script: 0x2, flags: 0x1},
	263: {lang: 0x3e3, script: 0x55, flags: 0x0},
	264: {lang: 0x3a, script: 0x5, flags: 0x0},
	266: {lang: 0x15d, script: 0x55, flags: 0x0},
	267: {lang: 0x3a, script: 0x5, flags: 0x0},
	268: {lang: 0x42, script: 0x2, flags: 0x1},
	271: {lang: 0x414, script: 0x55, flags: 0x0},
	272: {lang: 0x345, script: 0x55, flags: 0x0},
	273: {lang: 0x44, script: 0x2, flags: 0x1},
	275: {lang: 0x1f7, script: 0x55, flags: 0x0},
	276: {lang: 0x15d, script: 0x55, flags: 0x0},
	277: {lang: 0x427, script: 0x55, flags: 0x0},
	278: {lang: 0x365, script: 0x55, flags: 0x0},
	280: {lang: 0x3be, script: 0x55, flags: 0x0},
	282: {lang: 0x13d, script: 0x55, flags: 0x0},
	284: {lang: 0x46, script: 0x2, flags: 0x1},
	288: {lang: 0x15d, script: 0x55, flags: 0x0},
	289: {lang: 0x15d, script: 0x55, flags: 0x0},
	290: {lang: 0x48, script: 0x2, flags: 0x1},
	291: {lang: 0x4a, script: 0x3, flags: 0x1},
	292: {lang: 0x4d, script: 0x2, flags: 0x1},
	293: {lang: 0x475, script: 0x55, flags: 0x0},
	294: {lang: 0x3be, script: 0x55, flags: 0x0},
	295: {lang: 0x474, script: 0x55, flags: 0x0},
	296: {lang: 0x4f, script: 0x2, flags: 0x1},
	297: {lang: 0x480, script: 0x55, flags: 0x0},
	299: {lang: 0x51, script: 0x4, flags: 0x1},
	301: {lang: 0x49e, script: 0x55, flags: 0x0},
	302: {lang: 0x55, script: 0x2, flags: 0x1},
	303: {lang: 0x443, script: 0x55, flags: 0x0},
	304: {lang: 0x57, script: 0x3, flags: 0x1},
	305: {lang: 0x443, script: 0x55, flags: 0x0},
	309: {lang: 0x510, script: 0x3a, flags: 0x2},
	310: {lang: 0x13d, script: 0x55, flags: 0x0},
	311: {lang: 0x4ba, script: 0x55, flags: 0x0},
	312: {lang: 0x1f7, script: 0x55, flags: 0x0},
	315: {lang: 0x13d, script: 0x55, flags: 0x0},
	318: {lang: 0x4c1, script: 0x55, flags: 0x0},
	319: {lang: 0x8a, script: 0x55, flags: 0x0},
	320: {lang: 0x15d, script: 0x55, flags: 0x0},
	322: {lang: 0x419, script: 0x55, flags: 0x0},
	333: {lang: 0x5a, script: 0x2, flags: 0x1},
	350: {lang: 0x3a, script: 0x5, flags: 0x0},
	351: {lang: 0x5c, script: 0x2, flags: 0x1},
	356: {lang: 0x421, script: 0x55, flags: 0x0},
}

// likelyRegionList holds lists info associated with likelyRegion.
// Size: 376 bytes, 94 elements
var likelyRegionList = [94]likelyLangScript{
	0:  {lang: 0x147, script: 0x5, flags: 0x0},
	1:  {lang: 0x474, script: 0x55, flags: 0x0},
	2:  {lang: 0x42f, script: 0x55, flags: 0x0},
	3:  {lang: 0x2fd, script: 0x1e, flags: 0x0},
	4:  {lang: 0x1d5, script: 0x8, flags: 0x0},
	5:  {lang: 0x272, script: 0x55, flags: 0x0},
	6:  {lang: 0xb7, script: 0x55, flags: 0x0},
	7:  {lang: 0x430, script: 0x1e, flags: 0x0},
	8:  {lang: 0x12c, script: 0xdc, flags: 0x0},
	9:  {lang: 0x34f, script: 0x20, flags: 0x0},
	10: {lang: 0x527, script: 0x37, flags: 0x0},
	11: {lang: 0x4aa, script: 0x5, flags: 0x0},
	12: {lang: 0x51d, script: 0x38, flags: 0x0},
	13: {lang: 0x521, script: 0x55, flags: 0x0},
	14: {lang: 0x298, script: 0xdb, flags: 0x0},
	15: {lang: 0x135, script: 0x30, flags: 0x0},
	16: {lang: 0x488, script: 0x55, flags: 0x0},
	17: {lang: 0x3a, script: 0x5, flags: 0x0},
	18: {lang: 0x15d, script: 0x55, flags: 0x0},
	19: {lang: 0x27, script: 0x28, flags: 0x0},
	20: {lang: 0x138, script: 0x55, flags: 0x0},
	21: {lang: 0x268, script: 0x5, flags: 0x2},
	22: {lang: 0x510, script: 0x3a, flags: 0x2},
	23: {lang: 0x20e, script: 0x2a, flags: 0x0},
	24: {lang: 0x5, script: 0x1e, flags: 0x0},
	25: {lang: 0x272, script: 0x55, flags: 0x0},
	26: {lang: 0x135, script: 0x30, flags: 0x0},
	27: {lang: 0x2fd, script: 0x1e, flags: 0x0},
	28: {lang: 0x1df, script: 0x55, flags: 0x0},
	29: {lang: 0x31d, script: 0x5, flags: 0x0},
	30: {lang: 0x1bc, script: 0x20, flags: 0x0},
	31: {lang: 0x4b2, script: 0x5, flags: 0x0},
	32: {lang: 0x234, script: 0x70, flags: 0x0},
	33: {lang: 0x147, script: 0x5, flags: 0x0},
	34: {lang: 0x474, script: 0x55, flags: 0x0},
	35: {lang: 0x248, script: 0x49, flags: 0x0},
	36: {lang: 0xe6, script: 0x5, flags: 0x0},
	37: {lang: 0x224, script: 0xdb, flags: 0x0},
	38: {lang: 0x3a, script: 0x5, flags: 0x0},
	39: {lang: 0x15d, script: 0x55, flags: 0x0},
	40: {lang: 0x2b6, script: 0x52, flags: 0x0},
	41: {lang: 0x224, script: 0xdb, flags: 0x0},
	42: {lang: 0x3a, script: 0x5, flags: 0x0},
	43: {lang: 0x15d, script: 0x55, flags: 0x0},
	44: {lang: 0x3da, script: 0x55, flags: 0x0},
	45: {lang: 0x4ac, script: 0x1e, flags: 0x0},
	46: {lang: 0x2fd, script: 0x1e, flags: 0x0},
	47: {lang: 0x42f, script: 0x55, flags: 0x0},
	48: {lang: 0x32f, script: 0x70, flags: 0x0},
	49: {lang: 0x211, script: 0x55, flags: 0x0},
	50: {lang: 0x309, script: 0x1e, flags: 0x0},
	51: {lang: 0x240, script: 0x5, flags: 0x0},
	52: {lang: 0x527, script: 0x38, flags: 0x0},
	53: {lang: 0x3be, script: 0x55, flags: 0x0},
	54: {lang: 0x3a, script: 0x5, flags: 0x0},
	55: {lang: 0x15d, script: 0x55, flags: 0x0},
	56: {lang: 0x2eb, script: 0x55, flags: 0x0},
	57: {lang: 0x4b2, script: 0x5, flags: 0x0},
	58: {lang: 0x88, script: 0x20, flags: 0x0},
	59: {lang: 0x4b2, script: 0x5, flags: 0x0},
	60: {lang: 0x4b2, script: 0x5, flags: 0x0},
	61: {lang: 0xbe, script: 0x20, flags: 0x0},
	62: {lang: 0x3da, script: 0x55, flags: 0x0},
	63: {lang: 0x7e, script: 0x1e, flags: 0x0},
	64: {lang: 0x3e0, script: 0x1e, flags: 0x0},
	65: {lang: 0x265, script: 0x55, flags: 0x0},
	66: {lang: 0x442, script: 0x55, flags: 0x0},
	67: {lang: 0x510, script: 0x3a, flags: 0x0},
	68: {lang: 0x410, script: 0x55, flags: 0x0},
	69: {lang: 0x4ac, script: 0x1e, flags: 0x0},
	70: {lang: 0x3a, script: 0x5, flags: 0x0},
	71: {lang: 0x15d, script: 0x55, flags: 0x0},
	72: {lang: 0x15d, script: 0x55, flags: 0x0},
	73: {lang: 0x35, script: 0x5, flags: 0x0},
	74: {lang: 0x469, script: 0xdb, flags: 0x0},
	75: {lang: 0x2ea, script: 0x5, flags: 0x0},
	76: {lang: 0x30d, script: 0x70, flags: 0x0},
	77: {lang: 0x465, script: 0x1e, flags: 0x0},
	78: {lang: 0x147, script: 0x5, flags: 0x0},
	79: {lang: 0x3a, script: 0x5, flags: 0x0},
	80: {lang: 0x15d, script: 0x55, flags: 0x0},
	81: {lang: 0x488, script: 0x55, flags: 0x0},
	82: {lang: 0x58, script: 0x5, flags: 0x0},
	83: {lang: 0x217, script: 0x1e, flags: 0x0},
	84: {lang: 0x81, script: 0x30, flags: 0x0},
	85: {lang: 0x527, script: 0x38, flags: 0x0},
	86: {lang: 0x48a, script: 0x55, flags: 0x0},
	87: {lang: 0x4ac, script: 0x1e, flags: 0x0},
	88: {lang: 0x510, script: 0x3a, flags: 0x0},
	89: {lang: 0x3b1, script: 0x55, flags: 0x0},
	90: {lang: 0x42f, script: 0x55, flags: 0x0},
	91: {lang: 0x430, script: 0x1e, flags: 0x0},
	92: {lang: 0x15d, script: 0x55, flags: 0x0},
	93: {lang: 0x444, script: 0x5, flags: 0x0},
}

type likelyTag struct {
	lang   uint16
	region uint16
	script uint8
}

// Size: 198 bytes, 33 elements
var likelyRegionGroup = [33]likelyTag{
	1:  {lang: 0x138, region: 0xd6, script: 0x55},
	2:  {lang: 0x138, region: 0x135, script: 0x55},
	3:  {lang: 0x3be, region: 0x41, script: 0x55},
	4:  {lang: 0x138, region: 0x2f, script: 0x55},
	5:  {lang: 0x138, region: 0xd6, script: 0x55},
	6:  {lang: 0x13d, region: 0xcf, script: 0x55},
	7:  {lang: 0x443, region: 0x12f, script: 0x55},
	8:  {lang: 0x3a, region: 0x6b, script: 0x5},
	9:  {lang: 0x443, region: 0x4b, script: 0x55},
	10: {lang: 0x138, region: 0x161, script: 0x55},
	11: {lang: 0x138, region: 0x135, script: 0x55},
	12: {lang: 0x138, region: 0x135, script: 0x55},
	13: {lang: 0x13d, region: 0x59, script: 0x55},
	14: {lang: 0x527, region: 0x53, script: 0x37},
	15: {lang: 0x1bc, region: 0x99, script: 0x20},
	16: {lang: 0x1df, region: 0x95, script: 0x55},
	17: {lang: 0x1f7, region: 0x9e, script: 0x55},
	18: {lang: 0x138, region: 0x2f, script: 0x55},
	19: {lang: 0x138, region: 0xe6, script: 0x55},
	20: {lang: 0x138, region: 0x8a, script: 0x55},
	21: {lang: 0x419, region: 0x142, script: 0x55},
	22: {lang: 0x527, region: 0x53, script: 0x37},
	23: {lang: 0x4ba, region: 0x137, script: 0x55},
	24: {lang: 0x3a, region: 0x108, script: 0x5},
	25: {lang: 0x3e0, region: 0x106, script: 0x1e},
	26: {lang: 0x3e0, region: 0x106, script: 0x1e},
	27: {lang: 0x138, region: 0x7b, script: 0x55},
	28: {lang: 0x10c, region: 0x60, script: 0x55},
	30: {lang: 0x13d, region: 0x1f, script: 0x55},
	31: {lang: 0x138, region: 0x9a, script: 0x55},
	32: {lang: 0x138, region: 0x7b, script: 0x55},
}

// Size: 358 bytes, 358 elements
var regionToGroups = [358]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00,
	0x00, 0x04, 0x00, 0x00, 0x04, 0x01, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x04,
	// Entry 40 - 7F
	0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00,
	0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x04, 0x00, 0x08,
	0x00, 0x04, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00,
	// Entry 80 - BF
	0x00, 0x00, 0x04, 0x00, 0x00, 0x04, 0x00, 0x00,
	0x00, 0x04, 0x01, 0x00, 0x04, 0x02, 0x00, 0x04,
	0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00,
	0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x08, 0x08, 0x00, 0x00, 0x00, 0x04, 0x00,
	// Entry C0 - FF
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x01,
	0x04, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x04, 0x00, 0x05, 0x00, 0x00, 0x00,
	0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 100 - 13F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00,
	0x00, 0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x04,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x05, 0x04, 0x00,
	0x00, 0x04, 0x00, 0x04, 0x04, 0x05, 0x00, 0x00,
	// Entry 140 - 17F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
}

// Size: 18 bytes, 3 elements
var paradigmLocales = [3][3]uint16{
	0: [3]uint16{0x138, 0x0, 0x7b},
	1: [3]uint16{0x13d, 0x0, 0x1f},
	2: [3]uint16{0x3be, 0x41, 0xee},
}

type mutualIntelligibility struct {
	want     uint16
	have     uint16
	distance uint8
	oneway   bool
}

type scriptIntelligibility struct {
	wantLang   uint16
	haveLang   uint16
	wantScript uint8
	haveScript uint8
	distance   uint8
}

type regionIntelligibility struct {
	lang     uint16
	script   uint8
	group    uint8
	distance uint8
}

// matchLang holds pairs of langIDs of base languages that are typically
// mutually intelligible. Each pair is associated with a confidence and
// whether the intelligibility goes one or both ways.
// Size: 678 bytes, 113 elements
var matchLang = [113]mutualIntelligibility{
	0:   {want: 0x1cf, have: 0xb7, distance: 0x4, oneway: false},
	1:   {want: 0x405, have: 0xb7, distance: 0x4, oneway: false},
	2:   {want: 0x405, have: 0x1cf, distance: 0x4, oneway: false},
	3:   {want: 0x405, have: 0x430, distance: 0x4, oneway: false},
	4:   {want: 0x438, have: 0x1, distance: 0x4, oneway: false},
	5:   {want: 0x1a1, have: 0x10c, distance: 0x4, oneway: true},
	6:   {want: 0x293, have: 0x10c, distance: 0x4, oneway: true},
	7:   {want: 0x100, have: 0x36d, distance: 0x8, oneway: false},
	8:   {want: 0x100, have: 0x345, distance: 0x8, oneway: false},
	9:   {want: 0x5, have: 0x3e0, distance: 0xa, oneway: true},
	10:  {want: 0xd, have: 0x138, distance: 0xa, oneway: true},
	11:  {want: 0x16, have: 0x365, distance: 0xa, oneway: true},
	12:  {want: 0x21, have: 0x138, distance: 0xa, oneway: true},
	13:  {want: 0x56, have: 0x13d, distance: 0xa, oneway: true},
	14:  {want: 0x58, have: 0x3e0, distance: 0xa, oneway: true},
	15:  {want: 0x71, have: 0x3e0, distance: 0xa, oneway: true},
	16:  {want: 0x75, have: 0x138, distance: 0xa, oneway: true},
	17:  {want: 0x82, have: 0x1bc, distance: 0xa, oneway: true},
	18:  {want: 0xa5, have: 0x138, distance: 0xa, oneway: true},
	19:  {want: 0xb2, have: 0x15d, distance: 0xa, oneway: true},
	20:  {want: 0xdd, have: 0x152, distance: 0xa, oneway: true},
	21:  {want: 0xe5, have: 0x138, distance: 0xa, oneway: true},
	22:  {want: 0xe9, have: 0x3a, distance: 0xa, oneway: true},
	23:  {want: 0xef, have: 0x15d, distance: 0xa, oneway: true},
	24:  {want: 0xf8, have: 0x15d, distance: 0xa, oneway: true},
	25:  {want: 0xff, have: 0x138, distance: 0xa, oneway: true},
	26:  {want: 0x12f, have: 0x138, distance: 0xa, oneway: true},
	27:  {want: 0x13b, have: 0x138, distance: 0xa, oneway: true},
	28:  {want: 0x13f, have: 0x150, distance: 0xa, oneway: true},
	29:  {want: 0x144, have: 0x13d, distance: 0xa, oneway: true},
	30:  {want: 0x157, have: 0x100, distance: 0xa, oneway: true},
	31:  {want: 0x16c, have: 0x365, distance: 0xa, oneway: true},
	32:  {want: 0x16d, have: 0x138, distance: 0xa, oneway: true},
	33:  {want: 0x16e, have: 0x138, distance: 0xa, oneway: true},
	34:  {want: 0x17c, have: 0x138, distance: 0xa, oneway: true},
	35:  {want: 0x18e, have: 0x13d, distance: 0xa, oneway: true},
	36:  {want: 0x192, have: 0x13d, distance: 0xa, oneway: true},
	37:  {want: 0x1a2, have: 0x1bc, distance: 0xa, oneway: true},
	38:  {want: 0x1b2, have: 0x138, distance: 0xa, oneway: true},
	39:  {want: 0x1b6, have: 0x138, distance: 0xa, oneway: true},
	40:  {want: 0x1d2, have: 0x15d, distance: 0xa, oneway: true},
	41:  {want: 0x1d5, have: 0x3e0, distance: 0xa, oneway: true},
	42:  {want: 0x1d7, have: 0x138, distance: 0xa, oneway: true},
	43:  {want: 0x1e5, have: 0x138, distance: 0xa, oneway: true},
	44:  {want: 0x1f6, have: 0x138, distance: 0xa, oneway: true},
	45:  {want: 0x20c, have: 0x1df, distance: 0xa, oneway: true},
	46:  {want: 0x20e, have: 0x138, distance: 0xa, oneway: true},
	47:  {want: 0x22b, have: 0x15d, distance: 0xa, oneway: true},
	48:  {want: 0x240, have: 0x3e0, distance: 0xa, oneway: true},
	49:  {want: 0x248, have: 0x138, distance: 0xa, oneway: true},
	50:  {want: 0x24f, have: 0x138, distance: 0xa, oneway: true},
	51:  {want: 0x263, have: 0x138, distance: 0xa, oneway: true},
	52:  {want: 0x272, have: 0x488, distance: 0xa, oneway: true},
	53:  {want: 0x288, have: 0x3e0, distance: 0xa, oneway: true},
	54:  {want: 0x28c, have: 0x1f7, distance: 0xa, oneway: true},
	55:  {want: 0x2a1, have: 0x138, distance: 0xa, oneway: true},
	56:  {want: 0x2b3, have: 0x15d, distance: 0xa, oneway: true},
	57:  {want: 0x2b6, have: 0x138, distance: 0xa, oneway: true},
	58:  {want: 0x2bc, have: 0x138, distance: 0xa, oneway: true},
	59:  {want: 0x2c1, have: 0x15d, distance: 0xa, oneway: true},
	60:  {want: 0x2eb, have: 0x138, distance: 0xa, oneway: true},
	61:  {want: 0x2ef, have: 0x15d, distance: 0xa, oneway: true},
	62:  {want: 0x2f8, have: 0x138, distance: 0xa, oneway: true},
	63:  {want: 0x2fd, have: 0x7e, distance: 0xa, oneway: true},
	64:  {want: 0x302, have: 0x138, distance: 0xa, oneway: true},
	65:  {want: 0x309, have: 0x3e0, distance: 0xa, oneway: true},
	66:  {want: 0x319, have: 0x1bc, distance: 0xa, oneway: true},
	67:  {want: 0x31d, have: 0x1df, distance: 0xa, oneway: true},
	68:  {want: 0x31e, have: 0x138, distance: 0xa, oneway: true},
	69:  {want: 0x32f, have: 0x138, distance: 0xa, oneway: true},
	70:  {want: 0x34f, have: 0x138, distance: 0xa, oneway: true},
	71:  {want: 0x368, have: 0x345, distance: 0xa, oneway: false},
	72:  {want: 0x368, have: 0x36d, distance: 0xa, oneway: true},
	73:  {want: 0x378, have: 0x138, distance: 0xa, oneway: true},
	74:  {want: 0x385, have: 0x138, distance: 0xa, oneway: true},
	75:  {want: 0x387, have: 0x138, distance: 0xa, oneway: true},
	76:  {want: 0x389, have: 0x15d, distance: 0xa, oneway: true},
	77:  {want: 0x38e, have: 0x138, distance: 0xa, oneway: true},
	78:  {want: 0x393, have: 0x138, distance: 0xa, oneway: true},
	79:  {want: 0x39b, have: 0x138, distance: 0xa, oneway: true},
	80:  {want: 0x3a3, have: 0x138, distance: 0xa, oneway: true},
	81:  {want: 0x3bc, have: 0x138, distance: 0xa, oneway: true},
	82:  {want: 0x3c2, have: 0x13d, distance: 0xa, oneway: true},
	83:  {want: 0x3d2, have: 0x10c, distance: 0xa, oneway: true},
	84:  {want: 0x3d7, have: 0x138, distance: 0xa, oneway: true},
	85:  {want: 0x3e3, have: 0x15d, distance: 0xa, oneway: true},
	86:  {want: 0x3e7, have: 0x1bc, distance: 0xa, oneway: true},
	87:  {want: 0x3f8, have: 0x138, distance: 0xa, oneway: true},
	88:  {want: 0x40a, have: 0x138, distance: 0xa, oneway: true},
	89:  {want: 0x421, have: 0x138, distance: 0xa, oneway: true},
	90:  {want: 0x427, have: 0x138, distance: 0xa, oneway: true},
	91:  {want: 0x42f, have: 0x138, distance: 0xa, oneway: true},
	92:  {want: 0x439, have: 0x138, distance: 0xa, oneway: true},
	93:  {want: 0x43c, have: 0x1df, distance: 0xa, oneway: true},
	94:  {want: 0x443, have: 0x138, distance: 0xa, oneway: true},
	95:  {want: 0x44e, have: 0x138, distance: 0xa, oneway: true},
	96:  {want: 0x45f, have: 0x138, distance: 0xa, oneway: true},
	97:  {want: 0x465, have: 0x3e0, distance: 0xa, oneway: true},
	98:  {want: 0x46d, have: 0x138, distance: 0xa, oneway: true},
	99:  {want: 0x474, have: 0x3e0, distance: 0xa, oneway: true},
	100: {want: 0x3880, have: 0x138, distance: 0xa, oneway: true},
	101: {want: 0x47e, have: 0x138, distance: 0xa, oneway: true},
	102: {want: 0x480, have: 0x138, distance: 0xa, oneway: true},
	103: {want: 0x492, have: 0x3e0, distance: 0xa, oneway: true},
	104: {want: 0x49b, have: 0x138, distance: 0xa, oneway: true},
	105: {want: 0x4aa, have: 0x527, distance: 0xa, oneway: true},
	106: {want: 0x4b2, have: 0x138, distance: 0xa, oneway: true},
	107: {want: 0x4ba, have: 0x3e0, distance: 0xa, oneway: true},
	108: {want: 0x4e3, have: 0x15d, distance: 0xa, oneway: true},
	109: {want: 0x4f0, have: 0x138, distance: 0xa, oneway: true},
	110: {want: 0x510, have: 0x138, distance: 0xa, oneway: true},
	111: {want: 0x516, have: 0x138, distance: 0xa, oneway: true},
	112: {want: 0x52c, have: 0x138, distance: 0xa, oneway: true},
}

// matchScript holds pairs of scriptIDs where readers of one script
// can typically also read the other. Each is associated with a confidence.
// Size: 208 bytes, 26 elements
var matchScript = [26]scriptIntelligibility{
	0:  {wantLang: 0x430, haveLang: 0x430, wantScript: 0x55, haveScript: 0x1e, distance: 0x5},
	1:  {wantLang: 0x430, haveLang: 0x430, wantScript: 0x1e, haveScript: 0x55, distance: 0x5},
	2:  {wantLang: 0x58, haveLang: 0x3e0, wantScript: 0x55, haveScript: 0x1e, distance: 0xa},
	3:  {wantLang: 0xa5, haveLang: 0x138, wantScript: 0xe, haveScript: 0x55, distance: 0xa},
	4:  {wantLang: 0x1d5, haveLang: 0x3e0, wantScript: 0x8, haveScript: 0x1e, distance: 0xa},
	5:  {wantLang: 0x20e, haveLang: 0x138, wantScript: 0x2a, haveScript: 0x55, distance: 0xa},
	6:  {wantLang: 0x248, haveLang: 0x138, wantScript: 0x49, haveScript: 0x55, distance: 0xa},
	7:  {wantLang: 0x24f, haveLang: 0x138, wantScript: 0x4d, haveScript: 0x55, distance: 0xa},
	8:  {wantLang: 0x2b6, haveLang: 0x138, wantScript: 0x52, haveScript: 0x55, distance: 0xa},
	9:  {wantLang: 0x302, haveLang: 0x138, wantScript: 0x69, haveScript: 0x55, distance: 0xa},
	10: {wantLang: 0x32f, haveLang: 0x138, wantScript: 0x70, haveScript: 0x55, distance: 0xa},
	11: {wantLang: 0x34f, haveLang: 0x138, wantScript: 0x20, haveScript: 0x55, distance: 0xa},
	12: {wantLang: 0x393, haveLang: 0x138, wantScript: 0x7a, haveScript: 0x55, distance: 0xa},
	13: {wantLang: 0x39b, haveLang: 0x138, wantScript: 0x32, haveScript: 0x55, distance: 0xa},
	14: {wantLang: 0x3bc, haveLang: 0x138, wantScript: 0x5, haveScript: 0x55, distance: 0xa},
	15: {wantLang: 0x3f8, haveLang: 0x138, wantScript: 0x5, haveScript: 0x55, distance: 0xa},
	16: {wantLang: 0x40a, haveLang: 0x138, wantScript: 0xc6, haveScript: 0x55, distance: 0xa},
	17: {wantLang: 0x44e, haveLang: 0x138, wantScript: 0xd3, haveScript: 0x55, distance: 0xa},
	18: {wantLang: 0x45f, haveLang: 0x138, wantScript: 0xd6, haveScript: 0x55, distance: 0xa},
	19: {wantLang: 0x46d, haveLang: 0x138, wantScript: 0x28, haveScript: 0x55, distance: 0xa},
	20: {wantLang: 0x474, haveLang: 0x3e0, wantScript: 0x55, haveScript: 0x1e, distance: 0xa},
	21: {wantLang: 0x4b2, haveLang: 0x138, wantScript: 0x5, haveScript: 0x55, distance: 0xa},
	22: {wantLang: 0x4ba, haveLang: 0x3e0, wantScript: 0x55, haveScript: 0x1e, distance: 0xa},
	23: {wantLang: 0x510, haveLang: 0x138, wantScript: 0x3a, haveScript: 0x55, distance: 0xa},
	24: {wantLang: 0x527, haveLang: 0x527, wantScript: 0x37, haveScript: 0x38, distance: 0xf},
	25: {wantLang: 0x527, haveLang: 0x527, wantScript: 0x38, haveScript: 0x37, distance: 0x13},
}

// Size: 90 bytes, 15 elements
var matchRegion = [15]regionIntelligibility{
	0:  {lang: 0x3a, script: 0x0, group: 0x4, distance: 0x4},
	1:  {lang: 0x3a, script: 0x0, group: 0x84, distance: 0x4},
	2:  {lang: 0x138, script: 0x0, group: 0x1, distance: 0x4},
	3:  {lang: 0x138, script: 0x0, group: 0x81, distance: 0x4},
	4:  {lang: 0x13d, script: 0x0, group: 0x3, distance: 0x4},
	5:  {lang: 0x13d, script: 0x0, group: 0x83, distance: 0x4},
	6:  {lang: 0x3be, script: 0x0, group: 0x3, distance: 0x4},
	7:  {lang: 0x3be, script: 0x0, group: 0x83, distance: 0x4},
	8:  {lang: 0x527, script: 0x38, group: 0x2, distance: 0x4},
	9:  {lang: 0x527, script: 0x38, group: 0x82, distance: 0x4},
	10: {lang: 0x3a, script: 0x0, group: 0x80, distance: 0x5},
	11: {lang: 0x138, script: 0x0, group: 0x80, distance: 0x5},
	12: {lang: 0x13d, script: 0x0, group: 0x80, distance: 0x5},
	13: {lang: 0x3be, script: 0x0, group: 0x80, distance: 0x5},
	14: {lang: 0x527, script: 0x38, group: 0x80, distance: 0x5},
}

// Size: 264 bytes, 33 elements
var regionContainment = [33]uint64{
	// Entry 0 - 1F
	0x00000001dfffffff, 0x00000000000007a2, 0x0000000000003044, 0x0000000000000008,
	0x00000000803c0010, 0x0000000000000020, 0x0000000000000040, 0x0000000000000080,
	0x0000000000000100, 0x0000000000000200, 0x0000000000000400, 0x000000004000384c,
	0x0000000000001000, 0x0000000000002000, 0x0000000000004000, 0x0000000000008000,
	0x0000000000010000, 0x0000000000020000, 0x0000000000040000, 0x0000000000080000,
	0x0000000000100000, 0x0000000000200000, 0x0000000001c1c000, 0x0000000000800000,
	0x0000000001000000, 0x000000001e020000, 0x0000000004000000, 0x0000000008000000,
	0x0000000010000000, 0x0000000020000000, 0x0000000040002048, 0x0000000080000000,
	// Entry 20 - 3F
	0x0000000100000000,
}

// regionInclusion maps region identifiers to sets of regions in regionInclusionBits,
// where each set holds all groupings that are directly connected in a region
// containment graph.
// Size: 358 bytes, 358 elements
var regionInclusion = [358]uint8{
	// Entry 0 - 3F
	0x00, 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06,
	0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e,
	0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
	0x17, 0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e,
	0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x26, 0x23,
	0x24, 0x26, 0x27, 0x22, 0x28, 0x29, 0x2a, 0x2b,
	0x26, 0x2c, 0x24, 0x23, 0x26, 0x25, 0x2a, 0x2d,
	0x2e, 0x24, 0x2f, 0x2d, 0x26, 0x30, 0x31, 0x28,
	// Entry 40 - 7F
	0x26, 0x28, 0x26, 0x25, 0x31, 0x22, 0x32, 0x33,
	0x34, 0x30, 0x22, 0x27, 0x27, 0x27, 0x35, 0x2d,
	0x29, 0x28, 0x27, 0x36, 0x28, 0x22, 0x34, 0x23,
	0x21, 0x26, 0x2d, 0x26, 0x22, 0x37, 0x2e, 0x35,
	0x2a, 0x22, 0x2f, 0x38, 0x26, 0x26, 0x21, 0x39,
	0x39, 0x28, 0x38, 0x39, 0x39, 0x2f, 0x3a, 0x2f,
	0x20, 0x21, 0x38, 0x3b, 0x28, 0x3c, 0x2c, 0x21,
	0x2a, 0x35, 0x27, 0x38, 0x26, 0x24, 0x28, 0x2c,
	// Entry 80 - BF
	0x2d, 0x23, 0x30, 0x2d, 0x2d, 0x26, 0x27, 0x3a,
	0x22, 0x34, 0x3c, 0x2d, 0x28, 0x36, 0x22, 0x34,
	0x3a, 0x26, 0x2e, 0x21, 0x39, 0x31, 0x38, 0x24,
	0x2c, 0x25, 0x22, 0x24, 0x25, 0x2c, 0x3a, 0x2c,
	0x26, 0x24, 0x36, 0x21, 0x2f, 0x3d, 0x31, 0x3c,
	0x2f, 0x26, 0x36, 0x36, 0x24, 0x26, 0x3d, 0x31,
	0x24, 0x26, 0x35, 0x25, 0x2d, 0x32, 0x38, 0x2a,
	0x38, 0x39, 0x39, 0x35, 0x33, 0x23, 0x26, 0x2f,
	// Entry C0 - FF
	0x3c, 0x21, 0x23, 0x2d, 0x31, 0x36, 0x36, 0x3c,
	0x26, 0x2d, 0x26, 0x3a, 0x2f, 0x25, 0x2f, 0x34,
	0x31, 0x2f, 0x32, 0x3b, 0x2d, 0x2b, 0x2d, 0x21,
	0x34, 0x2a, 0x2c, 0x25, 0x21, 0x3c, 0x24, 0x29,
	0x2b, 0x24, 0x34, 0x21, 0x28, 0x29, 0x3b, 0x31,
	0x25, 0x2e, 0x30, 0x29, 0x26, 0x24, 0x3a, 0x21,
	0x3c, 0x28, 0x21, 0x24, 0x21, 0x21, 0x1f, 0x21,
	0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
	// Entry 100 - 13F
	0x21, 0x21, 0x2f, 0x21, 0x2e, 0x23, 0x33, 0x2f,
	0x24, 0x3b, 0x2f, 0x39, 0x38, 0x31, 0x2d, 0x3a,
	0x2c, 0x2e, 0x2d, 0x23, 0x2d, 0x2f, 0x28, 0x2f,
	0x27, 0x33, 0x34, 0x26, 0x24, 0x32, 0x22, 0x26,
	0x27, 0x22, 0x2d, 0x31, 0x3d, 0x29, 0x31, 0x3d,
	0x39, 0x29, 0x31, 0x24, 0x26, 0x29, 0x36, 0x2f,
	0x33, 0x2f, 0x21, 0x22, 0x21, 0x30, 0x28, 0x3d,
	0x23, 0x26, 0x21, 0x28, 0x26, 0x26, 0x31, 0x3b,
	// Entry 140 - 17F
	0x29, 0x21, 0x29, 0x21, 0x21, 0x21, 0x21, 0x21,
	0x21, 0x21, 0x21, 0x21, 0x21, 0x23, 0x21, 0x21,
	0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
	0x21, 0x21, 0x21, 0x21, 0x21, 0x24, 0x24, 0x2f,
	0x23, 0x32, 0x2f, 0x27, 0x2f, 0x21,
}

// regionInclusionBits is an array of bit vectors where every vector represents
// a set of region groupings.  These sets are used to compute the distance
// between two regions for the purpose of language matching.
// Size: 584 bytes, 73 elements
var regionInclusionBits = [73]uint64{
	// Entry 0 - 1F
	0x0000000102400813, 0x00000000000007a3, 0x0000000000003844, 0x0000000040000808,
	0x00000000803c0011, 0x0000000000000022, 0x0000000040000844, 0x0000000000000082,
	0x0000000000000102, 0x0000000000000202, 0x0000000000000402, 0x000000004000384d,
	0x0000000000001804, 0x0000000040002804, 0x0000000000404000, 0x0000000000408000,
	0x0000000000410000, 0x0000000002020000, 0x0000000000040010, 0x0000000000080010,
	0x0000000000100010, 0x0000000000200010, 0x0000000001c1c001, 0x0000000000c00000,
	0x0000000001400000, 0x000000001e020001, 0x0000000006000000, 0x000000000a000000,
	0x0000000012000000, 0x0000000020000000, 0x0000000040002848, 0x0000000080000010,
	// Entry 20 - 3F
	0x0000000100000001, 0x0000000000000001, 0x0000000080000000, 0x0000000000020000,
	0x0000000001000000, 0x0000000000008000, 0x0000000000002000, 0x0000000000000200,
	0x0000000000000008, 0x0000000000200000, 0x0000000110000000, 0x0000000000040000,
	0x0000000008000000, 0x0000000000000020, 0x0000000104000000, 0x0000000000000080,
	0x0000000000001000, 0x0000000000010000, 0x0000000000000400, 0x0000000004000000,
	0x0000000000000040, 0x0000000010000000, 0x0000000000004000, 0x0000000101000000,
	0x0000000108000000, 0x0000000000000100, 0x0000000100020000, 0x0000000000080000,
	0x0000000000100000, 0x0000000000800000, 0x00000001dfffffff, 0x0000000102400fb3,
	// Entry 40 - 5F
	0x00000001827c0813, 0x000000014240385f, 0x0000000103c1c813, 0x000000011e420813,
	0x0000000112000001, 0x0000000106000001, 0x0000000101400001, 0x000000010a000001,
	0x0000000102020001,
}

// regionInclusionNext marks, for each entry in regionInclusionBits, the set of
// all groups that are reachable from the groups set in the respective entry.
// Size: 73 bytes, 73 elements
var regionInclusionNext = [73]uint8{
	// Entry 0 - 3F
	0x3e, 0x3f, 0x0b, 0x0b, 0x40, 0x01, 0x0b, 0x01,
	0x01, 0x01, 0x01, 0x41, 0x0b, 0x0b, 0x16, 0x16,
	0x16, 0x19, 0x04, 0x04, 0x04, 0x04, 0x42, 0x16,
	0x16, 0x43, 0x19, 0x19, 0x19, 0x1d, 0x0b, 0x04,
	0x00, 0x00, 0x1f, 0x11, 0x18, 0x0f, 0x0d, 0x09,
	0x03, 0x15, 0x44, 0x12, 0x1b, 0x05, 0x45, 0x07,
	0x0c, 0x10, 0x0a, 0x1a, 0x06, 0x1c, 0x0e, 0x46,
	0x47, 0x08, 0x48, 0x13, 0x14, 0x17, 0x3e, 0x3e,
	// Entry 40 - 7F
	0x3e, 0x3e, 0x3e, 0x3e, 0x43, 0x43, 0x42, 0x43,
	0x43,
}

type parentRel struct {
	lang       uint16
	script     uint8
	maxScript  uint8
	toRegion   uint16
	fromRegion []uint16
}

// Size: 414 bytes, 5 elements
var parents = [5]parentRel{
	0: {lang: 0x138, script: 0x0, maxScript: 0x55, toRegion: 0x1, fromRegion: []uint16{0x1a, 0x25, 0x26, 0x2f, 0x34, 0x36, 0x3d, 0x42, 0x46, 0x48, 0x49, 0x4a, 0x50, 0x52, 0x5c, 0x5d, 0x61, 0x64, 0x6d, 0x73, 0x74, 0x75, 0x7b, 0x7c, 0x7f, 0x80, 0x81, 0x83, 0x8c, 0x8d, 0x96, 0x97, 0x98, 0x99, 0x9a, 0x9f, 0xa0, 0xa4, 0xa7, 0xa9, 0xad, 0xb1, 0xb4, 0xb5, 0xbf, 0xc6, 0xca, 0xcb, 0xcc, 0xce, 0xd0, 0xd2, 0xd5, 0xd6, 0xdd, 0xdf, 0xe0, 0xe6, 0xe7, 0xe8, 0xeb, 0xf0, 0x107, 0x109, 0x10a, 0x10b, 0x10d, 0x10e, 0x112, 0x117, 0x11b, 0x11d, 0x11f, 0x125, 0x129, 0x12c, 0x12d, 0x12f, 0x131, 0x139, 0x13c, 0x13f, 0x142, 0x161, 0x162, 0x164}},
	1: {lang: 0x138, script: 0x0, maxScript: 0x55, toRegion: 0x1a, fromRegion: []uint16{0x2e, 0x4e, 0x60, 0x63, 0x72, 0xd9, 0x10c, 0x10f}},
	2: {lang: 0x13d, script: 0x0, maxScript: 0x55, toRegion: 0x1f, fromRegion: []uint16{0x2c, 0x3f, 0x41, 0x48, 0x51, 0x54, 0x56, 0x59, 0x65, 0x69, 0x89, 0x8f, 0xcf, 0xd8, 0xe2, 0xe4, 0xec, 0xf1, 0x11a, 0x135, 0x136, 0x13b}},
	3: {lang: 0x3be, script: 0x0, maxScript: 0x55, toRegion: 0xee, fromRegion: []uint16{0x2a, 0x4e, 0x5a, 0x86, 0x8b, 0xb7, 0xc6, 0xd1, 0x118, 0x126}},
	4: {lang: 0x527, script: 0x38, maxScript: 0x38, toRegion: 0x8d, fromRegion: []uint16{0xc6}},
}

// Total table size 27175 bytes (26KiB); checksum: 569649CD
