package main

import (
	"code.justin.tv/feeds/verify-migration/cmd"
	"fmt"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"log"
)

func main() {
	audreyIDs := cmd.ReadIDs("audrey_comments.txt")
	cmd.Randomize(audreyIDs)

	sess, err := session.NewSession(&aws.Config{
		Region: aws.String("us-west-2"),
	})
	if err != nil {
		log.Panicln("Could open AWS session", err)
	}
	svc := dynamodb.New(sess)
	for i, audreyID := range audreyIDs {
		input := &dynamodb.QueryInput{
			TableName:              aws.String("duplo_production_comment"),
			IndexName:              aws.String("audrey_id-index"),
			KeyConditionExpression: aws.String("audrey_id = :audrey_id"),
			ExpressionAttributeValues: map[string]*dynamodb.AttributeValue{
				":audrey_id": {S: &audreyID},
			},
		}
		output, err := svc.Query(input)
		if err != nil {
			log.Println("Comment ", audreyID, " has error ", err)
		} else if len(output.Items) != 1 {
			log.Println("Comment ", audreyID, " has items: ", len(output.Items))
		}
		if i%1000 == 0 {
			fmt.Println(i, " ids checked")
		}
	}
}
