package cmd

import (
	"bufio"
	"encoding/json"
	"fmt"
	"log"
	"math/rand"
	"os"
	"strings"
)

func Randomize(ids []string) {
	l := len(ids)
	for i := 0; i < l; i++ {
		j := rand.Intn(l)
		ids[i], ids[j] = ids[j], ids[i]
	}
}

func ReadIDs(filename string) []string {
	var ids []string
	file, err := os.Open(filename)
	if err != nil {
		log.Fatal("Could not open file", err)
	}
	defer file.Close()

	scanner := bufio.NewScanner(file)
	for scanner.Scan() {
		id := strings.TrimSpace(scanner.Text())
		if id != "" {
			ids = append(ids, id)
		}
	}
	return ids
}

type Message struct {
	Message  string
	Expected string
	Actual   string
}

func Test(failed bool, header string, test func(interface{}, ...interface{}) string, actual interface{}, expected ...interface{}) bool {
	if failed {
		return failed
	}
	if result := test(actual, expected...); result != "" {
		var msg Message
		json.NewDecoder(strings.NewReader(result)).Decode(&msg)
		fmt.Printf("%s failed\n\tExpect: [%s]\n\tActual:[%s]\n", header, msg.Expected, msg.Actual)
		return true
	}
	return false
}
