package ctxloggoji

import (
	"code.justin.tv/feeds/ctxlog"
	"goji.io"
	"code.justin.tv/feeds/log"
)

// GojiMiddleware is usable by goji.UseC.  Will log the request as well as inject the needed headers
func GojiMiddleware(elevateKey interface{}, Ctxlog *ctxlog.Ctxlog, elevatedLog *log.ElevatedLog) func(h goji.Handler) goji.Handler {
	return func(h goji.Handler) goji.Handler {
		eh := &ctxlog.ElevatedLogHTTPHandler{
			NextC: h,
			ElevateLog: elevatedLog,
		}
		return &ctxlog.CtxHandler{
			NextC:  eh,
			Ctxlog: Ctxlog,
		}
	}
}
