// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package autoscaling provides a client for Auto Scaling.
package autoscaling

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

const opAttachInstances = "AttachInstances"

// AttachInstancesRequest generates a "aws/request.Request" representing the
// client's request for the AttachInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachInstancesRequest method.
//    req, resp := client.AttachInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) AttachInstancesRequest(input *AttachInstancesInput) (req *request.Request, output *AttachInstancesOutput) {
	op := &request.Operation{
		Name:       opAttachInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &AttachInstancesOutput{}
	req.Data = output
	return
}

// AttachInstances API operation for Auto Scaling.
//
// Attaches one or more EC2 instances to the specified Auto Scaling group.
//
// When you attach instances, Auto Scaling increases the desired capacity of
// the group by the number of instances being attached. If the number of instances
// being attached plus the desired capacity of the group exceeds the maximum
// size of the group, the operation fails.
//
// If there is a Classic load balancer attached to your Auto Scaling group,
// the instances are also registered with the load balancer. If there are target
// groups attached to your Auto Scaling group, the instances are also registered
// with the target groups.
//
// For more information, see Attach EC2 Instances to Your Auto Scaling Group
// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/attach-instance-asg.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation AttachInstances for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) AttachInstances(input *AttachInstancesInput) (*AttachInstancesOutput, error) {
	req, out := c.AttachInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opAttachLoadBalancerTargetGroups = "AttachLoadBalancerTargetGroups"

// AttachLoadBalancerTargetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the AttachLoadBalancerTargetGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachLoadBalancerTargetGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachLoadBalancerTargetGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachLoadBalancerTargetGroupsRequest method.
//    req, resp := client.AttachLoadBalancerTargetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) AttachLoadBalancerTargetGroupsRequest(input *AttachLoadBalancerTargetGroupsInput) (req *request.Request, output *AttachLoadBalancerTargetGroupsOutput) {
	op := &request.Operation{
		Name:       opAttachLoadBalancerTargetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachLoadBalancerTargetGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AttachLoadBalancerTargetGroupsOutput{}
	req.Data = output
	return
}

// AttachLoadBalancerTargetGroups API operation for Auto Scaling.
//
// Attaches one or more target groups to the specified Auto Scaling group.
//
// To describe the target groups for an Auto Scaling group, use DescribeLoadBalancerTargetGroups.
// To detach the target group from the Auto Scaling group, use DetachLoadBalancerTargetGroups.
//
// For more information, see Attach a Load Balancer to Your Auto Scaling Group
// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/attach-load-balancer-asg.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation AttachLoadBalancerTargetGroups for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) AttachLoadBalancerTargetGroups(input *AttachLoadBalancerTargetGroupsInput) (*AttachLoadBalancerTargetGroupsOutput, error) {
	req, out := c.AttachLoadBalancerTargetGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opAttachLoadBalancers = "AttachLoadBalancers"

// AttachLoadBalancersRequest generates a "aws/request.Request" representing the
// client's request for the AttachLoadBalancers operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AttachLoadBalancers for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AttachLoadBalancers method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AttachLoadBalancersRequest method.
//    req, resp := client.AttachLoadBalancersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) AttachLoadBalancersRequest(input *AttachLoadBalancersInput) (req *request.Request, output *AttachLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opAttachLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachLoadBalancersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AttachLoadBalancersOutput{}
	req.Data = output
	return
}

// AttachLoadBalancers API operation for Auto Scaling.
//
// Attaches one or more Classic load balancers to the specified Auto Scaling
// group.
//
// To attach an Application load balancer instead, see AttachLoadBalancerTargetGroups.
//
// To describe the load balancers for an Auto Scaling group, use DescribeLoadBalancers.
// To detach the load balancer from the Auto Scaling group, use DetachLoadBalancers.
//
// For more information, see Attach a Load Balancer to Your Auto Scaling Group
// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/attach-load-balancer-asg.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation AttachLoadBalancers for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) AttachLoadBalancers(input *AttachLoadBalancersInput) (*AttachLoadBalancersOutput, error) {
	req, out := c.AttachLoadBalancersRequest(input)
	err := req.Send()
	return out, err
}

const opCompleteLifecycleAction = "CompleteLifecycleAction"

// CompleteLifecycleActionRequest generates a "aws/request.Request" representing the
// client's request for the CompleteLifecycleAction operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CompleteLifecycleAction for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CompleteLifecycleAction method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CompleteLifecycleActionRequest method.
//    req, resp := client.CompleteLifecycleActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) CompleteLifecycleActionRequest(input *CompleteLifecycleActionInput) (req *request.Request, output *CompleteLifecycleActionOutput) {
	op := &request.Operation{
		Name:       opCompleteLifecycleAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CompleteLifecycleActionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CompleteLifecycleActionOutput{}
	req.Data = output
	return
}

// CompleteLifecycleAction API operation for Auto Scaling.
//
// Completes the lifecycle action for the specified token or instance with the
// specified result.
//
// This step is a part of the procedure for adding a lifecycle hook to an Auto
// Scaling group:
//
//   (Optional) Create a Lambda function and a rule that allows CloudWatch
// Events to invoke your Lambda function when Auto Scaling launches or terminates
// instances.
//
//   (Optional) Create a notification target and an IAM role. The target can
// be either an Amazon SQS queue or an Amazon SNS topic. The role allows Auto
// Scaling to publish lifecycle notifications to the target.
//
//   Create the lifecycle hook. Specify whether the hook is used when the instances
// launch or terminate.
//
//   If you need more time, record the lifecycle action heartbeat to keep the
// instance in a pending state.
//
//    If you finish before the timeout period ends, complete the lifecycle
// action.
//
//   For more information, see Auto Scaling Lifecycle (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroupLifecycle.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation CompleteLifecycleAction for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) CompleteLifecycleAction(input *CompleteLifecycleActionInput) (*CompleteLifecycleActionOutput, error) {
	req, out := c.CompleteLifecycleActionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAutoScalingGroup = "CreateAutoScalingGroup"

// CreateAutoScalingGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateAutoScalingGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateAutoScalingGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateAutoScalingGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateAutoScalingGroupRequest method.
//    req, resp := client.CreateAutoScalingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) CreateAutoScalingGroupRequest(input *CreateAutoScalingGroupInput) (req *request.Request, output *CreateAutoScalingGroupOutput) {
	op := &request.Operation{
		Name:       opCreateAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAutoScalingGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &CreateAutoScalingGroupOutput{}
	req.Data = output
	return
}

// CreateAutoScalingGroup API operation for Auto Scaling.
//
// Creates an Auto Scaling group with the specified name and attributes.
//
// If you exceed your maximum limit of Auto Scaling groups, which by default
// is 20 per region, the call fails. For information about viewing and updating
// this limit, see DescribeAccountLimits.
//
// For more information, see Auto Scaling Groups (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroup.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation CreateAutoScalingGroup for usage and error information.
//
// Returned Error Codes:
//   * AlreadyExists
//   You already have an Auto Scaling group or launch configuration with this
//   name.
//
//   * LimitExceeded
//   You have already reached a limit for your Auto Scaling resources (for example,
//   groups, launch configurations, or lifecycle hooks). For more information,
//   see DescribeAccountLimits.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) CreateAutoScalingGroup(input *CreateAutoScalingGroupInput) (*CreateAutoScalingGroupOutput, error) {
	req, out := c.CreateAutoScalingGroupRequest(input)
	err := req.Send()
	return out, err
}

const opCreateLaunchConfiguration = "CreateLaunchConfiguration"

// CreateLaunchConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateLaunchConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateLaunchConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateLaunchConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateLaunchConfigurationRequest method.
//    req, resp := client.CreateLaunchConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) CreateLaunchConfigurationRequest(input *CreateLaunchConfigurationInput) (req *request.Request, output *CreateLaunchConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLaunchConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &CreateLaunchConfigurationOutput{}
	req.Data = output
	return
}

// CreateLaunchConfiguration API operation for Auto Scaling.
//
// Creates a launch configuration.
//
// If you exceed your maximum limit of launch configurations, which by default
// is 100 per region, the call fails. For information about viewing and updating
// this limit, see DescribeAccountLimits.
//
// For more information, see Launch Configurations (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/LaunchConfiguration.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation CreateLaunchConfiguration for usage and error information.
//
// Returned Error Codes:
//   * AlreadyExists
//   You already have an Auto Scaling group or launch configuration with this
//   name.
//
//   * LimitExceeded
//   You have already reached a limit for your Auto Scaling resources (for example,
//   groups, launch configurations, or lifecycle hooks). For more information,
//   see DescribeAccountLimits.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) CreateLaunchConfiguration(input *CreateLaunchConfigurationInput) (*CreateLaunchConfigurationOutput, error) {
	req, out := c.CreateLaunchConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opCreateOrUpdateTags = "CreateOrUpdateTags"

// CreateOrUpdateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateOrUpdateTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateOrUpdateTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateOrUpdateTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateOrUpdateTagsRequest method.
//    req, resp := client.CreateOrUpdateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) CreateOrUpdateTagsRequest(input *CreateOrUpdateTagsInput) (req *request.Request, output *CreateOrUpdateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateOrUpdateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateOrUpdateTagsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &CreateOrUpdateTagsOutput{}
	req.Data = output
	return
}

// CreateOrUpdateTags API operation for Auto Scaling.
//
// Creates or updates tags for the specified Auto Scaling group.
//
// When you specify a tag with a key that already exists, the operation overwrites
// the previous tag definition, and you do not get an error message.
//
// For more information, see Tagging Auto Scaling Groups and Instances (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/ASTagging.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation CreateOrUpdateTags for usage and error information.
//
// Returned Error Codes:
//   * LimitExceeded
//   You have already reached a limit for your Auto Scaling resources (for example,
//   groups, launch configurations, or lifecycle hooks). For more information,
//   see DescribeAccountLimits.
//
//   * AlreadyExists
//   You already have an Auto Scaling group or launch configuration with this
//   name.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) CreateOrUpdateTags(input *CreateOrUpdateTagsInput) (*CreateOrUpdateTagsOutput, error) {
	req, out := c.CreateOrUpdateTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAutoScalingGroup = "DeleteAutoScalingGroup"

// DeleteAutoScalingGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAutoScalingGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteAutoScalingGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteAutoScalingGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteAutoScalingGroupRequest method.
//    req, resp := client.DeleteAutoScalingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DeleteAutoScalingGroupRequest(input *DeleteAutoScalingGroupInput) (req *request.Request, output *DeleteAutoScalingGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAutoScalingGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteAutoScalingGroupOutput{}
	req.Data = output
	return
}

// DeleteAutoScalingGroup API operation for Auto Scaling.
//
// Deletes the specified Auto Scaling group.
//
// If the group has instances or scaling activities in progress, you must specify
// the option to force the deletion in order for it to succeed.
//
// If the group has policies, deleting the group deletes the policies, the
// underlying alarm actions, and any alarm that no longer has an associated
// action.
//
// To remove instances from the Auto Scaling group before deleting it, call
// DetachInstances with the list of instances and the option to decrement the
// desired capacity so that Auto Scaling does not launch replacement instances.
//
// To terminate all instances before deleting the Auto Scaling group, call
// UpdateAutoScalingGroup and set the minimum size and desired capacity of the
// Auto Scaling group to zero.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeleteAutoScalingGroup for usage and error information.
//
// Returned Error Codes:
//   * ScalingActivityInProgress
//   The operation can't be performed because there are scaling activities in
//   progress.
//
//   * ResourceInUse
//   The operation can't be performed because the resource is in use.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DeleteAutoScalingGroup(input *DeleteAutoScalingGroupInput) (*DeleteAutoScalingGroupOutput, error) {
	req, out := c.DeleteAutoScalingGroupRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteLaunchConfiguration = "DeleteLaunchConfiguration"

// DeleteLaunchConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLaunchConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteLaunchConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteLaunchConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteLaunchConfigurationRequest method.
//    req, resp := client.DeleteLaunchConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DeleteLaunchConfigurationRequest(input *DeleteLaunchConfigurationInput) (req *request.Request, output *DeleteLaunchConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLaunchConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteLaunchConfigurationOutput{}
	req.Data = output
	return
}

// DeleteLaunchConfiguration API operation for Auto Scaling.
//
// Deletes the specified launch configuration.
//
// The launch configuration must not be attached to an Auto Scaling group.
// When this call completes, the launch configuration is no longer available
// for use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeleteLaunchConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ResourceInUse
//   The operation can't be performed because the resource is in use.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DeleteLaunchConfiguration(input *DeleteLaunchConfigurationInput) (*DeleteLaunchConfigurationOutput, error) {
	req, out := c.DeleteLaunchConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteLifecycleHook = "DeleteLifecycleHook"

// DeleteLifecycleHookRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLifecycleHook operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteLifecycleHook for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteLifecycleHook method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteLifecycleHookRequest method.
//    req, resp := client.DeleteLifecycleHookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DeleteLifecycleHookRequest(input *DeleteLifecycleHookInput) (req *request.Request, output *DeleteLifecycleHookOutput) {
	op := &request.Operation{
		Name:       opDeleteLifecycleHook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLifecycleHookInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteLifecycleHookOutput{}
	req.Data = output
	return
}

// DeleteLifecycleHook API operation for Auto Scaling.
//
// Deletes the specified lifecycle hook.
//
// If there are any outstanding lifecycle actions, they are completed first
// (ABANDON for launching instances, CONTINUE for terminating instances).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeleteLifecycleHook for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DeleteLifecycleHook(input *DeleteLifecycleHookInput) (*DeleteLifecycleHookOutput, error) {
	req, out := c.DeleteLifecycleHookRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteNotificationConfiguration = "DeleteNotificationConfiguration"

// DeleteNotificationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNotificationConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteNotificationConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteNotificationConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteNotificationConfigurationRequest method.
//    req, resp := client.DeleteNotificationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DeleteNotificationConfigurationRequest(input *DeleteNotificationConfigurationInput) (req *request.Request, output *DeleteNotificationConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteNotificationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNotificationConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteNotificationConfigurationOutput{}
	req.Data = output
	return
}

// DeleteNotificationConfiguration API operation for Auto Scaling.
//
// Deletes the specified notification.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeleteNotificationConfiguration for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DeleteNotificationConfiguration(input *DeleteNotificationConfigurationInput) (*DeleteNotificationConfigurationOutput, error) {
	req, out := c.DeleteNotificationConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePolicy = "DeletePolicy"

// DeletePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeletePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeletePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeletePolicyRequest method.
//    req, resp := client.DeletePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DeletePolicyRequest(input *DeletePolicyInput) (req *request.Request, output *DeletePolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeletePolicyOutput{}
	req.Data = output
	return
}

// DeletePolicy API operation for Auto Scaling.
//
// Deletes the specified Auto Scaling policy.
//
// Deleting a policy deletes the underlying alarm action, but does not delete
// the alarm, even if it no longer has an associated action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeletePolicy for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DeletePolicy(input *DeletePolicyInput) (*DeletePolicyOutput, error) {
	req, out := c.DeletePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteScheduledAction = "DeleteScheduledAction"

// DeleteScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScheduledAction operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteScheduledAction for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteScheduledAction method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteScheduledActionRequest method.
//    req, resp := client.DeleteScheduledActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DeleteScheduledActionRequest(input *DeleteScheduledActionInput) (req *request.Request, output *DeleteScheduledActionOutput) {
	op := &request.Operation{
		Name:       opDeleteScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScheduledActionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteScheduledActionOutput{}
	req.Data = output
	return
}

// DeleteScheduledAction API operation for Auto Scaling.
//
// Deletes the specified scheduled action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeleteScheduledAction for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DeleteScheduledAction(input *DeleteScheduledActionInput) (*DeleteScheduledActionOutput, error) {
	req, out := c.DeleteScheduledActionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteTagsOutput{}
	req.Data = output
	return
}

// DeleteTags API operation for Auto Scaling.
//
// Deletes the specified tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DeleteTags for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAccountLimits = "DescribeAccountLimits"

// DescribeAccountLimitsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountLimits operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAccountLimits for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAccountLimits method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAccountLimitsRequest method.
//    req, resp := client.DescribeAccountLimitsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeAccountLimitsRequest(input *DescribeAccountLimitsInput) (req *request.Request, output *DescribeAccountLimitsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountLimitsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAccountLimitsOutput{}
	req.Data = output
	return
}

// DescribeAccountLimits API operation for Auto Scaling.
//
// Describes the current Auto Scaling resource limits for your AWS account.
//
// For information about requesting an increase in these limits, see AWS Service
// Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html)
// in the Amazon Web Services General Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeAccountLimits for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeAccountLimits(input *DescribeAccountLimitsInput) (*DescribeAccountLimitsOutput, error) {
	req, out := c.DescribeAccountLimitsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAdjustmentTypes = "DescribeAdjustmentTypes"

// DescribeAdjustmentTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAdjustmentTypes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAdjustmentTypes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAdjustmentTypes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAdjustmentTypesRequest method.
//    req, resp := client.DescribeAdjustmentTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeAdjustmentTypesRequest(input *DescribeAdjustmentTypesInput) (req *request.Request, output *DescribeAdjustmentTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeAdjustmentTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAdjustmentTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAdjustmentTypesOutput{}
	req.Data = output
	return
}

// DescribeAdjustmentTypes API operation for Auto Scaling.
//
// Describes the policy adjustment types for use with PutScalingPolicy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeAdjustmentTypes for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeAdjustmentTypes(input *DescribeAdjustmentTypesInput) (*DescribeAdjustmentTypesOutput, error) {
	req, out := c.DescribeAdjustmentTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeAutoScalingGroups = "DescribeAutoScalingGroups"

// DescribeAutoScalingGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutoScalingGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAutoScalingGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAutoScalingGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAutoScalingGroupsRequest method.
//    req, resp := client.DescribeAutoScalingGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeAutoScalingGroupsRequest(input *DescribeAutoScalingGroupsInput) (req *request.Request, output *DescribeAutoScalingGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeAutoScalingGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAutoScalingGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAutoScalingGroupsOutput{}
	req.Data = output
	return
}

// DescribeAutoScalingGroups API operation for Auto Scaling.
//
// Describes one or more Auto Scaling groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeAutoScalingGroups for usage and error information.
//
// Returned Error Codes:
//   * InvalidNextToken
//   The NextToken value is not valid.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeAutoScalingGroups(input *DescribeAutoScalingGroupsInput) (*DescribeAutoScalingGroupsOutput, error) {
	req, out := c.DescribeAutoScalingGroupsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeAutoScalingGroupsPages iterates over the pages of a DescribeAutoScalingGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAutoScalingGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAutoScalingGroups operation.
//    pageNum := 0
//    err := client.DescribeAutoScalingGroupsPages(params,
//        func(page *DescribeAutoScalingGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeAutoScalingGroupsPages(input *DescribeAutoScalingGroupsInput, fn func(p *DescribeAutoScalingGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeAutoScalingGroupsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeAutoScalingGroupsOutput), lastPage)
	})
}

const opDescribeAutoScalingInstances = "DescribeAutoScalingInstances"

// DescribeAutoScalingInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutoScalingInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAutoScalingInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAutoScalingInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAutoScalingInstancesRequest method.
//    req, resp := client.DescribeAutoScalingInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeAutoScalingInstancesRequest(input *DescribeAutoScalingInstancesInput) (req *request.Request, output *DescribeAutoScalingInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeAutoScalingInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAutoScalingInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAutoScalingInstancesOutput{}
	req.Data = output
	return
}

// DescribeAutoScalingInstances API operation for Auto Scaling.
//
// Describes one or more Auto Scaling instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeAutoScalingInstances for usage and error information.
//
// Returned Error Codes:
//   * InvalidNextToken
//   The NextToken value is not valid.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeAutoScalingInstances(input *DescribeAutoScalingInstancesInput) (*DescribeAutoScalingInstancesOutput, error) {
	req, out := c.DescribeAutoScalingInstancesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeAutoScalingInstancesPages iterates over the pages of a DescribeAutoScalingInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAutoScalingInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeAutoScalingInstances operation.
//    pageNum := 0
//    err := client.DescribeAutoScalingInstancesPages(params,
//        func(page *DescribeAutoScalingInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeAutoScalingInstancesPages(input *DescribeAutoScalingInstancesInput, fn func(p *DescribeAutoScalingInstancesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeAutoScalingInstancesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeAutoScalingInstancesOutput), lastPage)
	})
}

const opDescribeAutoScalingNotificationTypes = "DescribeAutoScalingNotificationTypes"

// DescribeAutoScalingNotificationTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAutoScalingNotificationTypes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeAutoScalingNotificationTypes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeAutoScalingNotificationTypes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeAutoScalingNotificationTypesRequest method.
//    req, resp := client.DescribeAutoScalingNotificationTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeAutoScalingNotificationTypesRequest(input *DescribeAutoScalingNotificationTypesInput) (req *request.Request, output *DescribeAutoScalingNotificationTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeAutoScalingNotificationTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAutoScalingNotificationTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeAutoScalingNotificationTypesOutput{}
	req.Data = output
	return
}

// DescribeAutoScalingNotificationTypes API operation for Auto Scaling.
//
// Describes the notification types that are supported by Auto Scaling.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeAutoScalingNotificationTypes for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeAutoScalingNotificationTypes(input *DescribeAutoScalingNotificationTypesInput) (*DescribeAutoScalingNotificationTypesOutput, error) {
	req, out := c.DescribeAutoScalingNotificationTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLaunchConfigurations = "DescribeLaunchConfigurations"

// DescribeLaunchConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLaunchConfigurations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeLaunchConfigurations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeLaunchConfigurations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeLaunchConfigurationsRequest method.
//    req, resp := client.DescribeLaunchConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeLaunchConfigurationsRequest(input *DescribeLaunchConfigurationsInput) (req *request.Request, output *DescribeLaunchConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeLaunchConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeLaunchConfigurationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLaunchConfigurationsOutput{}
	req.Data = output
	return
}

// DescribeLaunchConfigurations API operation for Auto Scaling.
//
// Describes one or more launch configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeLaunchConfigurations for usage and error information.
//
// Returned Error Codes:
//   * InvalidNextToken
//   The NextToken value is not valid.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeLaunchConfigurations(input *DescribeLaunchConfigurationsInput) (*DescribeLaunchConfigurationsOutput, error) {
	req, out := c.DescribeLaunchConfigurationsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeLaunchConfigurationsPages iterates over the pages of a DescribeLaunchConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeLaunchConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeLaunchConfigurations operation.
//    pageNum := 0
//    err := client.DescribeLaunchConfigurationsPages(params,
//        func(page *DescribeLaunchConfigurationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeLaunchConfigurationsPages(input *DescribeLaunchConfigurationsInput, fn func(p *DescribeLaunchConfigurationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeLaunchConfigurationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeLaunchConfigurationsOutput), lastPage)
	})
}

const opDescribeLifecycleHookTypes = "DescribeLifecycleHookTypes"

// DescribeLifecycleHookTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLifecycleHookTypes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeLifecycleHookTypes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeLifecycleHookTypes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeLifecycleHookTypesRequest method.
//    req, resp := client.DescribeLifecycleHookTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeLifecycleHookTypesRequest(input *DescribeLifecycleHookTypesInput) (req *request.Request, output *DescribeLifecycleHookTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeLifecycleHookTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLifecycleHookTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLifecycleHookTypesOutput{}
	req.Data = output
	return
}

// DescribeLifecycleHookTypes API operation for Auto Scaling.
//
// Describes the available types of lifecycle hooks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeLifecycleHookTypes for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeLifecycleHookTypes(input *DescribeLifecycleHookTypesInput) (*DescribeLifecycleHookTypesOutput, error) {
	req, out := c.DescribeLifecycleHookTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLifecycleHooks = "DescribeLifecycleHooks"

// DescribeLifecycleHooksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLifecycleHooks operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeLifecycleHooks for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeLifecycleHooks method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeLifecycleHooksRequest method.
//    req, resp := client.DescribeLifecycleHooksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeLifecycleHooksRequest(input *DescribeLifecycleHooksInput) (req *request.Request, output *DescribeLifecycleHooksOutput) {
	op := &request.Operation{
		Name:       opDescribeLifecycleHooks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLifecycleHooksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLifecycleHooksOutput{}
	req.Data = output
	return
}

// DescribeLifecycleHooks API operation for Auto Scaling.
//
// Describes the lifecycle hooks for the specified Auto Scaling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeLifecycleHooks for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeLifecycleHooks(input *DescribeLifecycleHooksInput) (*DescribeLifecycleHooksOutput, error) {
	req, out := c.DescribeLifecycleHooksRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLoadBalancerTargetGroups = "DescribeLoadBalancerTargetGroups"

// DescribeLoadBalancerTargetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoadBalancerTargetGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeLoadBalancerTargetGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeLoadBalancerTargetGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeLoadBalancerTargetGroupsRequest method.
//    req, resp := client.DescribeLoadBalancerTargetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeLoadBalancerTargetGroupsRequest(input *DescribeLoadBalancerTargetGroupsInput) (req *request.Request, output *DescribeLoadBalancerTargetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeLoadBalancerTargetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoadBalancerTargetGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLoadBalancerTargetGroupsOutput{}
	req.Data = output
	return
}

// DescribeLoadBalancerTargetGroups API operation for Auto Scaling.
//
// Describes the target groups for the specified Auto Scaling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeLoadBalancerTargetGroups for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeLoadBalancerTargetGroups(input *DescribeLoadBalancerTargetGroupsInput) (*DescribeLoadBalancerTargetGroupsOutput, error) {
	req, out := c.DescribeLoadBalancerTargetGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLoadBalancers = "DescribeLoadBalancers"

// DescribeLoadBalancersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoadBalancers operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeLoadBalancers for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeLoadBalancers method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeLoadBalancersRequest method.
//    req, resp := client.DescribeLoadBalancersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeLoadBalancersRequest(input *DescribeLoadBalancersInput) (req *request.Request, output *DescribeLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opDescribeLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoadBalancersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLoadBalancersOutput{}
	req.Data = output
	return
}

// DescribeLoadBalancers API operation for Auto Scaling.
//
// Describes the load balancers for the specified Auto Scaling group.
//
// Note that this operation describes only Classic load balancers. If you have
// Application load balancers, use DescribeLoadBalancerTargetGroups instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeLoadBalancers for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeLoadBalancers(input *DescribeLoadBalancersInput) (*DescribeLoadBalancersOutput, error) {
	req, out := c.DescribeLoadBalancersRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeMetricCollectionTypes = "DescribeMetricCollectionTypes"

// DescribeMetricCollectionTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMetricCollectionTypes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeMetricCollectionTypes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeMetricCollectionTypes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeMetricCollectionTypesRequest method.
//    req, resp := client.DescribeMetricCollectionTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeMetricCollectionTypesRequest(input *DescribeMetricCollectionTypesInput) (req *request.Request, output *DescribeMetricCollectionTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeMetricCollectionTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMetricCollectionTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeMetricCollectionTypesOutput{}
	req.Data = output
	return
}

// DescribeMetricCollectionTypes API operation for Auto Scaling.
//
// Describes the available CloudWatch metrics for Auto Scaling.
//
// Note that the GroupStandbyInstances metric is not returned by default. You
// must explicitly request this metric when calling EnableMetricsCollection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeMetricCollectionTypes for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeMetricCollectionTypes(input *DescribeMetricCollectionTypesInput) (*DescribeMetricCollectionTypesOutput, error) {
	req, out := c.DescribeMetricCollectionTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeNotificationConfigurations = "DescribeNotificationConfigurations"

// DescribeNotificationConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNotificationConfigurations operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeNotificationConfigurations for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeNotificationConfigurations method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeNotificationConfigurationsRequest method.
//    req, resp := client.DescribeNotificationConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeNotificationConfigurationsRequest(input *DescribeNotificationConfigurationsInput) (req *request.Request, output *DescribeNotificationConfigurationsOutput) {
	op := &request.Operation{
		Name:       opDescribeNotificationConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeNotificationConfigurationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeNotificationConfigurationsOutput{}
	req.Data = output
	return
}

// DescribeNotificationConfigurations API operation for Auto Scaling.
//
// Describes the notification actions associated with the specified Auto Scaling
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeNotificationConfigurations for usage and error information.
//
// Returned Error Codes:
//   * InvalidNextToken
//   The NextToken value is not valid.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeNotificationConfigurations(input *DescribeNotificationConfigurationsInput) (*DescribeNotificationConfigurationsOutput, error) {
	req, out := c.DescribeNotificationConfigurationsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeNotificationConfigurationsPages iterates over the pages of a DescribeNotificationConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeNotificationConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeNotificationConfigurations operation.
//    pageNum := 0
//    err := client.DescribeNotificationConfigurationsPages(params,
//        func(page *DescribeNotificationConfigurationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeNotificationConfigurationsPages(input *DescribeNotificationConfigurationsInput, fn func(p *DescribeNotificationConfigurationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeNotificationConfigurationsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeNotificationConfigurationsOutput), lastPage)
	})
}

const opDescribePolicies = "DescribePolicies"

// DescribePoliciesRequest generates a "aws/request.Request" representing the
// client's request for the DescribePolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribePolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribePolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribePoliciesRequest method.
//    req, resp := client.DescribePoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribePoliciesRequest(input *DescribePoliciesInput) (req *request.Request, output *DescribePoliciesOutput) {
	op := &request.Operation{
		Name:       opDescribePolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribePoliciesOutput{}
	req.Data = output
	return
}

// DescribePolicies API operation for Auto Scaling.
//
// Describes the policies for the specified Auto Scaling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribePolicies for usage and error information.
//
// Returned Error Codes:
//   * InvalidNextToken
//   The NextToken value is not valid.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribePolicies(input *DescribePoliciesInput) (*DescribePoliciesOutput, error) {
	req, out := c.DescribePoliciesRequest(input)
	err := req.Send()
	return out, err
}

// DescribePoliciesPages iterates over the pages of a DescribePolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribePolicies operation.
//    pageNum := 0
//    err := client.DescribePoliciesPages(params,
//        func(page *DescribePoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribePoliciesPages(input *DescribePoliciesInput, fn func(p *DescribePoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribePoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribePoliciesOutput), lastPage)
	})
}

const opDescribeScalingActivities = "DescribeScalingActivities"

// DescribeScalingActivitiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingActivities operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeScalingActivities for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeScalingActivities method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeScalingActivitiesRequest method.
//    req, resp := client.DescribeScalingActivitiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeScalingActivitiesRequest(input *DescribeScalingActivitiesInput) (req *request.Request, output *DescribeScalingActivitiesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingActivities,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScalingActivitiesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeScalingActivitiesOutput{}
	req.Data = output
	return
}

// DescribeScalingActivities API operation for Auto Scaling.
//
// Describes one or more scaling activities for the specified Auto Scaling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeScalingActivities for usage and error information.
//
// Returned Error Codes:
//   * InvalidNextToken
//   The NextToken value is not valid.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeScalingActivities(input *DescribeScalingActivitiesInput) (*DescribeScalingActivitiesOutput, error) {
	req, out := c.DescribeScalingActivitiesRequest(input)
	err := req.Send()
	return out, err
}

// DescribeScalingActivitiesPages iterates over the pages of a DescribeScalingActivities operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScalingActivities method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeScalingActivities operation.
//    pageNum := 0
//    err := client.DescribeScalingActivitiesPages(params,
//        func(page *DescribeScalingActivitiesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeScalingActivitiesPages(input *DescribeScalingActivitiesInput, fn func(p *DescribeScalingActivitiesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeScalingActivitiesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeScalingActivitiesOutput), lastPage)
	})
}

const opDescribeScalingProcessTypes = "DescribeScalingProcessTypes"

// DescribeScalingProcessTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScalingProcessTypes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeScalingProcessTypes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeScalingProcessTypes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeScalingProcessTypesRequest method.
//    req, resp := client.DescribeScalingProcessTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeScalingProcessTypesRequest(input *DescribeScalingProcessTypesInput) (req *request.Request, output *DescribeScalingProcessTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeScalingProcessTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeScalingProcessTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeScalingProcessTypesOutput{}
	req.Data = output
	return
}

// DescribeScalingProcessTypes API operation for Auto Scaling.
//
// Describes the scaling process types for use with ResumeProcesses and SuspendProcesses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeScalingProcessTypes for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeScalingProcessTypes(input *DescribeScalingProcessTypesInput) (*DescribeScalingProcessTypesOutput, error) {
	req, out := c.DescribeScalingProcessTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeScheduledActions = "DescribeScheduledActions"

// DescribeScheduledActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeScheduledActions operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeScheduledActions for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeScheduledActions method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeScheduledActionsRequest method.
//    req, resp := client.DescribeScheduledActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeScheduledActionsRequest(input *DescribeScheduledActionsInput) (req *request.Request, output *DescribeScheduledActionsOutput) {
	op := &request.Operation{
		Name:       opDescribeScheduledActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeScheduledActionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeScheduledActionsOutput{}
	req.Data = output
	return
}

// DescribeScheduledActions API operation for Auto Scaling.
//
// Describes the actions scheduled for your Auto Scaling group that haven't
// run. To describe the actions that have already run, use DescribeScalingActivities.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeScheduledActions for usage and error information.
//
// Returned Error Codes:
//   * InvalidNextToken
//   The NextToken value is not valid.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeScheduledActions(input *DescribeScheduledActionsInput) (*DescribeScheduledActionsOutput, error) {
	req, out := c.DescribeScheduledActionsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeScheduledActionsPages iterates over the pages of a DescribeScheduledActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeScheduledActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeScheduledActions operation.
//    pageNum := 0
//    err := client.DescribeScheduledActionsPages(params,
//        func(page *DescribeScheduledActionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeScheduledActionsPages(input *DescribeScheduledActionsInput, fn func(p *DescribeScheduledActionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeScheduledActionsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeScheduledActionsOutput), lastPage)
	})
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTagsOutput{}
	req.Data = output
	return
}

// DescribeTags API operation for Auto Scaling.
//
// Describes the specified tags.
//
// You can use filters to limit the results. For example, you can query for
// the tags for a specific Auto Scaling group. You can specify multiple values
// for a filter. A tag must match at least one of the specified values for it
// to be included in the results.
//
// You can also specify multiple filters. The result includes information for
// a particular tag only if it matches all the filters. If there's no match,
// no special message is returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeTags for usage and error information.
//
// Returned Error Codes:
//   * InvalidNextToken
//   The NextToken value is not valid.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	err := req.Send()
	return out, err
}

// DescribeTagsPages iterates over the pages of a DescribeTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTags operation.
//    pageNum := 0
//    err := client.DescribeTagsPages(params,
//        func(page *DescribeTagsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AutoScaling) DescribeTagsPages(input *DescribeTagsInput, fn func(p *DescribeTagsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeTagsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeTagsOutput), lastPage)
	})
}

const opDescribeTerminationPolicyTypes = "DescribeTerminationPolicyTypes"

// DescribeTerminationPolicyTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTerminationPolicyTypes operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeTerminationPolicyTypes for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeTerminationPolicyTypes method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeTerminationPolicyTypesRequest method.
//    req, resp := client.DescribeTerminationPolicyTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DescribeTerminationPolicyTypesRequest(input *DescribeTerminationPolicyTypesInput) (req *request.Request, output *DescribeTerminationPolicyTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeTerminationPolicyTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTerminationPolicyTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeTerminationPolicyTypesOutput{}
	req.Data = output
	return
}

// DescribeTerminationPolicyTypes API operation for Auto Scaling.
//
// Describes the termination policies supported by Auto Scaling.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DescribeTerminationPolicyTypes for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DescribeTerminationPolicyTypes(input *DescribeTerminationPolicyTypesInput) (*DescribeTerminationPolicyTypesOutput, error) {
	req, out := c.DescribeTerminationPolicyTypesRequest(input)
	err := req.Send()
	return out, err
}

const opDetachInstances = "DetachInstances"

// DetachInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DetachInstances operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachInstances for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachInstances method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachInstancesRequest method.
//    req, resp := client.DetachInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DetachInstancesRequest(input *DetachInstancesInput) (req *request.Request, output *DetachInstancesOutput) {
	op := &request.Operation{
		Name:       opDetachInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DetachInstancesOutput{}
	req.Data = output
	return
}

// DetachInstances API operation for Auto Scaling.
//
// Removes one or more instances from the specified Auto Scaling group.
//
// After the instances are detached, you can manage them independently from
// the rest of the Auto Scaling group.
//
// If you do not specify the option to decrement the desired capacity, Auto
// Scaling launches instances to replace the ones that are detached.
//
// If there is a Classic load balancer attached to the Auto Scaling group,
// the instances are deregistered from the load balancer. If there are target
// groups attached to the Auto Scaling group, the instances are deregistered
// from the target groups.
//
// For more information, see Detach EC2 Instances from Your Auto Scaling Group
// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/detach-instance-asg.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DetachInstances for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DetachInstances(input *DetachInstancesInput) (*DetachInstancesOutput, error) {
	req, out := c.DetachInstancesRequest(input)
	err := req.Send()
	return out, err
}

const opDetachLoadBalancerTargetGroups = "DetachLoadBalancerTargetGroups"

// DetachLoadBalancerTargetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DetachLoadBalancerTargetGroups operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachLoadBalancerTargetGroups for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachLoadBalancerTargetGroups method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachLoadBalancerTargetGroupsRequest method.
//    req, resp := client.DetachLoadBalancerTargetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DetachLoadBalancerTargetGroupsRequest(input *DetachLoadBalancerTargetGroupsInput) (req *request.Request, output *DetachLoadBalancerTargetGroupsOutput) {
	op := &request.Operation{
		Name:       opDetachLoadBalancerTargetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachLoadBalancerTargetGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DetachLoadBalancerTargetGroupsOutput{}
	req.Data = output
	return
}

// DetachLoadBalancerTargetGroups API operation for Auto Scaling.
//
// Detaches one or more target groups from the specified Auto Scaling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DetachLoadBalancerTargetGroups for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DetachLoadBalancerTargetGroups(input *DetachLoadBalancerTargetGroupsInput) (*DetachLoadBalancerTargetGroupsOutput, error) {
	req, out := c.DetachLoadBalancerTargetGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opDetachLoadBalancers = "DetachLoadBalancers"

// DetachLoadBalancersRequest generates a "aws/request.Request" representing the
// client's request for the DetachLoadBalancers operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DetachLoadBalancers for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DetachLoadBalancers method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DetachLoadBalancersRequest method.
//    req, resp := client.DetachLoadBalancersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DetachLoadBalancersRequest(input *DetachLoadBalancersInput) (req *request.Request, output *DetachLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opDetachLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachLoadBalancersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DetachLoadBalancersOutput{}
	req.Data = output
	return
}

// DetachLoadBalancers API operation for Auto Scaling.
//
// Detaches one or more Classic load balancers from the specified Auto Scaling
// group.
//
// Note that this operation detaches only Classic load balancers. If you have
// Application load balancers, use DetachLoadBalancerTargetGroups instead.
//
// When you detach a load balancer, it enters the Removing state while deregistering
// the instances in the group. When all instances are deregistered, then you
// can no longer describe the load balancer using DescribeLoadBalancers. Note
// that the instances remain running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DetachLoadBalancers for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DetachLoadBalancers(input *DetachLoadBalancersInput) (*DetachLoadBalancersOutput, error) {
	req, out := c.DetachLoadBalancersRequest(input)
	err := req.Send()
	return out, err
}

const opDisableMetricsCollection = "DisableMetricsCollection"

// DisableMetricsCollectionRequest generates a "aws/request.Request" representing the
// client's request for the DisableMetricsCollection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableMetricsCollection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableMetricsCollection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableMetricsCollectionRequest method.
//    req, resp := client.DisableMetricsCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) DisableMetricsCollectionRequest(input *DisableMetricsCollectionInput) (req *request.Request, output *DisableMetricsCollectionOutput) {
	op := &request.Operation{
		Name:       opDisableMetricsCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableMetricsCollectionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DisableMetricsCollectionOutput{}
	req.Data = output
	return
}

// DisableMetricsCollection API operation for Auto Scaling.
//
// Disables group metrics for the specified Auto Scaling group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation DisableMetricsCollection for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) DisableMetricsCollection(input *DisableMetricsCollectionInput) (*DisableMetricsCollectionOutput, error) {
	req, out := c.DisableMetricsCollectionRequest(input)
	err := req.Send()
	return out, err
}

const opEnableMetricsCollection = "EnableMetricsCollection"

// EnableMetricsCollectionRequest generates a "aws/request.Request" representing the
// client's request for the EnableMetricsCollection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableMetricsCollection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableMetricsCollection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableMetricsCollectionRequest method.
//    req, resp := client.EnableMetricsCollectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) EnableMetricsCollectionRequest(input *EnableMetricsCollectionInput) (req *request.Request, output *EnableMetricsCollectionOutput) {
	op := &request.Operation{
		Name:       opEnableMetricsCollection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableMetricsCollectionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &EnableMetricsCollectionOutput{}
	req.Data = output
	return
}

// EnableMetricsCollection API operation for Auto Scaling.
//
// Enables group metrics for the specified Auto Scaling group. For more information,
// see Monitoring Your Auto Scaling Groups and Instances (http://docs.aws.amazon.com/AutoScaling/latest/userguide/as-instance-monitoring.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation EnableMetricsCollection for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) EnableMetricsCollection(input *EnableMetricsCollectionInput) (*EnableMetricsCollectionOutput, error) {
	req, out := c.EnableMetricsCollectionRequest(input)
	err := req.Send()
	return out, err
}

const opEnterStandby = "EnterStandby"

// EnterStandbyRequest generates a "aws/request.Request" representing the
// client's request for the EnterStandby operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnterStandby for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnterStandby method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnterStandbyRequest method.
//    req, resp := client.EnterStandbyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) EnterStandbyRequest(input *EnterStandbyInput) (req *request.Request, output *EnterStandbyOutput) {
	op := &request.Operation{
		Name:       opEnterStandby,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnterStandbyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnterStandbyOutput{}
	req.Data = output
	return
}

// EnterStandby API operation for Auto Scaling.
//
// Moves the specified instances into Standby mode.
//
// For more information, see Auto Scaling Lifecycle (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroupLifecycle.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation EnterStandby for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) EnterStandby(input *EnterStandbyInput) (*EnterStandbyOutput, error) {
	req, out := c.EnterStandbyRequest(input)
	err := req.Send()
	return out, err
}

const opExecutePolicy = "ExecutePolicy"

// ExecutePolicyRequest generates a "aws/request.Request" representing the
// client's request for the ExecutePolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ExecutePolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ExecutePolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ExecutePolicyRequest method.
//    req, resp := client.ExecutePolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) ExecutePolicyRequest(input *ExecutePolicyInput) (req *request.Request, output *ExecutePolicyOutput) {
	op := &request.Operation{
		Name:       opExecutePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExecutePolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &ExecutePolicyOutput{}
	req.Data = output
	return
}

// ExecutePolicy API operation for Auto Scaling.
//
// Executes the specified policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation ExecutePolicy for usage and error information.
//
// Returned Error Codes:
//   * ScalingActivityInProgress
//   The operation can't be performed because there are scaling activities in
//   progress.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) ExecutePolicy(input *ExecutePolicyInput) (*ExecutePolicyOutput, error) {
	req, out := c.ExecutePolicyRequest(input)
	err := req.Send()
	return out, err
}

const opExitStandby = "ExitStandby"

// ExitStandbyRequest generates a "aws/request.Request" representing the
// client's request for the ExitStandby operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ExitStandby for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ExitStandby method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ExitStandbyRequest method.
//    req, resp := client.ExitStandbyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) ExitStandbyRequest(input *ExitStandbyInput) (req *request.Request, output *ExitStandbyOutput) {
	op := &request.Operation{
		Name:       opExitStandby,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExitStandbyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ExitStandbyOutput{}
	req.Data = output
	return
}

// ExitStandby API operation for Auto Scaling.
//
// Moves the specified instances out of Standby mode.
//
// For more information, see Auto Scaling Lifecycle (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroupLifecycle.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation ExitStandby for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) ExitStandby(input *ExitStandbyInput) (*ExitStandbyOutput, error) {
	req, out := c.ExitStandbyRequest(input)
	err := req.Send()
	return out, err
}

const opPutLifecycleHook = "PutLifecycleHook"

// PutLifecycleHookRequest generates a "aws/request.Request" representing the
// client's request for the PutLifecycleHook operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutLifecycleHook for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutLifecycleHook method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutLifecycleHookRequest method.
//    req, resp := client.PutLifecycleHookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) PutLifecycleHookRequest(input *PutLifecycleHookInput) (req *request.Request, output *PutLifecycleHookOutput) {
	op := &request.Operation{
		Name:       opPutLifecycleHook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutLifecycleHookInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutLifecycleHookOutput{}
	req.Data = output
	return
}

// PutLifecycleHook API operation for Auto Scaling.
//
// Creates or updates a lifecycle hook for the specified Auto Scaling Group.
//
// A lifecycle hook tells Auto Scaling that you want to perform an action on
// an instance that is not actively in service; for example, either when the
// instance launches or before the instance terminates.
//
// This step is a part of the procedure for adding a lifecycle hook to an Auto
// Scaling group:
//
//   (Optional) Create a Lambda function and a rule that allows CloudWatch
// Events to invoke your Lambda function when Auto Scaling launches or terminates
// instances.
//
//   (Optional) Create a notification target and an IAM role. The target can
// be either an Amazon SQS queue or an Amazon SNS topic. The role allows Auto
// Scaling to publish lifecycle notifications to the target.
//
//    Create the lifecycle hook. Specify whether the hook is used when the
// instances launch or terminate.
//
//   If you need more time, record the lifecycle action heartbeat to keep the
// instance in a pending state.
//
//   If you finish before the timeout period ends, complete the lifecycle action.
//
//   For more information, see Auto Scaling Lifecycle (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroupLifecycle.html)
// in the Auto Scaling User Guide.
//
// If you exceed your maximum limit of lifecycle hooks, which by default is
// 50 per Auto Scaling group, the call fails. For information about updating
// this limit, see AWS Service Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html)
// in the Amazon Web Services General Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation PutLifecycleHook for usage and error information.
//
// Returned Error Codes:
//   * LimitExceeded
//   You have already reached a limit for your Auto Scaling resources (for example,
//   groups, launch configurations, or lifecycle hooks). For more information,
//   see DescribeAccountLimits.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) PutLifecycleHook(input *PutLifecycleHookInput) (*PutLifecycleHookOutput, error) {
	req, out := c.PutLifecycleHookRequest(input)
	err := req.Send()
	return out, err
}

const opPutNotificationConfiguration = "PutNotificationConfiguration"

// PutNotificationConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutNotificationConfiguration operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutNotificationConfiguration for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutNotificationConfiguration method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutNotificationConfigurationRequest method.
//    req, resp := client.PutNotificationConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) PutNotificationConfigurationRequest(input *PutNotificationConfigurationInput) (req *request.Request, output *PutNotificationConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutNotificationConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutNotificationConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutNotificationConfigurationOutput{}
	req.Data = output
	return
}

// PutNotificationConfiguration API operation for Auto Scaling.
//
// Configures an Auto Scaling group to send notifications when specified events
// take place. Subscribers to the specified topic can have messages delivered
// to an endpoint such as a web server or an email address.
//
// This configuration overwrites any existing configuration.
//
// For more information see Getting SNS Notifications When Your Auto Scaling
// Group Scales (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/ASGettingNotifications.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation PutNotificationConfiguration for usage and error information.
//
// Returned Error Codes:
//   * LimitExceeded
//   You have already reached a limit for your Auto Scaling resources (for example,
//   groups, launch configurations, or lifecycle hooks). For more information,
//   see DescribeAccountLimits.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) PutNotificationConfiguration(input *PutNotificationConfigurationInput) (*PutNotificationConfigurationOutput, error) {
	req, out := c.PutNotificationConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opPutScalingPolicy = "PutScalingPolicy"

// PutScalingPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutScalingPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutScalingPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutScalingPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutScalingPolicyRequest method.
//    req, resp := client.PutScalingPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) PutScalingPolicyRequest(input *PutScalingPolicyInput) (req *request.Request, output *PutScalingPolicyOutput) {
	op := &request.Operation{
		Name:       opPutScalingPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScalingPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutScalingPolicyOutput{}
	req.Data = output
	return
}

// PutScalingPolicy API operation for Auto Scaling.
//
// Creates or updates a policy for an Auto Scaling group. To update an existing
// policy, use the existing policy name and set the parameters you want to change.
// Any existing parameter not changed in an update to an existing policy is
// not changed in this update request.
//
// If you exceed your maximum limit of step adjustments, which by default is
// 20 per region, the call fails. For information about updating this limit,
// see AWS Service Limits (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html)
// in the Amazon Web Services General Reference.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation PutScalingPolicy for usage and error information.
//
// Returned Error Codes:
//   * LimitExceeded
//   You have already reached a limit for your Auto Scaling resources (for example,
//   groups, launch configurations, or lifecycle hooks). For more information,
//   see DescribeAccountLimits.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) PutScalingPolicy(input *PutScalingPolicyInput) (*PutScalingPolicyOutput, error) {
	req, out := c.PutScalingPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opPutScheduledUpdateGroupAction = "PutScheduledUpdateGroupAction"

// PutScheduledUpdateGroupActionRequest generates a "aws/request.Request" representing the
// client's request for the PutScheduledUpdateGroupAction operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutScheduledUpdateGroupAction for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutScheduledUpdateGroupAction method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutScheduledUpdateGroupActionRequest method.
//    req, resp := client.PutScheduledUpdateGroupActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) PutScheduledUpdateGroupActionRequest(input *PutScheduledUpdateGroupActionInput) (req *request.Request, output *PutScheduledUpdateGroupActionOutput) {
	op := &request.Operation{
		Name:       opPutScheduledUpdateGroupAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutScheduledUpdateGroupActionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutScheduledUpdateGroupActionOutput{}
	req.Data = output
	return
}

// PutScheduledUpdateGroupAction API operation for Auto Scaling.
//
// Creates or updates a scheduled scaling action for an Auto Scaling group.
// When updating a scheduled scaling action, if you leave a parameter unspecified,
// the corresponding value remains unchanged in the affected Auto Scaling group.
//
// For more information, see Scheduled Scaling (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/schedule_time.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation PutScheduledUpdateGroupAction for usage and error information.
//
// Returned Error Codes:
//   * AlreadyExists
//   You already have an Auto Scaling group or launch configuration with this
//   name.
//
//   * LimitExceeded
//   You have already reached a limit for your Auto Scaling resources (for example,
//   groups, launch configurations, or lifecycle hooks). For more information,
//   see DescribeAccountLimits.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) PutScheduledUpdateGroupAction(input *PutScheduledUpdateGroupActionInput) (*PutScheduledUpdateGroupActionOutput, error) {
	req, out := c.PutScheduledUpdateGroupActionRequest(input)
	err := req.Send()
	return out, err
}

const opRecordLifecycleActionHeartbeat = "RecordLifecycleActionHeartbeat"

// RecordLifecycleActionHeartbeatRequest generates a "aws/request.Request" representing the
// client's request for the RecordLifecycleActionHeartbeat operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RecordLifecycleActionHeartbeat for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RecordLifecycleActionHeartbeat method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RecordLifecycleActionHeartbeatRequest method.
//    req, resp := client.RecordLifecycleActionHeartbeatRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) RecordLifecycleActionHeartbeatRequest(input *RecordLifecycleActionHeartbeatInput) (req *request.Request, output *RecordLifecycleActionHeartbeatOutput) {
	op := &request.Operation{
		Name:       opRecordLifecycleActionHeartbeat,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RecordLifecycleActionHeartbeatInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RecordLifecycleActionHeartbeatOutput{}
	req.Data = output
	return
}

// RecordLifecycleActionHeartbeat API operation for Auto Scaling.
//
// Records a heartbeat for the lifecycle action associated with the specified
// token or instance. This extends the timeout by the length of time defined
// using PutLifecycleHook.
//
// This step is a part of the procedure for adding a lifecycle hook to an Auto
// Scaling group:
//
//   (Optional) Create a Lambda function and a rule that allows CloudWatch
// Events to invoke your Lambda function when Auto Scaling launches or terminates
// instances.
//
//   (Optional) Create a notification target and an IAM role. The target can
// be either an Amazon SQS queue or an Amazon SNS topic. The role allows Auto
// Scaling to publish lifecycle notifications to the target.
//
//   Create the lifecycle hook. Specify whether the hook is used when the instances
// launch or terminate.
//
//    If you need more time, record the lifecycle action heartbeat to keep
// the instance in a pending state.
//
//   If you finish before the timeout period ends, complete the lifecycle action.
//
//   For more information, see Auto Scaling Lifecycle (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroupLifecycle.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation RecordLifecycleActionHeartbeat for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) RecordLifecycleActionHeartbeat(input *RecordLifecycleActionHeartbeatInput) (*RecordLifecycleActionHeartbeatOutput, error) {
	req, out := c.RecordLifecycleActionHeartbeatRequest(input)
	err := req.Send()
	return out, err
}

const opResumeProcesses = "ResumeProcesses"

// ResumeProcessesRequest generates a "aws/request.Request" representing the
// client's request for the ResumeProcesses operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ResumeProcesses for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ResumeProcesses method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ResumeProcessesRequest method.
//    req, resp := client.ResumeProcessesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) ResumeProcessesRequest(input *ScalingProcessQuery) (req *request.Request, output *ResumeProcessesOutput) {
	op := &request.Operation{
		Name:       opResumeProcesses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScalingProcessQuery{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &ResumeProcessesOutput{}
	req.Data = output
	return
}

// ResumeProcesses API operation for Auto Scaling.
//
// Resumes the specified suspended Auto Scaling processes, or all suspended
// process, for the specified Auto Scaling group.
//
// For more information, see Suspending and Resuming Auto Scaling Processes
// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US_SuspendResume.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation ResumeProcesses for usage and error information.
//
// Returned Error Codes:
//   * ResourceInUse
//   The operation can't be performed because the resource is in use.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) ResumeProcesses(input *ScalingProcessQuery) (*ResumeProcessesOutput, error) {
	req, out := c.ResumeProcessesRequest(input)
	err := req.Send()
	return out, err
}

const opSetDesiredCapacity = "SetDesiredCapacity"

// SetDesiredCapacityRequest generates a "aws/request.Request" representing the
// client's request for the SetDesiredCapacity operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetDesiredCapacity for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetDesiredCapacity method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetDesiredCapacityRequest method.
//    req, resp := client.SetDesiredCapacityRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) SetDesiredCapacityRequest(input *SetDesiredCapacityInput) (req *request.Request, output *SetDesiredCapacityOutput) {
	op := &request.Operation{
		Name:       opSetDesiredCapacity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetDesiredCapacityInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetDesiredCapacityOutput{}
	req.Data = output
	return
}

// SetDesiredCapacity API operation for Auto Scaling.
//
// Sets the size of the specified Auto Scaling group.
//
// For more information about desired capacity, see What Is Auto Scaling? (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/WhatIsAutoScaling.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation SetDesiredCapacity for usage and error information.
//
// Returned Error Codes:
//   * ScalingActivityInProgress
//   The operation can't be performed because there are scaling activities in
//   progress.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) SetDesiredCapacity(input *SetDesiredCapacityInput) (*SetDesiredCapacityOutput, error) {
	req, out := c.SetDesiredCapacityRequest(input)
	err := req.Send()
	return out, err
}

const opSetInstanceHealth = "SetInstanceHealth"

// SetInstanceHealthRequest generates a "aws/request.Request" representing the
// client's request for the SetInstanceHealth operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetInstanceHealth for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetInstanceHealth method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetInstanceHealthRequest method.
//    req, resp := client.SetInstanceHealthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) SetInstanceHealthRequest(input *SetInstanceHealthInput) (req *request.Request, output *SetInstanceHealthOutput) {
	op := &request.Operation{
		Name:       opSetInstanceHealth,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetInstanceHealthInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SetInstanceHealthOutput{}
	req.Data = output
	return
}

// SetInstanceHealth API operation for Auto Scaling.
//
// Sets the health status of the specified instance.
//
// For more information, see Health Checks (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/healthcheck.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation SetInstanceHealth for usage and error information.
//
// Returned Error Codes:
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) SetInstanceHealth(input *SetInstanceHealthInput) (*SetInstanceHealthOutput, error) {
	req, out := c.SetInstanceHealthRequest(input)
	err := req.Send()
	return out, err
}

const opSetInstanceProtection = "SetInstanceProtection"

// SetInstanceProtectionRequest generates a "aws/request.Request" representing the
// client's request for the SetInstanceProtection operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SetInstanceProtection for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SetInstanceProtection method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SetInstanceProtectionRequest method.
//    req, resp := client.SetInstanceProtectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) SetInstanceProtectionRequest(input *SetInstanceProtectionInput) (req *request.Request, output *SetInstanceProtectionOutput) {
	op := &request.Operation{
		Name:       opSetInstanceProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetInstanceProtectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetInstanceProtectionOutput{}
	req.Data = output
	return
}

// SetInstanceProtection API operation for Auto Scaling.
//
// Updates the instance protection settings of the specified instances.
//
// For more information, see Instance Protection (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingBehavior.InstanceTermination.html#instance-protection)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation SetInstanceProtection for usage and error information.
//
// Returned Error Codes:
//   * LimitExceeded
//   You have already reached a limit for your Auto Scaling resources (for example,
//   groups, launch configurations, or lifecycle hooks). For more information,
//   see DescribeAccountLimits.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) SetInstanceProtection(input *SetInstanceProtectionInput) (*SetInstanceProtectionOutput, error) {
	req, out := c.SetInstanceProtectionRequest(input)
	err := req.Send()
	return out, err
}

const opSuspendProcesses = "SuspendProcesses"

// SuspendProcessesRequest generates a "aws/request.Request" representing the
// client's request for the SuspendProcesses operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See SuspendProcesses for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the SuspendProcesses method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the SuspendProcessesRequest method.
//    req, resp := client.SuspendProcessesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) SuspendProcessesRequest(input *ScalingProcessQuery) (req *request.Request, output *SuspendProcessesOutput) {
	op := &request.Operation{
		Name:       opSuspendProcesses,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScalingProcessQuery{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &SuspendProcessesOutput{}
	req.Data = output
	return
}

// SuspendProcesses API operation for Auto Scaling.
//
// Suspends the specified Auto Scaling processes, or all processes, for the
// specified Auto Scaling group.
//
// Note that if you suspend either the Launch or Terminate process types, it
// can prevent other process types from functioning properly.
//
// To resume processes that have been suspended, use ResumeProcesses.
//
// For more information, see Suspending and Resuming Auto Scaling Processes
// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US_SuspendResume.html)
// in the Auto Scaling User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation SuspendProcesses for usage and error information.
//
// Returned Error Codes:
//   * ResourceInUse
//   The operation can't be performed because the resource is in use.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) SuspendProcesses(input *ScalingProcessQuery) (*SuspendProcessesOutput, error) {
	req, out := c.SuspendProcessesRequest(input)
	err := req.Send()
	return out, err
}

const opTerminateInstanceInAutoScalingGroup = "TerminateInstanceInAutoScalingGroup"

// TerminateInstanceInAutoScalingGroupRequest generates a "aws/request.Request" representing the
// client's request for the TerminateInstanceInAutoScalingGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See TerminateInstanceInAutoScalingGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the TerminateInstanceInAutoScalingGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the TerminateInstanceInAutoScalingGroupRequest method.
//    req, resp := client.TerminateInstanceInAutoScalingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) TerminateInstanceInAutoScalingGroupRequest(input *TerminateInstanceInAutoScalingGroupInput) (req *request.Request, output *TerminateInstanceInAutoScalingGroupOutput) {
	op := &request.Operation{
		Name:       opTerminateInstanceInAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateInstanceInAutoScalingGroupInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TerminateInstanceInAutoScalingGroupOutput{}
	req.Data = output
	return
}

// TerminateInstanceInAutoScalingGroup API operation for Auto Scaling.
//
// Terminates the specified instance and optionally adjusts the desired group
// size.
//
// This call simply makes a termination request. The instance is not terminated
// immediately.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation TerminateInstanceInAutoScalingGroup for usage and error information.
//
// Returned Error Codes:
//   * ScalingActivityInProgress
//   The operation can't be performed because there are scaling activities in
//   progress.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) TerminateInstanceInAutoScalingGroup(input *TerminateInstanceInAutoScalingGroupInput) (*TerminateInstanceInAutoScalingGroupOutput, error) {
	req, out := c.TerminateInstanceInAutoScalingGroupRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAutoScalingGroup = "UpdateAutoScalingGroup"

// UpdateAutoScalingGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAutoScalingGroup operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateAutoScalingGroup for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateAutoScalingGroup method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateAutoScalingGroupRequest method.
//    req, resp := client.UpdateAutoScalingGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *AutoScaling) UpdateAutoScalingGroupRequest(input *UpdateAutoScalingGroupInput) (req *request.Request, output *UpdateAutoScalingGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateAutoScalingGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAutoScalingGroupInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateAutoScalingGroupOutput{}
	req.Data = output
	return
}

// UpdateAutoScalingGroup API operation for Auto Scaling.
//
// Updates the configuration for the specified Auto Scaling group.
//
// To update an Auto Scaling group with a launch configuration with InstanceMonitoring
// set to False, you must first disable the collection of group metrics. Otherwise,
// you will get an error. If you have previously enabled the collection of group
// metrics, you can disable it using DisableMetricsCollection.
//
// The new settings are registered upon the completion of this call. Any launch
// configuration settings take effect on any triggers after this call returns.
// Scaling activities that are currently in progress aren't affected.
//
// Note the following:
//
//   If you specify a new value for MinSize without specifying a value for
// DesiredCapacity, and the new MinSize is larger than the current size of the
// group, we implicitly call SetDesiredCapacity to set the size of the group
// to the new value of MinSize.
//
//   If you specify a new value for MaxSize without specifying a value for
// DesiredCapacity, and the new MaxSize is smaller than the current size of
// the group, we implicitly call SetDesiredCapacity to set the size of the group
// to the new value of MaxSize.
//
//   All other optional parameters are left unchanged if not specified.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Auto Scaling's
// API operation UpdateAutoScalingGroup for usage and error information.
//
// Returned Error Codes:
//   * ScalingActivityInProgress
//   The operation can't be performed because there are scaling activities in
//   progress.
//
//   * ResourceContention
//   You already have a pending update to an Auto Scaling resource (for example,
//   a group, instance, or load balancer).
//
func (c *AutoScaling) UpdateAutoScalingGroup(input *UpdateAutoScalingGroupInput) (*UpdateAutoScalingGroupOutput, error) {
	req, out := c.UpdateAutoScalingGroupRequest(input)
	err := req.Send()
	return out, err
}

// Describes scaling activity, which is a long-running process that represents
// a change to your Auto Scaling group, such as changing its size or replacing
// an instance.
type Activity struct {
	_ struct{} `type:"structure"`

	// The ID of the activity.
	//
	// ActivityId is a required field
	ActivityId *string `type:"string" required:"true"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The reason the activity began.
	//
	// Cause is a required field
	Cause *string `min:"1" type:"string" required:"true"`

	// A friendly, more verbose description of the activity.
	Description *string `type:"string"`

	// The details about the activity.
	Details *string `type:"string"`

	// The end time of the activity.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// A value between 0 and 100 that indicates the progress of the activity.
	Progress *int64 `type:"integer"`

	// The start time of the activity.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The current status of the activity.
	//
	// StatusCode is a required field
	StatusCode *string `type:"string" required:"true" enum:"ScalingActivityStatusCode"`

	// A friendly, more verbose description of the activity status.
	StatusMessage *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Activity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Activity) GoString() string {
	return s.String()
}

// Describes a policy adjustment type.
//
// For more information, see Dynamic Scaling (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/as-scale-based-on-demand.html)
// in the Auto Scaling User Guide.
type AdjustmentType struct {
	_ struct{} `type:"structure"`

	// The policy adjustment type. The valid values are ChangeInCapacity, ExactCapacity,
	// and PercentChangeInCapacity.
	AdjustmentType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AdjustmentType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdjustmentType) GoString() string {
	return s.String()
}

// Describes an alarm.
type Alarm struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the alarm.
	AlarmARN *string `min:"1" type:"string"`

	// The name of the alarm.
	AlarmName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Alarm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Alarm) GoString() string {
	return s.String()
}

// Contains the parameters for AttachInstances.
type AttachInstancesInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more instance IDs.
	InstanceIds []*string `type:"list"`
}

// String returns the string representation
func (s AttachInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachInstancesInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AttachInstancesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachInstancesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for AttachLoadBalancerTargetGroups.
type AttachLoadBalancerTargetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Names (ARN) of the target groups.
	//
	// TargetGroupARNs is a required field
	TargetGroupARNs []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s AttachLoadBalancerTargetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachLoadBalancerTargetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachLoadBalancerTargetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachLoadBalancerTargetGroupsInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.TargetGroupARNs == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupARNs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type AttachLoadBalancerTargetGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachLoadBalancerTargetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachLoadBalancerTargetGroupsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for AttachLoadBalancers.
type AttachLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more load balancer names.
	//
	// LoadBalancerNames is a required field
	LoadBalancerNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s AttachLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachLoadBalancersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachLoadBalancersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachLoadBalancersInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.LoadBalancerNames == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of AttachLoadBalancers.
type AttachLoadBalancersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachLoadBalancersOutput) GoString() string {
	return s.String()
}

// Describes a block device mapping.
type BlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh).
	//
	// DeviceName is a required field
	DeviceName *string `min:"1" type:"string" required:"true"`

	// The information about the Amazon EBS volume.
	Ebs *Ebs `type:"structure"`

	// Suppresses a device mapping.
	//
	// If this parameter is true for the root device, the instance might fail the
	// EC2 health check. Auto Scaling launches a replacement instance if the instance
	// fails the health check.
	NoDevice *bool `type:"boolean"`

	// The name of the virtual device (for example, ephemeral0).
	VirtualName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s BlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockDeviceMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BlockDeviceMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BlockDeviceMapping"}
	if s.DeviceName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeviceName"))
	}
	if s.DeviceName != nil && len(*s.DeviceName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeviceName", 1))
	}
	if s.VirtualName != nil && len(*s.VirtualName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualName", 1))
	}
	if s.Ebs != nil {
		if err := s.Ebs.Validate(); err != nil {
			invalidParams.AddNested("Ebs", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the parameters for CompleteLifecycleAction.
type CompleteLifecycleActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the group for the lifecycle hook.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	InstanceId *string `min:"1" type:"string"`

	// The action for the group to take. This parameter can be either CONTINUE or
	// ABANDON.
	//
	// LifecycleActionResult is a required field
	LifecycleActionResult *string `type:"string" required:"true"`

	// A universally unique identifier (UUID) that identifies a specific lifecycle
	// action associated with an instance. Auto Scaling sends this token to the
	// notification target you specified when you created the lifecycle hook.
	LifecycleActionToken *string `min:"36" type:"string"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CompleteLifecycleActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteLifecycleActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CompleteLifecycleActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CompleteLifecycleActionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.LifecycleActionResult == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleActionResult"))
	}
	if s.LifecycleActionToken != nil && len(*s.LifecycleActionToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("LifecycleActionToken", 36))
	}
	if s.LifecycleHookName == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LifecycleHookName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of CompleteLifecycleAction.
type CompleteLifecycleActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CompleteLifecycleActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteLifecycleActionOutput) GoString() string {
	return s.String()
}

// Contains the parameters for CreateAutoScalingGroup.
type CreateAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group. This name must be unique within the scope of your
	// AWS account.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more Availability Zones for the group. This parameter is optional
	// if you specify one or more subnets.
	AvailabilityZones []*string `min:"1" type:"list"`

	// The amount of time, in seconds, after a scaling activity completes before
	// another scaling activity can start. The default is 300.
	//
	// For more information, see Auto Scaling Cooldowns (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/Cooldown.html)
	// in the Auto Scaling User Guide.
	DefaultCooldown *int64 `type:"integer"`

	// The number of EC2 instances that should be running in the group. This number
	// must be greater than or equal to the minimum size of the group and less than
	// or equal to the maximum size of the group.
	DesiredCapacity *int64 `type:"integer"`

	// The amount of time, in seconds, that Auto Scaling waits before checking the
	// health status of an EC2 instance that has come into service. During this
	// time, any health check failures for the instance are ignored. The default
	// is 0.
	//
	// This parameter is required if you are adding an ELB health check.
	//
	// For more information, see Health Checks (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/healthcheck.html)
	// in the Auto Scaling User Guide.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. The valid values are EC2 and ELB.
	//
	// By default, health checks use Amazon EC2 instance status checks to determine
	// the health of an instance. For more information, see Health Checks (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/healthcheck.html)
	// in the Auto Scaling User Guide.
	HealthCheckType *string `min:"1" type:"string"`

	// The ID of the instance used to create a launch configuration for the group.
	// Alternatively, specify a launch configuration instead of an EC2 instance.
	//
	// When you specify an ID of an instance, Auto Scaling creates a new launch
	// configuration and associates it with the group. This launch configuration
	// derives its attributes from the specified instance, with the exception of
	// the block device mapping.
	//
	// For more information, see Create an Auto Scaling Group Using an EC2 Instance
	// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/create-asg-from-instance.html)
	// in the Auto Scaling User Guide.
	InstanceId *string `min:"1" type:"string"`

	// The name of the launch configuration. Alternatively, specify an EC2 instance
	// instead of a launch configuration.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// One or more Classic load balancers. To specify an Application load balancer,
	// use TargetGroupARNs instead.
	//
	// For more information, see Using a Load Balancer With an Auto Scaling Group
	// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US_SetUpASLBApp.html)
	// in the Auto Scaling User Guide.
	LoadBalancerNames []*string `type:"list"`

	// The maximum size of the group.
	//
	// MaxSize is a required field
	MaxSize *int64 `type:"integer" required:"true"`

	// The minimum size of the group.
	//
	// MinSize is a required field
	MinSize *int64 `type:"integer" required:"true"`

	// Indicates whether newly launched instances are protected from termination
	// by Auto Scaling when scaling in.
	NewInstancesProtectedFromScaleIn *bool `type:"boolean"`

	// The name of the placement group into which you'll launch your instances,
	// if any. For more information, see Placement Groups (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	PlacementGroup *string `min:"1" type:"string"`

	// One or more tags.
	//
	// For more information, see Tagging Auto Scaling Groups and Instances (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/ASTagging.html)
	// in the Auto Scaling User Guide.
	Tags []*Tag `type:"list"`

	// The Amazon Resource Names (ARN) of the target groups.
	TargetGroupARNs []*string `type:"list"`

	// One or more termination policies used to select the instance to terminate.
	// These policies are executed in the order that they are listed.
	//
	// For more information, see Controlling Which Instances Auto Scaling Terminates
	// During Scale In (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingBehavior.InstanceTermination.html)
	// in the Auto Scaling User Guide.
	TerminationPolicies []*string `type:"list"`

	// A comma-separated list of subnet identifiers for your virtual private cloud
	// (VPC).
	//
	// If you specify subnets and Availability Zones with this call, ensure that
	// the subnets' Availability Zones match the Availability Zones specified.
	//
	// For more information, see Launching Auto Scaling Instances in a VPC (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/asg-in-vpc.html)
	// in the Auto Scaling User Guide.
	VPCZoneIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAutoScalingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAutoScalingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAutoScalingGroupInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.AvailabilityZones != nil && len(s.AvailabilityZones) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AvailabilityZones", 1))
	}
	if s.HealthCheckType != nil && len(*s.HealthCheckType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthCheckType", 1))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.LaunchConfigurationName != nil && len(*s.LaunchConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchConfigurationName", 1))
	}
	if s.MaxSize == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxSize"))
	}
	if s.MinSize == nil {
		invalidParams.Add(request.NewErrParamRequired("MinSize"))
	}
	if s.PlacementGroup != nil && len(*s.PlacementGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementGroup", 1))
	}
	if s.VPCZoneIdentifier != nil && len(*s.VPCZoneIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCZoneIdentifier", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAutoScalingGroupOutput) GoString() string {
	return s.String()
}

// Contains the parameters for CreateLaunchConfiguration.
type CreateLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Used for groups that launch instances into a virtual private cloud (VPC).
	// Specifies whether to assign a public IP address to each instance. For more
	// information, see Launching Auto Scaling Instances in a VPC (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/asg-in-vpc.html)
	// in the Auto Scaling User Guide.
	//
	// If you specify this parameter, be sure to specify at least one subnet when
	// you create your group.
	//
	// Default: If the instance is launched into a default subnet, the default
	// is true. If the instance is launched into a nondefault subnet, the default
	// is false. For more information, see Supported Platforms (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// One or more mappings that specify how block devices are exposed to the instance.
	// For more information, see Block Device Mapping (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	BlockDeviceMappings []*BlockDeviceMapping `type:"list"`

	// The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.
	// This parameter is supported only if you are launching EC2-Classic instances.
	// For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClassicLinkVPCId *string `min:"1" type:"string"`

	// The IDs of one or more security groups for the specified ClassicLink-enabled
	// VPC. This parameter is required if you specify a ClassicLink-enabled VPC,
	// and is not supported otherwise. For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClassicLinkVPCSecurityGroups []*string `type:"list"`

	// Indicates whether the instance is optimized for Amazon EBS I/O. By default,
	// the instance is not optimized for EBS I/O. The optimization provides dedicated
	// throughput to Amazon EBS and an optimized configuration stack to provide
	// optimal I/O performance. This optimization is not available with all instance
	// types. Additional usage charges apply. For more information, see Amazon EBS-Optimized
	// Instances (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	EbsOptimized *bool `type:"boolean"`

	// The name or the Amazon Resource Name (ARN) of the instance profile associated
	// with the IAM role for the instance.
	//
	// EC2 instances launched with an IAM role will automatically have AWS security
	// credentials available. You can use IAM roles with Auto Scaling to automatically
	// enable applications running on your EC2 instances to securely access other
	// AWS resources. For more information, see Launch Auto Scaling Instances with
	// an IAM Role (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/us-iam-role.html)
	// in the Auto Scaling User Guide.
	IamInstanceProfile *string `min:"1" type:"string"`

	// The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.
	// For more information, see Finding an AMI (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ImageId *string `min:"1" type:"string"`

	// The ID of the instance to use to create the launch configuration.
	//
	// The new launch configuration derives attributes from the instance, with
	// the exception of the block device mapping.
	//
	// To create a launch configuration with a block device mapping or override
	// any other instance attributes, specify them as part of the same request.
	//
	// For more information, see Create a Launch Configuration Using an EC2 Instance
	// (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/create-lc-with-instanceID.html)
	// in the Auto Scaling User Guide.
	InstanceId *string `min:"1" type:"string"`

	// Enables detailed monitoring (true) or basic monitoring (false) for the Auto
	// Scaling instances.
	InstanceMonitoring *InstanceMonitoring `type:"structure"`

	// The instance type of the EC2 instance. For information about available instance
	// types, see  Available Instance Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes)
	// in the Amazon Elastic Compute Cloud User Guide.
	InstanceType *string `min:"1" type:"string"`

	// The ID of the kernel associated with the AMI.
	KernelId *string `min:"1" type:"string"`

	// The name of the key pair. For more information, see Amazon EC2 Key Pairs
	// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in
	// the Amazon Elastic Compute Cloud User Guide.
	KeyName *string `min:"1" type:"string"`

	// The name of the launch configuration. This name must be unique within the
	// scope of your AWS account.
	//
	// LaunchConfigurationName is a required field
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`

	// The tenancy of the instance. An instance with a tenancy of dedicated runs
	// on single-tenant hardware and can only be launched into a VPC.
	//
	// You must set the value of this parameter to dedicated if want to launch
	// Dedicated Instances into a shared tenancy VPC (VPC with instance placement
	// tenancy attribute set to default).
	//
	// If you specify this parameter, be sure to specify at least one subnet when
	// you create your group.
	//
	// For more information, see Launching Auto Scaling Instances in a VPC (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/asg-in-vpc.html)
	// in the Auto Scaling User Guide.
	//
	// Valid values: default | dedicated
	PlacementTenancy *string `min:"1" type:"string"`

	// The ID of the RAM disk associated with the AMI.
	RamdiskId *string `min:"1" type:"string"`

	// One or more security groups with which to associate the instances.
	//
	// If your instances are launched in EC2-Classic, you can either specify security
	// group names or the security group IDs. For more information about security
	// groups for EC2-Classic, see Amazon EC2 Security Groups (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// If your instances are launched into a VPC, specify security group IDs. For
	// more information, see Security Groups for Your VPC (http://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
	// in the Amazon Virtual Private Cloud User Guide.
	SecurityGroups []*string `type:"list"`

	// The maximum hourly price to be paid for any Spot Instance launched to fulfill
	// the request. Spot Instances are launched when the price you specify exceeds
	// the current Spot market price. For more information, see Launching Spot Instances
	// in Your Auto Scaling Group (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US-SpotInstances.html)
	// in the Auto Scaling User Guide.
	SpotPrice *string `min:"1" type:"string"`

	// The user data to make available to the launched EC2 instances. For more information,
	// see Instance Metadata and User Data (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	UserData *string `type:"string"`
}

// String returns the string representation
func (s CreateLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLaunchConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLaunchConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLaunchConfigurationInput"}
	if s.ClassicLinkVPCId != nil && len(*s.ClassicLinkVPCId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClassicLinkVPCId", 1))
	}
	if s.IamInstanceProfile != nil && len(*s.IamInstanceProfile) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IamInstanceProfile", 1))
	}
	if s.ImageId != nil && len(*s.ImageId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageId", 1))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 1))
	}
	if s.KernelId != nil && len(*s.KernelId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KernelId", 1))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.LaunchConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchConfigurationName"))
	}
	if s.LaunchConfigurationName != nil && len(*s.LaunchConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchConfigurationName", 1))
	}
	if s.PlacementTenancy != nil && len(*s.PlacementTenancy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementTenancy", 1))
	}
	if s.RamdiskId != nil && len(*s.RamdiskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RamdiskId", 1))
	}
	if s.SpotPrice != nil && len(*s.SpotPrice) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SpotPrice", 1))
	}
	if s.BlockDeviceMappings != nil {
		for i, v := range s.BlockDeviceMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "BlockDeviceMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLaunchConfigurationOutput) GoString() string {
	return s.String()
}

// Contains the parameters for CreateOrUpdateTags.
type CreateOrUpdateTagsInput struct {
	_ struct{} `type:"structure"`

	// One or more tags.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateOrUpdateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrUpdateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOrUpdateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOrUpdateTagsInput"}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateOrUpdateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateOrUpdateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOrUpdateTagsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteAutoScalingGroup.
type DeleteAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the group to delete.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// Specifies that the group will be deleted along with all instances associated
	// with the group, without waiting for all instances to be terminated. This
	// parameter also deletes any lifecycle actions associated with the group.
	ForceDelete *bool `type:"boolean"`
}

// String returns the string representation
func (s DeleteAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAutoScalingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAutoScalingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAutoScalingGroupInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAutoScalingGroupOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteLaunchConfiguration.
type DeleteLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the launch configuration.
	//
	// LaunchConfigurationName is a required field
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLaunchConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLaunchConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLaunchConfigurationInput"}
	if s.LaunchConfigurationName == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchConfigurationName"))
	}
	if s.LaunchConfigurationName != nil && len(*s.LaunchConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchConfigurationName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLaunchConfigurationOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteLifecycleHook.
type DeleteLifecycleHookInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group for the lifecycle hook.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLifecycleHookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLifecycleHookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLifecycleHookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLifecycleHookInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.LifecycleHookName == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LifecycleHookName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DeleteLifecycleHook.
type DeleteLifecycleHookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLifecycleHookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLifecycleHookOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteNotificationConfiguration.
type DeleteNotificationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic.
	//
	// TopicARN is a required field
	TopicARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotificationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNotificationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNotificationConfigurationInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.TopicARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicARN"))
	}
	if s.TopicARN != nil && len(*s.TopicARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNotificationConfigurationOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeletePolicy.
type DeletePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The name or Amazon Resource Name (ARN) of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePolicyInput"}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeletePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePolicyOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteScheduledAction.
type DeleteScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The name of the action to delete.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduledActionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledActionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteScheduledActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteScheduledActionOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DeleteTags.
type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// One or more tags.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DescribeAccountLimitsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountLimitsInput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeAccountLimits.
type DescribeAccountLimitsOutput struct {
	_ struct{} `type:"structure"`

	// The maximum number of groups allowed for your AWS account. The default limit
	// is 20 per region.
	MaxNumberOfAutoScalingGroups *int64 `type:"integer"`

	// The maximum number of launch configurations allowed for your AWS account.
	// The default limit is 100 per region.
	MaxNumberOfLaunchConfigurations *int64 `type:"integer"`

	// The current number of groups for your AWS account.
	NumberOfAutoScalingGroups *int64 `type:"integer"`

	// The current number of launch configurations for your AWS account.
	NumberOfLaunchConfigurations *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeAccountLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountLimitsOutput) GoString() string {
	return s.String()
}

type DescribeAdjustmentTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAdjustmentTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAdjustmentTypesInput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeAdjustmentTypes.
type DescribeAdjustmentTypesOutput struct {
	_ struct{} `type:"structure"`

	// The policy adjustment types.
	AdjustmentTypes []*AdjustmentType `type:"list"`
}

// String returns the string representation
func (s DescribeAdjustmentTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAdjustmentTypesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeAutoScalingGroups.
type DescribeAutoScalingGroupsInput struct {
	_ struct{} `type:"structure"`

	// The group names. If you omit this parameter, all Auto Scaling groups are
	// described.
	AutoScalingGroupNames []*string `type:"list"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAutoScalingGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoScalingGroupsInput) GoString() string {
	return s.String()
}

// Contains the output for DescribeAutoScalingGroups.
type DescribeAutoScalingGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The groups.
	//
	// AutoScalingGroups is a required field
	AutoScalingGroups []*Group `type:"list" required:"true"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAutoScalingGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoScalingGroupsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeAutoScalingInstances.
type DescribeAutoScalingInstancesInput struct {
	_ struct{} `type:"structure"`

	// The instances to describe; up to 50 instance IDs. If you omit this parameter,
	// all Auto Scaling instances are described. If you specify an ID that does
	// not exist, it is ignored with no error.
	InstanceIds []*string `type:"list"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAutoScalingInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoScalingInstancesInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeAutoScalingInstances.
type DescribeAutoScalingInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The instances.
	AutoScalingInstances []*InstanceDetails `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeAutoScalingInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoScalingInstancesOutput) GoString() string {
	return s.String()
}

type DescribeAutoScalingNotificationTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAutoScalingNotificationTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoScalingNotificationTypesInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeAutoScalingNotificationTypes.
type DescribeAutoScalingNotificationTypesOutput struct {
	_ struct{} `type:"structure"`

	// The notification types.
	AutoScalingNotificationTypes []*string `type:"list"`
}

// String returns the string representation
func (s DescribeAutoScalingNotificationTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAutoScalingNotificationTypesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeLaunchConfigurations.
type DescribeLaunchConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The launch configuration names. If you omit this parameter, all launch configurations
	// are described.
	LaunchConfigurationNames []*string `type:"list"`

	// The maximum number of items to return with this call. The default is 100.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLaunchConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLaunchConfigurationsInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeLaunchConfigurations.
type DescribeLaunchConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The launch configurations.
	//
	// LaunchConfigurations is a required field
	LaunchConfigurations []*LaunchConfiguration `type:"list" required:"true"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLaunchConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLaunchConfigurationsOutput) GoString() string {
	return s.String()
}

type DescribeLifecycleHookTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeLifecycleHookTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLifecycleHookTypesInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeLifecycleHookTypes.
type DescribeLifecycleHookTypesOutput struct {
	_ struct{} `type:"structure"`

	// The lifecycle hook types.
	LifecycleHookTypes []*string `type:"list"`
}

// String returns the string representation
func (s DescribeLifecycleHookTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLifecycleHookTypesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeLifecycleHooks.
type DescribeLifecycleHooksInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The names of one or more lifecycle hooks. If you omit this parameter, all
	// lifecycle hooks are described.
	LifecycleHookNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeLifecycleHooksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLifecycleHooksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLifecycleHooksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLifecycleHooksInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeLifecycleHooks.
type DescribeLifecycleHooksOutput struct {
	_ struct{} `type:"structure"`

	// The lifecycle hooks for the specified group.
	LifecycleHooks []*LifecycleHook `type:"list"`
}

// String returns the string representation
func (s DescribeLifecycleHooksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLifecycleHooksOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeLoadBalancerTargetGroups.
type DescribeLoadBalancerTargetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLoadBalancerTargetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancerTargetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoadBalancerTargetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLoadBalancerTargetGroupsInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeLoadBalancerTargetGroups.
type DescribeLoadBalancerTargetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the target groups.
	LoadBalancerTargetGroups []*LoadBalancerTargetGroupState `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLoadBalancerTargetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancerTargetGroupsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeLoadBalancers.
type DescribeLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoadBalancersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLoadBalancersInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeLoadBalancers.
type DescribeLoadBalancersOutput struct {
	_ struct{} `type:"structure"`

	// The load balancers.
	LoadBalancers []*LoadBalancerState `type:"list"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBalancersOutput) GoString() string {
	return s.String()
}

type DescribeMetricCollectionTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeMetricCollectionTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMetricCollectionTypesInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeMetricsCollectionTypes.
type DescribeMetricCollectionTypesOutput struct {
	_ struct{} `type:"structure"`

	// The granularities for the metrics.
	Granularities []*MetricGranularityType `type:"list"`

	// One or more metrics.
	Metrics []*MetricCollectionType `type:"list"`
}

// String returns the string representation
func (s DescribeMetricCollectionTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMetricCollectionTypesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeNotificationConfigurations.
type DescribeNotificationConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupNames []*string `type:"list"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeNotificationConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotificationConfigurationsInput) GoString() string {
	return s.String()
}

// Contains the output from DescribeNotificationConfigurations.
type DescribeNotificationConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// The notification configurations.
	//
	// NotificationConfigurations is a required field
	NotificationConfigurations []*NotificationConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeNotificationConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNotificationConfigurationsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribePolicies.
type DescribePoliciesInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The maximum number of items to be returned with each call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// One or more policy names or policy ARNs to be described. If you omit this
	// parameter, all policy names are described. If an group name is provided,
	// the results are limited to that group. This list is limited to 50 items.
	// If you specify an unknown policy name, it is ignored with no error.
	PolicyNames []*string `type:"list"`

	// One or more policy types. Valid values are SimpleScaling and StepScaling.
	PolicyTypes []*string `type:"list"`
}

// String returns the string representation
func (s DescribePoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePoliciesInput"}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribePolicies.
type DescribePoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// The scaling policies.
	ScalingPolicies []*ScalingPolicy `type:"list"`
}

// String returns the string representation
func (s DescribePoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePoliciesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeScalingActivities.
type DescribeScalingActivitiesInput struct {
	_ struct{} `type:"structure"`

	// The activity IDs of the desired scaling activities. If you omit this parameter,
	// all activities for the past six weeks are described. If you specify an Auto
	// Scaling group, the results are limited to that group. The list of requested
	// activities cannot contain more than 50 items. If unknown activities are requested,
	// they are ignored with no error.
	ActivityIds []*string `type:"list"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeScalingActivitiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingActivitiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScalingActivitiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScalingActivitiesInput"}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeScalingActivities.
type DescribeScalingActivitiesOutput struct {
	_ struct{} `type:"structure"`

	// The scaling activities. Activities are sorted by start time. Activities still
	// in progress are described first.
	//
	// Activities is a required field
	Activities []*Activity `type:"list" required:"true"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeScalingActivitiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingActivitiesOutput) GoString() string {
	return s.String()
}

type DescribeScalingProcessTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeScalingProcessTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingProcessTypesInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeScalingProcessTypes.
type DescribeScalingProcessTypesOutput struct {
	_ struct{} `type:"structure"`

	// The names of the process types.
	Processes []*ProcessType `type:"list"`
}

// String returns the string representation
func (s DescribeScalingProcessTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScalingProcessTypesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeScheduledActions.
type DescribeScheduledActionsInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The latest scheduled start time to return. If scheduled action names are
	// provided, this parameter is ignored.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`

	// Describes one or more scheduled actions. If you omit this parameter, all
	// scheduled actions are described. If you specify an unknown scheduled action,
	// it is ignored with no error.
	//
	// You can describe up to a maximum of 50 instances with a single call. If
	// there are more items to return, the call returns a token. To get the next
	// set of items, repeat the call with the returned token.
	ScheduledActionNames []*string `type:"list"`

	// The earliest scheduled start time to return. If scheduled action names are
	// provided, this parameter is ignored.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s DescribeScheduledActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScheduledActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeScheduledActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeScheduledActionsInput"}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DescribeScheduledActions.
type DescribeScheduledActionsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// The scheduled actions.
	ScheduledUpdateGroupActions []*ScheduledUpdateGroupAction `type:"list"`
}

// String returns the string representation
func (s DescribeScheduledActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeScheduledActionsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DescribeTags.
type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// A filter used to scope the tags to return.
	Filters []*Filter `type:"list"`

	// The maximum number of items to return with this call.
	MaxRecords *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeTags.
type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `type:"string"`

	// One or more tags.
	Tags []*TagDescription `type:"list"`
}

// String returns the string representation
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

type DescribeTerminationPolicyTypesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeTerminationPolicyTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTerminationPolicyTypesInput) GoString() string {
	return s.String()
}

// Contains the output of DescribeTerminationPolicyTypes.
type DescribeTerminationPolicyTypesOutput struct {
	_ struct{} `type:"structure"`

	// The termination policies supported by Auto Scaling (OldestInstance, OldestLaunchConfiguration,
	// NewestInstance, ClosestToNextInstanceHour, and Default).
	TerminationPolicyTypes []*string `type:"list"`
}

// String returns the string representation
func (s DescribeTerminationPolicyTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTerminationPolicyTypesOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DetachInstances.
type DetachInstancesInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more instance IDs.
	InstanceIds []*string `type:"list"`

	// If True, the Auto Scaling group decrements the desired capacity value by
	// the number of instances detached.
	//
	// ShouldDecrementDesiredCapacity is a required field
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s DetachInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachInstancesInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.ShouldDecrementDesiredCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("ShouldDecrementDesiredCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of DetachInstances.
type DetachInstancesOutput struct {
	_ struct{} `type:"structure"`

	// The activities related to detaching the instances from the Auto Scaling group.
	Activities []*Activity `type:"list"`
}

// String returns the string representation
func (s DetachInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachInstancesOutput) GoString() string {
	return s.String()
}

type DetachLoadBalancerTargetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Names (ARN) of the target groups.
	//
	// TargetGroupARNs is a required field
	TargetGroupARNs []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DetachLoadBalancerTargetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachLoadBalancerTargetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachLoadBalancerTargetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachLoadBalancerTargetGroupsInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.TargetGroupARNs == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetGroupARNs"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DetachLoadBalancerTargetGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachLoadBalancerTargetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachLoadBalancerTargetGroupsOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DetachLoadBalancers.
type DetachLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more load balancer names.
	//
	// LoadBalancerNames is a required field
	LoadBalancerNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DetachLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachLoadBalancersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachLoadBalancersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachLoadBalancersInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.LoadBalancerNames == nil {
		invalidParams.Add(request.NewErrParamRequired("LoadBalancerNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output for DetachLoadBalancers.
type DetachLoadBalancersOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachLoadBalancersOutput) GoString() string {
	return s.String()
}

// Contains the parameters for DisableMetricsCollection.
type DisableMetricsCollectionInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more of the following metrics. If you omit this parameter, all metrics
	// are disabled.
	//
	//    GroupMinSize
	//
	//    GroupMaxSize
	//
	//    GroupDesiredCapacity
	//
	//    GroupInServiceInstances
	//
	//    GroupPendingInstances
	//
	//    GroupStandbyInstances
	//
	//    GroupTerminatingInstances
	//
	//    GroupTotalInstances
	Metrics []*string `type:"list"`
}

// String returns the string representation
func (s DisableMetricsCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableMetricsCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableMetricsCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableMetricsCollectionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisableMetricsCollectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableMetricsCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableMetricsCollectionOutput) GoString() string {
	return s.String()
}

// Describes an Amazon EBS volume.
type Ebs struct {
	_ struct{} `type:"structure"`

	// Indicates whether the volume is deleted on instance termination.
	//
	// Default: true
	DeleteOnTermination *bool `type:"boolean"`

	// Indicates whether the volume should be encrypted. Encrypted EBS volumes must
	// be attached to instances that support Amazon EBS encryption. Volumes that
	// are created from encrypted snapshots are automatically encrypted. There is
	// no way to create an encrypted volume from an unencrypted snapshot or an unencrypted
	// volume from an encrypted snapshot. For more information, see Amazon EBS Encryption
	// (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html) in
	// the Amazon Elastic Compute Cloud User Guide.
	Encrypted *bool `type:"boolean"`

	// The number of I/O operations per second (IOPS) to provision for the volume.
	//
	// Constraint: Required when the volume type is io1.
	Iops *int64 `min:"100" type:"integer"`

	// The ID of the snapshot.
	SnapshotId *string `min:"1" type:"string"`

	// The volume size, in GiB. For standard volumes, specify a value from 1 to
	// 1,024. For io1 volumes, specify a value from 4 to 16,384. For gp2 volumes,
	// specify a value from 1 to 16,384. If you specify a snapshot, the volume size
	// must be equal to or larger than the snapshot size.
	//
	// Default: If you create a volume from a snapshot and you don't specify a
	// volume size, the default is the snapshot size.
	VolumeSize *int64 `min:"1" type:"integer"`

	// The volume type. For more information, see Amazon EBS Volume Types (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	//
	// Valid values: standard | io1 | gp2
	//
	// Default: standard
	VolumeType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Ebs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Ebs) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ebs) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ebs"}
	if s.Iops != nil && *s.Iops < 100 {
		invalidParams.Add(request.NewErrParamMinValue("Iops", 100))
	}
	if s.SnapshotId != nil && len(*s.SnapshotId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotId", 1))
	}
	if s.VolumeSize != nil && *s.VolumeSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("VolumeSize", 1))
	}
	if s.VolumeType != nil && len(*s.VolumeType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VolumeType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the parameters for EnableMetricsCollection.
type EnableMetricsCollectionInput struct {
	_ struct{} `type:"structure"`

	// The name or ARN of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The granularity to associate with the metrics to collect. The only valid
	// value is 1Minute.
	//
	// Granularity is a required field
	Granularity *string `min:"1" type:"string" required:"true"`

	// One or more of the following metrics. If you omit this parameter, all metrics
	// are enabled.
	//
	//    GroupMinSize
	//
	//    GroupMaxSize
	//
	//    GroupDesiredCapacity
	//
	//    GroupInServiceInstances
	//
	//    GroupPendingInstances
	//
	//    GroupStandbyInstances
	//
	//    GroupTerminatingInstances
	//
	//    GroupTotalInstances
	Metrics []*string `type:"list"`
}

// String returns the string representation
func (s EnableMetricsCollectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableMetricsCollectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableMetricsCollectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableMetricsCollectionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.Granularity == nil {
		invalidParams.Add(request.NewErrParamRequired("Granularity"))
	}
	if s.Granularity != nil && len(*s.Granularity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Granularity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EnableMetricsCollectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableMetricsCollectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableMetricsCollectionOutput) GoString() string {
	return s.String()
}

// Describes an enabled metric.
type EnabledMetric struct {
	_ struct{} `type:"structure"`

	// The granularity of the metric. The only valid value is 1Minute.
	Granularity *string `min:"1" type:"string"`

	// One of the following metrics:
	//
	//    GroupMinSize
	//
	//    GroupMaxSize
	//
	//    GroupDesiredCapacity
	//
	//    GroupInServiceInstances
	//
	//    GroupPendingInstances
	//
	//    GroupStandbyInstances
	//
	//    GroupTerminatingInstances
	//
	//    GroupTotalInstances
	Metric *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EnabledMetric) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnabledMetric) GoString() string {
	return s.String()
}

// Contains the parameters for EnteStandby.
type EnterStandbyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more instances to move into Standby mode. You must specify at least
	// one instance ID.
	InstanceIds []*string `type:"list"`

	// Specifies whether the instances moved to Standby mode count as part of the
	// Auto Scaling group's desired capacity. If set, the desired capacity for the
	// Auto Scaling group decrements by the number of instances moved to Standby
	// mode.
	//
	// ShouldDecrementDesiredCapacity is a required field
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s EnterStandbyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnterStandbyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnterStandbyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnterStandbyInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.ShouldDecrementDesiredCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("ShouldDecrementDesiredCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of EnterStandby.
type EnterStandbyOutput struct {
	_ struct{} `type:"structure"`

	// The activities related to moving instances into Standby mode.
	Activities []*Activity `type:"list"`
}

// String returns the string representation
func (s EnterStandbyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnterStandbyOutput) GoString() string {
	return s.String()
}

// Contains the parameters for ExecutePolicy.
type ExecutePolicyInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The breach threshold for the alarm.
	//
	// This parameter is required if the policy type is StepScaling and not supported
	// otherwise.
	BreachThreshold *float64 `type:"double"`

	// If this parameter is true, Auto Scaling waits for the cooldown period to
	// complete before executing the policy. Otherwise, Auto Scaling executes the
	// policy without waiting for the cooldown period to complete.
	//
	// This parameter is not supported if the policy type is StepScaling.
	//
	// For more information, see Auto Scaling Cooldowns (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/Cooldown.html)
	// in the Auto Scaling User Guide.
	HonorCooldown *bool `type:"boolean"`

	// The metric value to compare to BreachThreshold. This enables you to execute
	// a policy of type StepScaling and determine which step adjustment to use.
	// For example, if the breach threshold is 50 and you want to use a step adjustment
	// with a lower bound of 0 and an upper bound of 10, you can set the metric
	// value to 59.
	//
	// If you specify a metric value that doesn't correspond to a step adjustment
	// for the policy, the call returns an error.
	//
	// This parameter is required if the policy type is StepScaling and not supported
	// otherwise.
	MetricValue *float64 `type:"double"`

	// The name or ARN of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ExecutePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExecutePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExecutePolicyInput"}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ExecutePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ExecutePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutePolicyOutput) GoString() string {
	return s.String()
}

// Contains the parameters for ExitStandby.
type ExitStandbyInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more instance IDs. You must specify at least one instance ID.
	InstanceIds []*string `type:"list"`
}

// String returns the string representation
func (s ExitStandbyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExitStandbyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExitStandbyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExitStandbyInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the parameters for ExitStandby.
type ExitStandbyOutput struct {
	_ struct{} `type:"structure"`

	// The activities related to moving instances out of Standby mode.
	Activities []*Activity `type:"list"`
}

// String returns the string representation
func (s ExitStandbyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExitStandbyOutput) GoString() string {
	return s.String()
}

// Describes a filter.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter. The valid values are: "auto-scaling-group", "key",
	// "value", and "propagate-at-launch".
	Name *string `type:"string"`

	// The value of the filter.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Describes an Auto Scaling group.
type Group struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the group.
	AutoScalingGroupARN *string `min:"1" type:"string"`

	// The name of the group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more Availability Zones for the group.
	//
	// AvailabilityZones is a required field
	AvailabilityZones []*string `min:"1" type:"list" required:"true"`

	// The date and time the group was created.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The amount of time, in seconds, after a scaling activity completes before
	// another scaling activity can start.
	//
	// DefaultCooldown is a required field
	DefaultCooldown *int64 `type:"integer" required:"true"`

	// The desired size of the group.
	//
	// DesiredCapacity is a required field
	DesiredCapacity *int64 `type:"integer" required:"true"`

	// The metrics enabled for the group.
	EnabledMetrics []*EnabledMetric `type:"list"`

	// The amount of time, in seconds, that Auto Scaling waits before checking the
	// health status of an EC2 instance that has come into service.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. The valid values are EC2 and ELB.
	//
	// HealthCheckType is a required field
	HealthCheckType *string `min:"1" type:"string" required:"true"`

	// The EC2 instances associated with the group.
	Instances []*Instance `type:"list"`

	// The name of the associated launch configuration.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// One or more load balancers associated with the group.
	LoadBalancerNames []*string `type:"list"`

	// The maximum size of the group.
	//
	// MaxSize is a required field
	MaxSize *int64 `type:"integer" required:"true"`

	// The minimum size of the group.
	//
	// MinSize is a required field
	MinSize *int64 `type:"integer" required:"true"`

	// Indicates whether newly launched instances are protected from termination
	// by Auto Scaling when scaling in.
	NewInstancesProtectedFromScaleIn *bool `type:"boolean"`

	// The name of the placement group into which you'll launch your instances,
	// if any. For more information, see Placement Groups (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	PlacementGroup *string `min:"1" type:"string"`

	// The current state of the group when DeleteAutoScalingGroup is in progress.
	Status *string `min:"1" type:"string"`

	// The suspended processes associated with the group.
	SuspendedProcesses []*SuspendedProcess `type:"list"`

	// The tags for the group.
	Tags []*TagDescription `type:"list"`

	// The Amazon Resource Names (ARN) of the target groups for your load balancer.
	TargetGroupARNs []*string `type:"list"`

	// The termination policies for the group.
	TerminationPolicies []*string `type:"list"`

	// One or more subnet IDs, if applicable, separated by commas.
	//
	// If you specify VPCZoneIdentifier and AvailabilityZones, ensure that the
	// Availability Zones of the subnets match the values for AvailabilityZones.
	VPCZoneIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Group) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Group) GoString() string {
	return s.String()
}

// Describes an EC2 instance.
type Instance struct {
	_ struct{} `type:"structure"`

	// The Availability Zone in which the instance is running.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `min:"1" type:"string" required:"true"`

	// The last reported health status of the instance. "Healthy" means that the
	// instance is healthy and should remain in service. "Unhealthy" means that
	// the instance is unhealthy and Auto Scaling should terminate and replace it.
	//
	// HealthStatus is a required field
	HealthStatus *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The launch configuration associated with the instance.
	//
	// LaunchConfigurationName is a required field
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`

	// A description of the current lifecycle state. Note that the Quarantined state
	// is not used.
	//
	// LifecycleState is a required field
	LifecycleState *string `type:"string" required:"true" enum:"LifecycleState"`

	// Indicates whether the instance is protected from termination by Auto Scaling
	// when scaling in.
	//
	// ProtectedFromScaleIn is a required field
	ProtectedFromScaleIn *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// Describes an EC2 instance associated with an Auto Scaling group.
type InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group associated with the instance.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The Availability Zone for the instance.
	//
	// AvailabilityZone is a required field
	AvailabilityZone *string `min:"1" type:"string" required:"true"`

	// The last reported health status of this instance. "Healthy" means that the
	// instance is healthy and should remain in service. "Unhealthy" means that
	// the instance is unhealthy and Auto Scaling should terminate and replace it.
	//
	// HealthStatus is a required field
	HealthStatus *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The launch configuration associated with the instance.
	//
	// LaunchConfigurationName is a required field
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`

	// The lifecycle state for the instance. For more information, see Auto Scaling
	// Lifecycle (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroupLifecycle.html)
	// in the Auto Scaling User Guide.
	//
	// LifecycleState is a required field
	LifecycleState *string `min:"1" type:"string" required:"true"`

	// Indicates whether the instance is protected from termination by Auto Scaling
	// when scaling in.
	//
	// ProtectedFromScaleIn is a required field
	ProtectedFromScaleIn *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceDetails) GoString() string {
	return s.String()
}

// Describes whether instance monitoring is enabled.
type InstanceMonitoring struct {
	_ struct{} `type:"structure"`

	// If True, instance monitoring is enabled.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s InstanceMonitoring) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceMonitoring) GoString() string {
	return s.String()
}

// Describes a launch configuration.
type LaunchConfiguration struct {
	_ struct{} `type:"structure"`

	// [EC2-VPC] Indicates whether to assign a public IP address to each instance.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// A block device mapping, which specifies the block devices for the instance.
	BlockDeviceMappings []*BlockDeviceMapping `type:"list"`

	// The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to.
	// This parameter can only be used if you are launching EC2-Classic instances.
	// For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClassicLinkVPCId *string `min:"1" type:"string"`

	// The IDs of one or more security groups for the VPC specified in ClassicLinkVPCId.
	// This parameter is required if you specify a ClassicLink-enabled VPC, and
	// cannot be used otherwise. For more information, see ClassicLink (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	ClassicLinkVPCSecurityGroups []*string `type:"list"`

	// The creation date and time for the launch configuration.
	//
	// CreatedTime is a required field
	CreatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// Controls whether the instance is optimized for EBS I/O (true) or not (false).
	EbsOptimized *bool `type:"boolean"`

	// The name or Amazon Resource Name (ARN) of the instance profile associated
	// with the IAM role for the instance.
	IamInstanceProfile *string `min:"1" type:"string"`

	// The ID of the Amazon Machine Image (AMI).
	//
	// ImageId is a required field
	ImageId *string `min:"1" type:"string" required:"true"`

	// Controls whether instances in this group are launched with detailed (true)
	// or basic (false) monitoring.
	InstanceMonitoring *InstanceMonitoring `type:"structure"`

	// The instance type for the instances.
	//
	// InstanceType is a required field
	InstanceType *string `min:"1" type:"string" required:"true"`

	// The ID of the kernel associated with the AMI.
	KernelId *string `min:"1" type:"string"`

	// The name of the key pair.
	KeyName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the launch configuration.
	LaunchConfigurationARN *string `min:"1" type:"string"`

	// The name of the launch configuration.
	//
	// LaunchConfigurationName is a required field
	LaunchConfigurationName *string `min:"1" type:"string" required:"true"`

	// The tenancy of the instance, either default or dedicated. An instance with
	// dedicated tenancy runs in an isolated, single-tenant hardware and can only
	// be launched into a VPC.
	PlacementTenancy *string `min:"1" type:"string"`

	// The ID of the RAM disk associated with the AMI.
	RamdiskId *string `min:"1" type:"string"`

	// The security groups to associate with the instances.
	SecurityGroups []*string `type:"list"`

	// The price to bid when launching Spot Instances.
	SpotPrice *string `min:"1" type:"string"`

	// The user data available to the instances.
	UserData *string `type:"string"`
}

// String returns the string representation
func (s LaunchConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchConfiguration) GoString() string {
	return s.String()
}

// Describes a lifecycle hook, which tells Auto Scaling that you want to perform
// an action when an instance launches or terminates. When you have a lifecycle
// hook in place, the Auto Scaling group will either:
//
//   Pause the instance after it launches, but before it is put into service
//
//   Pause the instance as it terminates, but before it is fully terminated
//
//   For more information, see Auto Scaling Lifecycle (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingGroupLifecycle.html)
// in the Auto Scaling User Guide.
type LifecycleHook struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group for the lifecycle hook.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// Defines the action the Auto Scaling group should take when the lifecycle
	// hook timeout elapses or if an unexpected failure occurs. The valid values
	// are CONTINUE and ABANDON. The default value is CONTINUE.
	DefaultResult *string `type:"string"`

	// The maximum time, in seconds, that an instance can remain in a Pending:Wait
	// or Terminating:Wait state. The default is 172800 seconds (48 hours).
	GlobalTimeout *int64 `type:"integer"`

	// The maximum time, in seconds, that can elapse before the lifecycle hook times
	// out. The default is 3600 seconds (1 hour). When the lifecycle hook times
	// out, Auto Scaling performs the default action. You can prevent the lifecycle
	// hook from timing out by calling RecordLifecycleActionHeartbeat.
	HeartbeatTimeout *int64 `type:"integer"`

	// The name of the lifecycle hook.
	LifecycleHookName *string `min:"1" type:"string"`

	// The state of the EC2 instance to which you want to attach the lifecycle hook.
	// For a list of lifecycle hook types, see DescribeLifecycleHookTypes.
	LifecycleTransition *string `type:"string"`

	// Additional information that you want to include any time Auto Scaling sends
	// a message to the notification target.
	NotificationMetadata *string `min:"1" type:"string"`

	// The ARN of the notification target that Auto Scaling uses to notify you when
	// an instance is in the transition state for the lifecycle hook. This ARN target
	// can be either an SQS queue or an SNS topic. The notification message sent
	// to the target includes the following:
	//
	//   Lifecycle action token
	//
	//   User account ID
	//
	//   Name of the Auto Scaling group
	//
	//   Lifecycle hook name
	//
	//   EC2 instance ID
	//
	//   Lifecycle transition
	//
	//   Notification metadata
	NotificationTargetARN *string `min:"1" type:"string"`

	// The ARN of the IAM role that allows the Auto Scaling group to publish to
	// the specified notification target.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LifecycleHook) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleHook) GoString() string {
	return s.String()
}

// Describes the state of a Classic load balancer.
//
// If you specify a load balancer when creating the Auto Scaling group, the
// state of the load balancer is InService.
//
// If you attach a load balancer to an existing Auto Scaling group, the initial
// state is Adding. The state transitions to Added after all instances in the
// group are registered with the load balancer. If ELB health checks are enabled
// for the load balancer, the state transitions to InService after at least
// one instance in the group passes the health check. If EC2 health checks are
// enabled instead, the load balancer remains in the Added state.
type LoadBalancerState struct {
	_ struct{} `type:"structure"`

	// The name of the load balancer.
	LoadBalancerName *string `min:"1" type:"string"`

	// One of the following load balancer states:
	//
	//    Adding - The instances in the group are being registered with the load
	// balancer.
	//
	//    Added - All instances in the group are registered with the load balancer.
	//
	//    InService - At least one instance in the group passed an ELB health check.
	//
	//    Removing - The instances in the group are being deregistered from the
	// load balancer. If connection draining is enabled, Elastic Load Balancing
	// waits for in-flight requests to complete before deregistering the instances.
	//
	//    Removed - All instances in the group are deregistered from the load balancer.
	State *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LoadBalancerState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerState) GoString() string {
	return s.String()
}

// Describes the state of a target group.
//
// If you attach a target group to an existing Auto Scaling group, the initial
// state is Adding. The state transitions to Added after all Auto Scaling instances
// are registered with the target group. If ELB health checks are enabled, the
// state transitions to InService after at least one Auto Scaling instance passes
// the health check. If EC2 health checks are enabled instead, the target group
// remains in the Added state.
type LoadBalancerTargetGroupState struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	LoadBalancerTargetGroupARN *string `min:"1" type:"string"`

	// The state of the target group.
	//
	//    Adding - The Auto Scaling instances are being registered with the target
	// group.
	//
	//    Added - All Auto Scaling instances are registered with the target group.
	//
	//    InService - At least one Auto Scaling instance passed an ELB health check.
	//
	//    Removing - The Auto Scaling instances are being deregistered from the
	// target group. If connection draining is enabled, Elastic Load Balancing waits
	// for in-flight requests to complete before deregistering the instances.
	//
	//    Removed - All Auto Scaling instances are deregistered from the target
	// group.
	State *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LoadBalancerTargetGroupState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBalancerTargetGroupState) GoString() string {
	return s.String()
}

// Describes a metric.
type MetricCollectionType struct {
	_ struct{} `type:"structure"`

	// One of the following metrics:
	//
	//    GroupMinSize
	//
	//    GroupMaxSize
	//
	//    GroupDesiredCapacity
	//
	//    GroupInServiceInstances
	//
	//    GroupPendingInstances
	//
	//    GroupStandbyInstances
	//
	//    GroupTerminatingInstances
	//
	//    GroupTotalInstances
	Metric *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MetricCollectionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricCollectionType) GoString() string {
	return s.String()
}

// Describes a granularity of a metric.
type MetricGranularityType struct {
	_ struct{} `type:"structure"`

	// The granularity. The only valid value is 1Minute.
	Granularity *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MetricGranularityType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MetricGranularityType) GoString() string {
	return s.String()
}

// Describes a notification.
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// One of the following event notification types:
	//
	//    autoscaling:EC2_INSTANCE_LAUNCH
	//
	//    autoscaling:EC2_INSTANCE_LAUNCH_ERROR
	//
	//    autoscaling:EC2_INSTANCE_TERMINATE
	//
	//    autoscaling:EC2_INSTANCE_TERMINATE_ERROR
	//
	//    autoscaling:TEST_NOTIFICATION
	NotificationType *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic.
	TopicARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfiguration) GoString() string {
	return s.String()
}

// Describes a process type.
//
// For more information, see Auto Scaling Processes (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/US_SuspendResume.html#process-types)
// in the Auto Scaling User Guide.
type ProcessType struct {
	_ struct{} `type:"structure"`

	// One of the following processes:
	//
	//    Launch
	//
	//    Terminate
	//
	//    AddToLoadBalancer
	//
	//    AlarmNotification
	//
	//    AZRebalance
	//
	//    HealthCheck
	//
	//    ReplaceUnhealthy
	//
	//    ScheduledActions
	//
	// ProcessName is a required field
	ProcessName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ProcessType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProcessType) GoString() string {
	return s.String()
}

// Contains the parameters for PutLifecycleHook.
type PutLifecycleHookInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group to which you want to assign the lifecycle
	// hook.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// Defines the action the Auto Scaling group should take when the lifecycle
	// hook timeout elapses or if an unexpected failure occurs. This parameter can
	// be either CONTINUE or ABANDON. The default value is ABANDON.
	DefaultResult *string `type:"string"`

	// The amount of time, in seconds, that can elapse before the lifecycle hook
	// times out. When the lifecycle hook times out, Auto Scaling performs the default
	// action. You can prevent the lifecycle hook from timing out by calling RecordLifecycleActionHeartbeat.
	// The default is 3600 seconds (1 hour).
	HeartbeatTimeout *int64 `type:"integer"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`

	// The instance state to which you want to attach the lifecycle hook. For a
	// list of lifecycle hook types, see DescribeLifecycleHookTypes.
	//
	// This parameter is required for new lifecycle hooks, but optional when updating
	// existing hooks.
	LifecycleTransition *string `type:"string"`

	// Contains additional information that you want to include any time Auto Scaling
	// sends a message to the notification target.
	NotificationMetadata *string `min:"1" type:"string"`

	// The ARN of the notification target that Auto Scaling will use to notify you
	// when an instance is in the transition state for the lifecycle hook. This
	// target can be either an SQS queue or an SNS topic. If you specify an empty
	// string, this overrides the current ARN.
	//
	// The notification messages sent to the target include the following information:
	//
	//    AutoScalingGroupName. The name of the Auto Scaling group.
	//
	//    AccountId. The AWS account ID.
	//
	//    LifecycleTransition. The lifecycle hook type.
	//
	//    LifecycleActionToken. The lifecycle action token.
	//
	//    EC2InstanceId. The EC2 instance ID.
	//
	//    LifecycleHookName. The name of the lifecycle hook.
	//
	//    NotificationMetadata. User-defined information.
	//
	//   This operation uses the JSON format when sending notifications to an Amazon
	// SQS queue, and an email key/value pair format when sending notifications
	// to an Amazon SNS topic.
	//
	// When you specify a notification target, Auto Scaling sends it a test message.
	// Test messages contains the following additional key/value pair: "Event":
	// "autoscaling:TEST_NOTIFICATION".
	NotificationTargetARN *string `type:"string"`

	// The ARN of the IAM role that allows the Auto Scaling group to publish to
	// the specified notification target.
	//
	// This parameter is required for new lifecycle hooks, but optional when updating
	// existing hooks.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutLifecycleHookInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLifecycleHookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLifecycleHookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLifecycleHookInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.LifecycleHookName == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LifecycleHookName", 1))
	}
	if s.NotificationMetadata != nil && len(*s.NotificationMetadata) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NotificationMetadata", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of PutLifecycleHook.
type PutLifecycleHookOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutLifecycleHookOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLifecycleHookOutput) GoString() string {
	return s.String()
}

// Contains the parameters for PutNotificationConfiguration.
type PutNotificationConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The type of event that will cause the notification to be sent. For details
	// about notification types supported by Auto Scaling, see DescribeAutoScalingNotificationTypes.
	//
	// NotificationTypes is a required field
	NotificationTypes []*string `type:"list" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon Simple Notification Service
	// (SNS) topic.
	//
	// TopicARN is a required field
	TopicARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutNotificationConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutNotificationConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutNotificationConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutNotificationConfigurationInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.NotificationTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("NotificationTypes"))
	}
	if s.TopicARN == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicARN"))
	}
	if s.TopicARN != nil && len(*s.TopicARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutNotificationConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutNotificationConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutNotificationConfigurationOutput) GoString() string {
	return s.String()
}

// Contains the parameters for PutScalingPolicy.
type PutScalingPolicyInput struct {
	_ struct{} `type:"structure"`

	// The adjustment type. Valid values are ChangeInCapacity, ExactCapacity, and
	// PercentChangeInCapacity.
	//
	// For more information, see Dynamic Scaling (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/as-scale-based-on-demand.html)
	// in the Auto Scaling User Guide.
	//
	// AdjustmentType is a required field
	AdjustmentType *string `min:"1" type:"string" required:"true"`

	// The name or ARN of the group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The amount of time, in seconds, after a scaling activity completes and before
	// the next scaling activity can start. If this parameter is not specified,
	// the default cooldown period for the group applies.
	//
	// This parameter is not supported unless the policy type is SimpleScaling.
	//
	// For more information, see Auto Scaling Cooldowns (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/Cooldown.html)
	// in the Auto Scaling User Guide.
	Cooldown *int64 `type:"integer"`

	// The estimated time, in seconds, until a newly launched instance can contribute
	// to the CloudWatch metrics. The default is to use the value specified for
	// the default cooldown period for the group.
	//
	// This parameter is not supported if the policy type is SimpleScaling.
	EstimatedInstanceWarmup *int64 `type:"integer"`

	// The aggregation type for the CloudWatch metrics. Valid values are Minimum,
	// Maximum, and Average. If the aggregation type is null, the value is treated
	// as Average.
	//
	// This parameter is not supported if the policy type is SimpleScaling.
	MetricAggregationType *string `min:"1" type:"string"`

	// The minimum number of instances to scale. If the value of AdjustmentType
	// is PercentChangeInCapacity, the scaling policy changes the DesiredCapacity
	// of the Auto Scaling group by at least this many instances. Otherwise, the
	// error is ValidationError.
	MinAdjustmentMagnitude *int64 `type:"integer"`

	// Available for backward compatibility. Use MinAdjustmentMagnitude instead.
	MinAdjustmentStep *int64 `deprecated:"true" type:"integer"`

	// The name of the policy.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`

	// The policy type. Valid values are SimpleScaling and StepScaling. If the policy
	// type is null, the value is treated as SimpleScaling.
	PolicyType *string `min:"1" type:"string"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	//
	// This parameter is required if the policy type is SimpleScaling and not supported
	// otherwise.
	ScalingAdjustment *int64 `type:"integer"`

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	//
	// This parameter is required if the policy type is StepScaling and not supported
	// otherwise.
	StepAdjustments []*StepAdjustment `type:"list"`
}

// String returns the string representation
func (s PutScalingPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScalingPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutScalingPolicyInput"}
	if s.AdjustmentType == nil {
		invalidParams.Add(request.NewErrParamRequired("AdjustmentType"))
	}
	if s.AdjustmentType != nil && len(*s.AdjustmentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdjustmentType", 1))
	}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.MetricAggregationType != nil && len(*s.MetricAggregationType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MetricAggregationType", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}
	if s.PolicyType != nil && len(*s.PolicyType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyType", 1))
	}
	if s.StepAdjustments != nil {
		for i, v := range s.StepAdjustments {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StepAdjustments", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of PutScalingPolicy.
type PutScalingPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the policy.
	PolicyARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutScalingPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScalingPolicyOutput) GoString() string {
	return s.String()
}

// Contains the parameters for PutScheduledUpdateGroupAction.
type PutScheduledUpdateGroupActionInput struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The number of EC2 instances that should be running in the group.
	DesiredCapacity *int64 `type:"integer"`

	// The time for this action to end.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The maximum size for the Auto Scaling group.
	MaxSize *int64 `type:"integer"`

	// The minimum size for the Auto Scaling group.
	MinSize *int64 `type:"integer"`

	// The time when recurring future actions will start. Start time is specified
	// by the user following the Unix cron syntax format. For more information,
	// see Cron (http://en.wikipedia.org/wiki/Cron) in Wikipedia.
	//
	// When StartTime and EndTime are specified with Recurrence, they form the
	// boundaries of when the recurring action will start and stop.
	Recurrence *string `min:"1" type:"string"`

	// The name of this scaling action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `min:"1" type:"string" required:"true"`

	// The time for this action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT
	// only (for example, 2014-06-01T00:00:00Z).
	//
	// If you try to schedule your action in the past, Auto Scaling returns an
	// error message.
	//
	// When StartTime and EndTime are specified with Recurrence, they form the
	// boundaries of when the recurring action starts and stops.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// This parameter is deprecated.
	Time *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s PutScheduledUpdateGroupActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScheduledUpdateGroupActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutScheduledUpdateGroupActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutScheduledUpdateGroupActionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.Recurrence != nil && len(*s.Recurrence) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Recurrence", 1))
	}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledActionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutScheduledUpdateGroupActionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutScheduledUpdateGroupActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutScheduledUpdateGroupActionOutput) GoString() string {
	return s.String()
}

// Contains the parameters for RecordLifecycleActionHeartbeat.
type RecordLifecycleActionHeartbeatInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group for the hook.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	InstanceId *string `min:"1" type:"string"`

	// A token that uniquely identifies a specific lifecycle action associated with
	// an instance. Auto Scaling sends this token to the notification target you
	// specified when you created the lifecycle hook.
	LifecycleActionToken *string `min:"36" type:"string"`

	// The name of the lifecycle hook.
	//
	// LifecycleHookName is a required field
	LifecycleHookName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordLifecycleActionHeartbeatInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordLifecycleActionHeartbeatInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordLifecycleActionHeartbeatInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecordLifecycleActionHeartbeatInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.LifecycleActionToken != nil && len(*s.LifecycleActionToken) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("LifecycleActionToken", 36))
	}
	if s.LifecycleHookName == nil {
		invalidParams.Add(request.NewErrParamRequired("LifecycleHookName"))
	}
	if s.LifecycleHookName != nil && len(*s.LifecycleHookName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LifecycleHookName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of RecordLifecycleActionHeartBeat.
type RecordLifecycleActionHeartbeatOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RecordLifecycleActionHeartbeatOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordLifecycleActionHeartbeatOutput) GoString() string {
	return s.String()
}

type ResumeProcessesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResumeProcessesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResumeProcessesOutput) GoString() string {
	return s.String()
}

// Describes a scaling policy.
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// The adjustment type, which specifies how ScalingAdjustment is interpreted.
	// Valid values are ChangeInCapacity, ExactCapacity, and PercentChangeInCapacity.
	AdjustmentType *string `min:"1" type:"string"`

	// The CloudWatch alarms related to the policy.
	Alarms []*Alarm `type:"list"`

	// The name of the Auto Scaling group associated with this scaling policy.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The amount of time, in seconds, after a scaling activity completes before
	// any further trigger-related scaling activities can start.
	Cooldown *int64 `type:"integer"`

	// The estimated time, in seconds, until a newly launched instance can contribute
	// to the CloudWatch metrics.
	EstimatedInstanceWarmup *int64 `type:"integer"`

	// The aggregation type for the CloudWatch metrics. Valid values are Minimum,
	// Maximum, and Average.
	MetricAggregationType *string `min:"1" type:"string"`

	// The minimum number of instances to scale. If the value of AdjustmentType
	// is PercentChangeInCapacity, the scaling policy changes the DesiredCapacity
	// of the Auto Scaling group by at least this many instances. Otherwise, the
	// error is ValidationError.
	MinAdjustmentMagnitude *int64 `type:"integer"`

	// Available for backward compatibility. Use MinAdjustmentMagnitude instead.
	MinAdjustmentStep *int64 `deprecated:"true" type:"integer"`

	// The Amazon Resource Name (ARN) of the policy.
	PolicyARN *string `min:"1" type:"string"`

	// The name of the scaling policy.
	PolicyName *string `min:"1" type:"string"`

	// The policy type. Valid values are SimpleScaling and StepScaling.
	PolicyType *string `min:"1" type:"string"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	ScalingAdjustment *int64 `type:"integer"`

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	StepAdjustments []*StepAdjustment `type:"list"`
}

// String returns the string representation
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingPolicy) GoString() string {
	return s.String()
}

// Contains the parameters for SuspendProcesses and ResumeProcesses.
type ScalingProcessQuery struct {
	_ struct{} `type:"structure"`

	// The name or Amazon Resource Name (ARN) of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more of the following processes. If you omit this parameter, all processes
	// are specified.
	//
	//    Launch
	//
	//    Terminate
	//
	//    HealthCheck
	//
	//    ReplaceUnhealthy
	//
	//    AZRebalance
	//
	//    AlarmNotification
	//
	//    ScheduledActions
	//
	//    AddToLoadBalancer
	ScalingProcesses []*string `type:"list"`
}

// String returns the string representation
func (s ScalingProcessQuery) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScalingProcessQuery) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScalingProcessQuery) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScalingProcessQuery"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a scheduled update to an Auto Scaling group.
type ScheduledUpdateGroupAction struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	AutoScalingGroupName *string `min:"1" type:"string"`

	// The number of instances you prefer to maintain in the group.
	DesiredCapacity *int64 `type:"integer"`

	// The date and time that the action is scheduled to end. This date and time
	// can be up to one month in the future.
	EndTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The maximum size of the group.
	MaxSize *int64 `type:"integer"`

	// The minimum size of the group.
	MinSize *int64 `type:"integer"`

	// The recurring schedule for the action.
	Recurrence *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the scheduled action.
	ScheduledActionARN *string `min:"1" type:"string"`

	// The name of the scheduled action.
	ScheduledActionName *string `min:"1" type:"string"`

	// The date and time that the action is scheduled to begin. This date and time
	// can be up to one month in the future.
	//
	// When StartTime and EndTime are specified with Recurrence, they form the
	// boundaries of when the recurring action will start and stop.
	StartTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// This parameter is deprecated.
	Time *time.Time `type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation
func (s ScheduledUpdateGroupAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduledUpdateGroupAction) GoString() string {
	return s.String()
}

// Contains the parameters for SetDesiredCapacity.
type SetDesiredCapacityInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// The number of EC2 instances that should be running in the Auto Scaling group.
	//
	// DesiredCapacity is a required field
	DesiredCapacity *int64 `type:"integer" required:"true"`

	// By default, SetDesiredCapacity overrides any cooldown period associated with
	// the Auto Scaling group. Specify True to make Auto Scaling to wait for the
	// cool-down period associated with the Auto Scaling group to complete before
	// initiating a scaling activity to set your Auto Scaling group to its new capacity.
	HonorCooldown *bool `type:"boolean"`
}

// String returns the string representation
func (s SetDesiredCapacityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDesiredCapacityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDesiredCapacityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetDesiredCapacityInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.DesiredCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("DesiredCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetDesiredCapacityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetDesiredCapacityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDesiredCapacityOutput) GoString() string {
	return s.String()
}

// Contains the parameters for SetInstanceHealth.
type SetInstanceHealthInput struct {
	_ struct{} `type:"structure"`

	// The health status of the instance. Set to Healthy if you want the instance
	// to remain in service. Set to Unhealthy if you want the instance to be out
	// of service. Auto Scaling will terminate and replace the unhealthy instance.
	//
	// HealthStatus is a required field
	HealthStatus *string `min:"1" type:"string" required:"true"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// If the Auto Scaling group of the specified instance has a HealthCheckGracePeriod
	// specified for the group, by default, this call will respect the grace period.
	// Set this to False, if you do not want the call to respect the grace period
	// associated with the group.
	//
	// For more information, see the description of the health check grace period
	// for CreateAutoScalingGroup.
	ShouldRespectGracePeriod *bool `type:"boolean"`
}

// String returns the string representation
func (s SetInstanceHealthInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetInstanceHealthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetInstanceHealthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetInstanceHealthInput"}
	if s.HealthStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("HealthStatus"))
	}
	if s.HealthStatus != nil && len(*s.HealthStatus) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthStatus", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetInstanceHealthOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetInstanceHealthOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetInstanceHealthOutput) GoString() string {
	return s.String()
}

// Contains the parameters for SetInstanceProtection.
type SetInstanceProtectionInput struct {
	_ struct{} `type:"structure"`

	// The name of the group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more instance IDs.
	//
	// InstanceIds is a required field
	InstanceIds []*string `type:"list" required:"true"`

	// Indicates whether the instance is protected from termination by Auto Scaling
	// when scaling in.
	//
	// ProtectedFromScaleIn is a required field
	ProtectedFromScaleIn *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s SetInstanceProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetInstanceProtectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetInstanceProtectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetInstanceProtectionInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.InstanceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceIds"))
	}
	if s.ProtectedFromScaleIn == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtectedFromScaleIn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of SetInstanceProtection.
type SetInstanceProtectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetInstanceProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetInstanceProtectionOutput) GoString() string {
	return s.String()
}

// Describes an adjustment based on the difference between the value of the
// aggregated CloudWatch metric and the breach threshold that you've defined
// for the alarm.
//
// For the following examples, suppose that you have an alarm with a breach
// threshold of 50:
//
//   If you want the adjustment to be triggered when the metric is greater
// than or equal to 50 and less than 60, specify a lower bound of 0 and an upper
// bound of 10.
//
//   If you want the adjustment to be triggered when the metric is greater
// than 40 and less than or equal to 50, specify a lower bound of -10 and an
// upper bound of 0.
//
//   There are a few rules for the step adjustments for your step policy:
//
//   The ranges of your step adjustments can't overlap or have a gap.
//
//   At most one step adjustment can have a null lower bound. If one step adjustment
// has a negative lower bound, then there must be a step adjustment with a null
// lower bound.
//
//   At most one step adjustment can have a null upper bound. If one step adjustment
// has a positive upper bound, then there must be a step adjustment with a null
// upper bound.
//
//   The upper and lower bound can't be null in the same step adjustment.
type StepAdjustment struct {
	_ struct{} `type:"structure"`

	// The lower bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the lower bound
	// is inclusive (the metric must be greater than or equal to the threshold plus
	// the lower bound). Otherwise, it is exclusive (the metric must be greater
	// than the threshold plus the lower bound). A null value indicates negative
	// infinity.
	MetricIntervalLowerBound *float64 `type:"double"`

	// The upper bound for the difference between the alarm threshold and the CloudWatch
	// metric. If the metric value is above the breach threshold, the upper bound
	// is exclusive (the metric must be less than the threshold plus the upper bound).
	// Otherwise, it is inclusive (the metric must be less than or equal to the
	// threshold plus the upper bound). A null value indicates positive infinity.
	//
	// The upper bound must be greater than the lower bound.
	MetricIntervalUpperBound *float64 `type:"double"`

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	//
	// ScalingAdjustment is a required field
	ScalingAdjustment *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s StepAdjustment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepAdjustment) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StepAdjustment) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StepAdjustment"}
	if s.ScalingAdjustment == nil {
		invalidParams.Add(request.NewErrParamRequired("ScalingAdjustment"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SuspendProcessesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SuspendProcessesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SuspendProcessesOutput) GoString() string {
	return s.String()
}

// Describes an Auto Scaling process that has been suspended. For more information,
// see ProcessType.
type SuspendedProcess struct {
	_ struct{} `type:"structure"`

	// The name of the suspended process.
	ProcessName *string `min:"1" type:"string"`

	// The reason that the process was suspended.
	SuspensionReason *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SuspendedProcess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SuspendedProcess) GoString() string {
	return s.String()
}

// Describes a tag for an Auto Scaling group.
type Tag struct {
	_ struct{} `type:"structure"`

	// The tag key.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Determines whether the tag is added to new instances as they are launched
	// in the group.
	PropagateAtLaunch *bool `type:"boolean"`

	// The name of the group.
	ResourceId *string `type:"string"`

	// The type of resource. The only supported value is auto-scaling-group.
	ResourceType *string `type:"string"`

	// The tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes a tag for an Auto Scaling group.
type TagDescription struct {
	_ struct{} `type:"structure"`

	// The tag key.
	Key *string `min:"1" type:"string"`

	// Determines whether the tag is added to new instances as they are launched
	// in the group.
	PropagateAtLaunch *bool `type:"boolean"`

	// The name of the group.
	ResourceId *string `type:"string"`

	// The type of resource. The only supported value is auto-scaling-group.
	ResourceType *string `type:"string"`

	// The tag value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s TagDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagDescription) GoString() string {
	return s.String()
}

// Contains the parameters for TerminateInstanceInAutoScalingGroup.
type TerminateInstanceInAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// If true, terminating the instance also decrements the size of the Auto Scaling
	// group.
	//
	// ShouldDecrementDesiredCapacity is a required field
	ShouldDecrementDesiredCapacity *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s TerminateInstanceInAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateInstanceInAutoScalingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateInstanceInAutoScalingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateInstanceInAutoScalingGroupInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.ShouldDecrementDesiredCapacity == nil {
		invalidParams.Add(request.NewErrParamRequired("ShouldDecrementDesiredCapacity"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of TerminateInstancesInAutoScalingGroup.
type TerminateInstanceInAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`

	// A scaling activity.
	Activity *Activity `type:"structure"`
}

// String returns the string representation
func (s TerminateInstanceInAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateInstanceInAutoScalingGroupOutput) GoString() string {
	return s.String()
}

// Contains the parameters for UpdateAutoScalingGroup.
type UpdateAutoScalingGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group.
	//
	// AutoScalingGroupName is a required field
	AutoScalingGroupName *string `min:"1" type:"string" required:"true"`

	// One or more Availability Zones for the group.
	AvailabilityZones []*string `min:"1" type:"list"`

	// The amount of time, in seconds, after a scaling activity completes before
	// another scaling activity can start. The default is 300.
	//
	// For more information, see Auto Scaling Cooldowns (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/Cooldown.html)
	// in the Auto Scaling User Guide.
	DefaultCooldown *int64 `type:"integer"`

	// The number of EC2 instances that should be running in the Auto Scaling group.
	// This number must be greater than or equal to the minimum size of the group
	// and less than or equal to the maximum size of the group.
	DesiredCapacity *int64 `type:"integer"`

	// The amount of time, in seconds, that Auto Scaling waits before checking the
	// health status of an EC2 instance that has come into service. The default
	// is 0.
	//
	// For more information, see Health Checks (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/healthcheck.html)
	// in the Auto Scaling User Guide.
	HealthCheckGracePeriod *int64 `type:"integer"`

	// The service to use for the health checks. The valid values are EC2 and ELB.
	HealthCheckType *string `min:"1" type:"string"`

	// The name of the launch configuration.
	LaunchConfigurationName *string `min:"1" type:"string"`

	// The maximum size of the Auto Scaling group.
	MaxSize *int64 `type:"integer"`

	// The minimum size of the Auto Scaling group.
	MinSize *int64 `type:"integer"`

	// Indicates whether newly launched instances are protected from termination
	// by Auto Scaling when scaling in.
	NewInstancesProtectedFromScaleIn *bool `type:"boolean"`

	// The name of the placement group into which you'll launch your instances,
	// if any. For more information, see Placement Groups (http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
	// in the Amazon Elastic Compute Cloud User Guide.
	PlacementGroup *string `min:"1" type:"string"`

	// A standalone termination policy or a list of termination policies used to
	// select the instance to terminate. The policies are executed in the order
	// that they are listed.
	//
	// For more information, see Controlling Which Instances Auto Scaling Terminates
	// During Scale In (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/AutoScalingBehavior.InstanceTermination.html)
	// in the Auto Scaling User Guide.
	TerminationPolicies []*string `type:"list"`

	// The ID of the subnet, if you are launching into a VPC. You can specify several
	// subnets in a comma-separated list.
	//
	// When you specify VPCZoneIdentifier with AvailabilityZones, ensure that the
	// subnets' Availability Zones match the values you specify for AvailabilityZones.
	//
	// For more information, see Launching Auto Scaling Instances in a VPC (http://docs.aws.amazon.com/AutoScaling/latest/DeveloperGuide/asg-in-vpc.html)
	// in the Auto Scaling User Guide.
	VPCZoneIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateAutoScalingGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAutoScalingGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAutoScalingGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAutoScalingGroupInput"}
	if s.AutoScalingGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoScalingGroupName"))
	}
	if s.AutoScalingGroupName != nil && len(*s.AutoScalingGroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AutoScalingGroupName", 1))
	}
	if s.AvailabilityZones != nil && len(s.AvailabilityZones) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AvailabilityZones", 1))
	}
	if s.HealthCheckType != nil && len(*s.HealthCheckType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HealthCheckType", 1))
	}
	if s.LaunchConfigurationName != nil && len(*s.LaunchConfigurationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchConfigurationName", 1))
	}
	if s.PlacementGroup != nil && len(*s.PlacementGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PlacementGroup", 1))
	}
	if s.VPCZoneIdentifier != nil && len(*s.VPCZoneIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VPCZoneIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateAutoScalingGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAutoScalingGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAutoScalingGroupOutput) GoString() string {
	return s.String()
}

const (
	// LifecycleStatePending is a LifecycleState enum value
	LifecycleStatePending = "Pending"

	// LifecycleStatePendingWait is a LifecycleState enum value
	LifecycleStatePendingWait = "Pending:Wait"

	// LifecycleStatePendingProceed is a LifecycleState enum value
	LifecycleStatePendingProceed = "Pending:Proceed"

	// LifecycleStateQuarantined is a LifecycleState enum value
	LifecycleStateQuarantined = "Quarantined"

	// LifecycleStateInService is a LifecycleState enum value
	LifecycleStateInService = "InService"

	// LifecycleStateTerminating is a LifecycleState enum value
	LifecycleStateTerminating = "Terminating"

	// LifecycleStateTerminatingWait is a LifecycleState enum value
	LifecycleStateTerminatingWait = "Terminating:Wait"

	// LifecycleStateTerminatingProceed is a LifecycleState enum value
	LifecycleStateTerminatingProceed = "Terminating:Proceed"

	// LifecycleStateTerminated is a LifecycleState enum value
	LifecycleStateTerminated = "Terminated"

	// LifecycleStateDetaching is a LifecycleState enum value
	LifecycleStateDetaching = "Detaching"

	// LifecycleStateDetached is a LifecycleState enum value
	LifecycleStateDetached = "Detached"

	// LifecycleStateEnteringStandby is a LifecycleState enum value
	LifecycleStateEnteringStandby = "EnteringStandby"

	// LifecycleStateStandby is a LifecycleState enum value
	LifecycleStateStandby = "Standby"
)

const (
	// ScalingActivityStatusCodePendingSpotBidPlacement is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodePendingSpotBidPlacement = "PendingSpotBidPlacement"

	// ScalingActivityStatusCodeWaitingForSpotInstanceRequestId is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeWaitingForSpotInstanceRequestId = "WaitingForSpotInstanceRequestId"

	// ScalingActivityStatusCodeWaitingForSpotInstanceId is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeWaitingForSpotInstanceId = "WaitingForSpotInstanceId"

	// ScalingActivityStatusCodeWaitingForInstanceId is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeWaitingForInstanceId = "WaitingForInstanceId"

	// ScalingActivityStatusCodePreInService is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodePreInService = "PreInService"

	// ScalingActivityStatusCodeInProgress is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeInProgress = "InProgress"

	// ScalingActivityStatusCodeWaitingForElbconnectionDraining is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeWaitingForElbconnectionDraining = "WaitingForELBConnectionDraining"

	// ScalingActivityStatusCodeMidLifecycleAction is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeMidLifecycleAction = "MidLifecycleAction"

	// ScalingActivityStatusCodeWaitingForInstanceWarmup is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeWaitingForInstanceWarmup = "WaitingForInstanceWarmup"

	// ScalingActivityStatusCodeSuccessful is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeSuccessful = "Successful"

	// ScalingActivityStatusCodeFailed is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeFailed = "Failed"

	// ScalingActivityStatusCodeCancelled is a ScalingActivityStatusCode enum value
	ScalingActivityStatusCodeCancelled = "Cancelled"
)
