// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package kms provides a client for AWS Key Management Service.
package kms

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCancelKeyDeletion = "CancelKeyDeletion"

// CancelKeyDeletionRequest generates a "aws/request.Request" representing the
// client's request for the CancelKeyDeletion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CancelKeyDeletion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CancelKeyDeletion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CancelKeyDeletionRequest method.
//    req, resp := client.CancelKeyDeletionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) CancelKeyDeletionRequest(input *CancelKeyDeletionInput) (req *request.Request, output *CancelKeyDeletionOutput) {
	op := &request.Operation{
		Name:       opCancelKeyDeletion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelKeyDeletionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelKeyDeletionOutput{}
	req.Data = output
	return
}

// CancelKeyDeletion API operation for AWS Key Management Service.
//
// Cancels the deletion of a customer master key (CMK). When this operation
// is successful, the CMK is set to the Disabled state. To enable a CMK, use
// EnableKey.
//
// For more information about scheduling and canceling deletion of a CMK, see
// Deleting Customer Master Keys (http://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html)
// in the AWS Key Management Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation CancelKeyDeletion for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) CancelKeyDeletion(input *CancelKeyDeletionInput) (*CancelKeyDeletionOutput, error) {
	req, out := c.CancelKeyDeletionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateAlias = "CreateAlias"

// CreateAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateAlias operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateAlias for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateAlias method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateAliasRequest method.
//    req, resp := client.CreateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) CreateAliasRequest(input *CreateAliasInput) (req *request.Request, output *CreateAliasOutput) {
	op := &request.Operation{
		Name:       opCreateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAliasInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &CreateAliasOutput{}
	req.Data = output
	return
}

// CreateAlias API operation for AWS Key Management Service.
//
// Creates a display name for a customer master key. An alias can be used to
// identify a key and should be unique. The console enforces a one-to-one mapping
// between the alias and a key. An alias name can contain only alphanumeric
// characters, forward slashes (/), underscores (_), and dashes (-). An alias
// must start with the word "alias" followed by a forward slash (alias/). An
// alias that begins with "aws" after the forward slash (alias/aws...) is reserved
// by Amazon Web Services (AWS).
//
// The alias and the key it is mapped to must be in the same AWS account and
// the same region.
//
// To map an alias to a different key, call UpdateAlias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation CreateAlias for usage and error information.
//
// Returned Error Codes:
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * AlreadyExistsException
//   The request was rejected because it attempted to create a resource that already
//   exists.
//
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InvalidAliasNameException
//   The request was rejected because the specified alias name is not valid.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * LimitExceededException
//   The request was rejected because a limit was exceeded. For more information,
//   see Limits (http://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//   in the AWS Key Management Service Developer Guide.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) CreateAlias(input *CreateAliasInput) (*CreateAliasOutput, error) {
	req, out := c.CreateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opCreateGrant = "CreateGrant"

// CreateGrantRequest generates a "aws/request.Request" representing the
// client's request for the CreateGrant operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateGrant for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateGrant method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateGrantRequest method.
//    req, resp := client.CreateGrantRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) CreateGrantRequest(input *CreateGrantInput) (req *request.Request, output *CreateGrantOutput) {
	op := &request.Operation{
		Name:       opCreateGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGrantInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateGrantOutput{}
	req.Data = output
	return
}

// CreateGrant API operation for AWS Key Management Service.
//
// Adds a grant to a key to specify who can use the key and under what conditions.
// Grants are alternate permission mechanisms to key policies.
//
// For more information about grants, see Grants (http://docs.aws.amazon.com/kms/latest/developerguide/grants.html)
// in the AWS Key Management Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation CreateGrant for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * DisabledException
//   The request was rejected because the specified CMK is not enabled.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidGrantTokenException
//   The request was rejected because the specified grant token is not valid.
//
//   * LimitExceededException
//   The request was rejected because a limit was exceeded. For more information,
//   see Limits (http://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//   in the AWS Key Management Service Developer Guide.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) CreateGrant(input *CreateGrantInput) (*CreateGrantOutput, error) {
	req, out := c.CreateGrantRequest(input)
	err := req.Send()
	return out, err
}

const opCreateKey = "CreateKey"

// CreateKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreateKey operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateKey for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateKey method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateKeyRequest method.
//    req, resp := client.CreateKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) CreateKeyRequest(input *CreateKeyInput) (req *request.Request, output *CreateKeyOutput) {
	op := &request.Operation{
		Name:       opCreateKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateKeyOutput{}
	req.Data = output
	return
}

// CreateKey API operation for AWS Key Management Service.
//
// Creates a customer master key (CMK).
//
// You can use a CMK to encrypt small amounts of data (4 KiB or less) directly,
// but CMKs are more commonly used to encrypt data encryption keys (DEKs), which
// are used to encrypt raw data. For more information about DEKs and the difference
// between CMKs and DEKs, see the following:
//
//   The GenerateDataKey operation
//
//    AWS Key Management Service Concepts (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html)
// in the AWS Key Management Service Developer Guide
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation CreateKey for usage and error information.
//
// Returned Error Codes:
//   * MalformedPolicyDocumentException
//   The request was rejected because the specified policy is not syntactically
//   or semantically correct.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * LimitExceededException
//   The request was rejected because a limit was exceeded. For more information,
//   see Limits (http://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) CreateKey(input *CreateKeyInput) (*CreateKeyOutput, error) {
	req, out := c.CreateKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDecrypt = "Decrypt"

// DecryptRequest generates a "aws/request.Request" representing the
// client's request for the Decrypt operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See Decrypt for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the Decrypt method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DecryptRequest method.
//    req, resp := client.DecryptRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) DecryptRequest(input *DecryptInput) (req *request.Request, output *DecryptOutput) {
	op := &request.Operation{
		Name:       opDecrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DecryptInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DecryptOutput{}
	req.Data = output
	return
}

// Decrypt API operation for AWS Key Management Service.
//
// Decrypts ciphertext. Ciphertext is plaintext that has been previously encrypted
// by using any of the following functions:
//
//    GenerateDataKey
//
//    GenerateDataKeyWithoutPlaintext
//
//    Encrypt
//
//   Note that if a caller has been granted access permissions to all keys
// (through, for example, IAM user policies that grant Decrypt permission on
// all resources), then ciphertext encrypted by using keys in other accounts
// where the key grants access to the caller can be decrypted. To remedy this,
// we recommend that you do not grant Decrypt access in an IAM user policy.
// Instead grant Decrypt access only in key policies. If you must grant Decrypt
// access in an IAM user policy, you should scope the resource to specific keys
// or to specific trusted accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation Decrypt for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * DisabledException
//   The request was rejected because the specified CMK is not enabled.
//
//   * InvalidCiphertextException
//   The request was rejected because the specified ciphertext has been corrupted
//   or is otherwise invalid.
//
//   * KeyUnavailableException
//   The request was rejected because the specified CMK was not available. The
//   request can be retried.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InvalidGrantTokenException
//   The request was rejected because the specified grant token is not valid.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) Decrypt(input *DecryptInput) (*DecryptOutput, error) {
	req, out := c.DecryptRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteAlias = "DeleteAlias"

// DeleteAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAlias operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteAlias for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteAlias method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteAliasRequest method.
//    req, resp := client.DeleteAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) DeleteAliasRequest(input *DeleteAliasInput) (req *request.Request, output *DeleteAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAliasInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteAliasOutput{}
	req.Data = output
	return
}

// DeleteAlias API operation for AWS Key Management Service.
//
// Deletes the specified alias. To map an alias to a different key, call UpdateAlias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation DeleteAlias for usage and error information.
//
// Returned Error Codes:
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) DeleteAlias(input *DeleteAliasInput) (*DeleteAliasOutput, error) {
	req, out := c.DeleteAliasRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteImportedKeyMaterial = "DeleteImportedKeyMaterial"

// DeleteImportedKeyMaterialRequest generates a "aws/request.Request" representing the
// client's request for the DeleteImportedKeyMaterial operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteImportedKeyMaterial for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteImportedKeyMaterial method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteImportedKeyMaterialRequest method.
//    req, resp := client.DeleteImportedKeyMaterialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) DeleteImportedKeyMaterialRequest(input *DeleteImportedKeyMaterialInput) (req *request.Request, output *DeleteImportedKeyMaterialOutput) {
	op := &request.Operation{
		Name:       opDeleteImportedKeyMaterial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteImportedKeyMaterialInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DeleteImportedKeyMaterialOutput{}
	req.Data = output
	return
}

// DeleteImportedKeyMaterial API operation for AWS Key Management Service.
//
// Deletes key material that you previously imported and makes the specified
// customer master key (CMK) unusable. For more information about importing
// key material into AWS KMS, see Importing Key Material (http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
// in the AWS Key Management Service Developer Guide.
//
// When the specified CMK is in the PendingDeletion state, this operation does
// not change the CMK's state. Otherwise, it changes the CMK's state to PendingImport.
//
// After you delete key material, you can use ImportKeyMaterial to reimport
// the same key material into the CMK.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation DeleteImportedKeyMaterial for usage and error information.
//
// Returned Error Codes:
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) DeleteImportedKeyMaterial(input *DeleteImportedKeyMaterialInput) (*DeleteImportedKeyMaterialOutput, error) {
	req, out := c.DeleteImportedKeyMaterialRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeKey = "DescribeKey"

// DescribeKeyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeKey operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeKey for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeKey method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeKeyRequest method.
//    req, resp := client.DescribeKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) DescribeKeyRequest(input *DescribeKeyInput) (req *request.Request, output *DescribeKeyOutput) {
	op := &request.Operation{
		Name:       opDescribeKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeKeyOutput{}
	req.Data = output
	return
}

// DescribeKey API operation for AWS Key Management Service.
//
// Provides detailed information about the specified customer master key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation DescribeKey for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
func (c *KMS) DescribeKey(input *DescribeKeyInput) (*DescribeKeyOutput, error) {
	req, out := c.DescribeKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDisableKey = "DisableKey"

// DisableKeyRequest generates a "aws/request.Request" representing the
// client's request for the DisableKey operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableKey for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableKey method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableKeyRequest method.
//    req, resp := client.DisableKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) DisableKeyRequest(input *DisableKeyInput) (req *request.Request, output *DisableKeyOutput) {
	op := &request.Operation{
		Name:       opDisableKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableKeyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DisableKeyOutput{}
	req.Data = output
	return
}

// DisableKey API operation for AWS Key Management Service.
//
// Sets the state of a customer master key (CMK) to disabled, thereby preventing
// its use for cryptographic operations. For more information about how key
// state affects the use of a CMK, see How Key State Affects the Use of a Customer
// Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation DisableKey for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) DisableKey(input *DisableKeyInput) (*DisableKeyOutput, error) {
	req, out := c.DisableKeyRequest(input)
	err := req.Send()
	return out, err
}

const opDisableKeyRotation = "DisableKeyRotation"

// DisableKeyRotationRequest generates a "aws/request.Request" representing the
// client's request for the DisableKeyRotation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DisableKeyRotation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DisableKeyRotation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DisableKeyRotationRequest method.
//    req, resp := client.DisableKeyRotationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) DisableKeyRotationRequest(input *DisableKeyRotationInput) (req *request.Request, output *DisableKeyRotationOutput) {
	op := &request.Operation{
		Name:       opDisableKeyRotation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableKeyRotationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &DisableKeyRotationOutput{}
	req.Data = output
	return
}

// DisableKeyRotation API operation for AWS Key Management Service.
//
// Disables rotation of the specified key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation DisableKeyRotation for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * DisabledException
//   The request was rejected because the specified CMK is not enabled.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
func (c *KMS) DisableKeyRotation(input *DisableKeyRotationInput) (*DisableKeyRotationOutput, error) {
	req, out := c.DisableKeyRotationRequest(input)
	err := req.Send()
	return out, err
}

const opEnableKey = "EnableKey"

// EnableKeyRequest generates a "aws/request.Request" representing the
// client's request for the EnableKey operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableKey for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableKey method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableKeyRequest method.
//    req, resp := client.EnableKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) EnableKeyRequest(input *EnableKeyInput) (req *request.Request, output *EnableKeyOutput) {
	op := &request.Operation{
		Name:       opEnableKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableKeyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &EnableKeyOutput{}
	req.Data = output
	return
}

// EnableKey API operation for AWS Key Management Service.
//
// Marks a key as enabled, thereby permitting its use.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation EnableKey for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * LimitExceededException
//   The request was rejected because a limit was exceeded. For more information,
//   see Limits (http://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//   in the AWS Key Management Service Developer Guide.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) EnableKey(input *EnableKeyInput) (*EnableKeyOutput, error) {
	req, out := c.EnableKeyRequest(input)
	err := req.Send()
	return out, err
}

const opEnableKeyRotation = "EnableKeyRotation"

// EnableKeyRotationRequest generates a "aws/request.Request" representing the
// client's request for the EnableKeyRotation operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See EnableKeyRotation for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the EnableKeyRotation method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EnableKeyRotationRequest method.
//    req, resp := client.EnableKeyRotationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) EnableKeyRotationRequest(input *EnableKeyRotationInput) (req *request.Request, output *EnableKeyRotationOutput) {
	op := &request.Operation{
		Name:       opEnableKeyRotation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableKeyRotationInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &EnableKeyRotationOutput{}
	req.Data = output
	return
}

// EnableKeyRotation API operation for AWS Key Management Service.
//
// Enables rotation of the specified customer master key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation EnableKeyRotation for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * DisabledException
//   The request was rejected because the specified CMK is not enabled.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
func (c *KMS) EnableKeyRotation(input *EnableKeyRotationInput) (*EnableKeyRotationOutput, error) {
	req, out := c.EnableKeyRotationRequest(input)
	err := req.Send()
	return out, err
}

const opEncrypt = "Encrypt"

// EncryptRequest generates a "aws/request.Request" representing the
// client's request for the Encrypt operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See Encrypt for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the Encrypt method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the EncryptRequest method.
//    req, resp := client.EncryptRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) EncryptRequest(input *EncryptInput) (req *request.Request, output *EncryptOutput) {
	op := &request.Operation{
		Name:       opEncrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EncryptInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EncryptOutput{}
	req.Data = output
	return
}

// Encrypt API operation for AWS Key Management Service.
//
// Encrypts plaintext into ciphertext by using a customer master key. The Encrypt
// function has two primary use cases:
//
//   You can encrypt up to 4 KB of arbitrary data such as an RSA key, a database
// password, or other sensitive customer information.
//
//   If you are moving encrypted data from one region to another, you can use
// this API to encrypt in the new region the plaintext data key that was used
// to encrypt the data in the original region. This provides you with an encrypted
// copy of the data key that can be decrypted in the new region and used there
// to decrypt the encrypted data.
//
//   Unless you are moving encrypted data from one region to another, you don't
// use this function to encrypt a generated data key within a region. You retrieve
// data keys already encrypted by calling the GenerateDataKey or GenerateDataKeyWithoutPlaintext
// function. Data keys don't need to be encrypted again by calling Encrypt.
//
// If you want to encrypt data locally in your application, you can use the
// GenerateDataKey function to return a plaintext data encryption key and a
// copy of the key encrypted under the customer master key (CMK) of your choosing.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation Encrypt for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * DisabledException
//   The request was rejected because the specified CMK is not enabled.
//
//   * KeyUnavailableException
//   The request was rejected because the specified CMK was not available. The
//   request can be retried.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InvalidKeyUsageException
//   The request was rejected because the specified KeySpec value is not valid.
//
//   * InvalidGrantTokenException
//   The request was rejected because the specified grant token is not valid.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) Encrypt(input *EncryptInput) (*EncryptOutput, error) {
	req, out := c.EncryptRequest(input)
	err := req.Send()
	return out, err
}

const opGenerateDataKey = "GenerateDataKey"

// GenerateDataKeyRequest generates a "aws/request.Request" representing the
// client's request for the GenerateDataKey operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GenerateDataKey for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GenerateDataKey method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GenerateDataKeyRequest method.
//    req, resp := client.GenerateDataKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) GenerateDataKeyRequest(input *GenerateDataKeyInput) (req *request.Request, output *GenerateDataKeyOutput) {
	op := &request.Operation{
		Name:       opGenerateDataKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateDataKeyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GenerateDataKeyOutput{}
	req.Data = output
	return
}

// GenerateDataKey API operation for AWS Key Management Service.
//
// Returns a data encryption key that you can use in your application to encrypt
// data locally.
//
// You must specify the customer master key (CMK) under which to generate the
// data key. You must also specify the length of the data key using either the
// KeySpec or NumberOfBytes field. You must specify one field or the other,
// but not both. For common key lengths (128-bit and 256-bit symmetric keys),
// we recommend that you use KeySpec.
//
// This operation returns a plaintext copy of the data key in the Plaintext
// field of the response, and an encrypted copy of the data key in the CiphertextBlob
// field. The data key is encrypted under the CMK specified in the KeyId field
// of the request.
//
// We recommend that you use the following pattern to encrypt data locally
// in your application:
//
//   Use this operation (GenerateDataKey) to retrieve a data encryption key.
//
//   Use the plaintext data encryption key (returned in the Plaintext field
// of the response) to encrypt data locally, then erase the plaintext data key
// from memory.
//
//   Store the encrypted data key (returned in the CiphertextBlob field of
// the response) alongside the locally encrypted data.
//
//   To decrypt data locally:
//
//   Use the Decrypt operation to decrypt the encrypted data key into a plaintext
// copy of the data key.
//
//   Use the plaintext data key to decrypt data locally, then erase the plaintext
// data key from memory.
//
//   To return only an encrypted copy of the data key, use GenerateDataKeyWithoutPlaintext.
// To return an arbitrary unpredictable byte string, use GenerateRandom.
//
// If you use the optional EncryptionContext field, you must store at least
// enough information to be able to reconstruct the full encryption context
// when you later send the ciphertext to the Decrypt operation. It is a good
// practice to choose an encryption context that you can reconstruct on the
// fly to better secure the ciphertext. For more information, see Encryption
// Context (http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html)
// in the AWS Key Management Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GenerateDataKey for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * DisabledException
//   The request was rejected because the specified CMK is not enabled.
//
//   * KeyUnavailableException
//   The request was rejected because the specified CMK was not available. The
//   request can be retried.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InvalidKeyUsageException
//   The request was rejected because the specified KeySpec value is not valid.
//
//   * InvalidGrantTokenException
//   The request was rejected because the specified grant token is not valid.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) GenerateDataKey(input *GenerateDataKeyInput) (*GenerateDataKeyOutput, error) {
	req, out := c.GenerateDataKeyRequest(input)
	err := req.Send()
	return out, err
}

const opGenerateDataKeyWithoutPlaintext = "GenerateDataKeyWithoutPlaintext"

// GenerateDataKeyWithoutPlaintextRequest generates a "aws/request.Request" representing the
// client's request for the GenerateDataKeyWithoutPlaintext operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GenerateDataKeyWithoutPlaintext for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GenerateDataKeyWithoutPlaintext method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GenerateDataKeyWithoutPlaintextRequest method.
//    req, resp := client.GenerateDataKeyWithoutPlaintextRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) GenerateDataKeyWithoutPlaintextRequest(input *GenerateDataKeyWithoutPlaintextInput) (req *request.Request, output *GenerateDataKeyWithoutPlaintextOutput) {
	op := &request.Operation{
		Name:       opGenerateDataKeyWithoutPlaintext,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateDataKeyWithoutPlaintextInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GenerateDataKeyWithoutPlaintextOutput{}
	req.Data = output
	return
}

// GenerateDataKeyWithoutPlaintext API operation for AWS Key Management Service.
//
// Returns a data encryption key encrypted under a customer master key (CMK).
// This operation is identical to GenerateDataKey but returns only the encrypted
// copy of the data key.
//
// This operation is useful in a system that has multiple components with different
// degrees of trust. For example, consider a system that stores encrypted data
// in containers. Each container stores the encrypted data and an encrypted
// copy of the data key. One component of the system, called the control plane,
// creates new containers. When it creates a new container, it uses this operation
// (GenerateDataKeyWithoutPlaintext) to get an encrypted data key and then stores
// it in the container. Later, a different component of the system, called the
// data plane, puts encrypted data into the containers. To do this, it passes
// the encrypted data key to the Decrypt operation, then uses the returned plaintext
// data key to encrypt data, and finally stores the encrypted data in the container.
// In this system, the control plane never sees the plaintext data key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GenerateDataKeyWithoutPlaintext for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * DisabledException
//   The request was rejected because the specified CMK is not enabled.
//
//   * KeyUnavailableException
//   The request was rejected because the specified CMK was not available. The
//   request can be retried.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InvalidKeyUsageException
//   The request was rejected because the specified KeySpec value is not valid.
//
//   * InvalidGrantTokenException
//   The request was rejected because the specified grant token is not valid.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) GenerateDataKeyWithoutPlaintext(input *GenerateDataKeyWithoutPlaintextInput) (*GenerateDataKeyWithoutPlaintextOutput, error) {
	req, out := c.GenerateDataKeyWithoutPlaintextRequest(input)
	err := req.Send()
	return out, err
}

const opGenerateRandom = "GenerateRandom"

// GenerateRandomRequest generates a "aws/request.Request" representing the
// client's request for the GenerateRandom operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GenerateRandom for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GenerateRandom method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GenerateRandomRequest method.
//    req, resp := client.GenerateRandomRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) GenerateRandomRequest(input *GenerateRandomInput) (req *request.Request, output *GenerateRandomOutput) {
	op := &request.Operation{
		Name:       opGenerateRandom,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateRandomInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GenerateRandomOutput{}
	req.Data = output
	return
}

// GenerateRandom API operation for AWS Key Management Service.
//
// Generates an unpredictable byte string.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GenerateRandom for usage and error information.
//
// Returned Error Codes:
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
func (c *KMS) GenerateRandom(input *GenerateRandomInput) (*GenerateRandomOutput, error) {
	req, out := c.GenerateRandomRequest(input)
	err := req.Send()
	return out, err
}

const opGetKeyPolicy = "GetKeyPolicy"

// GetKeyPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetKeyPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetKeyPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetKeyPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetKeyPolicyRequest method.
//    req, resp := client.GetKeyPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) GetKeyPolicyRequest(input *GetKeyPolicyInput) (req *request.Request, output *GetKeyPolicyOutput) {
	op := &request.Operation{
		Name:       opGetKeyPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetKeyPolicyOutput{}
	req.Data = output
	return
}

// GetKeyPolicy API operation for AWS Key Management Service.
//
// Retrieves a policy attached to the specified key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GetKeyPolicy for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) GetKeyPolicy(input *GetKeyPolicyInput) (*GetKeyPolicyOutput, error) {
	req, out := c.GetKeyPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetKeyRotationStatus = "GetKeyRotationStatus"

// GetKeyRotationStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetKeyRotationStatus operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetKeyRotationStatus for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetKeyRotationStatus method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetKeyRotationStatusRequest method.
//    req, resp := client.GetKeyRotationStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) GetKeyRotationStatusRequest(input *GetKeyRotationStatusInput) (req *request.Request, output *GetKeyRotationStatusOutput) {
	op := &request.Operation{
		Name:       opGetKeyRotationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyRotationStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetKeyRotationStatusOutput{}
	req.Data = output
	return
}

// GetKeyRotationStatus API operation for AWS Key Management Service.
//
// Retrieves a Boolean value that indicates whether key rotation is enabled
// for the specified key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GetKeyRotationStatus for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
func (c *KMS) GetKeyRotationStatus(input *GetKeyRotationStatusInput) (*GetKeyRotationStatusOutput, error) {
	req, out := c.GetKeyRotationStatusRequest(input)
	err := req.Send()
	return out, err
}

const opGetParametersForImport = "GetParametersForImport"

// GetParametersForImportRequest generates a "aws/request.Request" representing the
// client's request for the GetParametersForImport operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See GetParametersForImport for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the GetParametersForImport method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the GetParametersForImportRequest method.
//    req, resp := client.GetParametersForImportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) GetParametersForImportRequest(input *GetParametersForImportInput) (req *request.Request, output *GetParametersForImportOutput) {
	op := &request.Operation{
		Name:       opGetParametersForImport,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetParametersForImportInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetParametersForImportOutput{}
	req.Data = output
	return
}

// GetParametersForImport API operation for AWS Key Management Service.
//
// Returns the items you need in order to import key material into AWS KMS from
// your existing key management infrastructure. For more information about importing
// key material into AWS KMS, see Importing Key Material (http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
// in the AWS Key Management Service Developer Guide.
//
// You must specify the key ID of the customer master key (CMK) into which
// you will import key material. This CMK's Origin must be EXTERNAL. You must
// also specify the wrapping algorithm and type of wrapping key (public key)
// that you will use to encrypt the key material.
//
// This operation returns a public key and an import token. Use the public
// key to encrypt the key material. Store the import token to send with a subsequent
// ImportKeyMaterial request. The public key and import token from the same
// response must be used together. These items are valid for 24 hours, after
// which they cannot be used for a subsequent ImportKeyMaterial request. To
// retrieve new ones, send another GetParametersForImport request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation GetParametersForImport for usage and error information.
//
// Returned Error Codes:
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) GetParametersForImport(input *GetParametersForImportInput) (*GetParametersForImportOutput, error) {
	req, out := c.GetParametersForImportRequest(input)
	err := req.Send()
	return out, err
}

const opImportKeyMaterial = "ImportKeyMaterial"

// ImportKeyMaterialRequest generates a "aws/request.Request" representing the
// client's request for the ImportKeyMaterial operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ImportKeyMaterial for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ImportKeyMaterial method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ImportKeyMaterialRequest method.
//    req, resp := client.ImportKeyMaterialRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) ImportKeyMaterialRequest(input *ImportKeyMaterialInput) (req *request.Request, output *ImportKeyMaterialOutput) {
	op := &request.Operation{
		Name:       opImportKeyMaterial,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportKeyMaterialInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ImportKeyMaterialOutput{}
	req.Data = output
	return
}

// ImportKeyMaterial API operation for AWS Key Management Service.
//
// Imports key material into an AWS KMS customer master key (CMK) from your
// existing key management infrastructure. For more information about importing
// key material into AWS KMS, see Importing Key Material (http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
// in the AWS Key Management Service Developer Guide.
//
// You must specify the key ID of the CMK to import the key material into.
// This CMK's Origin must be EXTERNAL. You must also send an import token and
// the encrypted key material. Send the import token that you received in the
// same GetParametersForImport response that contained the public key that you
// used to encrypt the key material. You must also specify whether the key material
// expires and if so, when. When the key material expires, AWS KMS deletes the
// key material and the CMK becomes unusable. To use the CMK again, you can
// reimport the same key material. If you set an expiration date, you can change
// it only by reimporting the same key material and specifying a new expiration
// date.
//
// When this operation is successful, the specified CMK's key state changes
// to Enabled, and you can use the CMK.
//
// After you successfully import key material into a CMK, you can reimport
// the same key material into that CMK, but you cannot import different key
// material.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ImportKeyMaterial for usage and error information.
//
// Returned Error Codes:
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
//   * InvalidCiphertextException
//   The request was rejected because the specified ciphertext has been corrupted
//   or is otherwise invalid.
//
//   * IncorrectKeyMaterialException
//   The request was rejected because the provided key material is invalid or
//   is not the same key material that was previously imported into this customer
//   master key (CMK).
//
//   * ExpiredImportTokenException
//   The request was rejected because the provided import token is expired. Use
//   GetParametersForImport to retrieve a new import token and public key, use
//   the new public key to encrypt the key material, and then try the request
//   again.
//
//   * InvalidImportTokenException
//   The request was rejected because the provided import token is invalid or
//   is associated with a different customer master key (CMK).
//
func (c *KMS) ImportKeyMaterial(input *ImportKeyMaterialInput) (*ImportKeyMaterialOutput, error) {
	req, out := c.ImportKeyMaterialRequest(input)
	err := req.Send()
	return out, err
}

const opListAliases = "ListAliases"

// ListAliasesRequest generates a "aws/request.Request" representing the
// client's request for the ListAliases operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListAliases for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListAliases method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListAliasesRequest method.
//    req, resp := client.ListAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) ListAliasesRequest(input *ListAliasesInput) (req *request.Request, output *ListAliasesOutput) {
	op := &request.Operation{
		Name:       opListAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "Truncated",
		},
	}

	if input == nil {
		input = &ListAliasesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListAliasesOutput{}
	req.Data = output
	return
}

// ListAliases API operation for AWS Key Management Service.
//
// Lists all of the key aliases in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ListAliases for usage and error information.
//
// Returned Error Codes:
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InvalidMarkerException
//   The request was rejected because the marker that specifies where pagination
//   should next begin is not valid.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
func (c *KMS) ListAliases(input *ListAliasesInput) (*ListAliasesOutput, error) {
	req, out := c.ListAliasesRequest(input)
	err := req.Send()
	return out, err
}

// ListAliasesPages iterates over the pages of a ListAliases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAliases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAliases operation.
//    pageNum := 0
//    err := client.ListAliasesPages(params,
//        func(page *ListAliasesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *KMS) ListAliasesPages(input *ListAliasesInput, fn func(p *ListAliasesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListAliasesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListAliasesOutput), lastPage)
	})
}

const opListGrants = "ListGrants"

// ListGrantsRequest generates a "aws/request.Request" representing the
// client's request for the ListGrants operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListGrants for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListGrants method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListGrantsRequest method.
//    req, resp := client.ListGrantsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) ListGrantsRequest(input *ListGrantsInput) (req *request.Request, output *ListGrantsResponse) {
	op := &request.Operation{
		Name:       opListGrants,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "Truncated",
		},
	}

	if input == nil {
		input = &ListGrantsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListGrantsResponse{}
	req.Data = output
	return
}

// ListGrants API operation for AWS Key Management Service.
//
// List the grants for a specified key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ListGrants for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InvalidMarkerException
//   The request was rejected because the marker that specifies where pagination
//   should next begin is not valid.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) ListGrants(input *ListGrantsInput) (*ListGrantsResponse, error) {
	req, out := c.ListGrantsRequest(input)
	err := req.Send()
	return out, err
}

// ListGrantsPages iterates over the pages of a ListGrants operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListGrants method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListGrants operation.
//    pageNum := 0
//    err := client.ListGrantsPages(params,
//        func(page *ListGrantsResponse, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *KMS) ListGrantsPages(input *ListGrantsInput, fn func(p *ListGrantsResponse, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListGrantsRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListGrantsResponse), lastPage)
	})
}

const opListKeyPolicies = "ListKeyPolicies"

// ListKeyPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListKeyPolicies operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListKeyPolicies for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListKeyPolicies method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListKeyPoliciesRequest method.
//    req, resp := client.ListKeyPoliciesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) ListKeyPoliciesRequest(input *ListKeyPoliciesInput) (req *request.Request, output *ListKeyPoliciesOutput) {
	op := &request.Operation{
		Name:       opListKeyPolicies,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "Truncated",
		},
	}

	if input == nil {
		input = &ListKeyPoliciesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListKeyPoliciesOutput{}
	req.Data = output
	return
}

// ListKeyPolicies API operation for AWS Key Management Service.
//
// Retrieves a list of policies attached to a key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ListKeyPolicies for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) ListKeyPolicies(input *ListKeyPoliciesInput) (*ListKeyPoliciesOutput, error) {
	req, out := c.ListKeyPoliciesRequest(input)
	err := req.Send()
	return out, err
}

// ListKeyPoliciesPages iterates over the pages of a ListKeyPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKeyPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListKeyPolicies operation.
//    pageNum := 0
//    err := client.ListKeyPoliciesPages(params,
//        func(page *ListKeyPoliciesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *KMS) ListKeyPoliciesPages(input *ListKeyPoliciesInput, fn func(p *ListKeyPoliciesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListKeyPoliciesRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListKeyPoliciesOutput), lastPage)
	})
}

const opListKeys = "ListKeys"

// ListKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListKeys operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListKeys for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListKeys method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListKeysRequest method.
//    req, resp := client.ListKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) ListKeysRequest(input *ListKeysInput) (req *request.Request, output *ListKeysOutput) {
	op := &request.Operation{
		Name:       opListKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "Truncated",
		},
	}

	if input == nil {
		input = &ListKeysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListKeysOutput{}
	req.Data = output
	return
}

// ListKeys API operation for AWS Key Management Service.
//
// Lists the customer master keys.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ListKeys for usage and error information.
//
// Returned Error Codes:
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidMarkerException
//   The request was rejected because the marker that specifies where pagination
//   should next begin is not valid.
//
func (c *KMS) ListKeys(input *ListKeysInput) (*ListKeysOutput, error) {
	req, out := c.ListKeysRequest(input)
	err := req.Send()
	return out, err
}

// ListKeysPages iterates over the pages of a ListKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListKeys operation.
//    pageNum := 0
//    err := client.ListKeysPages(params,
//        func(page *ListKeysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *KMS) ListKeysPages(input *ListKeysInput, fn func(p *ListKeysOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListKeysRequest(input)
	page.Handlers.Build.PushBack(request.MakeAddToUserAgentFreeFormHandler("Paginator"))
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListKeysOutput), lastPage)
	})
}

const opListRetirableGrants = "ListRetirableGrants"

// ListRetirableGrantsRequest generates a "aws/request.Request" representing the
// client's request for the ListRetirableGrants operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListRetirableGrants for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListRetirableGrants method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListRetirableGrantsRequest method.
//    req, resp := client.ListRetirableGrantsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) ListRetirableGrantsRequest(input *ListRetirableGrantsInput) (req *request.Request, output *ListGrantsResponse) {
	op := &request.Operation{
		Name:       opListRetirableGrants,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRetirableGrantsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListGrantsResponse{}
	req.Data = output
	return
}

// ListRetirableGrants API operation for AWS Key Management Service.
//
// Returns a list of all grants for which the grant's RetiringPrincipal matches
// the one specified.
//
// A typical use is to list all grants that you are able to retire. To retire
// a grant, use RetireGrant.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ListRetirableGrants for usage and error information.
//
// Returned Error Codes:
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InvalidMarkerException
//   The request was rejected because the marker that specifies where pagination
//   should next begin is not valid.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
func (c *KMS) ListRetirableGrants(input *ListRetirableGrantsInput) (*ListGrantsResponse, error) {
	req, out := c.ListRetirableGrantsRequest(input)
	err := req.Send()
	return out, err
}

const opPutKeyPolicy = "PutKeyPolicy"

// PutKeyPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutKeyPolicy operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See PutKeyPolicy for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the PutKeyPolicy method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the PutKeyPolicyRequest method.
//    req, resp := client.PutKeyPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) PutKeyPolicyRequest(input *PutKeyPolicyInput) (req *request.Request, output *PutKeyPolicyOutput) {
	op := &request.Operation{
		Name:       opPutKeyPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutKeyPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &PutKeyPolicyOutput{}
	req.Data = output
	return
}

// PutKeyPolicy API operation for AWS Key Management Service.
//
// Attaches a key policy to the specified customer master key (CMK).
//
// For more information about key policies, see Key Policies (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
// in the AWS Key Management Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation PutKeyPolicy for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * MalformedPolicyDocumentException
//   The request was rejected because the specified policy is not syntactically
//   or semantically correct.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * UnsupportedOperationException
//   The request was rejected because a specified parameter is not supported or
//   a specified resource is not valid for this operation.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * LimitExceededException
//   The request was rejected because a limit was exceeded. For more information,
//   see Limits (http://docs.aws.amazon.com/kms/latest/developerguide/limits.html)
//   in the AWS Key Management Service Developer Guide.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) PutKeyPolicy(input *PutKeyPolicyInput) (*PutKeyPolicyOutput, error) {
	req, out := c.PutKeyPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opReEncrypt = "ReEncrypt"

// ReEncryptRequest generates a "aws/request.Request" representing the
// client's request for the ReEncrypt operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ReEncrypt for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ReEncrypt method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ReEncryptRequest method.
//    req, resp := client.ReEncryptRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) ReEncryptRequest(input *ReEncryptInput) (req *request.Request, output *ReEncryptOutput) {
	op := &request.Operation{
		Name:       opReEncrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReEncryptInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ReEncryptOutput{}
	req.Data = output
	return
}

// ReEncrypt API operation for AWS Key Management Service.
//
// Encrypts data on the server side with a new customer master key without exposing
// the plaintext of the data on the client side. The data is first decrypted
// and then encrypted. This operation can also be used to change the encryption
// context of a ciphertext.
//
// Unlike other actions, ReEncrypt is authorized twice - once as ReEncryptFrom
// on the source key and once as ReEncryptTo on the destination key. We therefore
// recommend that you include the "action":"kms:ReEncrypt*" statement in your
// key policies to permit re-encryption from or to the key. The statement is
// included automatically when you authorize use of the key through the console
// but must be included manually when you set a policy by using the PutKeyPolicy
// function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ReEncrypt for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * DisabledException
//   The request was rejected because the specified CMK is not enabled.
//
//   * InvalidCiphertextException
//   The request was rejected because the specified ciphertext has been corrupted
//   or is otherwise invalid.
//
//   * KeyUnavailableException
//   The request was rejected because the specified CMK was not available. The
//   request can be retried.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InvalidKeyUsageException
//   The request was rejected because the specified KeySpec value is not valid.
//
//   * InvalidGrantTokenException
//   The request was rejected because the specified grant token is not valid.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) ReEncrypt(input *ReEncryptInput) (*ReEncryptOutput, error) {
	req, out := c.ReEncryptRequest(input)
	err := req.Send()
	return out, err
}

const opRetireGrant = "RetireGrant"

// RetireGrantRequest generates a "aws/request.Request" representing the
// client's request for the RetireGrant operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RetireGrant for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RetireGrant method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RetireGrantRequest method.
//    req, resp := client.RetireGrantRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) RetireGrantRequest(input *RetireGrantInput) (req *request.Request, output *RetireGrantOutput) {
	op := &request.Operation{
		Name:       opRetireGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RetireGrantInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RetireGrantOutput{}
	req.Data = output
	return
}

// RetireGrant API operation for AWS Key Management Service.
//
// Retires a grant. You can retire a grant when you're done using it to clean
// up. You should revoke a grant when you intend to actively deny operations
// that depend on it. The following are permitted to call this API:
//
//   The account that created the grant
//
//   The RetiringPrincipal, if present
//
//   The GranteePrincipal, if RetireGrant is a grantee operation
//
//   The grant to retire must be identified by its grant token or by a combination
// of the key ARN and the grant ID. A grant token is a unique variable-length
// base64-encoded string. A grant ID is a 64 character unique identifier of
// a grant. Both are returned by the CreateGrant function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation RetireGrant for usage and error information.
//
// Returned Error Codes:
//   * InvalidGrantTokenException
//   The request was rejected because the specified grant token is not valid.
//
//   * InvalidGrantIdException
//   The request was rejected because the specified GrantId is not valid.
//
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) RetireGrant(input *RetireGrantInput) (*RetireGrantOutput, error) {
	req, out := c.RetireGrantRequest(input)
	err := req.Send()
	return out, err
}

const opRevokeGrant = "RevokeGrant"

// RevokeGrantRequest generates a "aws/request.Request" representing the
// client's request for the RevokeGrant operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RevokeGrant for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RevokeGrant method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RevokeGrantRequest method.
//    req, resp := client.RevokeGrantRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) RevokeGrantRequest(input *RevokeGrantInput) (req *request.Request, output *RevokeGrantOutput) {
	op := &request.Operation{
		Name:       opRevokeGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeGrantInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &RevokeGrantOutput{}
	req.Data = output
	return
}

// RevokeGrant API operation for AWS Key Management Service.
//
// Revokes a grant. You can revoke a grant to actively deny operations that
// depend on it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation RevokeGrant for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * InvalidGrantIdException
//   The request was rejected because the specified GrantId is not valid.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) RevokeGrant(input *RevokeGrantInput) (*RevokeGrantOutput, error) {
	req, out := c.RevokeGrantRequest(input)
	err := req.Send()
	return out, err
}

const opScheduleKeyDeletion = "ScheduleKeyDeletion"

// ScheduleKeyDeletionRequest generates a "aws/request.Request" representing the
// client's request for the ScheduleKeyDeletion operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ScheduleKeyDeletion for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ScheduleKeyDeletion method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ScheduleKeyDeletionRequest method.
//    req, resp := client.ScheduleKeyDeletionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) ScheduleKeyDeletionRequest(input *ScheduleKeyDeletionInput) (req *request.Request, output *ScheduleKeyDeletionOutput) {
	op := &request.Operation{
		Name:       opScheduleKeyDeletion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScheduleKeyDeletionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ScheduleKeyDeletionOutput{}
	req.Data = output
	return
}

// ScheduleKeyDeletion API operation for AWS Key Management Service.
//
// Schedules the deletion of a customer master key (CMK). You may provide a
// waiting period, specified in days, before deletion occurs. If you do not
// provide a waiting period, the default period of 30 days is used. When this
// operation is successful, the state of the CMK changes to PendingDeletion.
// Before the waiting period ends, you can use CancelKeyDeletion to cancel the
// deletion of the CMK. After the waiting period ends, AWS KMS deletes the CMK
// and all AWS KMS data associated with it, including all aliases that point
// to it.
//
//  Deleting a CMK is a destructive and potentially dangerous operation. When
// a CMK is deleted, all data that was encrypted under the CMK is rendered unrecoverable.
// To restrict the use of a CMK without deleting it, use DisableKey.
//
//  For more information about scheduling a CMK for deletion, see Deleting
// Customer Master Keys (http://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html)
// in the AWS Key Management Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation ScheduleKeyDeletion for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) ScheduleKeyDeletion(input *ScheduleKeyDeletionInput) (*ScheduleKeyDeletionOutput, error) {
	req, out := c.ScheduleKeyDeletionRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateAlias = "UpdateAlias"

// UpdateAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAlias operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateAlias for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateAlias method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateAliasRequest method.
//    req, resp := client.UpdateAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) UpdateAliasRequest(input *UpdateAliasInput) (req *request.Request, output *UpdateAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAliasInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateAliasOutput{}
	req.Data = output
	return
}

// UpdateAlias API operation for AWS Key Management Service.
//
// Updates an alias to map it to a different key.
//
// An alias is not a property of a key. Therefore, an alias can be mapped to
// and unmapped from an existing key without changing the properties of the
// key.
//
// An alias name can contain only alphanumeric characters, forward slashes
// (/), underscores (_), and dashes (-). An alias must start with the word "alias"
// followed by a forward slash (alias/). An alias that begins with "aws" after
// the forward slash (alias/aws...) is reserved by Amazon Web Services (AWS).
//
// The alias and the key it is mapped to must be in the same AWS account and
// the same region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation UpdateAlias for usage and error information.
//
// Returned Error Codes:
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) UpdateAlias(input *UpdateAliasInput) (*UpdateAliasOutput, error) {
	req, out := c.UpdateAliasRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateKeyDescription = "UpdateKeyDescription"

// UpdateKeyDescriptionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateKeyDescription operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateKeyDescription for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateKeyDescription method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateKeyDescriptionRequest method.
//    req, resp := client.UpdateKeyDescriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
func (c *KMS) UpdateKeyDescriptionRequest(input *UpdateKeyDescriptionInput) (req *request.Request, output *UpdateKeyDescriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateKeyDescription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateKeyDescriptionInput{}
	}

	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	output = &UpdateKeyDescriptionOutput{}
	req.Data = output
	return
}

// UpdateKeyDescription API operation for AWS Key Management Service.
//
// Updates the description of a key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Key Management Service's
// API operation UpdateKeyDescription for usage and error information.
//
// Returned Error Codes:
//   * NotFoundException
//   The request was rejected because the specified entity or resource could not
//   be found.
//
//   * InvalidArnException
//   The request was rejected because a specified ARN was not valid.
//
//   * DependencyTimeoutException
//   The system timed out while trying to fulfill the request. The request can
//   be retried.
//
//   * InternalException
//   The request was rejected because an internal exception occurred. The request
//   can be retried.
//
//   * InvalidStateException
//   The request was rejected because the state of the specified resource is not
//   valid for this request.
//
//   For more information about how key state affects the use of a CMK, see How
//   Key State Affects Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
//   in the AWS Key Management Service Developer Guide.
//
func (c *KMS) UpdateKeyDescription(input *UpdateKeyDescriptionInput) (*UpdateKeyDescriptionOutput, error) {
	req, out := c.UpdateKeyDescriptionRequest(input)
	err := req.Send()
	return out, err
}

// Contains information about an alias.
type AliasListEntry struct {
	_ struct{} `type:"structure"`

	// String that contains the key ARN.
	AliasArn *string `min:"20" type:"string"`

	// String that contains the alias.
	AliasName *string `min:"1" type:"string"`

	// String that contains the key identifier pointed to by the alias.
	TargetKeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AliasListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasListEntry) GoString() string {
	return s.String()
}

type CancelKeyDeletionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the customer master key (CMK) for which to cancel
	// deletion.
	//
	// To specify this value, use the unique key ID or the Amazon Resource Name
	// (ARN) of the CMK. Examples:
	//
	//   Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   To obtain the unique key ID and key ARN for a given CMK, use ListKeys
	// or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelKeyDeletionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelKeyDeletionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelKeyDeletionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelKeyDeletionInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CancelKeyDeletionOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the master key for which deletion is canceled.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CancelKeyDeletionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelKeyDeletionOutput) GoString() string {
	return s.String()
}

type CreateAliasInput struct {
	_ struct{} `type:"structure"`

	// String that contains the display name. The name must start with the word
	// "alias" followed by a forward slash (alias/). Aliases that begin with "alias/AWS"
	// are reserved.
	//
	// AliasName is a required field
	AliasName *string `min:"1" type:"string" required:"true"`

	// An identifier of the key for which you are creating the alias. This value
	// cannot be another alias but can be a globally unique identifier or a fully
	// specified ARN to a key.
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	// TargetKeyId is a required field
	TargetKeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.TargetKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetKeyId"))
	}
	if s.TargetKeyId != nil && len(*s.TargetKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CreateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAliasOutput) GoString() string {
	return s.String()
}

type CreateGrantInput struct {
	_ struct{} `type:"structure"`

	// The conditions under which the operations permitted by the grant are allowed.
	//
	// You can use this value to allow the operations permitted by the grant only
	// when a specified encryption context is present. For more information, see
	// Encryption Context (http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html)
	// in the AWS Key Management Service Developer Guide.
	Constraints *GrantConstraints `type:"structure"`

	// A list of grant tokens.
	//
	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// The principal that is given permission to perform the operations that the
	// grant permits.
	//
	// To specify the principal, use the Amazon Resource Name (ARN) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of an AWS principal. Valid AWS principals include AWS accounts (root), IAM
	// users, federated users, and assumed role users. For examples of the ARN syntax
	// to use for specifying a principal, see AWS Identity and Access Management
	// (IAM) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
	// in the Example ARNs section of the AWS General Reference.
	//
	// GranteePrincipal is a required field
	GranteePrincipal *string `min:"1" type:"string" required:"true"`

	// The unique identifier for the customer master key (CMK) that the grant applies
	// to.
	//
	// To specify this value, use the globally unique key ID or the Amazon Resource
	// Name (ARN) of the key. Examples:
	//
	//   Globally unique key ID: 12345678-1234-1234-1234-123456789012
	//
	//   Key ARN: arn:aws:kms:us-west-2:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// A friendly name for identifying the grant. Use this value to prevent unintended
	// creation of duplicate grants when retrying this request.
	//
	// When this value is absent, all CreateGrant requests result in a new grant
	// with a unique GrantId even if all the supplied parameters are identical.
	// This can result in unintended duplicates when you retry the CreateGrant request.
	//
	// When this value is present, you can retry a CreateGrant request with identical
	// parameters; if the grant already exists, the original GrantId is returned
	// without creating a new grant. Note that the returned grant token is unique
	// with every CreateGrant request, even when a duplicate GrantId is returned.
	// All grant tokens obtained in this way can be used interchangeably.
	Name *string `min:"1" type:"string"`

	// A list of operations that the grant permits. The list can contain any combination
	// of one or more of the following values:
	//
	//    Decrypt
	//
	//    Encrypt
	//
	//    GenerateDataKey
	//
	//    GenerateDataKeyWithoutPlaintext
	//
	//    ReEncryptFrom (http://docs.aws.amazon.com/kms/latest/APIReference/API_ReEncrypt.html)
	//
	//    ReEncryptTo (http://docs.aws.amazon.com/kms/latest/APIReference/API_ReEncrypt.html)
	//
	//    CreateGrant
	//
	//    RetireGrant
	//
	//    DescribeKey
	Operations []*string `type:"list"`

	// The principal that is given permission to retire the grant by using RetireGrant
	// operation.
	//
	// To specify the principal, use the Amazon Resource Name (ARN) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of an AWS principal. Valid AWS principals include AWS accounts (root), IAM
	// users, federated users, and assumed role users. For examples of the ARN syntax
	// to use for specifying a principal, see AWS Identity and Access Management
	// (IAM) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
	// in the Example ARNs section of the AWS General Reference.
	RetiringPrincipal *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGrantInput"}
	if s.GranteePrincipal == nil {
		invalidParams.Add(request.NewErrParamRequired("GranteePrincipal"))
	}
	if s.GranteePrincipal != nil && len(*s.GranteePrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GranteePrincipal", 1))
	}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RetiringPrincipal != nil && len(*s.RetiringPrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RetiringPrincipal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateGrantOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the grant.
	//
	// You can use the GrantId in a subsequent RetireGrant or RevokeGrant operation.
	GrantId *string `min:"1" type:"string"`

	// The grant token.
	//
	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGrantOutput) GoString() string {
	return s.String()
}

type CreateKeyInput struct {
	_ struct{} `type:"structure"`

	// A flag to indicate whether to bypass the key policy lockout safety check.
	//
	//  Setting this value to true increases the likelihood that the CMK becomes
	// unmanageable. Do not set this value to true indiscriminately.
	//
	// For more information, refer to the scenario in the Default Key Policy (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
	// section in the AWS Key Management Service Developer Guide.
	//
	//  Use this parameter only when you include a policy in the request and you
	// intend to prevent the principal making the request from making a subsequent
	// PutKeyPolicy request on the CMK.
	//
	// The default value is false.
	BypassPolicyLockoutSafetyCheck *bool `type:"boolean"`

	// A description of the CMK.
	//
	// Use a description that helps you decide whether the CMK is appropriate for
	// a task.
	Description *string `type:"string"`

	// The intended use of the CMK.
	//
	// You can use CMKs only for symmetric encryption and decryption.
	KeyUsage *string `type:"string" enum:"KeyUsageType"`

	// The source of the CMK's key material.
	//
	// The default is AWS_KMS, which means AWS KMS creates the key material. When
	// this parameter is set to EXTERNAL, the request creates a CMK without key
	// material so that you can import key material from your existing key management
	// infrastructure. For more information about importing key material into AWS
	// KMS, see Importing Key Material (http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
	// in the AWS Key Management Service Developer Guide.
	//
	// The CMK's Origin is immutable and is set when the CMK is created.
	Origin *string `type:"string" enum:"OriginType"`

	// The key policy to attach to the CMK.
	//
	// If you specify a policy and do not set BypassPolicyLockoutSafetyCheck to
	// true, the policy must meet the following criteria:
	//
	//   It must allow the principal making the CreateKey request to make a subsequent
	// PutKeyPolicy request on the CMK. This reduces the likelihood that the CMK
	// becomes unmanageable. For more information, refer to the scenario in the
	// Default Key Policy (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
	// section in the AWS Key Management Service Developer Guide.
	//
	//   The principal(s) specified in the key policy must exist and be visible
	// to AWS KMS. When you create a new AWS principal (for example, an IAM user
	// or role), you might need to enforce a delay before specifying the new principal
	// in a key policy because the new principal might not immediately be visible
	// to AWS KMS. For more information, see Changes that I make are not always
	// immediately visible (http://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency)
	// in the IAM User Guide.
	//
	//   If you do not specify a policy, AWS KMS attaches a default key policy
	// to the CMK. For more information, see Default Key Policy (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default)
	// in the AWS Key Management Service Developer Guide.
	//
	// The policy size limit is 32 KiB (32768 bytes).
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateKeyInput"}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateKeyOutput struct {
	_ struct{} `type:"structure"`

	// Metadata associated with the CMK.
	KeyMetadata *KeyMetadata `type:"structure"`
}

// String returns the string representation
func (s CreateKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateKeyOutput) GoString() string {
	return s.String()
}

type DecryptInput struct {
	_ struct{} `type:"structure"`

	// Ciphertext to be decrypted. The blob includes metadata.
	//
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	//
	// CiphertextBlob is a required field
	CiphertextBlob []byte `min:"1" type:"blob" required:"true"`

	// The encryption context. If this was specified in the Encrypt function, it
	// must be specified here or the decryption operation will fail. For more information,
	// see Encryption Context (http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html).
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`
}

// String returns the string representation
func (s DecryptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecryptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecryptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DecryptInput"}
	if s.CiphertextBlob == nil {
		invalidParams.Add(request.NewErrParamRequired("CiphertextBlob"))
	}
	if s.CiphertextBlob != nil && len(s.CiphertextBlob) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CiphertextBlob", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DecryptOutput struct {
	_ struct{} `type:"structure"`

	// ARN of the key used to perform the decryption. This value is returned if
	// no errors are encountered during the operation.
	KeyId *string `min:"1" type:"string"`

	// Decrypted plaintext data. This value may not be returned if the customer
	// master key is not available or if you didn't have permission to use it.
	//
	// Plaintext is automatically base64 encoded/decoded by the SDK.
	Plaintext []byte `min:"1" type:"blob"`
}

// String returns the string representation
func (s DecryptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecryptOutput) GoString() string {
	return s.String()
}

type DeleteAliasInput struct {
	_ struct{} `type:"structure"`

	// The alias to be deleted. The name must start with the word "alias" followed
	// by a forward slash (alias/). Aliases that begin with "alias/AWS" are reserved.
	//
	// AliasName is a required field
	AliasName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAliasOutput) GoString() string {
	return s.String()
}

type DeleteImportedKeyMaterialInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the CMK whose key material to delete. The CMK's Origin
	// must be EXTERNAL.
	//
	// A valid identifier is the unique key ID or the Amazon Resource Name (ARN)
	// of the CMK. Examples:
	//
	//   Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteImportedKeyMaterialInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteImportedKeyMaterialInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteImportedKeyMaterialInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteImportedKeyMaterialInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteImportedKeyMaterialOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteImportedKeyMaterialOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteImportedKeyMaterialOutput) GoString() string {
	return s.String()
}

type DescribeKeyInput struct {
	_ struct{} `type:"structure"`

	// A list of grant tokens.
	//
	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier, a fully specified ARN to either an alias or a key, or
	// an alias name prefixed by "alias/".
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	//   Alias Name Example - alias/MyAliasName
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeKeyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeKeyOutput struct {
	_ struct{} `type:"structure"`

	// Metadata associated with the key.
	KeyMetadata *KeyMetadata `type:"structure"`
}

// String returns the string representation
func (s DescribeKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeKeyOutput) GoString() string {
	return s.String()
}

type DisableKeyInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the CMK.
	//
	// Use the CMK's unique identifier or its Amazon Resource Name (ARN). For example:
	//
	//   Unique ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableKeyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisableKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyOutput) GoString() string {
	return s.String()
}

type DisableKeyRotationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisableKeyRotationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyRotationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableKeyRotationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisableKeyRotationInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DisableKeyRotationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisableKeyRotationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableKeyRotationOutput) GoString() string {
	return s.String()
}

type EnableKeyInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableKeyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EnableKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableKeyOutput) GoString() string {
	return s.String()
}

type EnableKeyRotationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s EnableKeyRotationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableKeyRotationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnableKeyRotationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnableKeyRotationInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EnableKeyRotationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s EnableKeyRotationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableKeyRotationOutput) GoString() string {
	return s.String()
}

type EncryptInput struct {
	_ struct{} `type:"structure"`

	// Name-value pair that specifies the encryption context to be used for authenticated
	// encryption. If used here, the same value must be supplied to the Decrypt
	// API or decryption will fail. For more information, see Encryption Context
	// (http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html).
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier, a fully specified ARN to either an alias or a key, or
	// an alias name prefixed by "alias/".
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	//   Alias Name Example - alias/MyAliasName
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Data to be encrypted.
	//
	// Plaintext is automatically base64 encoded/decoded by the SDK.
	//
	// Plaintext is a required field
	Plaintext []byte `min:"1" type:"blob" required:"true"`
}

// String returns the string representation
func (s EncryptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Plaintext == nil {
		invalidParams.Add(request.NewErrParamRequired("Plaintext"))
	}
	if s.Plaintext != nil && len(s.Plaintext) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Plaintext", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type EncryptOutput struct {
	_ struct{} `type:"structure"`

	// The encrypted plaintext. If you are using the CLI, the value is Base64 encoded.
	// Otherwise, it is not encoded.
	//
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// The ID of the key used during encryption.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EncryptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptOutput) GoString() string {
	return s.String()
}

type GenerateDataKeyInput struct {
	_ struct{} `type:"structure"`

	// A set of key-value pairs that represents additional authenticated data.
	//
	// For more information, see Encryption Context (http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html)
	// in the AWS Key Management Service Developer Guide.
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// The identifier of the CMK under which to generate and encrypt the data encryption
	// key.
	//
	// A valid identifier is the unique key ID or the Amazon Resource Name (ARN)
	// of the CMK, or the alias name or ARN of an alias that points to the CMK.
	// Examples:
	//
	//   Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   CMK ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   Alias name: alias/ExampleAlias
	//
	//   Alias ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The length of the data encryption key. Use AES_128 to generate a 128-bit
	// symmetric key, or AES_256 to generate a 256-bit symmetric key.
	KeySpec *string `type:"string" enum:"DataKeySpec"`

	// The length of the data encryption key in bytes. For example, use the value
	// 64 to generate a 512-bit data key (64 bytes is 512 bits). For common key
	// lengths (128-bit and 256-bit symmetric keys), we recommend that you use the
	// KeySpec field instead of this one.
	NumberOfBytes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GenerateDataKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateDataKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateDataKeyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.NumberOfBytes != nil && *s.NumberOfBytes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfBytes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GenerateDataKeyOutput struct {
	_ struct{} `type:"structure"`

	// The encrypted data encryption key.
	//
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// The identifier of the CMK under which the data encryption key was generated
	// and encrypted.
	KeyId *string `min:"1" type:"string"`

	// The data encryption key. Use this data key for local encryption and decryption,
	// then remove it from memory as soon as possible.
	//
	// Plaintext is automatically base64 encoded/decoded by the SDK.
	Plaintext []byte `min:"1" type:"blob"`
}

// String returns the string representation
func (s GenerateDataKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyOutput) GoString() string {
	return s.String()
}

type GenerateDataKeyWithoutPlaintextInput struct {
	_ struct{} `type:"structure"`

	// A set of key-value pairs that represents additional authenticated data.
	//
	// For more information, see Encryption Context (http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html)
	// in the AWS Key Management Service Developer Guide.
	EncryptionContext map[string]*string `type:"map"`

	// A list of grant tokens.
	//
	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// The identifier of the CMK under which to generate and encrypt the data encryption
	// key.
	//
	// A valid identifier is the unique key ID or the Amazon Resource Name (ARN)
	// of the CMK, or the alias name or ARN of an alias that points to the CMK.
	// Examples:
	//
	//   Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   CMK ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   Alias name: alias/ExampleAlias
	//
	//   Alias ARN: arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The length of the data encryption key. Use AES_128 to generate a 128-bit
	// symmetric key, or AES_256 to generate a 256-bit symmetric key.
	KeySpec *string `type:"string" enum:"DataKeySpec"`

	// The length of the data encryption key in bytes. For example, use the value
	// 64 to generate a 512-bit data key (64 bytes is 512 bits). For common key
	// lengths (128-bit and 256-bit symmetric keys), we recommend that you use the
	// KeySpec field instead of this one.
	NumberOfBytes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GenerateDataKeyWithoutPlaintextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyWithoutPlaintextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateDataKeyWithoutPlaintextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateDataKeyWithoutPlaintextInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.NumberOfBytes != nil && *s.NumberOfBytes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfBytes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GenerateDataKeyWithoutPlaintextOutput struct {
	_ struct{} `type:"structure"`

	// The encrypted data encryption key.
	//
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// The identifier of the CMK under which the data encryption key was generated
	// and encrypted.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GenerateDataKeyWithoutPlaintextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateDataKeyWithoutPlaintextOutput) GoString() string {
	return s.String()
}

type GenerateRandomInput struct {
	_ struct{} `type:"structure"`

	// The length of the byte string.
	NumberOfBytes *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GenerateRandomInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateRandomInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GenerateRandomInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GenerateRandomInput"}
	if s.NumberOfBytes != nil && *s.NumberOfBytes < 1 {
		invalidParams.Add(request.NewErrParamMinValue("NumberOfBytes", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GenerateRandomOutput struct {
	_ struct{} `type:"structure"`

	// The unpredictable byte string.
	//
	// Plaintext is automatically base64 encoded/decoded by the SDK.
	Plaintext []byte `min:"1" type:"blob"`
}

// String returns the string representation
func (s GenerateRandomOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GenerateRandomOutput) GoString() string {
	return s.String()
}

type GetKeyPolicyInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// String that contains the name of the policy. Currently, this must be "default".
	// Policy names can be discovered by calling ListKeyPolicies.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetKeyPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKeyPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKeyPolicyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetKeyPolicyOutput struct {
	_ struct{} `type:"structure"`

	// A policy document in JSON format.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetKeyPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyPolicyOutput) GoString() string {
	return s.String()
}

type GetKeyRotationStatusInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetKeyRotationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyRotationStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKeyRotationStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetKeyRotationStatusInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetKeyRotationStatusOutput struct {
	_ struct{} `type:"structure"`

	// A Boolean value that specifies whether key rotation is enabled.
	KeyRotationEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s GetKeyRotationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetKeyRotationStatusOutput) GoString() string {
	return s.String()
}

type GetParametersForImportInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the CMK into which you will import key material. The CMK's
	// Origin must be EXTERNAL.
	//
	// A valid identifier is the unique key ID or the Amazon Resource Name (ARN)
	// of the CMK. Examples:
	//
	//   Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The algorithm you will use to encrypt the key material before importing it
	// with ImportKeyMaterial. For more information, see Encrypt the Key Material
	// (http://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html)
	// in the AWS Key Management Service Developer Guide.
	//
	// WrappingAlgorithm is a required field
	WrappingAlgorithm *string `type:"string" required:"true" enum:"AlgorithmSpec"`

	// The type of wrapping key (public key) to return in the response. Only 2048-bit
	// RSA public keys are supported.
	//
	// WrappingKeySpec is a required field
	WrappingKeySpec *string `type:"string" required:"true" enum:"WrappingKeySpec"`
}

// String returns the string representation
func (s GetParametersForImportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetParametersForImportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetParametersForImportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetParametersForImportInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.WrappingAlgorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("WrappingAlgorithm"))
	}
	if s.WrappingKeySpec == nil {
		invalidParams.Add(request.NewErrParamRequired("WrappingKeySpec"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetParametersForImportOutput struct {
	_ struct{} `type:"structure"`

	// The import token to send in a subsequent ImportKeyMaterial request.
	//
	// ImportToken is automatically base64 encoded/decoded by the SDK.
	ImportToken []byte `min:"1" type:"blob"`

	// The identifier of the CMK to use in a subsequent ImportKeyMaterial request.
	// This is the same CMK specified in the GetParametersForImport request.
	KeyId *string `min:"1" type:"string"`

	// The time at which the import token and public key are no longer valid. After
	// this time, you cannot use them to make an ImportKeyMaterial request and you
	// must send another GetParametersForImport request to retrieve new ones.
	ParametersValidTo *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The public key to use to encrypt the key material before importing it with
	// ImportKeyMaterial.
	//
	// PublicKey is automatically base64 encoded/decoded by the SDK.
	PublicKey []byte `min:"1" type:"blob"`
}

// String returns the string representation
func (s GetParametersForImportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetParametersForImportOutput) GoString() string {
	return s.String()
}

// A structure for specifying the conditions under which the operations permitted
// by the grant are allowed.
//
// You can use this structure to allow the operations permitted by the grant
// only when a specified encryption context is present. For more information
// about encryption context, see Encryption Context (http://docs.aws.amazon.com/kms/latest/developerguide/encryption-context.html)
// in the AWS Key Management Service Developer Guide.
type GrantConstraints struct {
	_ struct{} `type:"structure"`

	// Contains a list of key-value pairs that must be present in the encryption
	// context of a subsequent operation permitted by the grant. When a subsequent
	// operation permitted by the grant includes an encryption context that matches
	// this list, the grant allows the operation. Otherwise, the operation is not
	// allowed.
	EncryptionContextEquals map[string]*string `type:"map"`

	// Contains a list of key-value pairs, a subset of which must be present in
	// the encryption context of a subsequent operation permitted by the grant.
	// When a subsequent operation permitted by the grant includes an encryption
	// context that matches this list or is a subset of this list, the grant allows
	// the operation. Otherwise, the operation is not allowed.
	EncryptionContextSubset map[string]*string `type:"map"`
}

// String returns the string representation
func (s GrantConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantConstraints) GoString() string {
	return s.String()
}

// Contains information about an entry in a list of grants.
type GrantListEntry struct {
	_ struct{} `type:"structure"`

	// The conditions under which the grant's operations are allowed.
	Constraints *GrantConstraints `type:"structure"`

	// The date and time when the grant was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The unique identifier for the grant.
	GrantId *string `min:"1" type:"string"`

	// The principal that receives the grant's permissions.
	GranteePrincipal *string `min:"1" type:"string"`

	// The AWS account under which the grant was issued.
	IssuingAccount *string `min:"1" type:"string"`

	// The unique identifier for the customer master key (CMK) to which the grant
	// applies.
	KeyId *string `min:"1" type:"string"`

	// The friendly name that identifies the grant. If a name was provided in the
	// CreateGrant request, that name is returned. Otherwise this value is null.
	Name *string `min:"1" type:"string"`

	// The list of operations permitted by the grant.
	Operations []*string `type:"list"`

	// The principal that can retire the grant.
	RetiringPrincipal *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GrantListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantListEntry) GoString() string {
	return s.String()
}

type ImportKeyMaterialInput struct {
	_ struct{} `type:"structure"`

	// The encrypted key material to import. It must be encrypted with the public
	// key that you received in the response to a previous GetParametersForImport
	// request, using the wrapping algorithm that you specified in that request.
	//
	// EncryptedKeyMaterial is automatically base64 encoded/decoded by the SDK.
	//
	// EncryptedKeyMaterial is a required field
	EncryptedKeyMaterial []byte `min:"1" type:"blob" required:"true"`

	// Specifies whether the key material expires. The default is KEY_MATERIAL_EXPIRES,
	// in which case you must include the ValidTo parameter. When this parameter
	// is set to KEY_MATERIAL_DOES_NOT_EXPIRE, you must omit the ValidTo parameter.
	ExpirationModel *string `type:"string" enum:"ExpirationModelType"`

	// The import token that you received in the response to a previous GetParametersForImport
	// request. It must be from the same response that contained the public key
	// that you used to encrypt the key material.
	//
	// ImportToken is automatically base64 encoded/decoded by the SDK.
	//
	// ImportToken is a required field
	ImportToken []byte `min:"1" type:"blob" required:"true"`

	// The identifier of the CMK to import the key material into. The CMK's Origin
	// must be EXTERNAL.
	//
	// A valid identifier is the unique key ID or the Amazon Resource Name (ARN)
	// of the CMK. Examples:
	//
	//   Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The time at which the imported key material expires. When the key material
	// expires, AWS KMS deletes the key material and the CMK becomes unusable. You
	// must omit this parameter when the ExpirationModel parameter is set to KEY_MATERIAL_DOES_NOT_EXPIRE.
	// Otherwise it is required.
	ValidTo *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ImportKeyMaterialInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportKeyMaterialInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportKeyMaterialInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportKeyMaterialInput"}
	if s.EncryptedKeyMaterial == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptedKeyMaterial"))
	}
	if s.EncryptedKeyMaterial != nil && len(s.EncryptedKeyMaterial) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EncryptedKeyMaterial", 1))
	}
	if s.ImportToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ImportToken"))
	}
	if s.ImportToken != nil && len(s.ImportToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImportToken", 1))
	}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ImportKeyMaterialOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ImportKeyMaterialOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportKeyMaterialOutput) GoString() string {
	return s.String()
}

// Contains information about each entry in the key list.
type KeyListEntry struct {
	_ struct{} `type:"structure"`

	// ARN of the key.
	KeyArn *string `min:"20" type:"string"`

	// Unique identifier of the key.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KeyListEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyListEntry) GoString() string {
	return s.String()
}

// Contains metadata about a customer master key (CMK).
//
// This data type is used as a response element for the CreateKey and DescribeKey
// operations.
type KeyMetadata struct {
	_ struct{} `type:"structure"`

	// The twelve-digit account ID of the AWS account that owns the CMK.
	AWSAccountId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the CMK. For examples, see AWS Key Management
	// Service (AWS KMS) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kms)
	// in the Example ARNs section of the AWS General Reference.
	Arn *string `min:"20" type:"string"`

	// The date and time when the CMK was created.
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time after which AWS KMS deletes the CMK. This value is present
	// only when KeyState is PendingDeletion, otherwise this value is omitted.
	DeletionDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The description of the CMK.
	Description *string `type:"string"`

	// Specifies whether the CMK is enabled. When KeyState is Enabled this value
	// is true, otherwise it is false.
	Enabled *bool `type:"boolean"`

	// Specifies whether the CMK's key material expires. This value is present only
	// when Origin is EXTERNAL, otherwise this value is omitted.
	ExpirationModel *string `type:"string" enum:"ExpirationModelType"`

	// The globally unique identifier for the CMK.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The state of the CMK.
	//
	// For more information about how key state affects the use of a CMK, see How
	// Key State Affects the Use of a Customer Master Key (http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
	// in the AWS Key Management Service Developer Guide.
	KeyState *string `type:"string" enum:"KeyState"`

	// The cryptographic operations for which you can use the CMK. Currently the
	// only allowed value is ENCRYPT_DECRYPT, which means you can use the CMK for
	// the Encrypt and Decrypt operations.
	KeyUsage *string `type:"string" enum:"KeyUsageType"`

	// The source of the CMK's key material. When this value is AWS_KMS, AWS KMS
	// created the key material. When this value is EXTERNAL, the key material was
	// imported from your existing key management infrastructure or the CMK lacks
	// key material.
	Origin *string `type:"string" enum:"OriginType"`

	// The time at which the imported key material expires. When the key material
	// expires, AWS KMS deletes the key material and the CMK becomes unusable. This
	// value is present only for CMKs whose Origin is EXTERNAL and whose ExpirationModel
	// is KEY_MATERIAL_EXPIRES, otherwise this value is omitted.
	ValidTo *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s KeyMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyMetadata) GoString() string {
	return s.String()
}

type ListAliasesInput struct {
	_ struct{} `type:"structure"`

	// When paginating results, specify the maximum number of items to return in
	// the response. If additional items exist beyond the number you specify, the
	// Truncated element in the response is set to true.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 100, inclusive. If you do not include a value, it defaults to 50.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results and only in a subsequent
	// request after you receive a response with truncated results. Set it to the
	// value of NextMarker from the response you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAliasesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListAliasesOutput struct {
	_ struct{} `type:"structure"`

	// A list of key aliases in the user's account.
	Aliases []*AliasListEntry `type:"list"`

	// When Truncated is true, this value is present and contains the value to use
	// for the Marker parameter in a subsequent pagination request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. If your results
	// were truncated, you can use the Marker parameter to make a subsequent pagination
	// request to retrieve more items in the list.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation
func (s ListAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAliasesOutput) GoString() string {
	return s.String()
}

type ListGrantsInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// When paginating results, specify the maximum number of items to return in
	// the response. If additional items exist beyond the number you specify, the
	// Truncated element in the response is set to true.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 100, inclusive. If you do not include a value, it defaults to 50.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results and only in a subsequent
	// request after you receive a response with truncated results. Set it to the
	// value of NextMarker from the response you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGrantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGrantsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGrantsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGrantsInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListGrantsResponse struct {
	_ struct{} `type:"structure"`

	// A list of grants.
	Grants []*GrantListEntry `type:"list"`

	// When Truncated is true, this value is present and contains the value to use
	// for the Marker parameter in a subsequent pagination request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. If your results
	// were truncated, you can use the Marker parameter to make a subsequent pagination
	// request to retrieve more items in the list.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation
func (s ListGrantsResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGrantsResponse) GoString() string {
	return s.String()
}

type ListKeyPoliciesInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier, a fully specified ARN to either an alias or a key, or
	// an alias name prefixed by "alias/".
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	//   Alias Name Example - alias/MyAliasName
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// When paginating results, specify the maximum number of items to return in
	// the response. If additional items exist beyond the number you specify, the
	// Truncated element in the response is set to true.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 1000, inclusive. If you do not include a value, it defaults to 100.
	//
	// Currently only 1 policy can be attached to a key.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results and only in a subsequent
	// request after you receive a response with truncated results. Set it to the
	// value of NextMarker from the response you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListKeyPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeyPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeyPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKeyPoliciesInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListKeyPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// When Truncated is true, this value is present and contains the value to use
	// for the Marker parameter in a subsequent pagination request.
	NextMarker *string `min:"1" type:"string"`

	// A list of policy names. Currently, there is only one policy and it is named
	// "Default".
	PolicyNames []*string `type:"list"`

	// A flag that indicates whether there are more items in the list. If your results
	// were truncated, you can use the Marker parameter to make a subsequent pagination
	// request to retrieve more items in the list.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation
func (s ListKeyPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeyPoliciesOutput) GoString() string {
	return s.String()
}

type ListKeysInput struct {
	_ struct{} `type:"structure"`

	// When paginating results, specify the maximum number of items to return in
	// the response. If additional items exist beyond the number you specify, the
	// Truncated element in the response is set to true.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 1000, inclusive. If you do not include a value, it defaults to 100.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results and only in a subsequent
	// request after you receive a response with truncated results. Set it to the
	// value of NextMarker from the response you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListKeysInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListKeysOutput struct {
	_ struct{} `type:"structure"`

	// A list of keys.
	Keys []*KeyListEntry `type:"list"`

	// When Truncated is true, this value is present and contains the value to use
	// for the Marker parameter in a subsequent pagination request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. If your results
	// were truncated, you can use the Marker parameter to make a subsequent pagination
	// request to retrieve more items in the list.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation
func (s ListKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListKeysOutput) GoString() string {
	return s.String()
}

type ListRetirableGrantsInput struct {
	_ struct{} `type:"structure"`

	// When paginating results, specify the maximum number of items to return in
	// the response. If additional items exist beyond the number you specify, the
	// Truncated element in the response is set to true.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 100, inclusive. If you do not include a value, it defaults to 50.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter only when paginating results and only in a subsequent
	// request after you receive a response with truncated results. Set it to the
	// value of NextMarker from the response you just received.
	Marker *string `min:"1" type:"string"`

	// The retiring principal for which to list grants.
	//
	// To specify the retiring principal, use the Amazon Resource Name (ARN) (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// of an AWS principal. Valid AWS principals include AWS accounts (root), IAM
	// users, federated users, and assumed role users. For examples of the ARN syntax
	// for specifying a principal, see AWS Identity and Access Management (IAM)
	// (http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
	// in the Example ARNs section of the Amazon Web Services General Reference.
	//
	// RetiringPrincipal is a required field
	RetiringPrincipal *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListRetirableGrantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRetirableGrantsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRetirableGrantsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRetirableGrantsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Marker", 1))
	}
	if s.RetiringPrincipal == nil {
		invalidParams.Add(request.NewErrParamRequired("RetiringPrincipal"))
	}
	if s.RetiringPrincipal != nil && len(*s.RetiringPrincipal) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RetiringPrincipal", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutKeyPolicyInput struct {
	_ struct{} `type:"structure"`

	// A flag to indicate whether to bypass the key policy lockout safety check.
	//
	//  Setting this value to true increases the likelihood that the CMK becomes
	// unmanageable. Do not set this value to true indiscriminately.
	//
	// For more information, refer to the scenario in the Default Key Policy (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
	// section in the AWS Key Management Service Developer Guide.
	//
	//  Use this parameter only when you intend to prevent the principal making
	// the request from making a subsequent PutKeyPolicy request on the CMK.
	//
	// The default value is false.
	BypassPolicyLockoutSafetyCheck *bool `type:"boolean"`

	// A unique identifier for the CMK.
	//
	// Use the CMK's unique identifier or its Amazon Resource Name (ARN). For example:
	//
	//   Unique ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The key policy to attach to the CMK.
	//
	// If you do not set BypassPolicyLockoutSafetyCheck to true, the policy must
	// meet the following criteria:
	//
	//   It must allow the principal making the PutKeyPolicy request to make a
	// subsequent PutKeyPolicy request on the CMK. This reduces the likelihood that
	// the CMK becomes unmanageable. For more information, refer to the scenario
	// in the Default Key Policy (http://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
	// section in the AWS Key Management Service Developer Guide.
	//
	//   The principal(s) specified in the key policy must exist and be visible
	// to AWS KMS. When you create a new AWS principal (for example, an IAM user
	// or role), you might need to enforce a delay before specifying the new principal
	// in a key policy because the new principal might not immediately be visible
	// to AWS KMS. For more information, see Changes that I make are not always
	// immediately visible (http://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency)
	// in the IAM User Guide.
	//
	//   The policy size limit is 32 KiB (32768 bytes).
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`

	// The name of the key policy.
	//
	// This value must be default.
	//
	// PolicyName is a required field
	PolicyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutKeyPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutKeyPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutKeyPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutKeyPolicyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.PolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyName"))
	}
	if s.PolicyName != nil && len(*s.PolicyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type PutKeyPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutKeyPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutKeyPolicyOutput) GoString() string {
	return s.String()
}

type ReEncryptInput struct {
	_ struct{} `type:"structure"`

	// Ciphertext of the data to re-encrypt.
	//
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	//
	// CiphertextBlob is a required field
	CiphertextBlob []byte `min:"1" type:"blob" required:"true"`

	// Encryption context to be used when the data is re-encrypted.
	DestinationEncryptionContext map[string]*string `type:"map"`

	// A unique identifier for the customer master key used to re-encrypt the data.
	// This value can be a globally unique identifier, a fully specified ARN to
	// either an alias or a key, or an alias name prefixed by "alias/".
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Alias ARN Example - arn:aws:kms:us-east-1:123456789012:alias/MyAliasName
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	//   Alias Name Example - alias/MyAliasName
	//
	// DestinationKeyId is a required field
	DestinationKeyId *string `min:"1" type:"string" required:"true"`

	// A list of grant tokens.
	//
	// For more information, see Grant Tokens (http://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []*string `type:"list"`

	// Encryption context used to encrypt and decrypt the data specified in the
	// CiphertextBlob parameter.
	SourceEncryptionContext map[string]*string `type:"map"`
}

// String returns the string representation
func (s ReEncryptInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReEncryptInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReEncryptInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReEncryptInput"}
	if s.CiphertextBlob == nil {
		invalidParams.Add(request.NewErrParamRequired("CiphertextBlob"))
	}
	if s.CiphertextBlob != nil && len(s.CiphertextBlob) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CiphertextBlob", 1))
	}
	if s.DestinationKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationKeyId"))
	}
	if s.DestinationKeyId != nil && len(*s.DestinationKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ReEncryptOutput struct {
	_ struct{} `type:"structure"`

	// The re-encrypted data. If you are using the CLI, the value is Base64 encoded.
	// Otherwise, it is not encoded.
	//
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// Unique identifier of the key used to re-encrypt the data.
	KeyId *string `min:"1" type:"string"`

	// Unique identifier of the key used to originally encrypt the data.
	SourceKeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ReEncryptOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReEncryptOutput) GoString() string {
	return s.String()
}

type RetireGrantInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier of the grant to be retired. The grant ID is returned by
	// the CreateGrant function.
	//
	//   Grant ID Example - 0123456789012345678901234567890123456789012345678901234567890123
	GrantId *string `min:"1" type:"string"`

	// Token that identifies the grant to be retired.
	GrantToken *string `min:"1" type:"string"`

	// A unique identifier for the customer master key associated with the grant.
	// This value can be a globally unique identifier or a fully specified ARN of
	// the key.
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RetireGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetireGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RetireGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RetireGrantInput"}
	if s.GrantId != nil && len(*s.GrantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrantId", 1))
	}
	if s.GrantToken != nil && len(*s.GrantToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrantToken", 1))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RetireGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RetireGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RetireGrantOutput) GoString() string {
	return s.String()
}

type RevokeGrantInput struct {
	_ struct{} `type:"structure"`

	// Identifier of the grant to be revoked.
	//
	// GrantId is a required field
	GrantId *string `min:"1" type:"string" required:"true"`

	// A unique identifier for the customer master key associated with the grant.
	// This value can be a globally unique identifier or the fully specified ARN
	// to a key.
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RevokeGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeGrantInput"}
	if s.GrantId == nil {
		invalidParams.Add(request.NewErrParamRequired("GrantId"))
	}
	if s.GrantId != nil && len(*s.GrantId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GrantId", 1))
	}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type RevokeGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RevokeGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RevokeGrantOutput) GoString() string {
	return s.String()
}

type ScheduleKeyDeletionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the customer master key (CMK) to delete.
	//
	// To specify this value, use the unique key ID or the Amazon Resource Name
	// (ARN) of the CMK. Examples:
	//
	//   Unique key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   Key ARN: arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//   To obtain the unique key ID and key ARN for a given CMK, use ListKeys
	// or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// The waiting period, specified in number of days. After the waiting period
	// ends, AWS KMS deletes the customer master key (CMK).
	//
	// This value is optional. If you include a value, it must be between 7 and
	// 30, inclusive. If you do not include a value, it defaults to 30.
	PendingWindowInDays *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ScheduleKeyDeletionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleKeyDeletionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleKeyDeletionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleKeyDeletionInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.PendingWindowInDays != nil && *s.PendingWindowInDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PendingWindowInDays", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ScheduleKeyDeletionOutput struct {
	_ struct{} `type:"structure"`

	// The date and time after which AWS KMS deletes the customer master key (CMK).
	DeletionDate *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The unique identifier of the customer master key (CMK) for which deletion
	// is scheduled.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ScheduleKeyDeletionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleKeyDeletionOutput) GoString() string {
	return s.String()
}

type UpdateAliasInput struct {
	_ struct{} `type:"structure"`

	// String that contains the name of the alias to be modified. The name must
	// start with the word "alias" followed by a forward slash (alias/). Aliases
	// that begin with "alias/aws" are reserved.
	//
	// AliasName is a required field
	AliasName *string `min:"1" type:"string" required:"true"`

	// Unique identifier of the customer master key to be mapped to the alias. This
	// value can be a globally unique identifier or the fully specified ARN of a
	// key.
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	//   You can call ListAliases to verify that the alias is mapped to the correct
	// TargetKeyId.
	//
	// TargetKeyId is a required field
	TargetKeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAliasInput"}
	if s.AliasName == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasName"))
	}
	if s.AliasName != nil && len(*s.AliasName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasName", 1))
	}
	if s.TargetKeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetKeyId"))
	}
	if s.TargetKeyId != nil && len(*s.TargetKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetKeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAliasOutput) GoString() string {
	return s.String()
}

type UpdateKeyDescriptionInput struct {
	_ struct{} `type:"structure"`

	// New description for the key.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// A unique identifier for the customer master key. This value can be a globally
	// unique identifier or the fully specified ARN to a key.
	//
	//   Key ARN Example - arn:aws:kms:us-east-1:123456789012:key/12345678-1234-1234-1234-123456789012
	//
	//   Globally Unique Key ID Example - 12345678-1234-1234-1234-123456789012
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateKeyDescriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateKeyDescriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateKeyDescriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateKeyDescriptionInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateKeyDescriptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateKeyDescriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateKeyDescriptionOutput) GoString() string {
	return s.String()
}

const (
	// AlgorithmSpecRsaesPkcs1V15 is a AlgorithmSpec enum value
	AlgorithmSpecRsaesPkcs1V15 = "RSAES_PKCS1_V1_5"

	// AlgorithmSpecRsaesOaepSha1 is a AlgorithmSpec enum value
	AlgorithmSpecRsaesOaepSha1 = "RSAES_OAEP_SHA_1"

	// AlgorithmSpecRsaesOaepSha256 is a AlgorithmSpec enum value
	AlgorithmSpecRsaesOaepSha256 = "RSAES_OAEP_SHA_256"
)

const (
	// DataKeySpecAes256 is a DataKeySpec enum value
	DataKeySpecAes256 = "AES_256"

	// DataKeySpecAes128 is a DataKeySpec enum value
	DataKeySpecAes128 = "AES_128"
)

const (
	// ExpirationModelTypeKeyMaterialExpires is a ExpirationModelType enum value
	ExpirationModelTypeKeyMaterialExpires = "KEY_MATERIAL_EXPIRES"

	// ExpirationModelTypeKeyMaterialDoesNotExpire is a ExpirationModelType enum value
	ExpirationModelTypeKeyMaterialDoesNotExpire = "KEY_MATERIAL_DOES_NOT_EXPIRE"
)

const (
	// GrantOperationDecrypt is a GrantOperation enum value
	GrantOperationDecrypt = "Decrypt"

	// GrantOperationEncrypt is a GrantOperation enum value
	GrantOperationEncrypt = "Encrypt"

	// GrantOperationGenerateDataKey is a GrantOperation enum value
	GrantOperationGenerateDataKey = "GenerateDataKey"

	// GrantOperationGenerateDataKeyWithoutPlaintext is a GrantOperation enum value
	GrantOperationGenerateDataKeyWithoutPlaintext = "GenerateDataKeyWithoutPlaintext"

	// GrantOperationReEncryptFrom is a GrantOperation enum value
	GrantOperationReEncryptFrom = "ReEncryptFrom"

	// GrantOperationReEncryptTo is a GrantOperation enum value
	GrantOperationReEncryptTo = "ReEncryptTo"

	// GrantOperationCreateGrant is a GrantOperation enum value
	GrantOperationCreateGrant = "CreateGrant"

	// GrantOperationRetireGrant is a GrantOperation enum value
	GrantOperationRetireGrant = "RetireGrant"

	// GrantOperationDescribeKey is a GrantOperation enum value
	GrantOperationDescribeKey = "DescribeKey"
)

const (
	// KeyStateEnabled is a KeyState enum value
	KeyStateEnabled = "Enabled"

	// KeyStateDisabled is a KeyState enum value
	KeyStateDisabled = "Disabled"

	// KeyStatePendingDeletion is a KeyState enum value
	KeyStatePendingDeletion = "PendingDeletion"

	// KeyStatePendingImport is a KeyState enum value
	KeyStatePendingImport = "PendingImport"
)

const (
	// KeyUsageTypeEncryptDecrypt is a KeyUsageType enum value
	KeyUsageTypeEncryptDecrypt = "ENCRYPT_DECRYPT"
)

const (
	// OriginTypeAwsKms is a OriginType enum value
	OriginTypeAwsKms = "AWS_KMS"

	// OriginTypeExternal is a OriginType enum value
	OriginTypeExternal = "EXTERNAL"
)

const (
	// WrappingKeySpecRsa2048 is a WrappingKeySpec enum value
	WrappingKeySpecRsa2048 = "RSA_2048"
)
