// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package sqs

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/client"
	"github.com/aws/aws-sdk-go/aws/client/metadata"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/signer/v4"
	"github.com/aws/aws-sdk-go/private/protocol/query"
)

// Welcome to the Amazon Simple Queue Service API Reference. This section describes
// who should read this guide, how the guide is organized, and other resources
// related to the Amazon Simple Queue Service (Amazon SQS).
//
// Amazon SQS offers reliable and scalable hosted queues for storing messages
// as they travel between computers. By using Amazon SQS, you can move data
// between distributed components of your applications that perform different
// tasks without losing messages or requiring each component to be always available.
//
// Helpful Links:
//
//  Current WSDL (2012-11-05) (http://queue.amazonaws.com/doc/2012-11-05/QueueService.wsdl)
//
// Making API Requests (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/MakingRequestsArticle.html)
//
// Amazon SQS product page (http://aws.amazon.com/sqs/)
//
// Using Amazon SQS Message Attributes (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/SQSMessageAttributes.html)
//
// Using Amazon SQS Dead Letter Queues (http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/SQSDeadLetterQueue.html)
//
// Regions and Endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html#sqs_region)
//
//  We also provide SDKs that enable you to access Amazon SQS from your preferred
// programming language. The SDKs contain functionality that automatically takes
// care of tasks such as:
//
//  Cryptographically signing your service requests
//
// Retrying requests
//
// Handling error responses
//
//  For a list of available SDKs, go to Tools for Amazon Web Services (http://aws.amazon.com/tools/).
//The service client's operations are safe to be used concurrently.
// It is not safe to mutate any of the client's properties though.
type SQS struct {
	*client.Client
}

// Used for custom client initialization logic
var initClient func(*client.Client)

// Used for custom request initialization logic
var initRequest func(*request.Request)

// A ServiceName is the name of the service the client will make API calls to.
const ServiceName = "sqs"

// New creates a new instance of the SQS client with a session.
// If additional configuration is needed for the client instance use the optional
// aws.Config parameter to add your extra config.
//
// Example:
//     // Create a SQS client from just a session.
//     svc := sqs.New(mySession)
//
//     // Create a SQS client with additional configuration
//     svc := sqs.New(mySession, aws.NewConfig().WithRegion("us-west-2"))
func New(p client.ConfigProvider, cfgs ...*aws.Config) *SQS {
	c := p.ClientConfig(ServiceName, cfgs...)
	return newClient(*c.Config, c.Handlers, c.Endpoint, c.SigningRegion)
}

// newClient creates, initializes and returns a new service client instance.
func newClient(cfg aws.Config, handlers request.Handlers, endpoint, signingRegion string) *SQS {
	svc := &SQS{
		Client: client.New(
			cfg,
			metadata.ClientInfo{
				ServiceName:   ServiceName,
				SigningRegion: signingRegion,
				Endpoint:      endpoint,
				APIVersion:    "2012-11-05",
			},
			handlers,
		),
	}

	// Handlers
	svc.Handlers.Sign.PushBackNamed(v4.SignRequestHandler)
	svc.Handlers.Build.PushBackNamed(query.BuildHandler)
	svc.Handlers.Unmarshal.PushBackNamed(query.UnmarshalHandler)
	svc.Handlers.UnmarshalMeta.PushBackNamed(query.UnmarshalMetaHandler)
	svc.Handlers.UnmarshalError.PushBackNamed(query.UnmarshalErrorHandler)

	// Run custom client initialization if present
	if initClient != nil {
		initClient(svc.Client)
	}

	return svc
}

// newRequest creates a new request for a SQS operation and runs any
// custom request initialization.
func (c *SQS) newRequest(op *request.Operation, params, data interface{}) *request.Request {
	req := c.NewRequest(op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
