package ecs

import (
	"os"

	"code.justin.tv/feeds/xray"
)

// Plugin allows adding ECS hostname information to xray
type Plugin struct {
}

// ModifyMetadata attaches the hostname to the ECS container name
func (p *Plugin) ModifyMetadata(meta *xray.OptionalMetadata) error {
	hostname, err := os.Hostname()

	if err != nil {
		return err
	}

	meta.ECSContainerName = hostname
	return nil
}
