package com.twitch.ipdev.flexo

import com.twitch.ipdev.SetBuildStatus

class FlexoPipelineStage {
  protected FlexoStage type
  protected Script script
  protected env

  protected Closure commands

  protected Boolean reportStatus

  // A standard way for templates to put commands into a Jenkinsfile stage
  FlexoPipelineStage (Script script, FlexoStage type, Boolean reportStatus = true, Closure commands = null, env) {
    this.type = type
    this.script = script
    this.env = env

    this.reportStatus = reportStatus

    this.commands = commands ?: {
      this.script.echo "The ${this.type.label} stage is empty"
    }
    // Setting the resolve strategy here allows templates to directly call valid Jenkinsfile DSL and not be
    // required to prefix everything with `script`, such as: `script.echo`.
    this.commands.delegate = this.script
    this.commands.setResolveStrategy(Closure.DELEGATE_FIRST)
  }

  def run() {
    // Create a Jeninsfile stage
    script.stage(type.label, {
      // Set a pending git commit status before we start running the commands
      if (reportStatus) { script.setBuildStatusPending(debug: true, description: "Flexo: ${type.label}", credentialsId: 'flexo-org-service_pat') }

      try {
        // Try to run all of the commands
        commands.call()
        // Report success or failure to git commit status.
        if (reportStatus) {
          if (script.currentBuild.currentResult ==~ /SUCCESS|UNSTABLE/) {
            script.setBuildStatusSuccess(debug: true, description: "Flexo: ${type.label}", credentialsId: 'flexo-org-service_pat')
          } else {
            script.echo """A stage failure was reported, but not handled as expected.
            |currentBuild.currentResult: ${script.currentBuild.currentResult}
            |Dumping environment info:""".stripMargin()
            script.sh "env"
          }
        }
      }
      catch (Exception e) {
        // If the commands in the stage generated an error, set the git commti status to a failure
        if (reportStatus) { script.setBuildStatusFailure(debug: true, description: "Flexo: ${type.label}", credentialsId: 'flexo-org-service_pat') }
        throw e
      }
    })
  }
}
