package com.twitch.ipdev.flexo

// A generic list of all available stage names. This is used to try to have standardized stage names
// in different templates.
public enum FlexoStage {
  INIT('Initialize'),
  LINT('Lint'),
  UNIT_TEST('Unit Test'),
  SECURITY_STATIC_ANALYSIS('Security Static Analysis'),
  BUILD('Build'),
  PUBLISH('Publish'),
  STAGING_DEPLOY('Staging Deploy'),
  INTEGRATION_TEST('Integration Test'),
  DEPLOY_APPROVAL('Approval'),
  PRODUCTION_DEPLOY('Production Deploy')

  protected String label;
  private FlexoStage(String label) {
    this.label = label;
  }
}
