# @twitch/flexo

![Flexo](imgs/flexo.jpg)

## What is @twitch/flexo?

Flexo is a continuous delivery platform that empowers our customers to reliably and quickly release code.

Please check out the [wiki](https://wiki.twitch.com/display/PS/Flexo)

## Using @twitch/flexo

If you're new to CDK, check out this [handy guide](https://wiki.twitch.com/display/ENG/CDK) for getting set up.

To add Flexo, first get set up with the [Artifactory NPM Repository](https://wiki.twitch.com/display/DTA/NPM+Repository+User+Guide "Artifactory").

```bash
# Set up a new CDK application
npx aws-cdk init app --language=typescript

# Install flexo and its dependencies
npx install-peerdeps -Y --registry https://npm.internal.justin.tv @twitch/flexo

# After flexo installs, feel free to edit your package.json to get the versions of CDK appropriate for your project.
```

Then to import flexo in your CDK application:

```ts
import * as flexo from '@twitch/flexo';
```

## Packages

* [jenkins-slaves-ecs](lib/jenkins-slaves-ecs/)
  * Create Jenkins slaves in a tiny bubble running in ECS
* [jenkins-slaves-swarm-asg](lib/jenkins-slaves-swarm-asg/)
  * Create Jenkins slaves in a tiny bubble running in an ad-hoc ASG
* [test-my-agents](lib/test-my-agents/)
  * Creates a Cloudwatch alarm and dashboard for Jenkins slaves using the [Flexo Jenkinsfile library function `testMyAgents`][testmyagents] to ensure your agents are running properly with the command dependencies you expect to be available.


---

## Developer Setup

#### Prereq

* Install [node](https://nodejs.org/en/download/package-manager/)
* Install [yarn](https://yarnpkg.com/lang/en/docs/install/#mac-stable)

### Adding a new Flexo package

```bash
cd flexo
mkdir lib/my-new-package/
touch lib/my-new-package/my-new-package.ts
echo "export * from './my-new-package/my-newpackage'" >> lib/index.ts
mkdir test/my-new-package/
touch test/my-new-package/my-new-package.test.ts
```

### Install/Build

```bash
# Get your packages installed
yarn install

# Build
yarn build

# Lint (will auto-fix)
yarn lint

# Run tests
yarn test
```

[testmyagents]: https://wiki.twitch.com/display/PS/Flexo+Jenkins+Shared+Libraries#FlexoJenkinsSharedLibraries-MonitoringyourFlexoCIAgents
